\name{CEOclubs}
\alias{CEOclubsAM}
\alias{CEOclubsBPG}
\docType{data}
\title{Galaskiewicz's CEO and Clubs Network}
\description{
Affiliation matrix and bipartite graph for Galaskiewicz's CEO and clubs network.
}
\usage{
data(CEOclubsAM)
data(CEOclubsBPG)
}


\format{

\code{CEOclubsAM}: data frame with 26 rows and 15 columns

\code{CEOclubsBPG}: graphNEL object with 41 nodes and 98 directed edges

}

\details{

\code{CEOclubsAM} is an affiliation matrix representation of the CEO and
clubs network.  The 26 rows correspond to the 26 CEOs, the 15 columns
correspond to the 15 clubs, and an entry of "1" in the ith row and jth
column represents membership of the ith CEO in the jth club.  All other
entries in the matrix are "0".

\code{CEOclubsBPG} is a bipartite graph representation of the
information contained in \code{CEOclubsAM}.  Edges connect CEOs to clubs
of which they are members.  The bipartite structure of the graph
should be apparent if \code{CEOclubsBPG} is plotted using Rgraphviz and
the "dot" layout.

}
\source{
Wasserman, S. and Faust, K. (1999). \emph{Social Network Analysis}. Cambridge
University Press. New York.
}

\references{
Galaskiewicz, J. (1985). \emph{Social Organization of an Urban Grants
  Economy}. New York: Academic Press.
}

\examples{
data(CEOclubsAM)
data(CEOclubsBPG)

}
\keyword{datasets}

\eof
\name{Countries}
\alias{basicGoods}
\alias{food}
\alias{crudeMaterials}
\alias{minerals}
\alias{diplomats}
\alias{countriesAttrs}
\docType{data}
\title{Countries Trade Data}
\description{
Graphs of relation data between a countries trade network and data frame of attribute variables.  
}
\usage{
data(basicGoods)
data(food)
data(crudeMaterials)
data(minerals)
data(diplomats)
data(countriesAttrs)
}


\format{

\code{basicGoods}: graphNEL object with 24 nodes and 310 directed edges

\code{food}: graphNEL object with 24 nodes and 307 directed edges

\code{crudeMaterials}: graphNEL object with 24 nodes and 307 directed edges

\code{minerals}: graphNEL object with 24 nodes and 135 directed edges

\code{diplomats}: graphNEL object with 24 nodes and 369 directed edges

\code{countriesAttrs}: data frame with 24 rows and 4 columns
}

\details{

The graphs contain the following relation information from one country
to another.  The data are reported in Tables B.12-B.16, respectively, in
Wasserman and Faust (1999).


\code{basicGoods} trade of basic manufactured goods

\code{food} trade of food and live animals

\code{crudeMaterials} trade of crude materials, excluding food

\code{minerals} trade of minerals, fuels, and other petroleum products

\code{diplomats} exchange of diplomats



\code{countriesAttrs} contains the following attribute variables for the countries.  The data are reported in Table B.17 in Wasserman and Faust (1999).


\code{PopGrowth} average annual population growth between 1970 and 1981

\code{GNP} average GNP growth rate per capita between 1970 and 1981

\code{Schools} secondary school enrollment ratio in 1980

\code{Energy} energy consumption per capita in 1980, measured in kilo
coal equivalents 


}

\source{
Wasserman, S. and Faust, K. (1999). \emph{Social Network Analysis}. Cambridge
University Press. New York.
}

\references{
Smith, D. and White, D. (1988). Structure and dynamics of the global
economy: Network analysis of international trade 1965-1980. Unpublished manuscript.
  
  }

\examples{
data(basicGoods)
data(food)
data(crudeMaterials)
data(minerals)
data(diplomats)
data(countriesAttrs)
}
\keyword{datasets}

\eof
\name{Florentine}
\alias{business}
\alias{marital}
\alias{florentineAttrs}
\docType{data}
\title{Padgett's Florentine Families}
\description{
Graphs of relation data between Padgett's Florentine families and data frame of attribute variables.  
}
\usage{
data(business)
data(marital)
data(florentineAttrs)
}


\format{

\code{business}: graphNEL object with 16 nodes and 15 undirected edges

\code{marital}: graphNEL object with 16 nodes and 20 undirected edges

\code{florentineAttrs}: data frame with 16 rows and 3 columns
}

\details{

The graphs contain the following relation information between the 16
Florentine families.  The data are reported in Tables B.5 and B.6,
respectively, in Wasserman and Faust (1999).


\code{business} business relations between families 

\code{marital} marital relations between families 


\code{florentineAttrs} contains the following attribute variables for the 16
Florentine families.  The data are reported in Table B.7 in Wasserman and Faust (1999).


\code{Wealth} net wealth, measured in 1427, coded in thousands of lira

\code{NumberPriorates} number of seats on the Civic Council held between 
nd 1344 

\code{NumberTies} number of business or marriage ties in the total
network data set containing 116 families 


}
\source{
Wasserman, S. and Faust, K. (1999). \emph{Social Network Analysis}. Cambridge
University Press. New York.
}

\references{

Kent, D. (1978). \emph{The Rise of the Medici: Faction in Florence,
  1426-1434}. Oxford: Oxford University Press.
  
Padgett, J.F. (1987). Social mobility in hieratic control
systems. Unpublished manuscript.  
  }

\examples{
data(business)
data(marital)
data(florentineAttrs)
}
\keyword{datasets}

\eof
\name{Freeman}
\alias{acqTime1}
\alias{acqTime2}
\alias{messages}
\alias{freemanAttrs}
\docType{data}
\title{Freeman's EIES Network}
\description{
Graphs of relation data for Freeman's EIES researchers and data frame of attributes.
}
\usage{
data(acqTime1)
data(acqTime2)
data(messages)
data(freemanAttrs)
}


\format{

\code{acqTime1}: graphNEL object with 32 nodes and 650 directed, weighted edges

\code{acqTime2}: graphNEL object with 32 nodes and 759 directed, weighted edges

\code{messages}: graphNEL object with 32 nodes and 460 directed, weighted edges

\code{freemanAttrs}: data frame with 32 rows and 4 columns

}

\details{

The graphs contain the following relation information between Freeman's
EIES researchers.  The data are reported in Tables B.8-B.10,
respectively, in Wasserman and Faust (1999).


  
\code{acqTime1} valued acquaintanceship relations measured at
nuary 1978, the start of the study; 4 = close personal friend,
2 = person I've met, 1 = person I've heard of but not met,
known name or no reply

\code{acqTime2} valued acquaintanceship relations measured at
ptember 1978, the end of the study; 4 = close personal friend,
2 = person I've met, 1 = person I've heard of but not met,
known name or no reply 

\code{messages} number of messages sent from one researcher to
another 




\code{freemanAttrs} contains the following attribute variables for the 32
researchers.  The data are reported in Table B.11 in Wasserman and Faust (1999).


\code{OriginalID} original ID, as numbered in Freeman and Freeman (1979)

\code{Citations} number of citations in 1978

\code{DisciplineCode} discipline, coded 1,2,3 

\code{Discipline} discipline name 


}
\source{
Wasserman, S. and Faust, K. (1999). \emph{Social Network Analysis}. Cambridge
University Press. New York.
}

\references{
Freeman, S.C. and Freeman, L.C. (1979). The networkers network: A study
of the impact of a new communications medium on sociometric structure.
Social Science Research Reports No.46. Irvine, CA: University of California.
  
}

\examples{
data(acqTime1)
data(acqTime2)
data(messages)
data(freemanAttrs)
}
\keyword{datasets}

\eof
\name{Krackhardt}
\alias{advice}
\alias{friendship}
\alias{reportsTo}
\alias{krackhardtAttrs}
\docType{data}
\title{Krackhardt's High-tech Managers}
\description{
Graphs of relation data between managers of Krackhardt's high-tech
company and data frame of attribute variables.  
}
\usage{
data(advice)
data(friendship)
data(reportsTo)
data(krackhardtAttrs)
}


\format{

\code{advice}: graphNEL object with 21 nodes and 190 directed edges

\code{friendship}: graphNEL object with 21 nodes and 102 directed edges

\code{reportsTo}: graphNEL object with 21 nodes and 20 directed edges

\code{krackhardtAttrs}: data frame with 21 rows and 4 columns

}

\details{

The graphs contain the following relation information between managers.
The data are reported in Tables B.1-B.3, respectively, in Wasserman and
Faust (1999).



\code{advice} advice relation

\code{friendship} friendship relation

\code{reportsTo} "reports to" relation



\code{krackhardtAttrs} contains the following attribute variables for the 21
managers.  The data are reported in Table B.4 in Wasserman and Faust (1999).


\code{Age} in years

\code{Tenure} length of time employed by company, in years 

\code{Level} level in the corporate hierarchy, coded 1,2,3 

\code{Dept} department of the company, coded 1,2,3,4 



}
\source{
Wasserman, S. and Faust, K. (1999). \emph{Social Network Analysis}. Cambridge
University Press. New York.
}

\references{
Krackhardt, D. (1987). Cognitive social structures. \emph{Social
  Networks}. 9, 109-134.
  }
\examples{
data(advice)
data(friendship)
data(reportsTo)
data(krackhardtAttrs)
}
\keyword{datasets}

\eof
