\name{Ruuid-class}
\docType{class}
\alias{Ruuid-class}
\alias{Ruuid}
\alias{stringRep}
\alias{uuid}
\alias{stringRep,Ruuid-method}
\alias{uuid,Ruuid-method}
\alias{as.character,Ruuid-method}
\alias{print,Ruuid-method}
\alias{==,Ruuid,Ruuid-method}
\alias{!=,Ruuid,Ruuid-method}
\title{Class "Ruuid": A class to manage UUID values}
\description{ Class \code{Ruuid} wraps and handles the UUID values for
  the user within R.}
\section{Objects from the Class}{
  Objects are not intended to be directly created.  A user can retrieve
  a new instantiation of this class with the \code{getuuid} function.
}
\section{Slots}{
  \describe{
    \item{\code{stringRep}:}{Object of class \code{"character"} A human
      readable string representation of the ID}
    \item{\code{uuid}:}{Object of class \code{"uuidt"} Contains the
      actual UUID value.}
  }
}

\section{Methods}{
  \describe{
    \item{stringRep}{Retrieves the string representation of the UUID}
    \item{uuid}{Retrieves the \code{"uuidt"} object}
    \item{print}{Outputs the string representation of the UUID}
    \item{as.character}{Returns the string representation of the UUID}
    \item{==}{Returns true if both arguments are \code{Ruuid} objects
      and have the same string representation.}
    \item{!=}{Returns true if both arguments are \code{Ruuid} objects
      and have different string representations.}
   }
  }
\references{Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{getuuid}}, \code{\link{uuidt}}}
\examples{
z <- getuuid()
z
class(z)
}
\keyword{classes}

\eof
\name{getuuid}
\alias{getuuid}
\title{Functions to handle unique IDs}
\description{
  These functions allow a user to retrieve and transform universally
  unique ID values.  A user can get a new UUID, as well as transform a string
  representation into a byte representation and vice versa.
}
\usage{
getuuid(cur)
}
\arguments{
  \item{cur}{If provided, either a UUID string or a \code{uuidt} object}
}
\details{
  This package uses Theodore Ts'o's libuuid to generate universally
  unique ID values.  A unique ID value is represented in R by the class
  \code{uuidt}, which wraps the byte values.  A wrapper object is the
  most common method of handling these values, \code{Ruuid} - which also
  provides for a string representation of the UUID.

  If no parameter \code{cur} is passed into \code{getuuid}, a new
  \code{Ruuid} is generated.  If either a string or a \code{uuidt}
  object is passed in, then the complementary piece is generated and the
  resultant \code{Ruuid} is generated.
}
\value{
  getuuid:  Returns an object of class \code{Ruuid}.
}
\references{ Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{Ruuid}}, \code{\link{uuidt}}}
\examples{
z <- getuuid()
z
a <- getuuid(as.character(z))
a
q <- getuuid(uuid(z))
q
w <- getuuid()
w
}
\keyword{utilities}

\eof
\name{uuidt-class}
\docType{class}
\alias{uuidt-class}
\alias{uuidt}
\alias{uuid,uuidt-method}
\alias{print,uuidt-method}
\title{Class "uuidt": A class to contain UUID values}
\description{Class \code{uuidt} wraps the actual byte values for a UUID}
\section{Objects from the Class}{
  Objects of class \code{uuidt} are not intended to be created directly
  by the user.  A call to \code{getuuid} or \code{str2uuid} will
  generate such a value.
}
\section{Slots}{
  \describe{
    \item{\code{uuid}:}{Object of class \code{"character"}: Byte values
      of the UUID}
  }
}

\section{Methods}{
  \describe{
    \item{uuid}{Retrieves the byte string of the UUID}
    \item{print}{Prints a human readable display of the byte values}
  }
}
\references{Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{getuuid}}, \code{\link{Ruuid}}}

\examples{
z <- getuuid()
a <- uuid(z)
a
class(a)
}
\keyword{classes}

\eof
