\name{Default methods and internal functions}
\alias{dbAppendTable.default}
\alias{dbClearResult.default}
\alias{dbColumnInfo.default}
\alias{dbConnect.default}
\alias{dbConnectionInfo.default}
\alias{dbDisconnect.default}
\alias{dbGetQuery.default}
\alias{dbGetResult.default}
\alias{dbListTables.default}
\alias{dbReadTable.default}
\alias{dbReconnect.default}
\alias{dbResultInfo.default}
\alias{dbSendQuery.default}
\alias{dbWriteTable.default}
\alias{print.Rdbi.result}
\alias{print.Rdbi.conn}
\title{Default methods and internal functions}
\description{Default methods and internal functions}
\usage{
  \method{dbAppendTable}{default}(conn, ...)
  \method{dbClearResult}{default}(result)
  \method{dbColumnInfo}{default}(result)
  \method{dbConnect}{default}(dbObj, ...)
  \method{dbConnectionInfo}{default}(conn)
  \method{dbDisconnect}{default}(conn)
  \method{dbGetQuery}{default}(conn, ...)
  \method{dbGetResult}{default}(result)
  \method{dbListTables}{default}(conn, ...)
  \method{dbReadTable}{default}(conn, ...)
  \method{dbReconnect}{default}(conn)
  \method{dbResultInfo}{default}(result)
  \method{dbSendQuery}{default}(conn, ...)
  \method{dbWriteTable}{default}(conn, ...)
  \method{print}{Rdbi.conn}(x, ...) % Added by JZ
  \method{print}{Rdbi.result}(x, ...) % Added by JZ
% Commented out by JZ
%  \method{print}{Rdbi.conn}(conn, ...)
%  \method{print}{Rdbi.result}(result, ...)
% Added by JZ

}
\note{See source for details.}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\keyword{internal}

\eof
\name{dbAppendTable}
\alias{dbAppendTable}
\title{Appends data to a database table}
\description{
  \code{dbAppendTable} is a generic function that, when called on a
  valid database connection object, appends the contents of a data frame
  to a database table.
}
\usage{
dbAppendTable(conn, ...)
}
\arguments{
  \item{conn}{A database connection object.}
  \item{\dots}{Additional arguments}
}
\details{
  Column names of the data frame must match column names of the database
  table.  Implementations should allow the data frame columns to be a
  subset of the database table columns and match R column names to SQL
  column names.  Appends must be atomic.  Implementations must use
  transactions or emulate them.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \link{methods}, \code{\link{class}},
  \code{\link{on.exit}}}

\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{dbClearResult}
\alias{dbClearResult}
\title{Clears resources associated with a query result}
\description{
  \code{dbClearResult} is a generic function that, when called on a
  result object, clears any resources associated with that object.
}
\usage{
dbClearResult(result)
}
\arguments{
  \item{result}{A query result object.}
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}

\seealso{\code{\link{dbSendQuery}}, \code{\link{data.frame}}}

\keyword{methods}
\keyword{data}

\eof
\name{dbColumnInfo}
\alias{dbColumnInfo}
\title{Returns type information about a result column}
\description{
  \code{dbColumnInfo} is a generic function that, when called on a
  result object, returns type information about tuple fields in the
  result.
}
\usage{
dbColumnInfo(result)
}
\arguments{
  \item{result}{A query result object.}
}
\value{
  Returns a data frame with each row corresponding to a different field
  in the result.  Rows are named for each field.  Any available
  information about a field can be presented in columns of the data
  frame.  The most important of these is probably a "Type" column that
  can be used to convert strings returned by the query into appropriate
  R types.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}

\seealso{\code{\link{dbSendQuery}}, \code{\link{dbResultInfo}}}

\keyword{methods}


\eof
\name{dbConnect}
\alias{dbConnect}
\title{Connect to a database}
\description{
  \code{dbConnect} is a generic function that, when evoked with a valid
  database class, will return a connection object.
}
\usage{
dbConnect(dbObj, ...)
}
\arguments{
  \item{dbObj}{A database class object.}
  \item{\dots}{An argument list specifying connection options.}
}
\details{
  Each package that sub-classes Rdbi must provide a \code{dbConnect}
  function.  The first argument of the \code{dbConnect} function is an
  object whose class determines which \code{dbConnect} method is
  actually called.  For example, the Rdbi.PgSQL package provides a
  function \code{PgSQL()} that returns an object of class
  \code{c("PgSQL", "Rdbi")}.  Therefore the call
  \code{dbConnect(PgSQL(), ...)} will invoke the method
  \code{dbConnect.PgSQL}.  Rdbi arranges for the specific package
  to be loaded via the \code{\link{autoload}} mechanism.  In this
  example, Rdbi.PgSQL is autoloaded when \code{PgSQL} is called.
}
\value{
  A database connection object that inherits from "Rdbi.conn".
  Additionally, the connection object should possess two attributes
  required to reopen the connection from the object.  The
  "library.call" contains a call or expression that will load the
  library necessary to support the connection object.  The
  "connect.call" attribute should contain the call that created the
  connection object.  Also, it is very convenient to arrange for
  low-level connection resources to be freed when the R connection
  object is garbage collected.  See the Rdbi.PgSQL C code for an
  example.  
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbDisconnect}}, \code{\link{dbReconnect}},
  \link{methods}, \code{\link{class}}, \code{\link{match.call}}}

\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{dbConnectionInfo}
\alias{dbConnectionInfo}
\title{Returns a list of connection status attributes}
\description{
  \code{dbConnectionInfo} is a generic function that, when called on a
  valid connection object, returns a list containing connection status
  information.  It is called by \code{print.Rdbi.conn}.
}
\usage{
dbConnectionInfo(conn)
}
\arguments{
  \item{conn}{A database connection object.}
}
\details{
  Any useful information such as the database host and connection status
  should be returned.
}
\value{
  An arbitrary list of connection attributes.
}
\note{I should probably define a \code{dbConnectionOK} method that is
  generic and return \code{TRUE} when the connection is valid.  However,
you don't need to constantly check for a valid connection object.  Keep
the code path short!  For example, in Rdbi.PgSQL, there is a C function
that submits a query request to the database backend.  This is the only
time that the connection object is actually derefenced to its connection
pointer.  This C function checks for a valid connection and returns and
error if needed.  Therefore there is no reason to check whether the
connection is valid before passing it to a query function; the C code
will do the check.  In this way the interface is simplified and the
connection checking is localized to a single call instead of scattered
all over the code.  As Bertrand Meyer put it: \emph{"Defensive coding is
  offensive!"}.}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt} \seealso{\code{\link{dbConnect}},
\code{\link{dbDisconnect}},
  \link{methods}, \code{\link{class}}}
\keyword{methods}
\keyword{connection}
\keyword{data}


\eof
\name{dbDisconnect}
\alias{dbDisconnect}
\title{Closes a database connection}
\description{
  \code{dbDisconnect} a generic function that, when called with a valid
  connection object, closes the database connection and frees any
  resource associated with the connection.
}
\usage{
dbDisconnect(conn)
}
\arguments{
  \item{conn}{A database connection object.}
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \code{\link{dbReconnect}},
  \link{methods}, \code{\link{class}}}
\keyword{methods}
\keyword{connection}
\keyword{data}


\eof
\name{dbGetQuery}
\alias{dbGetQuery}
\title{Submit a query string and fetch results}
\description{
  \code{dbGetQuery} is a generic function that, when called on a valid
  connection object, executes a query and returns a dataframe with the
  query results, or an error if no results were generated.
}
\usage{
dbGetQuery(conn, ...)
}
\arguments{
  \item{conn}{A database connection object}
  \item{\dots}{Arguments that when pasted together form a query string}
}
\details{
  Simply calls \code{\link{dbSendQuery}} and \code{\link{dbGetResult}}.
}
\value{
  A dataframe with the results.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \code{\link{dbGetResult}},
  \link{methods}, \code{\link{class}}, \code{\link{paste}}}  

\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{dbGetResult}
\alias{dbGetResult}
\title{Fetch results from a query}
\description{
  \code{dbGetResult} is a generic function that, when called on a result
  object, returns any tuples associated with the object.
}
\usage{
dbGetResult(result)
}
\arguments{
  \item{result}{A query result object.}
}
\details{
  Fetches the results of a query and returns a dataframe.  Non-character
  types should probably be converted to the appropriate numeric or
  logical type.  A generic type conversion interface is still needed.
}
\value{
  A dataframe with the results.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}

\seealso{\code{\link{dbSendQuery}}, \code{\link{data.frame}}}

\keyword{methods}
\keyword{data}

\eof
\name{dbListTables}
\alias{dbListTables}
\title{Lists database tables}
\description{
  A generic function that, when called on a valid connection object,
  returns a list of tables stored in the database backend.
}
\usage{
dbListTables(conn, ...)
}
\arguments{
  \item{conn}{A database connection object.}
  \item{\dots}{Additional arguments.}
}
\value{
  A list of character strings with table names.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \code{\link{ls}}, \link{methods},
  \code{\link{class}}, \code{\link{match.call}}} 
\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{dbReadTable}
\alias{dbReadTable}
\title{Reads a table into a data frame}
\description{
  \code{dbReadTable} is a generic function that, when called on a valid
  connection object, reads a table from the database backend and returns
  a data frame with the contents.
}
\usage{
dbReadTable(conn, ...)
}
\arguments{
  \item{conn}{A database connection object.}
  \item{\dots}{Additional arguments.}
}
\details{
  SQL types should be cast to R types to the extent possible.  A generic
  mechanism for type conversion is lacking.
}
\value{
  A data frame.
}

\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \link{methods}, \code{\link{class}}}

\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{dbReconnect}
\alias{dbReconnect}
\alias{dbReconnect.Rdbi.conn}
\title{Reopens a connection to a database}
\description{
  \code{dbReconnect} a generic function that, when called with a valid
  connection object, reopens the connection to the database backend.
}
\usage{
dbReconnect(conn)
}
\arguments{
  \item{conn}{A database connection object.}
}
\details{
  A database connection object contains the necessary information to
  re-establish a connection.  Thus, a database connection object can be
  saved across R sessions and reconnected later.  If I can convince the
  R developers to add a generic function that is always called when
  objects are restored, then it will be possible to have connections
  persist across R sessions.

  Note that packages that implement the Rdbi interface do not need to
  provide a \code{dbReconnect} function as long as the connection object
  returned by \code{\link{dbConnect}} inherits from "Rdbi.conn" and has
  attributes described in the documentation for \code{\link{dbConnect}}.
  \code{dbReconnect.Rdbi.conn} can reconnect the object.  If
  \code{dbReconnect.Rdbi.conn} is not general enough, the
  package can provide its own method.
}
\value{
  A database connection object.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \code{\link{dbDisconnect}},
  \link{methods}, \code{\link{class}}}
\keyword{methods}
\keyword{connection}
\keyword{data}


\eof
\name{dbResultInfo}
\alias{dbResultInfo}
\title{Returns information about a query result}
\description{
  \code{dbResultInfo} is a generic function that, when called on a
  result object, returns a list with status information.
}
\usage{
dbResultInfo(result)
}
\arguments{
  \item{result}{A query result object.}
}
\value{
  A list with result status information.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}

\seealso{\code{\link{dbSendQuery}}}

\keyword{methods}

\eof
\name{dbSendQuery}
\alias{dbSendQuery}
\title{Submits a query string to the database backend}
\description{
  \code{dbSendQuery} is a generic function that, when called on a valid
  connection object, pastes is argments into a query string and submits
  it to the database backend for processing.
}
\usage{
dbSendQuery(conn, ...)
}
\arguments{
  \item{conn}{A database connection object.}
  \item{\dots}{Arguments that when pasted together form a query string.}
}
\details{
  Sub-classed \code{dbSendQuery} methods should not fail unless the
  connection is not valid, in which case an error message should be
  printed.  Information about the query result status can be obtained
  by dereferencing the returned result object.
}
\value{
  A result object inheriting from "Rdbi.result".  You can arrange for
  the result buffer to be cleared when the result object is garbage
  collected by registering a finalizer function.  See the C code in
  Rdbi.PgSQL.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \code{\link{dbGetResult}},
  \code{\link{dbResultInfo}}, \link{methods}, \code{\link{class}},
  \code{\link{paste}}}  

\keyword{methods}
\keyword{connection}
\keyword{data}



\eof
\name{dbWriteTable}
\alias{dbWriteTable}
\title{Writes a data frame to a database table}
\description{
  \code{dbWriteTable} is a generic function that, when called on a valid
  connection object, write a data frame to a database table.
}
\usage{
dbWriteTable(conn, ...)
}
\arguments{
  \item{conn}{A database connection object.}
  \item{\dots}{Additional arguments.}
}
\details{
  Any writes to the database backend should be atomic.  Packages
  subclassing Rdbi need to use or emulate transactions.
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\seealso{\code{\link{dbConnect}}, \link{methods}, \code{\link{class}},
  \code{\link{on.exit}}}

\keyword{methods}
\keyword{connection}
\keyword{data}

\eof
\name{Utility functions}
\alias{list.to.csv}
\alias{list.to.key.pair.string}
\alias{printListPairs}
\alias{single.quote}
\alias{double.quote}
\alias{strip.line.feeds}
\alias{expand.asis}
\title{Utility functions}
\description{
  \code{list.to.csv} converts a list of values to a comma seperated
  string.
  
  \code{list.to.key.pair.string} takes a list and reformats it as a
  string with arbitrary seperators between keys and values and between
  key-value pairs.
  
  \code{printListPairs} is a simple utility function that prints list
  key-value pairs nicely formated.
  
  \code{single.quote} pastes its arguments into a single quoted string.
  
  \code{double.quote} pastes its arguments into a double quoted string.
  
  \code{strip.line.feeds} removes line feeds from a string.
  
  \code{expand.asis} takes an "asis" argument as used in
  \code{\link{read.table}}} and returns a vector of bools indicating
  whether columns should be converted to factors.
}
\usage{
list.to.csv(...)
list.to.key.pair.string(key.list, key.sep = "=", pair.sep = " ")
printListPairs(list)
single.quote(...)
double.quote(...)
strip.line.feeds(x)
expand.asis(as.is, len = length(as.is))
}
\arguments{
  \item{list}{A list of values.}
  \item{key.sep}{Seperator between keys and values.}
  \item{pair.sep}{Seperator between key-value pairs.}
  \item{string}{A text string.}
  \item{as.is}{A column name or number, or a vector of column numbers,
    or a vector of booleans indicating which columns to leave in
    character mode as opposed to converting to factors.}
  \item{len}{The length of the output "asis" vector.}
}
\references{\url{http://rdbi.sourceforge.net/}}
\author{Timothy H. Keitt}
\examples{
list.to.csv(list(a = 'a', b = 'b', c = 'c'))
printListPairs(list(a = 'a', b = 'b', c = 'c'))
list.to.key.pair.string(list(a = 'a', b = 'b', c = 'c'),
 key.sep = " -> ", pair.sep = " | ")
single.quote("test")
double.quote("test")
expand.asis(5, 10)
strip.line.feeds("test\n")
}
\keyword{internal}


\eof
