/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;

public final class ErrorMsg {
    private int _code;
    private int _line;
    private String _message = null;
    private String _url = null;
    Object[] _params = null;
    public static final int MULTIPLE_STYLESHEET_ERR = 0;
    public static final int TEMPLATE_REDEF_ERR = 1;
    public static final int TEMPLATE_UNDEF_ERR = 2;
    public static final int VARIABLE_REDEF_ERR = 3;
    public static final int VARIABLE_UNDEF_ERR = 4;
    public static final int CLASS_NOT_FOUND_ERR = 5;
    public static final int METHOD_NOT_FOUND_ERR = 6;
    public static final int ARGUMENT_CONVERSION_ERR = 7;
    public static final int FILE_NOT_FOUND_ERR = 8;
    public static final int INVALID_URI_ERR = 9;
    public static final int FILE_ACCESS_ERR = 10;
    public static final int MISSING_ROOT_ERR = 11;
    public static final int NAMESPACE_UNDEF_ERR = 12;
    public static final int FUNCTION_RESOLVE_ERR = 13;
    public static final int NEED_LITERAL_ERR = 14;
    public static final int XPATH_PARSER_ERR = 15;
    public static final int REQUIRED_ATTR_ERR = 16;
    public static final int ILLEGAL_CHAR_ERR = 17;
    public static final int ILLEGAL_PI_ERR = 18;
    public static final int STRAY_ATTRIBUTE_ERR = 19;
    public static final int ILLEGAL_ATTRIBUTE_ERR = 20;
    public static final int CIRCULAR_INCLUDE_ERR = 21;
    public static final int RESULT_TREE_SORT_ERR = 22;
    public static final int SYMBOLS_REDEF_ERR = 23;
    public static final int XSL_VERSION_ERR = 24;
    public static final int CIRCULAR_VARIABLE_ERR = 25;
    public static final int ILLEGAL_BINARY_OP_ERR = 26;
    public static final int ILLEGAL_ARG_ERR = 27;
    public static final int DOCUMENT_ARG_ERR = 28;
    public static final int MISSING_WHEN_ERR = 29;
    public static final int MULTIPLE_OTHERWISE_ERR = 30;
    public static final int STRAY_OTHERWISE_ERR = 31;
    public static final int STRAY_WHEN_ERR = 32;
    public static final int WHEN_ELEMENT_ERR = 33;
    public static final int UNNAMED_ATTRIBSET_ERR = 34;
    public static final int ILLEGAL_CHILD_ERR = 35;
    public static final int ILLEGAL_ELEM_NAME_ERR = 36;
    public static final int ILLEGAL_ATTR_NAME_ERR = 37;
    public static final int ILLEGAL_TEXT_NODE_ERR = 38;
    public static final int SAX_PARSER_CONFIG_ERR = 39;
    public static final int INTERNAL_ERR = 40;
    public static final int UNSUPPORTED_XSL_ERR = 41;
    public static final int UNSUPPORTED_EXT_ERR = 42;
    public static final int MISSING_XSLT_URI_ERR = 43;
    public static final int MISSING_XSLT_TARGET_ERR = 44;
    public static final int NOT_IMPLEMENTED_ERR = 45;
    public static final int NOT_STYLESHEET_ERR = 46;
    public static final int ELEMENT_PARSE_ERR = 47;
    public static final int KEY_USE_ATTR_ERR = 48;
    public static final int OUTPUT_VERSION_ERR = 49;
    public static final int ILLEGAL_RELAT_OP_ERR = 50;
    public static final int ATTRIBSET_UNDEF_ERR = 51;
    public static final int ATTR_VAL_TEMPLATE_ERR = 52;
    public static final int UNKNOWN_SIG_TYPE_ERR = 53;
    public static final int DATA_CONVERSION_ERR = 54;
    public static final int NO_TRANSLET_CLASS_ERR = 55;
    public static final int NO_MAIN_TRANSLET_ERR = 56;
    public static final int TRANSLET_CLASS_ERR = 57;
    public static final int TRANSLET_OBJECT_ERR = 58;
    public static final int ERROR_LISTENER_NULL_ERR = 59;
    public static final int JAXP_UNKNOWN_SOURCE_ERR = 60;
    public static final int JAXP_NO_SOURCE_ERR = 61;
    public static final int JAXP_COMPILE_ERR = 62;
    public static final int JAXP_INVALID_ATTR_ERR = 63;
    public static final int JAXP_SET_RESULT_ERR = 64;
    public static final int JAXP_NO_TRANSLET_ERR = 65;
    public static final int JAXP_NO_HANDLER_ERR = 66;
    public static final int JAXP_NO_RESULT_ERR = 67;
    public static final int JAXP_UNKNOWN_PROP_ERR = 68;
    public static final int SAX2DOM_ADAPTER_ERR = 69;
    public static final int XSLTC_SOURCE_ERR = 70;
    public static final int COMPILE_STDIN_ERR = 71;
    public static final int COMPILE_USAGE_STR = 72;
    public static final int TRANSFORM_USAGE_STR = 73;
    public static final int STRAY_SORT_ERR = 74;
    public static final int UNSUPPORTED_ENCODING = 75;
    public static final int SYNTAX_ERR = 76;
    public static final int CONSTRUCTOR_NOT_FOUND = 77;
    public static final int NO_JAVA_FUNCT_THIS_REF = 78;
    public static final int TYPE_CHECK_ERR = 79;
    public static final int TYPE_CHECK_UNK_LOC_ERR = 80;
    public static final int ILLEGAL_CMDLINE_OPTION_ERR = 81;
    public static final int CMDLINE_OPT_MISSING_ARG_ERR = 82;
    public static final int WARNING_PLUS_WRAPPED_MSG = 83;
    public static final int WARNING_MSG = 84;
    public static final int FATAL_ERR_PLUS_WRAPPED_MSG = 85;
    public static final int FATAL_ERR_MSG = 86;
    public static final int ERROR_PLUS_WRAPPED_MSG = 87;
    public static final int ERROR_MSG = 88;
    public static final int TRANSFORM_WITH_TRANSLET_STR = 89;
    public static final int TRANSFORM_WITH_JAR_STR = 90;
    private static String[] _errorMessages;
    private static String _compileError;
    private static String _compileWarning;
    private static String _runtimeError;
    public static final String ERROR_MESSAGES_KEY = "error-messages";
    public static final String COMPILER_ERROR_KEY = "compile-error";
    public static final String COMPILER_WARNING_KEY = "compile-warning";
    public static final String RUNTIME_ERROR_KEY = "runtime-error";

    public ErrorMsg(int code) {
        this._code = code;
        this._line = 0;
    }

    public ErrorMsg(String message) {
        this._code = -1;
        this._message = message;
        this._line = 0;
    }

    public ErrorMsg(String message, int line) {
        this._code = -1;
        this._message = message;
        this._line = line;
    }

    public ErrorMsg(int code, int line, Object param) {
        this._code = code;
        this._line = line;
        this._params = new Object[]{param};
    }

    public ErrorMsg(int code, Object param) {
        this(code);
        this._params = new Object[1];
        this._params[0] = param;
    }

    public ErrorMsg(int code, Object param1, Object param2) {
        this(code);
        this._params = new Object[2];
        this._params[0] = param1;
        this._params[1] = param2;
    }

    public ErrorMsg(int code, SyntaxTreeNode node) {
        this._code = code;
        this._url = this.getFileName(node);
        this._line = node.getLineNumber();
    }

    public ErrorMsg(int code, Object param1, SyntaxTreeNode node) {
        this._code = code;
        this._url = this.getFileName(node);
        this._line = node.getLineNumber();
        this._params = new Object[1];
        this._params[0] = param1;
    }

    public ErrorMsg(int code, Object param1, Object param2, SyntaxTreeNode node) {
        this._code = code;
        this._url = this.getFileName(node);
        this._line = node.getLineNumber();
        this._params = new Object[2];
        this._params[0] = param1;
        this._params[1] = param2;
    }

    public static String getCompileErrorMessage() {
        return _compileError;
    }

    public static String getCompileWarningMessage() {
        return _compileWarning;
    }

    public static String getTransletErrorMessage() {
        return _runtimeError;
    }

    private String getFileName(SyntaxTreeNode node) {
        Stylesheet stylesheet = node.getStylesheet();
        if (stylesheet != null) {
            return stylesheet.getSystemId();
        }
        return null;
    }

    private String formatLine() {
        StringBuffer result = new StringBuffer();
        if (this._url != null) {
            result.append(this._url);
            result.append(": ");
        }
        if (this._line > 0) {
            result.append("line ");
            result.append(Integer.toString(this._line));
            result.append(": ");
        }
        return result.toString();
    }

    public String toString() {
        String suffix = this._params == null ? (this._code >= 0 ? new String(_errorMessages[this._code]) : this._message) : MessageFormat.format(_errorMessages[this._code], this._params);
        return this.formatLine() + suffix;
    }

    public String toString(Object obj) {
        Object[] params = new Object[]{obj.toString()};
        String suffix = MessageFormat.format(_errorMessages[this._code], params);
        return this.formatLine() + suffix;
    }

    public String toString(Object obj0, Object obj1) {
        Object[] params = new Object[]{obj0.toString(), obj1.toString()};
        String suffix = MessageFormat.format(_errorMessages[this._code], params);
        return this.formatLine() + suffix;
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("org.apache.xalan.xsltc.compiler.util.ErrorMessages", Locale.getDefault());
        _errorMessages = bundle.getStringArray(ERROR_MESSAGES_KEY);
        _compileError = bundle.getString(COMPILER_ERROR_KEY);
        _compileWarning = bundle.getString(COMPILER_WARNING_KEY);
        _runtimeError = bundle.getString(RUNTIME_ERROR_KEY);
    }
}

