/*
 * Decompiled with CFR 0.152.
 */
package JLex;

import JLex.CAccept;
import JLex.CDTrans;
import JLex.CEmit;
import JLex.CError;
import JLex.CInput;
import JLex.CMakeNfa;
import JLex.CMinimize;
import JLex.CNfa;
import JLex.CNfa2Dfa;
import JLex.CSet;
import JLex.CSimplifyNfa;
import JLex.CSpec;
import JLex.CUtility;
import JLex.SparseBitSet;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CLexGen {
    private Reader m_instream;
    private PrintWriter m_outstream;
    private CInput m_input;
    private Hashtable m_tokens;
    private CSpec m_spec;
    private boolean m_init_flag = false;
    private CMakeNfa m_makeNfa;
    private CNfa2Dfa m_nfa2dfa;
    private CMinimize m_minimize;
    private CSimplifyNfa m_simplifyNfa;
    private CEmit m_emit;
    private static final boolean ERROR = false;
    private static final boolean NOT_ERROR = true;
    private static final int BUFFER_SIZE = 1024;
    static final int EOS = 1;
    static final int ANY = 2;
    static final int AT_BOL = 3;
    static final int AT_EOL = 4;
    static final int CCL_END = 5;
    static final int CCL_START = 6;
    static final int CLOSE_CURLY = 7;
    static final int CLOSE_PAREN = 8;
    static final int CLOSURE = 9;
    static final int DASH = 10;
    static final int END_OF_INPUT = 11;
    static final int L = 12;
    static final int OPEN_CURLY = 13;
    static final int OPEN_PAREN = 14;
    static final int OPTIONAL = 15;
    static final int OR = 16;
    static final int PLUS_CLOSE = 17;
    private final int CLASS_CODE = 0;
    private final int INIT_CODE = 1;
    private final int EOF_CODE = 2;
    private final int INIT_THROW_CODE = 3;
    private final int YYLEX_THROW_CODE = 4;
    private final int EOF_THROW_CODE = 5;
    private final int EOF_VALUE_CODE = 6;
    private char[] m_state_dir = new char[]{'%', 's', 't', 'a', 't', 'e', '\u0000'};
    private char[] m_char_dir = new char[]{'%', 'c', 'h', 'a', 'r', '\u0000'};
    private char[] m_line_dir = new char[]{'%', 'l', 'i', 'n', 'e', '\u0000'};
    private char[] m_cup_dir = new char[]{'%', 'c', 'u', 'p', '\u0000'};
    private char[] m_class_dir = new char[]{'%', 'c', 'l', 'a', 's', 's', '\u0000'};
    private char[] m_implements_dir = new char[]{'%', 'i', 'm', 'p', 'l', 'e', 'm', 'e', 'n', 't', 's', '\u0000'};
    private char[] m_function_dir = new char[]{'%', 'f', 'u', 'n', 'c', 't', 'i', 'o', 'n', '\u0000'};
    private char[] m_type_dir = new char[]{'%', 't', 'y', 'p', 'e', '\u0000'};
    private char[] m_integer_dir = new char[]{'%', 'i', 'n', 't', 'e', 'g', 'e', 'r', '\u0000'};
    private char[] m_intwrap_dir = new char[]{'%', 'i', 'n', 't', 'w', 'r', 'a', 'p', '\u0000'};
    private char[] m_full_dir = new char[]{'%', 'f', 'u', 'l', 'l', '\u0000'};
    private char[] m_unicode_dir = new char[]{'%', 'u', 'n', 'i', 'c', 'o', 'd', 'e', '\u0000'};
    private char[] m_ignorecase_dir = new char[]{'%', 'i', 'g', 'n', 'o', 'r', 'e', 'c', 'a', 's', 'e', '\u0000'};
    private char[] m_notunix_dir = new char[]{'%', 'n', 'o', 't', 'u', 'n', 'i', 'x', '\u0000'};
    private char[] m_init_code_dir = new char[]{'%', 'i', 'n', 'i', 't', '{', '\u0000'};
    private char[] m_init_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', '}', '\u0000'};
    private char[] m_init_throw_code_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_init_throw_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_yylex_throw_code_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_yylex_throw_code_end_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_eof_code_dir = new char[]{'%', 'e', 'o', 'f', '{', '\u0000'};
    private char[] m_eof_code_end_dir = new char[]{'%', 'e', 'o', 'f', '}', '\u0000'};
    private char[] m_eof_value_code_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '{', '\u0000'};
    private char[] m_eof_value_code_end_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '}', '\u0000'};
    private char[] m_eof_throw_code_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_eof_throw_code_end_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_class_code_dir = new char[]{'%', '{', '\u0000'};
    private char[] m_class_code_end_dir = new char[]{'%', '}', '\u0000'};
    private char[] m_yyeof_dir = new char[]{'%', 'y', 'y', 'e', 'o', 'f', '\u0000'};
    private char[] m_public_dir = new char[]{'%', 'p', 'u', 'b', 'l', 'i', 'c', '\u0000'};
    private SparseBitSet all_states = null;
    private boolean m_advance_stop = false;

    CLexGen(String string) throws FileNotFoundException, IOException {
        this.m_instream = new FileReader(string);
        if (null == this.m_instream) {
            System.out.println("Error: Unable to open input file " + string + ".");
            return;
        }
        this.m_outstream = new PrintWriter(new BufferedWriter(new FileWriter(string + ".java")));
        if (null == this.m_outstream) {
            System.out.println("Error: Unable to open output file " + string + ".java.");
            return;
        }
        this.m_input = new CInput(this.m_instream);
        this.m_tokens = new Hashtable();
        this.m_tokens.put(new Character('$'), new Integer(4));
        this.m_tokens.put(new Character('('), new Integer(14));
        this.m_tokens.put(new Character(')'), new Integer(8));
        this.m_tokens.put(new Character('*'), new Integer(9));
        this.m_tokens.put(new Character('+'), new Integer(17));
        this.m_tokens.put(new Character('-'), new Integer(10));
        this.m_tokens.put(new Character('.'), new Integer(2));
        this.m_tokens.put(new Character('?'), new Integer(15));
        this.m_tokens.put(new Character('['), new Integer(6));
        this.m_tokens.put(new Character(']'), new Integer(5));
        this.m_tokens.put(new Character('^'), new Integer(3));
        this.m_tokens.put(new Character('{'), new Integer(13));
        this.m_tokens.put(new Character('|'), new Integer(16));
        this.m_tokens.put(new Character('}'), new Integer(7));
        this.m_spec = new CSpec(this);
        this.m_nfa2dfa = new CNfa2Dfa();
        this.m_minimize = new CMinimize();
        this.m_makeNfa = new CMakeNfa();
        this.m_simplifyNfa = new CSimplifyNfa();
        this.m_emit = new CEmit();
        this.m_init_flag = true;
    }

    void generate() throws IOException, FileNotFoundException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        CUtility.assert(this.m_init_flag);
        if (this.m_spec.m_verbose) {
            System.out.println("Processing first section -- user code.");
        }
        this.userCode();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing second section -- JLex declarations.");
        }
        this.userDeclare();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing third section -- lexical rules.");
        }
        this.userRules();
        if (this.m_spec.m_verbose) {
            System.out.println("Outputting lexical analyzer code.");
        }
        this.m_emit.emit(this.m_spec, this.m_outstream);
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.m_outstream.close();
    }

    private void userCode() throws IOException {
        boolean bl = false;
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, 0);
        }
        while (true) {
            if (this.m_input.getLine()) {
                CError.parse_error(11, 0);
            }
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_index = this.m_input.m_line_read;
                return;
            }
            this.m_outstream.print(new String(this.m_input.m_line, 0, this.m_input.m_line_read));
        }
    }

    private char[] getName() {
        while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
        }
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            CError.parse_error(12, 0);
        }
        int n = this.m_input.m_line_index;
        while (n < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[n])) {
            ++n;
        }
        char[] cArray = new char[n - this.m_input.m_line_index];
        n = 0;
        while (this.m_input.m_line_index < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[this.m_input.m_line_index])) {
            cArray[n] = this.m_input.m_line[this.m_input.m_line_index];
            ++n;
            ++this.m_input.m_line_index;
        }
        return cArray;
    }

    /*
     * Unable to fully structure code
     */
    private char[] packCode(char[] var1_1, char[] var2_2, char[] var3_3, int var4_4, int var5_5) throws IOException {
        CUtility.assert(1 == var5_5 || 0 == var5_5 || 2 == var5_5 || 6 == var5_5 || 3 == var5_5 || 4 == var5_5 || 5 == var5_5);
        if (0 != CUtility.charncmp(this.m_input.m_line, 0, var1_1, 0, var1_1.length - 1)) {
            CError.parse_error(13, 0);
        }
        if (null == var3_3) {
            var3_3 = new char[1024];
            var4_4 = 0;
        }
        if (var4_4 >= var3_3.length) {
            var3_3 = CUtility.doubleSize(var3_3);
        }
        this.m_input.m_line_index = var1_1.length - 1;
        block9: while (true) {
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_input.getLine()) {
                    CError.parse_error(11, this.m_input.m_line_number);
                }
                if (0 != CUtility.charncmp(this.m_input.m_line, 0, var2_2, 0, var2_2.length - 1)) continue;
                this.m_input.m_line_index = var2_2.length - 1;
                switch (var5_5) {
                    case 0: {
                        this.m_spec.m_class_read = var4_4;
                        break;
                    }
                    case 1: {
                        this.m_spec.m_init_read = var4_4;
                        break;
                    }
                    case 2: {
                        this.m_spec.m_eof_read = var4_4;
                        break;
                    }
                    case 6: {
                        this.m_spec.m_eof_value_read = var4_4;
                        break;
                    }
                    case 3: {
                        this.m_spec.m_init_throw_read = var4_4;
                        break;
                    }
                    case 4: {
                        this.m_spec.m_yylex_throw_read = var4_4;
                        break;
                    }
                    case 5: {
                        this.m_spec.m_eof_throw_read = var4_4;
                        break;
                    }
                    default: {
                        CError.parse_error(13, this.m_input.m_line_number);
                    }
                }
                return var3_3;
            }
            while (true) {
                if (this.m_input.m_line_index < this.m_input.m_line_read) ** break;
                continue block9;
                var3_3[var4_4] = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
                if (++var4_4 < var3_3.length) continue;
                var3_3 = CUtility.doubleSize(var3_3);
            }
            break;
        }
    }

    private void userDeclare() throws IOException {
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        while (!this.m_input.getLine()) {
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_read -= 2;
                System.arraycopy(this.m_input.m_line, 2, this.m_input.m_line, 0, this.m_input.m_line_read);
                this.m_input.m_pushback_line = true;
                if (0 == this.m_input.m_line_read || '\n' == this.m_input.m_line[0]) {
                    this.m_input.m_pushback_line = false;
                }
                return;
            }
            if (0 == this.m_input.m_line_read) continue;
            if ('%' == this.m_input.m_line[0]) {
                if (1 >= this.m_input.m_line_read) {
                    CError.parse_error(12, this.m_input.m_line_number);
                    continue;
                }
                switch (this.m_input.m_line[1]) {
                    case '{': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_code_dir, 0, this.m_class_code_dir.length - 1)) {
                            this.m_spec.m_class_code = this.packCode(this.m_class_code_dir, this.m_class_code_end_dir, this.m_spec.m_class_code, this.m_spec.m_class_read, 0);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'c': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_char_dir, 0, this.m_char_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_char_dir.length;
                            this.m_spec.m_count_chars = true;
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_dir, 0, this.m_class_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_class_dir.length;
                            this.m_spec.m_class_name = this.getName();
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_cup_dir, 0, this.m_cup_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_cup_dir.length;
                            this.m_spec.m_cup_compatible = true;
                            this.m_spec.m_implements_name = "java_cup.runtime.Scanner".toCharArray();
                            this.m_spec.m_function_name = "next_token".toCharArray();
                            this.m_spec.m_type_name = "java_cup.runtime.Symbol".toCharArray();
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'e': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_code_dir, 0, this.m_eof_code_dir.length - 1)) {
                            this.m_spec.m_eof_code = this.packCode(this.m_eof_code_dir, this.m_eof_code_end_dir, this.m_spec.m_eof_code, this.m_spec.m_eof_read, 2);
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_value_code_dir, 0, this.m_eof_value_code_dir.length - 1)) {
                            this.m_spec.m_eof_value_code = this.packCode(this.m_eof_value_code_dir, this.m_eof_value_code_end_dir, this.m_spec.m_eof_value_code, this.m_spec.m_eof_value_read, 6);
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_throw_code_dir, 0, this.m_eof_throw_code_dir.length - 1)) {
                            this.m_spec.m_eof_throw_code = this.packCode(this.m_eof_throw_code_dir, this.m_eof_throw_code_end_dir, this.m_spec.m_eof_throw_code, this.m_spec.m_eof_throw_read, 5);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'f': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_function_dir, 0, this.m_function_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_function_dir.length;
                            this.m_spec.m_function_name = this.getName();
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_full_dir, 0, this.m_full_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_full_dir.length;
                            this.m_spec.m_dtrans_ncols = 256;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'i': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_integer_dir, 0, this.m_integer_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_integer_type = true;
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_intwrap_dir, 0, this.m_intwrap_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_intwrap_type = true;
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_code_dir, 0, this.m_init_code_dir.length - 1)) {
                            this.m_spec.m_init_code = this.packCode(this.m_init_code_dir, this.m_init_code_end_dir, this.m_spec.m_init_code, this.m_spec.m_init_read, 1);
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_throw_code_dir, 0, this.m_init_throw_code_dir.length - 1)) {
                            this.m_spec.m_init_throw_code = this.packCode(this.m_init_throw_code_dir, this.m_init_throw_code_end_dir, this.m_spec.m_init_throw_code, this.m_spec.m_init_throw_read, 3);
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_implements_dir, 0, this.m_implements_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_implements_dir.length;
                            this.m_spec.m_implements_name = this.getName();
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_ignorecase_dir, 0, this.m_ignorecase_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_ignorecase_dir.length;
                            this.m_spec.m_ignorecase = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'l': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_line_dir, 0, this.m_line_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_line_dir.length;
                            this.m_spec.m_count_lines = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'n': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_notunix_dir, 0, this.m_notunix_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_notunix_dir.length;
                            this.m_spec.m_unix = false;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'p': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_public_dir, 0, this.m_public_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_public_dir.length;
                            this.m_spec.m_public = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 's': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_state_dir, 0, this.m_state_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_state_dir.length;
                            this.saveStates();
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 't': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_type_dir, 0, this.m_type_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_type_dir.length;
                            this.m_spec.m_type_name = this.getName();
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'u': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_unicode_dir, 0, this.m_unicode_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_unicode_dir.length;
                            this.m_spec.m_dtrans_ncols = 65536;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'y': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yyeof_dir, 0, this.m_yyeof_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_yyeof_dir.length;
                            this.m_spec.m_yyeof = true;
                            break;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yylex_throw_code_dir, 0, this.m_yylex_throw_code_dir.length - 1)) {
                            this.m_spec.m_yylex_throw_code = this.packCode(this.m_yylex_throw_code_dir, this.m_yylex_throw_code_end_dir, this.m_spec.m_yylex_throw_code, this.m_spec.m_yylex_throw_read, 4);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    default: {
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                }
                continue;
            }
            this.m_input.m_line_index = 0;
            this.saveMacro();
        }
    }

    private void userRules() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating NFA machine representation.");
        }
        this.m_makeNfa.allocate_BOL_EOF(this.m_spec);
        this.m_makeNfa.thompson(this, this.m_spec, this.m_input);
        this.m_simplifyNfa.simplify(this.m_spec);
        CUtility.assert(11 == this.m_spec.m_current_token);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating DFA transition table.");
        }
        this.m_nfa2dfa.make_dfa(this, this.m_spec);
        if (this.m_spec.m_verbose) {
            System.out.println("Minimizing DFA transition table.");
        }
        this.m_minimize.min_dfa(this.m_spec);
    }

    private void printccl(CSet cSet) {
        System.out.print(" [");
        int n = 0;
        while (n < this.m_spec.m_dtrans_ncols) {
            if (cSet.contains(n)) {
                System.out.print(this.interp_int(n));
            }
            ++n;
        }
        System.out.print(']');
    }

    private String plab(CNfa cNfa) {
        if (null == cNfa) {
            return new String("--");
        }
        int n = this.m_spec.m_nfa_states.indexOf(cNfa);
        return new Integer(n).toString();
    }

    private String interp_int(int n) {
        switch (n) {
            case 8: {
                return new String("\\b");
            }
            case 9: {
                return new String("\\t");
            }
            case 10: {
                return new String("\\n");
            }
            case 12: {
                return new String("\\f");
            }
            case 13: {
                return new String("\\r");
            }
            case 32: {
                return new String("\\ ");
            }
        }
        return new Character((char)n).toString();
    }

    void print_nfa() {
        CNfa cNfa;
        System.out.println("--------------------- NFA -----------------------");
        int n = this.m_spec.m_nfa_states.size();
        int n2 = 0;
        while (n2 < n) {
            cNfa = (CNfa)this.m_spec.m_nfa_states.elementAt(n2);
            System.out.print("Nfa state " + this.plab(cNfa) + ": ");
            if (null == cNfa.m_next) {
                System.out.print("(TERMINAL)");
            } else {
                System.out.print("--> " + this.plab(cNfa.m_next));
                System.out.print("--> " + this.plab(cNfa.m_next2));
                switch (cNfa.m_edge) {
                    case -1: {
                        this.printccl(cNfa.m_set);
                        break;
                    }
                    case -3: {
                        System.out.print(" EPSILON ");
                        break;
                    }
                    default: {
                        System.out.print(" " + this.interp_int(cNfa.m_edge));
                    }
                }
            }
            if (0 == n2) {
                System.out.print(" (START STATE)");
            }
            if (null != cNfa.m_accept) {
                System.out.print(" accepting " + (0 != (cNfa.m_anchor & 1) ? "^" : "") + "<" + new String(cNfa.m_accept.m_action, 0, cNfa.m_accept.m_action_read) + ">" + (0 != (cNfa.m_anchor & 2) ? "$" : ""));
            }
            System.out.println();
            ++n2;
        }
        Enumeration enumeration = this.m_spec.m_states.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n3 = (Integer)this.m_spec.m_states.get(string);
            CUtility.assert(null != string);
            CUtility.assert(null != n3);
            System.out.println("State \"" + string + "\" has identifying index " + n3.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            int n4 = n3;
            int n5 = this.m_spec.m_state_rules[n4].size();
            int n6 = 0;
            while (n6 < n5) {
                cNfa = (CNfa)this.m_spec.m_state_rules[n4].elementAt(n6);
                System.out.print(this.m_spec.m_nfa_states.indexOf(cNfa) + " ");
                ++n6;
            }
            System.out.println();
        }
        System.out.println("-------------------- NFA ----------------------");
    }

    SparseBitSet getStates() throws IOException {
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        SparseBitSet sparseBitSet = null;
        while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                return null;
            }
        }
        if ('<' == this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            sparseBitSet = new SparseBitSet();
            while (true) {
                int n;
                String string;
                Integer n2;
                if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return sparseBitSet;
                }
                block3: while (true) {
                    if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                        do {
                            if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                        } while (!this.m_input.getLine());
                        CError.parse_error(11, this.m_input.m_line_number);
                        return sparseBitSet;
                    }
                    if (',' != this.m_input.m_line[this.m_input.m_line_index]) break;
                    ++this.m_input.m_line_index;
                }
                if ('>' == this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) {
                        this.m_advance_stop = true;
                    }
                    return sparseBitSet;
                }
                int n3 = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index] && '>' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index >= this.m_input.m_line_read) break;
                }
                if (null == (n2 = (Integer)this.m_spec.m_states.get(string = new String(this.m_input.m_line, n3, n = this.m_input.m_line_index - n3)))) {
                    System.out.println("Uninitialized State Name: " + string);
                    CError.parse_error(14, this.m_input.m_line_number);
                }
                sparseBitSet.set(n2);
            }
        }
        if (null == this.all_states) {
            this.all_states = new SparseBitSet();
            int n = this.m_spec.m_states.size();
            int n4 = 0;
            while (n4 < n) {
                this.all_states.set(n4);
                ++n4;
            }
        }
        if (this.m_input.m_line_index < this.m_input.m_line_read) {
            this.m_advance_stop = true;
        }
        return this.all_states;
    }

    private boolean expandMacro() {
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
            CError.parse_error(13, this.m_input.m_line_number);
            return false;
        }
        int n = this.m_input.m_line_index;
        int n2 = this.m_input.m_line_index + 1;
        if (n2 >= this.m_input.m_line_read) {
            CError.impos("Unfinished macro name");
            return false;
        }
        int n3 = n2;
        while ('}' != this.m_input.m_line[n2]) {
            if (++n2 < this.m_input.m_line_read) continue;
            CError.impos("Unfinished macro name at line " + this.m_input.m_line_number);
            return false;
        }
        int n4 = n2 - n3;
        int n5 = n2;
        if (0 == n4) {
            CError.impos("Nonexistent macro name");
            return false;
        }
        CUtility.assert(0 < n4);
        String string = new String(this.m_input.m_line, n3, n4);
        String string2 = (String)this.m_spec.m_macros.get(string);
        if (null == string2) {
            System.out.println("Error: Undefined macro \"" + string + "\".");
            CError.parse_error(8, this.m_input.m_line_number);
            return false;
        }
        char[] cArray = new char[this.m_input.m_line.length];
        int n6 = 0;
        while (n6 < n) {
            cArray[n6] = this.m_input.m_line[n6];
            CUtility.assert(n6 < cArray.length);
            ++n6;
        }
        if (n6 >= cArray.length) {
            cArray = CUtility.doubleSize(cArray);
        }
        int n7 = 0;
        while (n7 < string2.length()) {
            cArray[n6] = string2.charAt(n7);
            if (++n6 >= cArray.length) {
                cArray = CUtility.doubleSize(cArray);
            }
            ++n7;
        }
        if (n6 >= cArray.length) {
            cArray = CUtility.doubleSize(cArray);
        }
        n2 = n5 + 1;
        while (n2 < this.m_input.m_line_read) {
            cArray[n6] = this.m_input.m_line[n2];
            if (++n6 >= cArray.length) {
                cArray = CUtility.doubleSize(cArray);
            }
            ++n2;
        }
        this.m_input.m_line = cArray;
        this.m_input.m_line_read = n6;
        return true;
    }

    private void saveMacro() {
        int n;
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        int n2 = 0;
        while (CUtility.isspace(this.m_input.m_line[n2])) {
            if (++n2 < this.m_input.m_line_read) continue;
            return;
        }
        int n3 = n2;
        while (!CUtility.isspace(this.m_input.m_line[n2]) && '=' != this.m_input.m_line[n2]) {
            if (++n2 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int n4 = n2 - n3;
        if (0 == n4) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[n2])) {
            if (++n2 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        if ('=' == this.m_input.m_line[n2] && ++n2 >= this.m_input.m_line_read) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[n2])) {
            if (++n2 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int n5 = n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!CUtility.isspace(this.m_input.m_line[n2]) || bl || bl2 || bl3) {
            if ('\"' == this.m_input.m_line[n2] && !bl3) {
                bl = !bl;
            }
            if (!(bl3 = '\\' == this.m_input.m_line[n2] && false == bl3) && !bl) {
                if ('[' == this.m_input.m_line[n2] && !bl2) {
                    bl2 = true;
                }
                if (']' == this.m_input.m_line[n2] && bl2) {
                    bl2 = false;
                }
            }
            if (++n2 >= this.m_input.m_line_read) break;
        }
        if (0 == (n = n2 - n5)) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        CUtility.assert(0 < n);
        CUtility.assert(0 < n4);
        CUtility.assert(null != this.m_spec.m_macros);
        this.m_spec.m_macros.put(new String(this.m_input.m_line, n3, n4), new String(this.m_input.m_line, n5, n));
    }

    /*
     * Unable to fully structure code
     */
    private void saveStates() {
        CUtility.assert(null != this);
        CUtility.assert(null != this.m_outstream);
        CUtility.assert(null != this.m_input);
        CUtility.assert(null != this.m_tokens);
        CUtility.assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            return;
        }
        CUtility.assert('%' == this.m_input.m_line[0]);
        CUtility.assert('s' == this.m_input.m_line[1]);
        CUtility.assert(this.m_input.m_line_index <= this.m_input.m_line_read);
        CUtility.assert(0 <= this.m_input.m_line_index);
        CUtility.assert(0 <= this.m_input.m_line_read);
        if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl32
        return;
        {
            ++this.m_input.m_line_index;
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                return;
            }
            do {
                if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) continue block0;
                var1_1 = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index >= this.m_input.m_line_read) break;
                }
                var2_2 = this.m_input.m_line_index - var1_1;
                this.m_spec.m_states.put(new String(this.m_input.m_line, var1_1, var2_2), new Integer(this.m_spec.m_states.size()));
                if (',' != this.m_input.m_line[this.m_input.m_line_index]) continue;
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                return;
lbl32:
                // 3 sources

            } while (this.m_input.m_line_index < this.m_input.m_line_read);
        }
    }

    private char expandEscape() {
        char c;
        CUtility.assert(this.m_input.m_line_index < this.m_input.m_line_read);
        CUtility.assert(0 < this.m_input.m_line_read);
        CUtility.assert(0 <= this.m_input.m_line_index);
        if ('\\' != this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            return this.m_input.m_line[this.m_input.m_line_index - 1];
        }
        boolean bl = false;
        ++this.m_input.m_line_index;
        switch (this.m_input.m_line[this.m_input.m_line_index]) {
            case 'b': {
                ++this.m_input.m_line_index;
                return '\b';
            }
            case 't': {
                ++this.m_input.m_line_index;
                return '\t';
            }
            case 'n': {
                ++this.m_input.m_line_index;
                return '\n';
            }
            case 'f': {
                ++this.m_input.m_line_index;
                return '\f';
            }
            case 'r': {
                ++this.m_input.m_line_index;
                return '\r';
            }
            case '^': {
                ++this.m_input.m_line_index;
                char c2 = Character.toUpperCase(this.m_input.m_line[this.m_input.m_line_index]);
                if (c2 < '@' || c2 > 'Z') {
                    CError.parse_error(20, this.m_input.m_line_number);
                }
                c2 = (char)(c2 - 64);
                ++this.m_input.m_line_index;
                return c2;
            }
            case 'u': {
                bl = true;
            }
            case 'x': {
                ++this.m_input.m_line_index;
                char c3 = '\u0000';
                int n = 0;
                while (n < (bl ? 4 : 2)) {
                    if (!CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index])) break;
                    c3 = (char)(c3 << 4);
                    c3 = (char)(c3 | CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index]));
                    ++this.m_input.m_line_index;
                    ++n;
                }
                return c3;
            }
        }
        if (!CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
            c = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        } else {
            c = '\u0000';
            int n = 0;
            while (n < 3) {
                if (!CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) break;
                c = (char)(c << 3);
                c = (char)(c | CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index]));
                ++this.m_input.m_line_index;
                ++n;
            }
        }
        return c;
    }

    CAccept packAccept() throws IOException {
        int n;
        char[] cArray;
        block23: {
            cArray = new char[1024];
            n = 0;
            CUtility.assert(null != this);
            CUtility.assert(null != this.m_outstream);
            CUtility.assert(null != this.m_input);
            CUtility.assert(null != this.m_tokens);
            CUtility.assert(null != this.m_spec);
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                CError.parse_error(11, this.m_input.m_line_number);
                return null;
            }
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return null;
                }
            }
            if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
                CError.parse_error(17, this.m_input.m_line_number);
            }
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block3: while (true) {
                cArray[n] = this.m_input.m_line[this.m_input.m_line_index];
                if ((bl6 || bl5) && bl2) {
                    bl2 = false;
                } else if ((bl6 || bl5) && '\\' == this.m_input.m_line[this.m_input.m_line_index]) {
                    bl2 = true;
                } else if (!(bl6 || bl4 || bl3 || '\"' != this.m_input.m_line[this.m_input.m_line_index])) {
                    bl5 = !bl5;
                } else if (!(bl5 || bl4 || bl3 || '\'' != this.m_input.m_line[this.m_input.m_line_index])) {
                    boolean bl7 = bl6 = !bl6;
                }
                if (bl3) {
                    if (bl && '/' == this.m_input.m_line[this.m_input.m_line_index]) {
                        bl = false;
                        bl3 = false;
                    } else {
                        bl = '*' == this.m_input.m_line[this.m_input.m_line_index];
                    }
                } else if (!(bl4 || bl6 || bl5)) {
                    bl4 = bl && '/' == this.m_input.m_line[this.m_input.m_line_index];
                    bl3 = bl && '*' == this.m_input.m_line[this.m_input.m_line_index];
                    boolean bl8 = bl = '/' == this.m_input.m_line[this.m_input.m_line_index];
                }
                if (!(bl6 || bl5 || bl3 || bl4)) {
                    if ('{' == this.m_input.m_line[this.m_input.m_line_index]) {
                        ++n2;
                    } else if ('}' == this.m_input.m_line[this.m_input.m_line_index] && 0 == --n2) {
                        ++this.m_input.m_line_index;
                        break block23;
                    }
                }
                if (++n >= cArray.length) {
                    cArray = CUtility.doubleSize(cArray);
                }
                ++this.m_input.m_line_index;
                do {
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                    bl = false;
                    bl4 = false;
                    if (!bl6 && !bl5) continue;
                    CError.parse_error(6, this.m_input.m_line_number);
                    bl5 = false;
                    bl6 = false;
                } while (!this.m_input.getLine());
                break;
            }
            CError.parse_error(16, this.m_input.m_line_number);
            return null;
        }
        CAccept cAccept = new CAccept(cArray, ++n, this.m_input.m_line_number);
        CUtility.assert(null != cAccept);
        return cAccept;
    }

    /*
     * Unable to fully structure code
     */
    int advance() throws IOException {
        block19: {
            var1_1 = false;
            if (this.m_input.m_eof_reached) {
                this.m_spec.m_current_token = 11;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (1 == this.m_spec.m_current_token || this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_spec.m_in_quote) {
                    CError.parse_error(16, this.m_input.m_line_number);
                }
                do {
                    if (!this.m_advance_stop || this.m_input.m_line_index >= this.m_input.m_line_read) {
                        if (this.m_input.getLine()) {
                            this.m_spec.m_current_token = 11;
                            this.m_spec.m_lexeme = '\u0000';
                            return this.m_spec.m_current_token;
                        }
                        this.m_input.m_line_index = 0;
                    } else {
                        this.m_advance_stop = false;
                    }
                    while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                    }
                } while (this.m_input.m_line_index >= this.m_input.m_line_read);
            }
            CUtility.assert(this.m_input.m_line_index <= this.m_input.m_line_read);
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.m_spec.m_in_quote || '{' != this.m_input.m_line[this.m_input.m_line_index]) break block20;
                    if (!this.expandMacro()) break block19;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl-1000
                    this.m_spec.m_current_token = 1;
                    this.m_spec.m_lexeme = '\u0000';
                    return this.m_spec.m_current_token;
                }
                if ('\"' != this.m_input.m_line[this.m_input.m_line_index]) break block19;
                this.m_spec.m_in_quote = this.m_spec.m_in_quote == false;
                ++this.m_input.m_line_index;
            } while (this.m_input.m_line_index < this.m_input.m_line_read);
            this.m_spec.m_current_token = 1;
            this.m_spec.m_lexeme = '\u0000';
            return this.m_spec.m_current_token;
        }
        if (this.m_input.m_line_index > this.m_input.m_line_read) {
            System.out.println("m_input.m_line_index = " + this.m_input.m_line_index);
            System.out.println("m_input.m_line_read = " + this.m_input.m_line_read);
            CUtility.assert(this.m_input.m_line_index <= this.m_input.m_line_read);
        }
        var1_1 = '\\' == this.m_input.m_line[this.m_input.m_line_index];
        if (!this.m_spec.m_in_quote) {
            if (!this.m_spec.m_in_ccl && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                this.m_spec.m_current_token = 1;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (var1_1) {
                this.m_spec.m_lexeme = this.expandEscape();
            } else {
                this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
            }
        } else if (var1_1 && this.m_input.m_line_index + 1 < this.m_input.m_line_read && '\"' == this.m_input.m_line[this.m_input.m_line_index + 1]) {
            this.m_spec.m_lexeme = (char)34;
            this.m_input.m_line_index += 2;
        } else {
            this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        }
        var2_2 = (Integer)this.m_tokens.get(new Character(this.m_spec.m_lexeme));
        this.m_spec.m_current_token = this.m_spec.m_in_quote != false || true == var1_1 ? 12 : (null == var2_2 ? 12 : var2_2);
        if (6 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = true;
        }
        if (5 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = false;
        }
        return this.m_spec.m_current_token;
    }

    private void details() {
        System.out.println();
        System.out.println("\t** Macros **");
        Enumeration enumeration = this.m_spec.m_macros.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.m_spec.m_macros.get(string);
            CUtility.assert(null != string);
            CUtility.assert(null != string2);
            System.out.println("Macro name \"" + string + "\" has definition \"" + string2 + "\".");
        }
        System.out.println();
        System.out.println("\t** States **");
        Enumeration enumeration2 = this.m_spec.m_states.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            Integer n = (Integer)this.m_spec.m_states.get(string);
            CUtility.assert(null != string);
            CUtility.assert(null != n);
            System.out.println("State \"" + string + "\" has identifying index " + n.toString() + ".");
        }
        System.out.println();
        System.out.println("\t** Character Counting **");
        if (!this.m_spec.m_count_chars) {
            System.out.println("Character counting is off.");
        } else {
            CUtility.assert(this.m_spec.m_count_lines);
            System.out.println("Character counting is on.");
        }
        System.out.println();
        System.out.println("\t** Line Counting **");
        if (!this.m_spec.m_count_lines) {
            System.out.println("Line counting is off.");
        } else {
            CUtility.assert(this.m_spec.m_count_lines);
            System.out.println("Line counting is on.");
        }
        System.out.println();
        System.out.println("\t** Operating System Specificity **");
        if (!this.m_spec.m_unix) {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a newline, rather than \"\\n\".)");
        } else {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a newline, rather than \"\\r\\n\".)");
        }
        System.out.println();
        System.out.println("\t** Java CUP Compatibility **");
        if (!this.m_spec.m_cup_compatible) {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(Scanner implements java_cup.runtime.Scanner.)");
        } else {
            System.out.println("Not generating CUP compatible code.");
        }
        if (null != this.m_spec.m_dtrans_vector) {
            System.out.println();
            System.out.println("\t** DFA transition table **");
        }
    }

    void print_set(Vector vector) {
        int n = vector.size();
        if (0 == n) {
            System.out.print("empty ");
        }
        int n2 = 0;
        while (n2 < n) {
            CNfa cNfa = (CNfa)vector.elementAt(n2);
            System.out.print(cNfa.m_label + " ");
            ++n2;
        }
    }

    private void print_header() {
        int n;
        int n2 = 0;
        System.out.println("/*---------------------- DFA -----------------------");
        Enumeration enumeration = this.m_spec.m_states.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n3 = (Integer)this.m_spec.m_states.get(string);
            CUtility.assert(null != string);
            CUtility.assert(null != n3);
            System.out.println("State \"" + string + "\" has identifying index " + n3.toString() + ".");
            n = n3;
            if (-1 != this.m_spec.m_state_dtrans[n]) {
                System.out.println("\tStart index in transition table: " + this.m_spec.m_state_dtrans[n]);
                continue;
            }
            System.out.println("\tNo associated transition states.");
        }
        n = 0;
        while (n < this.m_spec.m_dtrans_vector.size()) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n);
            if (null == this.m_spec.m_accept_vector && null == this.m_spec.m_anchor_array) {
                if (null == cDTrans.m_accept) {
                    System.out.print(" * State " + n + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + n + " [accepting, line " + cDTrans.m_accept.m_line_number + " <" + new String(cDTrans.m_accept.m_action, 0, cDTrans.m_accept.m_action_read) + ">]");
                    if (0 != cDTrans.m_anchor) {
                        System.out.print(" Anchor: " + (0 != (cDTrans.m_anchor & 1) ? "start " : "") + (0 != (cDTrans.m_anchor & 2) ? "end " : ""));
                    }
                }
            } else {
                CAccept cAccept = (CAccept)this.m_spec.m_accept_vector.elementAt(n);
                if (null == cAccept) {
                    System.out.print(" * State " + n + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + n + " [accepting, line " + cAccept.m_line_number + " <" + new String(cAccept.m_action, 0, cAccept.m_action_read) + ">]");
                    if (0 != this.m_spec.m_anchor_array[n]) {
                        System.out.print(" Anchor: " + (0 != (this.m_spec.m_anchor_array[n] & 1) ? "start " : "") + (0 != (this.m_spec.m_anchor_array[n] & 2) ? "end " : ""));
                    }
                }
            }
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.m_spec.m_dtrans_ncols) {
                if (-1 != cDTrans.m_dtrans[n5]) {
                    if (n4 != cDTrans.m_dtrans[n5]) {
                        System.out.println();
                        System.out.print(" *    goto " + cDTrans.m_dtrans[n5] + " on ");
                        n2 = 0;
                    }
                    String string = this.interp_int(n5);
                    System.out.print(string);
                    if (56 < (n2 += string.length())) {
                        System.out.println();
                        System.out.print(" *             ");
                        n2 = 0;
                    }
                    n4 = cDTrans.m_dtrans[n5];
                }
                ++n5;
            }
            System.out.println();
            ++n;
        }
        System.out.println(" */");
        System.out.println();
    }
}

