/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSComplexTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSParticle;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSWildcard;

public class XSComplexTypeDecl
implements XSComplexTypeDefinition {
    String fName = null;
    String fTargetNamespace = null;
    XSTypeDefinition fBaseType = null;
    short fDerivedBy = (short)2;
    short fFinal = 0;
    short fBlock = 0;
    short fMiscFlags = 0;
    XSAttributeGroupDecl fAttrGrp = null;
    short fContentType = 0;
    XSSimpleType fXSSimpleType = null;
    XSParticleDecl fParticle = null;
    XSCMValidator fCMValidator = null;
    private static final short CT_IS_ABSTRACT = 1;
    private static final short CT_HAS_TYPE_ID = 2;
    private static final short CT_IS_ANONYMOUS = 4;

    public short getContentType() {
        return this.fContentType;
    }

    public short getDerivationMethod() {
        return this.fDerivedBy;
    }

    public short getFinal() {
        return this.fFinal;
    }

    public short getFinalSet() {
        return this.fFinal;
    }

    public short getProhibitedSubstitutions() {
        return this.fBlock;
    }

    public short getType() {
        return 3;
    }

    public short getTypeCategory() {
        return 13;
    }

    public void reset() {
        this.fName = null;
        this.fTargetNamespace = null;
        this.fBaseType = null;
        this.fDerivedBy = (short)2;
        this.fFinal = 0;
        this.fBlock = 0;
        this.fMiscFlags = 0;
        this.fAttrGrp.reset();
        this.fContentType = 0;
        this.fXSSimpleType = null;
        this.fParticle = null;
        this.fCMValidator = null;
    }

    public void setContainsTypeID() {
        this.fMiscFlags = (short)(this.fMiscFlags | 2);
    }

    public void setIsAbstractType() {
        this.fMiscFlags = (short)(this.fMiscFlags | 1);
    }

    public void setIsAnonymous() {
        this.fMiscFlags = (short)(this.fMiscFlags | 4);
    }

    public boolean containsTypeID() {
        return (this.fMiscFlags & 2) != 0;
    }

    public boolean getAbstract() {
        return (this.fMiscFlags & 1) != 0;
    }

    public boolean getAnonymous() {
        return (this.fMiscFlags & 4) != 0;
    }

    public boolean isFinal(short derivation) {
        return (this.fFinal & derivation) != 0;
    }

    public boolean isProhibitedSubstitution(short prohibited) {
        return (this.fBlock & prohibited) != 0;
    }

    public String getName() {
        return this.getAnonymous() ? null : this.fName;
    }

    public String getNamespace() {
        return this.fTargetNamespace;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public String getTypeName() {
        return this.fName;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.appendTypeInfo(str);
        return str.toString();
    }

    public void setName(String name) {
        this.fName = name;
    }

    void appendTypeInfo(StringBuffer str) {
        String[] contentType = new String[]{"EMPTY", "SIMPLE", "ELEMENT", "MIXED"};
        String[] derivedBy = new String[]{"EMPTY", "EXTENSION", "RESTRICTION"};
        str.append("Complex type name='" + this.fTargetNamespace + "," + this.getTypeName() + "', ");
        if (this.fBaseType != null) {
            str.append(" base type name='" + this.fBaseType.getName() + "', ");
        }
        str.append(" content type='" + contentType[this.fContentType] + "', ");
        str.append(" isAbstract='" + this.getAbstract() + "', ");
        str.append(" hasTypeId='" + this.containsTypeID() + "', ");
        str.append(" final='" + this.fFinal + "', ");
        str.append(" block='" + this.fBlock + "', ");
        if (this.fParticle != null) {
            str.append(" particle='" + this.fParticle.toString() + "', ");
        }
        str.append(" derivedBy='" + derivedBy[this.fDerivedBy] + "'. ");
    }

    public XSAttributeGroupDecl getAttrGrp() {
        return this.fAttrGrp;
    }

    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    public XSObjectList getAnnotations() {
        return null;
    }

    public XSObjectList getAttributeUses() {
        return this.fAttrGrp.getAttributeUses();
    }

    public XSParticle getParticle() {
        return this.fParticle;
    }

    public XSSimpleTypeDefinition getSimpleType() {
        return this.fXSSimpleType;
    }

    public XSTypeDefinition getBaseType() {
        return this.fBaseType;
    }

    public boolean derivedFromType(XSTypeDefinition ancestor, short derivationMethod) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor == SchemaGrammar.fAnyType) {
            return true;
        }
        XSTypeDefinition type = this;
        while (type != ancestor && type != SchemaGrammar.fAnySimpleType && type != SchemaGrammar.fAnyType) {
            type = type.getBaseType();
        }
        return type == ancestor;
    }

    public XSWildcard getAttributeWildcard() {
        return this.fAttrGrp.getAttributeWildcard();
    }

    public boolean derivedFrom(String ancestorNS, String ancestorName, short derivationMethod) {
        if (ancestorName == null) {
            return false;
        }
        if (ancestorNS != null && ancestorNS.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) && ancestorName.equals("anyType")) {
            return true;
        }
        XSTypeDefinition type = this;
        while (!(ancestorName.equals(type.getName()) && (ancestorNS == null && type.getNamespace() == null || ancestorNS != null && ancestorNS.equals(type.getNamespace())) || type == SchemaGrammar.fAnySimpleType || type == SchemaGrammar.fAnyType)) {
            type = type.getBaseType();
        }
        return type != SchemaGrammar.fAnySimpleType && type != SchemaGrammar.fAnyType;
    }

    public synchronized XSCMValidator getContentModel(CMBuilder cmBuilder) {
        if (this.fCMValidator == null) {
            this.fCMValidator = cmBuilder.getContentModel(this);
        }
        return this.fCMValidator;
    }

    public void setValues(String name, String targetNamespace, XSTypeDefinition baseType, short derivedBy, short schemaFinal, short block, short contentType, boolean isAbstract, XSAttributeGroupDecl attrGrp, XSSimpleType simpleType, XSParticleDecl particle) {
        this.fTargetNamespace = targetNamespace;
        this.fBaseType = baseType;
        this.fDerivedBy = derivedBy;
        this.fFinal = schemaFinal;
        this.fBlock = block;
        this.fContentType = contentType;
        if (isAbstract) {
            this.fMiscFlags = (short)(this.fMiscFlags | 1);
        }
        this.fAttrGrp = attrGrp;
        this.fXSSimpleType = simpleType;
        this.fParticle = particle;
    }
}

