/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private DocumentImpl fDocument;
    private Node fRoot;
    private int fWhatToShow = -1;
    private NodeFilter fNodeFilter;
    private boolean fDetach = false;
    private Node fCurrentNode;
    private boolean fForward = true;
    private boolean fEntityReferenceExpansion;

    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    public void detach() {
        this.fDetach = true;
        this.fDocument.removeNodeIterator(this);
    }

    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    public Node getRoot() {
        return this.fRoot;
    }

    public Node nextNode() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fRoot == null) {
            return null;
        }
        Node nextNode = this.fCurrentNode;
        boolean accepted = false;
        while (!accepted) {
            nextNode = !this.fForward && nextNode != null ? this.fCurrentNode : (!this.fEntityReferenceExpansion && nextNode != null && nextNode.getNodeType() == 5 ? this.nextNode(nextNode, false) : this.nextNode(nextNode, true));
            this.fForward = true;
            if (nextNode == null) {
                return null;
            }
            accepted = this.acceptNode(nextNode);
            if (!accepted) continue;
            this.fCurrentNode = nextNode;
            return this.fCurrentNode;
        }
        return null;
    }

    public Node previousNode() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fRoot == null || this.fCurrentNode == null) {
            return null;
        }
        Node previousNode = this.fCurrentNode;
        boolean accepted = false;
        while (!accepted) {
            previousNode = this.fForward && previousNode != null ? this.fCurrentNode : this.previousNode(previousNode);
            this.fForward = false;
            if (previousNode == null) {
                return null;
            }
            accepted = this.acceptNode(previousNode);
            if (!accepted) continue;
            this.fCurrentNode = previousNode;
            return this.fCurrentNode;
        }
        return null;
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        Node deleted = this.matchNodeOrParent(node);
        if (deleted == null) {
            return;
        }
        if (this.fForward) {
            this.fCurrentNode = this.previousNode(deleted);
        } else {
            Node next = this.nextNode(deleted, false);
            if (next != null) {
                this.fCurrentNode = next;
            } else {
                this.fCurrentNode = this.previousNode(deleted);
                this.fForward = true;
            }
        }
    }

    boolean acceptNode(Node node) {
        if (this.fNodeFilter == null) {
            return (this.fWhatToShow & 1 << node.getNodeType() - 1) != 0;
        }
        return (this.fWhatToShow & 1 << node.getNodeType() - 1) != 0 && this.fNodeFilter.acceptNode(node) == 1;
    }

    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    Node matchNodeOrParent(Node node) {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node n = this.fCurrentNode;
        while (n != this.fRoot) {
            if (node == n) {
                return n;
            }
            n = n.getParentNode();
        }
        return null;
    }

    Node previousNode(Node node) {
        if (node == this.fRoot) {
            return null;
        }
        Node result = node.getPreviousSibling();
        if (result == null) {
            result = node.getParentNode();
            return result;
        }
        if (result.hasChildNodes() && (this.fEntityReferenceExpansion || result == null || result.getNodeType() != 5)) {
            while (result.hasChildNodes()) {
                result = result.getLastChild();
            }
        }
        return result;
    }

    Node nextNode(Node node, boolean visitChildren) {
        if (node == null) {
            return this.fRoot;
        }
        if (visitChildren && node.hasChildNodes()) {
            Node result = node.getFirstChild();
            return result;
        }
        if (node == this.fRoot) {
            return null;
        }
        Node result = node.getNextSibling();
        if (result != null) {
            return result;
        }
        Node parent = node.getParentNode();
        while (parent != null && parent != this.fRoot) {
            result = parent.getNextSibling();
            if (result != null) {
                return result;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public NodeIteratorImpl(DocumentImpl document, Node root, int whatToShow, NodeFilter nodeFilter, boolean entityReferenceExpansion) {
        this.fDocument = document;
        this.fRoot = root;
        this.fCurrentNode = null;
        this.fWhatToShow = whatToShow;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = entityReferenceExpansion;
    }
}

