/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioMaterial;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioMaterial.CompoundMeasurement;
import org.biomage.Common.Identifiable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasComponentCompounds;
import org.biomage.Interface.HasCompoundIndices;
import org.biomage.Interface.HasExternalLIMS;
import org.xml.sax.Attributes;

public class Compound
extends Identifiable
implements Serializable,
HasComponentCompounds,
HasCompoundIndices,
HasExternalLIMS {
    Boolean isSolvent;
    protected HasCompoundIndices.CompoundIndices_list compoundIndices = new HasCompoundIndices.CompoundIndices_list();
    protected HasComponentCompounds.ComponentCompounds_list componentCompounds = new HasComponentCompounds.ComponentCompounds_list();
    protected DatabaseEntry externalLIMS;

    public Compound() {
    }

    public Compound(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "isSolvent");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.isSolvent = new Boolean(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Compound");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Compound>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.isSolvent != null) {
            out.write(" isSolvent=\"" + this.isSolvent + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.compoundIndices.size() > 0) {
            out.write("<CompoundIndices_assnlist>");
            for (i = 0; i < this.compoundIndices.size(); ++i) {
                ((OntologyEntry)this.compoundIndices.elementAt(i)).writeMAGEML(out);
            }
            out.write("</CompoundIndices_assnlist>");
        }
        if (this.componentCompounds.size() > 0) {
            out.write("<ComponentCompounds_assnlist>");
            for (i = 0; i < this.componentCompounds.size(); ++i) {
                ((CompoundMeasurement)this.componentCompounds.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ComponentCompounds_assnlist>");
        }
        if (this.externalLIMS != null) {
            out.write("<ExternalLIMS_assn>");
            this.externalLIMS.writeMAGEML(out);
            out.write("</ExternalLIMS_assn>");
        }
    }

    public void setIsSolvent(Boolean isSolvent) {
        this.isSolvent = isSolvent;
    }

    public Boolean getIsSolvent() {
        return this.isSolvent;
    }

    public String getModelClassName() {
        return new String("Compound");
    }

    public void setCompoundIndices(HasCompoundIndices.CompoundIndices_list compoundIndices) {
        this.compoundIndices = compoundIndices;
    }

    public HasCompoundIndices.CompoundIndices_list getCompoundIndices() {
        return this.compoundIndices;
    }

    public void addToCompoundIndices(OntologyEntry ontologyEntry) {
        this.compoundIndices.add(ontologyEntry);
    }

    public void addToCompoundIndices(int position, OntologyEntry ontologyEntry) {
        this.compoundIndices.add(position, ontologyEntry);
    }

    public OntologyEntry getFromCompoundIndices(int position) {
        return (OntologyEntry)this.compoundIndices.get(position);
    }

    public void removeElementAtFromCompoundIndices(int position) {
        this.compoundIndices.removeElementAt(position);
    }

    public void removeFromCompoundIndices(OntologyEntry ontologyEntry) {
        this.compoundIndices.remove(ontologyEntry);
    }

    public void setComponentCompounds(HasComponentCompounds.ComponentCompounds_list componentCompounds) {
        this.componentCompounds = componentCompounds;
    }

    public HasComponentCompounds.ComponentCompounds_list getComponentCompounds() {
        return this.componentCompounds;
    }

    public void addToComponentCompounds(CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.add(compoundMeasurement);
    }

    public void addToComponentCompounds(int position, CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.add(position, compoundMeasurement);
    }

    public CompoundMeasurement getFromComponentCompounds(int position) {
        return (CompoundMeasurement)this.componentCompounds.get(position);
    }

    public void removeElementAtFromComponentCompounds(int position) {
        this.componentCompounds.removeElementAt(position);
    }

    public void removeFromComponentCompounds(CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.remove(compoundMeasurement);
    }

    public void setExternalLIMS(DatabaseEntry externalLIMS) {
        this.externalLIMS = externalLIMS;
    }

    public DatabaseEntry getExternalLIMS() {
        return this.externalLIMS;
    }
}

