/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.ArrayDesign;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Extendable;
import org.biomage.Interface.HasDistanceUnit;
import org.biomage.Measurement.DistanceUnit;
import org.xml.sax.Attributes;

public class ZoneLayout
extends Extendable
implements Serializable,
HasDistanceUnit {
    Integer numFeaturesPerRow;
    Integer numFeaturesPerCol;
    Float spacingBetweenRows;
    Float spacingBetweenCols;
    protected DistanceUnit distanceUnit;

    public ZoneLayout() {
    }

    public ZoneLayout(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "numFeaturesPerRow");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.numFeaturesPerRow = new Integer(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "numFeaturesPerCol")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.numFeaturesPerCol = new Integer(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "spacingBetweenRows")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.spacingBetweenRows = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "spacingBetweenCols")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.spacingBetweenCols = new Float(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ZoneLayout");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ZoneLayout>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.numFeaturesPerRow != null) {
            out.write(" numFeaturesPerRow=\"" + this.numFeaturesPerRow + "\"");
        }
        if (this.numFeaturesPerCol != null) {
            out.write(" numFeaturesPerCol=\"" + this.numFeaturesPerCol + "\"");
        }
        if (this.spacingBetweenRows != null) {
            out.write(" spacingBetweenRows=\"" + this.spacingBetweenRows + "\"");
        }
        if (this.spacingBetweenCols != null) {
            out.write(" spacingBetweenCols=\"" + this.spacingBetweenCols + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.distanceUnit != null) {
            out.write("<DistanceUnit_assn>");
            this.distanceUnit.writeMAGEML(out);
            out.write("</DistanceUnit_assn>");
        }
    }

    public void setNumFeaturesPerRow(Integer numFeaturesPerRow) {
        this.numFeaturesPerRow = numFeaturesPerRow;
    }

    public Integer getNumFeaturesPerRow() {
        return this.numFeaturesPerRow;
    }

    public void setNumFeaturesPerCol(Integer numFeaturesPerCol) {
        this.numFeaturesPerCol = numFeaturesPerCol;
    }

    public Integer getNumFeaturesPerCol() {
        return this.numFeaturesPerCol;
    }

    public void setSpacingBetweenRows(Float spacingBetweenRows) {
        this.spacingBetweenRows = spacingBetweenRows;
    }

    public Float getSpacingBetweenRows() {
        return this.spacingBetweenRows;
    }

    public void setSpacingBetweenCols(Float spacingBetweenCols) {
        this.spacingBetweenCols = spacingBetweenCols;
    }

    public Float getSpacingBetweenCols() {
        return this.spacingBetweenCols;
    }

    public String getModelClassName() {
        return new String("ZoneLayout");
    }

    public void setDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public DistanceUnit getDistanceUnit() {
        return this.distanceUnit;
    }
}

