\name{FileDep}
\alias{FileDep}
\non_function{}
\title{ FileDep: a graphNEL object representing a file dependency dataset
example in boost graph library }
\description{ FileDep: a graphNEL object representing a file dependency dataset
example in boost graph library }
\usage{#data(FileDep)}
\source{
Boost Graph Library 
}
\references{
}
\examples{
# this is how the graph of data(FileDep) was obtained
library(graph)
fd <- file(system.file("XML/FileDep.gxl",package="RBGL"))
show(fromGXL(fd))
if (require(Rgraphviz))
 {
 data(FileDep)
 plot(FileDep)
 }
}
\keyword{graphs}

\eof
\name{bfs}
\alias{bfs}
\alias{dfs}
\alias{dfs,graph,character,ANY-method}
\alias{bfs,graph,character,ANY-method}
\alias{dfs,graph,missing,missing-method}
\alias{bfs,graph,missing,missing-method}
\alias{bfs,graph-method}
\alias{bfs,graph,character-method}
\alias{dfs,graph,character-method}
\alias{bfs,graph,ANY,ANY-method}
\title{ Breadth and Depth-first search }
\description{
  These functions return information on
  graph traversal by breadth and depth first search using
  routines from the BOOST library.  
}
\usage{
bfs(object, node, checkConn=FALSE)
\S4method{dfs}{object,node,checkConn}(graph)
\S4method{bfs}{object,node,checkConn}(graph)
}
\arguments{
  \item{object}{ instance of class graph from Bioconductor graph class}
  \item{node}{ node name where search starts -- note that this is ignored
for dfs }
  \item{checkConn}{ logical indicating whether connectivity of
input graph should be checked }
}
\details{
  These two functions are interfaces to the
  BOOST graph library functions for breadth first
and depth first search. Both methods can handle
  unconnected graphs and unless \code{checkConn} is specified neither
  tests connectivity. If \code{checkConn} is specified and the
  graph is not connected an error is signalled.

  Note that the parameter sequences for bfs and dfs agree, but that
  at present the \code{node} argument to \code{dfs} is ignored.
  Cormen et al note (p 542) that `results of depth-first search
  may depend upon the order in which the vertices are examined ...
  These different visitation orders tend not to cause problems
  in practices, as any DFS result can usually be used effectively,
  with essentially equivalent results'.  To fix the
  starting node of \code{dfs}, order the graph vertex list so that the
  desired start point is the first entry.
}
\value{
For \code{bfs} a vector of node indices in order of BFS visit.

For \code{dfs} a
list of two vectors of nodes, with elements
\code{discover} (order of DFS discovery),
and \code{finish}
(order of DFS completion).
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\examples{
dd <- fromGXL(file(system.file("XML/bfsex.gxl",package="RBGL")))
bfs(dd, "r", FALSE)
bfs(dd, "s", TRUE)

dd2 <- fromGXL(file(system.file("XML/dfsex.gxl",package="RBGL")))
dfs(dd2, "u", FALSE)
}
\keyword{ graphs }

\eof
\name{connectedComp}
\alias{connectedComp}
\title{Identify Connected Components in
an Undirected Graph  }
\description{The connected components in
an undirected graph are identified. If the graph is directed then the
weakly connected components are identified.
}
\usage{
connectedComp(g)
}
\arguments{
  \item{g}{ g: graph with \code{edgemode} \dQuote{undirected}}
}
\details{
Uses a depth first search approach to identifying all the connected
components of an undirected graph. If the input, \code{g}, is a directed
graph it is first transformed to an undirected graph (using
\code{\link[graph]{ugraph}}).
}

\value{
  A list of length equal to the number of connected components in
  \code{g}. Each element of the list contains a vector of the node
  labels for the nodes that are connected.
}
\references{Boost Graph Library}

\author{ Vince Carey <stvjc@channing.harvard.edu>}
\seealso{\code{\link[graph]{connComp}},\code{\link{strongComp}},
  \code{\link[graph]{ugraph}}}

\examples{
km <- fromGXL(file(system.file("GXL/kmstEx.gxl",package="graph")))
km@nodes <- c(km@nodes,"F","G","H")
km@edgeL$F <- list(edges=numeric(0))
km@edgeL$G <- list(edges=8)
km@edgeL$H <- list(edges=7)
ukm <- ugraph(km)
ukm
edges(ukm)
connectedComp(ukm)
}
\keyword{models }

\eof
\name{dijkstra.sp}
\alias{dijkstra.sp}
\title{ Dijkstra's shortest paths using boost C++ }
\description{
dijkstra's shortest paths
}
\usage{
dijkstra.sp(g,start=nodes(g)[1])
}
\arguments{
  \item{g}{ instance of class graph }
  \item{start}{ character: node name for start of path }
}
\details{
These functions are interfaces to the Boost graph library C++
routines for Dijkstra's shortest paths.
}

\value{
A list with elements:
\item{distance}{The vector of distances from \code{start} to each node
of \code{g}; includes \code{Inf} when there is no path from \code{start}.}
\item{penult}{A vector of indices 
(in \code{nodes(g)}) of predecessors corresponding to each node
on the path from that node back to \code{start}}. For example, if the
element one of this vector has value \code{10}, that means that the
predecessor of node \code{1} is node \code{10}. The next predecessor is
found by examining \code{penult[10]}.
\item{start}{The start node that was supplied in the call to
\code{dijkstra.sp}.}
}

\author{ VJ Carey <stvjc@channing.harvard.edu> }

\seealso{\code{\link{sp.between}}}

\examples{
dd <- fromGXL(file(system.file("XML/dijkex.gxl",package="RBGL")))
dijkstra.sp(dd)
dijkstra.sp(dd,nodes(dd)[2])
ospf <- fromGXL(file(system.file("XML/ospf.gxl",package="RBGL")))
dijkstra.sp(ospf,nodes(ospf)[6])
}
\keyword{ graphs }

\eof
\name{edgeConnectivity}
\alias{edgeConnectivity}
\title{computed edge connectivity and min disconnecting set
for an undirected graph}
\description{computed edge connectivity and min disconnecting set
for an undirected graph}
}
\usage{
edgeConnectivity(g)
}
\arguments{
  \item{g}{an instance of the \code{graph} class with \code{edgemode}
    \dQuote{undirected}}
}
\details{
Consider a graph G consisting of a single connected component.
The edge connectivity of G is the minimum number
of edges in G that can be cut to produce a graph with two
(disconnected) components.  The set of edges in this cut
is called the minimum disconnecting set.
}
\value{
A list:
\item{connectivity}{the integer describing the number of edges that must
be severed to obtain two components}
\item{minDisconSet}{a list (of length \code{connectivity}) of pairs of node names describing the edges
that need to be cut to obtain two components}
}
\references{Boost Graph Library by Siek et al.  }
\author{Vince Carey <stvjc@channing.harvard.edu>}

\seealso{\code{\link{connectedComp}}  }

\examples{
coex <- fromGXL(file(system.file("XML/conn.gxl",package="RBGL")))
edgeConnectivity(coex)
}
\keyword{ models }

\eof
\name{extractPath}
\alias{extractPath}
\title{convert a dijkstra.sp predecessor
structure into the path joining two nodes   }
\description{
determine a path between two nodes in a graph,
using output of \code{\link{dijkstra.sp}}.
}
\usage{
extractPath(s, f, pens)
}
\arguments{
  \item{s}{ s: index of starting node in nodes vector
of the graph from which \code{pens} was derived}
  \item{f}{ f: index of ending node in nodes vector }
  \item{pens}{ pens: predecessor index vector as returned
in the \code{preds} component of \code{\link{dijkstra.sp}} output}
}
%\details{
%}
%\value{
%}
%\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
%\note{  }


\seealso{  \code{\link[e1071]{allShortestPaths}}}

\examples{
data(FileDep)
dd <- dijkstra.sp(FileDep)
extractPath(1,9,dd$pen)
}
\keyword{ models }

\eof
\name{mstree.kruskal}
\alias{mstree.kruskal}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Kruskal's minimum spanning tree in boost }
\description{
compute the minimum spanning tree (MST) for
a graph and return a representation
in matrices
}
\usage{
mstree.kruskal(x) 
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ instance of class graph }
}
\details{
calls to kruskal minimum spanning tree algorithm of Boost graph library
}
\value{
a list
\item{edgeList}{a matrix m of dimension 2 by number of edges in the
MST, with m[i,j] the jth node in edge i}
\item{weights}{a vector of edge weights corresponding to the
columns of \code{edgeList}}
\item{nodes}{the vector of nodes of the input graph \code{x}}
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\examples{
km <- fromGXL(file(system.file("GXL/kmstEx.gxl",package="graph")))
mstree.kruskal(km)
km@edgeL$B$weights <- c(1.1,.95)
mstree.kruskal(km)
km2 <- fromGXL(file(system.file("XML/telenet.gxl",package="RBGL")))
m <- mstree.kruskal(km2)
print(sum(m[[2]]))
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
\name{sp.between}
\alias{sp.between}
\alias{sp.between.old}
\alias{sp.between.scalar}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Dijkstra's shortest paths using boost C++ }
\description{
dijkstra's shortest paths
}
\usage{
sp.between.scalar(g,start,finish) 
sp.between(g,start,finish) 
sp.between.old(g,start,finish) 
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{g}{ instance of class graph }
  \item{start}{ character: node name(s) for start of path  }
  \item{finish}{ character vector: node names for end of path}
}
\details{
These functions are interfaces to the Boost graph library C++
routines for Dijkstra's shortest paths.
}

\value{
\code{sp.between.scalar} returns a list with elements:
\item{length}{length (using edge weights) of shortest path}
\item{path}{vector of node names describing the path}
\item{pweights}{named vector of edge weights for all
weights constituting the path -- see \code{\link[graph]{pathWeights}}
for caveats about undirected graph representation.}

Note that if \code{start} or \code{finish} are vectors,
a list of results of repeated application of \code{sp.between.scalar}
is returned.
}


\note{
sp.between returns a list whose size depends upon the start and
finish arguments.  If start and finish are both scalar, then
a list is returned with elements the length of the shortest
path and the vector of nodes comprising that path.  If one of start
or finish is an n-vector, n>1, and the other is an atom,
a list is returned with n elements, each element of which is a list
possessing a length and path element.  If both start and finish
are n-vectors, a list of n elements is returned, with ith element the distance
and path between start[i] and finish[i].  It is an error to have
start and finish of different nonunity lengths.

sp.between.old is included for archival purposes.
}
\seealso{\code{\link{dijkstra.sp}}}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\examples{
ospf <- fromGXL(file(system.file("XML/ospf.gxl",package="RBGL")))
dijkstra.sp(ospf,nodes(ospf)[6])
sp.between(ospf, "RT6", "RT1")
sp.between(ospf, c("RT6", "RT2"), "RT1")
sp.between(ospf, c("RT6", "RT2"), c("RT1","RT5"))
if (interactive()) # see an error for query on nonexistent path
sp.between(ospf,"N10", "N13")
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
\name{strongComp}
\alias{strongComp}
\title{Identify Strongly Connected Components}

\description{The strongly connected components in
a directed graph are identified and returned as a list.
}
\usage{
strongComp(g)
}
\arguments{
  \item{g}{ g: graph with \code{edgemode} \dQuote{directed}.}
}
\details{
Tarjan's algorithm is used to determine all strongly connected
components of a \emph{directed graph}.
}
\value{
A list whose length is the number of strongly connected components in
\code{g}. Each element of the list is a vector of the node labels for
the nodes in that component.
}

\references{Boost Graph Library  }
\author{Vince Carey <stvjc@channing.harvard.edu>}

\seealso{\code{\link[graph]{connComp}},\code{\link{connectedComp}} }

\examples{
km <- fromGXL(file(system.file("XML/kmstEx.gxl",package="RBGL")))
km@nodes <- c(km@nodes,"F","G","H")
km@edgeL$F <- list(edges=numeric(0))
km@edgeL$G <- list(edges=8)
km@edgeL$H <- list(edges=7)
strongComp(km)
connectedComp(ugraph(km))
}
\keyword{ models }

\eof
\name{tsort}
\alias{tsort}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ topological sort of vertices of a digraph }
\description{
returns vector of zero-based indices of vertices
of a DAG in topological sort order
}
\usage{
tsort(x) # now x assumed to be Bioconductor graph graphNEL
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ instance of class graphNEL from Bioconductor graph class}
}
\details{
calls to the topological\_sort algorithm of BGL.  will check in BGL
whether the input is a DAG and will report to cerr and return
zeroes if it is not.  Thus this function can be used to check for
cycles in a digraph.
}
\value{
a numerical vector enumerating vertices in the
topological sort sequence, 0-based
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\examples{
data(FileDep)
nodes(FileDep)[tsort(FileDep)+1]
FD2 <- FileDep
if (interactive()) {
  # now introduce a cycle
  FD2@edgeL[["bar_cpp"]]$edges <- c(8,1)
  tsort(FD2)
  }
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
