\name{ebarraysFamily-class}
\alias{ebarraysFamily-class}
\alias{eb.createFamilyGG}
\alias{eb.createFamilyLNN}
\alias{coerce,character,ebarraysFamily-method}
\alias{show,ebarraysFamily-method}
\title{Class of Families to be used in the EBarrays package}
\description{
  Objects used as family in the \code{emfit} function. 

  The package contains two functions that create such objects for the
  two most commonly used families, Gamma-Gamma and
  Lognormal-Normal. Users may create their own famiies as well.
}
\usage{
eb.createFamilyGG()
eb.createFamilyLNN()
}
\value{
  Objects of class ``ebarraysFamily'' for the two predefined families
  Gamma-Gamma and Lognormal-Normal
}
\details{

  The \code{\link{emfit}} function can potentially fit models
  corresponding to several different Bayesian conjugate families. This
  is specified as the \code{family} argument, which ultimately has to be
  an object of formal class ``ebarraysFamily'' with some specific slots
  that determine the behaviour of the `family'.

  For users who are content to use the predefined GG and LNN models, no
  further details than that given in the documentation for
  \code{\link{emfit}} are necessary. If you wish to create your own
  families, read on.
}

\section{Objects from the Class}{
  Objects of class ``ebarraysFamily'' can be created by calls of the
  form \code{new("ebarraysFamily", ...)}. Predefined objects
  corresponding to the GG and LNN models can be created by
  \code{eb.createFamilyGG()} and \code{eb.createFamilyLNN()}. The same
  effect is achieved by coercing from the strings \code{"GG"} and
  \code{"LNN"} by \code{as("GG", "ebarraysFamily")} and \code{as("LNN",
    "ebarraysFamily")}.
}

\section{Slots}{
  An object of class ``ebarraysFamily'' extends the class
  \code{"character"} (representing a short hand name for the class) and
  should have the following slots (for more details see the source
  code):

  \describe{
    \item{\code{description}:}{
      A not too long character string describing the family
    }
    \item{\code{link}:}{
      function that maps user-visible parameters to the parametrization that
      would be used in the optimization step (e.g. \code{log(sigma^2)}
      for LNN). This allows the user to think in terms of familiar
      parametrizations that may not necessarily be the best when
      optimizing w.r.t. those parameters.
    }
    \item{\code{invlink}:}{
      inverse of the link function
    }
    \item{\code{thetaInit}:}{
      function of a single argument \code{data} (matrix containing raw
      expression values), that calculates and returns as a numeric
      vector initial estimates of the parameters (in the parametrization
      used for optimization)
    }
    \item{\code{f0}:}{
      function taking arguments \code{theta} and a list called
      \code{args}. \code{f0} calculates the negative log likelihood at
      the given parameter value \code{theta} (again, in the
      parametrization used for optimization). This is called from
      \code{emfit}. When called, only genes with positive intensities
      across all samples are used.
    }
    \item{\code{f0.pp}:}{
      \code{f0.pp} is essentially the same as \code{f0} except the terms
      common to the numerator and denominator when calculating posterior
      odds may be removed. It is called from \code{postprob}.
    }
    \item{\code{f0.arglist}:}{
      function that takes arguments \code{data} and \code{patterns} (of
      class ``ebarraysPatterns'') and returns a list with two
      components, \code{common.args} and
      \code{pattern.args}. \code{common.args} is a list of arguments to
      \code{f0} that don't change from one pattern to another, whereas
      \code{pattern.args[[i]][[j]]} is a similar list of arguments, but
      specific to the columns in \code{pattern[[i]][[j]]}. Eventually,
      the two components will be combined for each pattern and used as
      the \code{args} argument to \code{f0}.
    }
    \item{\code{logDensity}:}{
      function of two arguments \code{x} (data vector, containing log
      expressions) and \code{theta} (parameters in user-visible
      parametrization). Returns log marginal density of the natural log
      of intensity for the corresponding theoretical model. Used in
      \code{plotMarginal}
    }
    \item{\code{lower.bound}:}{
      vector of lower bounds for the argument \code{theta} of
      \code{f0}. Used in \code{optim}
    }
    \item{\code{upper.bound}:}{
      vector of upper bounds for the argument \code{theta} of
      \code{f0}. 
    }

  }
}

\seealso{
  \code{\link{emfit}}, \code{\link{optim}}, \code{\link{plotMarginal}}
}

\author{Christina Kendziorski, Michael Newton and Deepayan Sarkar}

\examples{
show(eb.createFamilyGG())
show(eb.createFamilyLNN())
}
\keyword{models}




\eof
\name{ebplots}
\alias{ebplots}
\alias{checkCCV}
\alias{checkConvergence}
\alias{plotMarginal}
\alias{checkModel}
\title{Various plotting routines in the EBarrays package}
\description{
  Various plotting routines, used for diagnostic purposes
}
\synopsis{
plotMarginal(fit, data, kernel = "rect", n = 100, bw = "nrd0", adjust = 1,
             xlab, ylab, \dots)
}
\usage{
checkCCV(data, useRank = FALSE, f = 1/2)
plotMarginal(fit, data, kernel = "rect", n = 100,
             bw = "nrd0", adjust = 1, \dots)
checkModel(data, model = c("gamma", "lognormal"),
           number = 9, nb = 10)
checkConvergence(\dots, dropfirst = FALSE)
}
\arguments{
  \item{data}{ data, as a ``matrix'' or ``exprSet''}
  \item{useRank}{ logical. If \code{TRUE}, ranks of means and c.v.-s are
    used in the scatterplot
  }
  \item{f} {passed to \code{\link{lowess}}}
  \item{fit}{ object of class ``ebarraysEmFit'', typically produced by a
    call to \code{\link{emfit}}
  }
  \item{kernel, n, bw, adjust}{ passed on to \code{\link{density}}}
  \item{model}{ which theoretical model use for Q-Q plot. Partial string
    matching is allowed
  }
  \item{number}{ number of subsets or bins (panels in the Trellis
    display) for which Q-Q plot is drawn
  }
  \item{nb}{ number of observations per bin (panel) }
  \item{\dots}{
    In the case of \code{checkConvergence}, matrices or vectors (treated
    as column vectors) with same number of rows. These are combined into
    a single matrix, then each column is scaled between 0 and 1 and
    plotted simultaneously.

    For \code{plotMarginal}, extra arguments are passed to the
    \code{xyplot} call used to produce the final result.
  }
  \item{dropfirst}{ logical. If \code{TRUE}, first row will be dropped }
}
\details{

  Needs to be written
}
\value{
  \code{plotMarginal} and \code{checkModel} return an object of class
  ``trellis'', using function in the Lattice package. Note that in
  certain situations, these may need to be explicitly `print'-ed to have
  any effect.
}
\seealso{\code{\link{emfit}}, \code{\link{lowess}}}
\author{Christina Kendziorski, Michael Newton and Deepayan Sarkar}
\examples{
data(gould)
checkCCV(gould)

}
\keyword{models}




\eof
\name{emfit}
\alias{emfit}
\alias{emfit,exprSet,character,ebarraysPatterns-method}
\alias{emfit,exprSet,ebarraysFamily,ebarraysPatterns-method}
\alias{emfit,matrix,character,ebarraysPatterns-method}
\alias{emfit,matrix,ebarraysFamily,ebarraysPatterns-method}
\alias{show,ebarraysEmFit-method}
\alias{ebarraysEmFit-class}
\title{ Implements EM algorithm for gene expression mixture model }
\description{
  Implements the EM algorithm for gene expression mixture model
}
\synopsis{
emfit(data,
      family,
      hypotheses,
      ...)
}
\usage{
emfit(data,
      family,
      hypotheses,
      theta.init = NULL, p.init = NULL,
      num.iter = 20,
      verbose = getOption("verbose"),
      trace = TRUE,
      optim.control = list())
}
\arguments{
  \item{data}{ a matrix or an an object of class ``exprSet''}
  \item{family}{
    an object of class ``ebarraysFamily'' or a characterstring which can
    be coerced to one. Currently, only the characters "GG" and "LNN" are
    valid. Other families can be supplied by constructing them
    explicitly.
  }
  \item{hypotheses}{
    an object of class ``ebarraysPatterns'' representing the hypotheses
    of interest. Such patterns can be generated by the function
    \code{\link{ebPatterns}}
  }
  \item{theta.init}{
    initial values of theta. Should be appropriate for the corresponding
    \code{family}. If omitted, defaults are calculated based on the
    \code{family}.
  }
  \item{p.init}{ initial values of mixture probabilities. If omitted,
    all hypotheses are initially taken as equally likely. }
  \item{num.iter}{ number of EM iterations}
  \item{verbose}{ logical or numeric (0,1,2) indicating desired level of
    information printed for the user}
  \item{trace}{ whther the result should have slots \code{thetaTrace}
    and \code{probTrace}, matrices giving values for all iterations}
  \item{optim.control}{ list passed unchanged to \code{\link{optim}} for
    finer control}
}
\note{
  \code{emfit} is actually a generic function, with methods for .
}
\value{
  an object of class ``ebarraysEmFit'', that can be summarized by
  \code{show()} and used to generate posterior probabilities using
  \code{\link{postprob}}
}

\references{

  See UW Madison Biostatistics and Medical Informatics Technical Report
  166, ``On parametric empirical Bayes methods for comparing multiple
  groups using replicated gene expression profiles,'' by
  C.M. Kendziorski, M.A. Newton, H. Lan, and M.N. Gould.  See
  \url{http://www.biostat.wisc.edu/~kendzior/}
}
\author{ Christina Kendziorski, Michael Newton and Deepayan Sarkar }
\seealso{
  \code{\link{ebPatterns}}, \code{\link{ebarraysFamily-class}}
}
\examples{
data(eset) ## from Biobase
patterns <- ebPatterns(c("1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1",
                         "1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2"))
gg.fit <- emfit(data = eset, family = "GG", hypotheses = patterns,
                verbose = TRUE)
##                theta.init = c(10, 1, 1), p.init = c(.99, .01))
show(gg.fit)
}
\keyword{models}


\eof
\name{gould}
\alias{gould}
\non_function{}
\title{ A dataset of class exprSet  }
\usage{data(gould)}
\format{
  The data are originally from Affymetrix chips, subsequently processed
  by dChip and then exported to R for analysis.
}
\description{
  This dataset is part of a dataset from a study of gene expression
  patterns of mammary epithelial cells in a rat model of breast cancer,
  consisting of 5000 genes in 4 biological conditions; 10 arrays total. 
}
\source{
  Dr. M.N. Gould's laboratory in UW-Madison
}
\examples{
data(gould)
}
\keyword{datasets}

\eof
\name{postprob}
\alias{postprob}
\alias{postprob,ebarraysEmFit,exprSet-method}
\alias{postprob,ebarraysEmFit,matrix-method}
\alias{show,ebarraysPostProb-method}
\alias{ebarraysPostProb-class}
\title{Calculates posterior probabilities for expression patterns}
\description{
  Takes the output from emfit and calculates the posterior probability
  of each of the hypotheses, for each gene.
}
\usage{
postprob(fit, data, ...)
}
\arguments{
  \item{fit}{ output from \code{\link{emfit}}}
  \item{data}{ a nunmeric matrix or an object of class ``exprSet''
    containing the data, typically the same one used in the \code{emfit}
    fit supplied below.
  }
  \item{\dots}{ other arguments, ignored}
}
\value{
  An object of class ``ebarraysPostProb'', which is essentially a matrix
  of probabilities with number of rows given by the number of genes in
  \code{data} and as many columns as the number of hypotheses for the
  fit. It additionally contains a slot `hypotheses' containing
  these hypotheses.
}
\seealso{
  \code{\link{emfit}}}
}
\author{ Christina Kendziorski, Michael Newton and Deepayan Sarkar}
\keyword{models}

\eof
\name{utilities}
\alias{utilities}
\alias{createExprSet}
\alias{ebPatterns}
\alias{show,ebarraysPatterns-method}
\alias{ebarraysPatterns-class}
\title{Utility functions for the EBarrays package}
\description{
  Utilitiy functions for the EBarrays package
}
\usage{
createExprSet(datafile, repfile)
ebPatterns(x)
}
\arguments{
  \item{datafile}{ file with data}
  \item{repfile}{ file with replication information}
  \item{x}{
    x can be a character vector (of length > 2) (see example), or an
    arbitrary connection which should provide patterns, one line for
    each pattern. If \code{x} is a character vector of length 1, it is
    assumed to be the name of a file (since there's no point in a
    patterns object with only one pattern) which is then opened and
    treated as a connection.
  }
}
\details{
  \code{ebPatterns} creates objects that represent a collection of
  hypotheses to be used by \code{emfit}.

  It, along with \code{createExprSet}, also provides back compatibility
  with an earlier version of \code{EBarrays}, which required input data
  to be in a very specific format. For example, the (earlier) usage
  \code{cleanup(NULL, "data.txt", "repfile.txt", "patternfile.txt")}
  can be replaced by \code{createExprSet("data.txt", "repfile.txt")} and
  \code{ebPatterns("patternfile.txt")}.

  Unless one has data in this particular format, the
  \code{createExprSet} function can be safely ignored.
}

\value{
  \code{createExprSet} creates an object of class ``exprSet''.

  \code{ebPatterns} creates an Object of class ``ebarraysPatterns'', to
  be used in other functions such as \code{\link{emfit}}. This is
  nothing more than a list (and can be treated as such as far as
  indexing goes) and is used only for method dispatch.

}
\seealso{\code{\link{emfit}}}
\author{Christina Kendziorski, Michael Newton and Deepayan Sarkar}
\examples{
patterns <- ebPatterns(c("1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1",
                         "1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2"))
show(patterns)
}
\keyword{models}




\eof
