\name{DynDoc-class}
\docType{class}
\alias{DynDoc-class}
\alias{pdfPath}
\alias{getKeywords}
\alias{getRequires}
\alias{getSuggests}
\alias{indexEntry}
\alias{codeChunks}
\alias{summary,DynDoc-method}
\alias{chunks,DynDoc-method}
\alias{codeChunks,DynDoc-method}
\alias{evalChunk,DynDoc-method}
\alias{getChunk,DynDoc-method}
\alias{getDepends,DynDoc-method}
\alias{getKeywords,DynDoc-method}
\alias{getRequires,DynDoc-method}
\alias{getSuggests,DynDoc-method}
\alias{indexEntry,DynDoc-method}
\alias{numChunks,DynDoc-method}
\alias{path,DynDoc-method}
\alias{pdfPath,DynDoc-method}
\alias{setChunk<-,DynDoc-method}
\alias{show,DynDoc-method}
\title{A Class For Dynamic Documents}
\description{The DynDoc class is used to represent dynamic documents and
  vignettes in R.}
\section{Slots}{
  \describe{
    \item{\code{indexEntry}:}{Object of class \code{"character"} The
      IndexEntry value from the document file}
    \item{\code{title}:}{Object of class \code{"character"} The name of
      the document}
    \item{\code{path}:}{Object of class \code{"character"} The path to
      the locally stored file}
    \item{\code{pdfPath}:}{Object of class \code{"character"} The path
      to a PDF rendition of the document}
    \item{\code{depends}:}{Object of class \code{"character"} Any
      package dependencies for the document}
    \item{\code{requires}:}{Object of class \code{"character"} Any
      requires level dependencies for the document}
    \item{\code{suggests}:}{Object of class \code{"character"} Any
      suggests level dependencies for the document}
    \item{\code{keywords}:}{Object of class \code{"character"} Any
      keywords for the document}
    \item{\code{codeChunks}:}{Object of class \code{"chunkList"} The
      code chunks contained in this document}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "DynDoc")}: Display information
    about the dynamic document}
    \item{summary}{\code{signature(object = "DynDoc")}: A more succinct
      informational display}
    \item{chunks}{\code{signature(object = "DynDoc")}: Returns the code
      chunks - currently in only for historical compatability with old code}
    \item{codeChunks}{\code{signature(object = "DynDoc")}: Returns the
      code chunks}
    \item{evalChunk}{\code{signature(object = "DynDoc")}: Will evaluate
      the R code contained in a chunk}
    \item{getChunk}{\code{signature(object = "DynDoc")}: Retrieves a
      specific code chunk}
    \item{getDepends}{\code{signature(object = "DynDoc")}: Obtain the
      Depends slot of the object}
    \item{getKeywords}{\code{signature(object = "DynDoc")}: Obtain the
      keywords slot of the object}
    \item{getRequires}{\code{signature(object = "DynDoc")}: A get method
    for the requires slot of this object}
    \item{getSuggests}{\code{signature(object = "DynDoc")}: Obtain the
      suggests slot of this object}
    \item{indexEntry}{\code{signature(object = "DynDoc")}: Obtain the
      indexEntry slot of this object}
    \item{numChunks}{\code{signature(object = "DynDoc")}: Returns the
      number of code chunks for this document }
    \item{path}{\code{signature(object = "DynDoc")}: Obtain the path
      slot of this object}
    \item{pdfPath}{\code{signature(object = "DynDoc")}: Obtain the
      pdfPath slot of this object}
    \item{setChunk<-}{\code{signature(object = "DynDoc")}: Change the
      code for one of the code chunks.}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{SweaveOptions-class}
\docType{class}
\alias{SweaveOptions-class}
\alias{SweaveOptions}
\alias{getOptions}
\alias{numOptions}
\alias{codeChunk,SweaveOptions-method}
\alias{getOptions,SweaveOptions-method}
\alias{numOptions,SweaveOptions-method}
\alias{show,SweaveOptions-method}
\title{Class "SweaveOptions", a class to handle options in Sweave}
\description{A small class designed to hold a set of Sweave options}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SweaveOptions", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{options}:}{Object of class \code{"list"} A list of
      strings representing options from a Sweave document.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "SweaveOptions")}: Outputs the options}
    \item{getOptions}{\code{signature(object = "SweaveOptions")}:
      Retrieves the options}
    \item{numOptions}{\code{signature(object = "SweaveOptions")}:
      Returns the number of options}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}}, \code{\link{codeChunk}}}
\examples{
##!!! Need an example here
}
\keyword{classes}

\eof
\name{Vignette-class}
\docType{class}
\alias{Vignette-class}
\alias{vigPkgVersion}
\alias{vigPkgVersion,Vignette-method}
\alias{vigPackage,Vignette-method}
\title{A Class To Represent Vignettes}
\description{This is a class that will represent a vignette file in R,
  it extends the DynDoc class}
\section{Slots}{
  \describe{
    \item{\code{package}:}{Object of class \code{"character"} The
      package that this vignette is associated with}
    \item{\code{vigPkgVersion}:}{Object of class \code{"VersionNumber"} The
    version number for this vignette's package}
    \item{\code{indexEntry}:}{Object of class \code{"character", from
	class "DynDoc"} The VignetteIndexEntry field from the document file}
    \item{\code{title}:}{Object of class \code{"character", from class
	"DynDoc"} The title of the vignette}
    \item{\code{path}:}{Object of class \code{"character", from class
	"DynDoc"} The path to the vignette file stored locally}
    \item{\code{pdfPath}:}{Object of class \code{"character", from class
	"DynDoc"} The path to a PDF representation of the vignette}
    \item{\code{depends}:}{Object of class \code{"character", from class
	"DynDoc"} Any package dependencies for this vignette}
    \item{\code{requires}:}{Object of class \code{"character", from
	class "DynDoc"} Any requires level dependencies for this vignette}
    \item{\code{suggests}:}{Object of class \code{"character", from
	class "DynDoc"} Any suggests level dependencies for this vignette}
    \item{\code{keywords}:}{Object of class \code{"character", from
	class "DynDoc"} Any keywords for this vignette}
    \item{\code{codeChunks}:}{Object of class \code{"chunkList", from
	class "DynDoc"} A list of code chunks from this vignette}
  }
}
\section{Extends}{
Class \code{"DynDoc"}, directly.
}
\section{Methods}{
  \describe{
    \item{package}{\code{signature(object = "Vignette")}: Retrieves the
      package name that this vignette is associated with}
    \item{vigPkgVersion}{\code{signature(object = "Vignette")}: Retrieves
      the version of the package that this vignette is associated with}
  }
}
\notes{The \code{Vignette} class is extending the \code{DynDoc} class by
  further associating the \code{DynDoc} concepts with a specific R
  package.
  }
\author{Jeff Gentry}
\seealso{\code{\link{DynDoc-class}}, \code{\link{Sweave}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{chunkList-class}
\docType{class}
\alias{chunkList-class}
\alias{chunkList}
\alias{chunks}
\alias{getAllCodeChunks}
\alias{getChunk}
\alias{setChunk}
\alias{setChunk<-}
\alias{numChunks}
\alias{chunks,chunkList-method}
\alias{evalChunk,chunkList-method}
\alias{evalEnv,chunkList-method}
\alias{getAllCodeChunks,chunkList-method}
\alias{getChunk,chunkList-method}
\alias{numChunks,chunkList-method}
\alias{setChunk<-,chunkList-method}
\alias{show,chunkList-method}
\alias{summary,chunkList-method}
\title{Class "chunkList"}
\description{ This class is essentially a wrapper for the
  \code{codeChunk} class.  It contains all of the \code{codeChunks} from
  a vignette file.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("chunkList", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{chunks}:}{Object of class \code{"list"} Stores a list of
    \code{codeChunk} objects, representing all of the code chunks from a
  vignette file.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "chunkList")}: Displays verbose
    information about the code chunks}
    \item{chunks}{\code{signature(object = "chunkList")}:  Retrieves a
      list of \code{codeChunk} objects}
    \item{getAllCodeChunks}{\code{signature(object = "chunkList")}:
      Collapses all of the code chunks into one block of code and
      returns this}
    \item{getChunk}{\code{signature(object = "chunkList")}: Retrieves a
      specific code chunk}
    \item{numChunks}{\code{signature(object = "chunkList")}: Returns the
    number of code chunks in this object}
    \item{setChunk<-}{\code{signature(object = "chunkList", value="character")}: Changes
      the code in a given \code{codeChunk} contained by this object }
    \item{summary}{\code{signature(object = "chunkList")}: A less
      verbose display of information about the object}
    \item{evalChunk}{\code{signature(object = "chunkList",
	pos="numeric")}: Evaluates the code chunk at the specified
      position in the \code{chunkList} object}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}}, \code{\link{codeChunk}}, \code{\link{vignetteCode}}}

\examples{
    library(tools)
    testfile <- file.path(.path.package("tools"),
                           "Sweave", "Sweave-test-1.Rnw")
    if (file.exists(testfile))
        z <- Stangle(testfile,driver=tangleToR)
}
\keyword{classes}

\eof
\name{codeChunk-class}
\docType{class}
\alias{codeChunk-class}
\alias{codeChunk}
\alias{chunk<-}
\alias{chunk}
\alias{chunkName}
\alias{chunk<-,codeChunk-method}
\alias{chunk,codeChunk-method}
\alias{chunkName,codeChunk-method}
\alias{evalChunk,codeChunk-method}
\alias{getOptions,codeChunk-method}
\alias{show,codeChunk-method}
\alias{SweaveOptions,codeChunk-method}
\title{Class "codeChunk"}
\description{A class to wrap necessary information for a code chunk from
  a vignette file.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("codeChunk", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{chunkName}:}{Object of class \code{"character"} The name
    (if one exists) for the code chunk}
    \item{\code{chunk}:}{Object of class \code{"character"} The code
      from the code chunk}
    \item{\code{options}:}{Object of class \code{"SweaveOptions"} Any
      options that were set at the time the code chunk appears in the
      vignette file}
  }
}

\section{Methods}{
  \describe{
    \item{evalChunk}{\code{signature(object = "codeChunk",
	env="environment")}: Will evaluate the code in the code chunk
      using the environment specified.  If no environment is specified,
      .GlobalEnv is used.}
    \item{show}{\code{signature(object = "codeChunk")}: Displays the
      information for the code chunk}
    \item{chunk<-}{\code{signature(object = "codeChunk",
	value="character")}: Edits the \code{chunk} slot of the object}
    \item{chunk}{\code{signature(object = "codeChunk")}: Returns the
      \code{chunk} slot of the object}
    \item{chunkName}{\code{signature(object = "codeChunk")}: Returns the
    name of the code chunk}
    \item{getOptions}{\code{signature(object = "codeChunk")}: Returns
      the actual options from the \code{options} slot. }
    \item{SweaveOptions}{\code{signature(object = "codeChunk")}: Returns
    the object stored in the \code{options} slot.}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}}, \code{\link{SweaveOptions}}, \code{\link{chunkList}}}

\examples{
    library(tools)
    testfile <- file.path(.path.package("tools"),
                           "Sweave", "Sweave-test-1.Rnw")
    if (file.exists(testfile)) {
        z <- Stangle(testfile,driver=tangleToR)
        getChunk(z,1)
    }
}
\keyword{classes}

\eof
\name{getPkgVigList}
\alias{getPkgVigList}
\alias{getVigInfo}
\alias{baseVigDesc}
\alias{print.pkgFileList}
\alias{getVigInfoNames}
\alias{transformVigInfoLine}
\title{A function to retrieve a listing of package vignettes}
\description{
  Functionality to retrive vignette metadata, on a per-vignette or a
  per-package level.
}
\usage{
getPkgVigList(pkg, vigDescFun=baseVigDesc, vigPath = "/doc/", 
vigExt="\\.(Rnw|Snw|rnw|snw)$", pkgVers = TRUE)

getVigInfo(vig,pkg=NULL, vigDescFun=baseVigDesc, pkgVers=TRUE)
}
\arguments{
  \item{pkg}{Path to a package directory}
  \item{vig}{Filename of a vignette}
  \item{vigDescFun}{Function to provide output string for display}
  \item{vigPath}{Path to directory that contains vignettes in the
    package}
  \item{vigExt}{Regular expression pattern to match vignette file extensions}
  \item{pkgVers}{Record the package version with the other vignette metadata}
}
\details{
  getPkgVigList: This function will look at all vignette files in the directory
    \code{<pkg>/<vigPath>}.  It will then extract any header information (using
    \code{getVigInfo}), and return a list of this information.

  getVigInfo:  This function will retrieve the metadata from a
    particular vignette file.  Any line starting with '\%\\Vignette' is
    taken to be metadata.  Common values include VignetteIndexEntry (required),
    VignetteKeywords, VignetteDepends, etc.  A named list of lists is
    returned to the user, where the names correspond to the particular
    metadata variable.

  Both functions take a parameter \code{baseVigDesc}, which is a
  function to provide the output string to correspond with a vignette
  summary.  This function is directly called by \code{getVigInfo}.  It
  takes one parameter, which is a vigInfo list from \code{getVigInfo}.
}
\author{Jeff Gentry}
\seealso{\code{\link{vignette}}}
\examples{
   dynPath <- .path.package("DynDoc")
   vigList <- getPkgVigList(dynPath)
   vigList
}
\keyword{utilities}

\eof
\name{getVignette}
\alias{getVignette}
\title{A function to handle vignette files}
\description{
  This function will take a vignette file and return a Vignette object
  in R which can be manipulated further.
}
\usage{
getVignette(vigPath, eval = TRUE)
}
\arguments{
  \item{vigPath}{The file path of the vignette file}
  \item{eval}{Whether or not to evaluate the code chunks}
}
\details{
  This function should still be considered experimental
}
\value{
  A valid \code{Vignette} object representing this vignette
}
\author{Jeff Gentry}
\seealso{\code{\link{Vignette-class}}}
\examples{
}
\keyword{utilities}

\eof
\name{getVignetteCode}
\alias{getVignetteCode}
\alias{editVignetteCode}
\title{Functionality to manage code chunks from a vignette}
\description{
  These functions allow for processing and management of vignette code
  chunks within R.  Users can directly manipulate the code chunks, as
  well as evaluate them at their option.
}
\usage{
getVignetteCode(vigPath, evalEnv = new.env())
editVignetteCode(vigCode, pos, code)
}
\arguments{
  \item{vigPath}{File path of vignette file to process}
  \item{evalEnv}{An environment to use for chunk evaluations}
  \item{vigCode}{The \code{vignetteCode} object to edit}
  \item{pos}{The position of the code chunk to edit}
  \item{code}{The new code chunk}
}
\details{
  \code{getVignetteCode}:  This function will call \code{Stangle} using
  the \code{tangleToR} driver in order to retrieve the code chunks from
  the specified vignette file.  It will then compile the other pertinent
  information and return a new \code{vignetteCode} object.

  \code{editVignetteCode}:  This function will edit a code chunk
  contained within a \code{vignetteCode} and return a new object
  representing that change.  The evaluation environment in the new
  object is a copy of the original as well, *not* the same environment.
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}},\code{\link{vignetteCode}},\code{\link{tangleToR}}}

\examples{
}
\keyword{utilities}

\eof
\name{getVignetteHeader}
\alias{getVignetteHeader}
\alias{hasVigHeaderField}
\title{A function to read vignette header information}
\description{
  Given a vignette filename, will read in the vignette header metadata.
}
\usage{
getVignetteHeader(vig, field)
hasVigHeaderField(vig, field="VignetteIndexEntry")
}
\arguments{
  \item{vig}{Vignette filename}
  \item{field}{A specific field to extract}
}
\details{
  The \code{getVignetteHeader} function will extract the metadata from a
  vignette file and return it as a named list, where the names of the
  list elements correspond to the metadata fields, and the elements
  themselves the values.  If a specific field is desired, it can be
  specified with the 'field' argument.

  The \code{hasVigHeaderField} function is a simple wrapper around
  \code{getVignetteHeader} and will most likely be removed in the very
  near future.  It just is a boolean to report if a given header field
  exists or not.
}
\author{Jeff Gentry}
\examples{

   ## !! Need a working vignette somewhere to work this on
}
\keyword{utilities}

\eof
\name{tangleToR}
\alias{tangleToR}
\alias{tangleToRSetup}
\alias{tangleToRRuncode}
\alias{tangleToRFinish}
\title{An Sweave driver to retrieve code chunks}
\description{
  A driver function for \code{Sweave} which will provide the user with
  code chunks from a vignette file within R.  Functionality is very
  similar to that provided by \code{Stangle} except that an R object is
  returned as opposed to the chunks being written to a file.
}
\usage{
tangleToR()
}
\value{
  An object of type \code{chunkList} is returned, which contains the
  code chunks from the vignette file.
}
\author{Jeff Gentry}
\seealso{\code{\link{Stangle}},\code{\link{Sweave}}, \code{\link{chunkList}}}

\examples{
    library(tools)
    testfile <- file.path(.path.package("tools"),
                           "Sweave", "Sweave-test-1.Rnw")
    if (file.exists(testfile))
        z <- Stangle(testfile,driver=tangleToR)
}
\keyword{utilities}


\eof
\name{vignetteCode-class}
\docType{class}
\alias{vignetteCode-class}
\alias{vignetteCode}
\alias{getDepends}
\alias{evalChunk}
\alias{evalEnv}
\alias{vigPackage}
\alias{path}
\alias{show,vignetteCode-method}
\alias{chunkList,vignetteCode-method}
\alias{chunks,vignetteCode-method}
\alias{evalChunk,vignetteCode-method}
\alias{evalEnv,vignetteCode-method}
\alias{getChunk,vignetteCode-method}
\alias{getDepends,vignetteCode-method}
\alias{numChunks,vignetteCode-method}
\alias{path,vignetteCode-method}
\alias{setChunk<-,vignetteCode-method}
\alias{summary,vignetteCode-method}
\alias{vigPackage,vignetteCode-method}
\title{Class "vignetteCode"}
\description{This class represents the code chunks and other related
  information from a vignette file.  It also provides for the ability to
  evaulate the code chunks in a separate environment.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("vignetteCode", ...)}
Also, a helper function \code{getVignetteCode} is provided that will do
all of the dirty work required to retrieve a \code{vignetteCode} object
from a vignette file.}
\section{Slots}{
  \describe{
    \item{\code{chunkList}:}{Object of class \code{"chunkList"} Holds
      the code chunks from the vignette file}
    \item{\code{path}:}{Object of class \code{"character"} The path of
      the vignette file }
    \item{\code{package}:}{Object of class \code{"character"} The
      package (if appropriate) that the vignette came from }
    \item{\code{getDepends}:}{Object of class \code{"character"} Any
      package dependencies for the vignette }
    \item{\code{evalEnv}:}{Object of class \code{"environment"} An
      environment used for evaulation of the code chunks.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "vignetteCode")}: Displays
      information about the code contained in the object}
    \item{chunkList}{\code{signature(object = "vignetteCode")}:
      Retrieves the \code{chunkList} object.}
    \item{chunks}{\code{signature(object = "vignetteCode")}: Retrieves
      the actual code chunks (not wrapped by the \code{chunkList}
      class)} 
    \item{getDepends}{\code{signature(object = "vignetteCode")}: Returns
      the list of package dependencies for this vignette}
    \item{evalChunk}{\code{signature(object =
	"vignetteCode",pos="numeric")}: Will evaulate the specified code
    chunk in the \code{evalEnv} environment}
    \item{evalEnv}{\code{signature(object = "vignetteCode")}: Returns
      the evaluation environment}
    \item{getChunk}{\code{signature(object =
	"vignetteCode",pos="numeric")}: Returns the \code{codeChunk}
      object representing the specified code chunk position} 
    \item{numChunks}{\code{signature(object = "vignetteCode")}: Returns
      the number of chunks in the object }
    \item{vigPackage}{\code{signature(object = "vignetteCode")}: Returns
      the package the vignette is a part of }
    \item{path}{\code{signature(object = "vignetteCode")}: Returns the
      local file path to the vignette }
    \item{setChunk<-}{\code{signature(object =
	"vignetteCode",pos="numeric", value="character")}: Resets the
      code chunk specified by \code{pos} to contain the code specified 
      by \code{value}} 
    \item{summary}{\code{signature(object = "vignetteCode")}: A less
      verbose output of information then with \code{show} }
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{Sweave}}, \code{\link{getVignetteCode}},
  \code{\link{editVignetteCode}}, \code{\link{chunkList}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
