\name{#PKGNAME#REFSEQ}
\alias{#PKGNAME#REFSEQ}
\title{Annotation of probe identifiers by RefSeq identifiers}
\description{

  This is an R environment (hash table) mapping probe identifiers to all
  the RefSeq identifiers that are mapped by NCBI to genes represented by
  the probe ids
}
\details{

  Probe ids are keys and the corresponding RefSeq ids are values. Values
  are vectors of length 1 or greater depending on whether a given probe
  id can be mapped to only one or more RefSeq ids. NA is used for probe
  ids that can not be mapped to any RefSeq id.

  RefSeq ids represent different types of records that are
  differentiated by different starting letter for the ids.

  NG_XXXXX: RefSeq accessions for genomic region (nucleotide) records

  NM_XXXXX: RefSeq accessions for mRNA records

  NC_XXXXX: RefSeq accessions for chromosome records

  NP_XXXXX: RefSeq accessions for protein records

  XR_XXXXX: RefSeq accessions for model RNAs that are not associated with
  protein products

  XM_XXXXX: RefSeq accessions for model mRNA records

  XP_XXXXX: RefSeq accessions for model protein records

  Mappings were based on data provided by:

  #LLSOURCE#

  Package built #DATE#
}
\references{
    \url{http://www.ncbi.nlm.nih.gov}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#REFSEQ)
        # Remove probe ids that do not map to any RefSeq
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # The RefSeq for the first two elements of XX
xx[1:2]
                # Get the first one
                xx[[1]]
}
}

\keyword{datasets}

