\name{#PKGNAME#HGID}
\alias{#PKGNAME#HGID}
\title{Annotation of probe identifers by HomoloGeneIDs}
\description{
  
  This is an R environment (hash table) mapping probe identifiers to
  internal HomoloGeneIDs used by NCBI 
}
\details{

  Probe ids are Keys and NCBI HomoloGeneIDs are values. Values are
  vectors of length 1 or greater depending on whether a given probe id
  can be mapped to only one or more internal HomoloGeneIDs. NA is
  assigned to probe ids that can not be mapped to an internal
  HomoloGeneID at this time.

  This environment allows users to like probe ids to HomoloGeneIDs so
  that the homologus genes of probe ids can be explored using another
  data package named homology.

  Mappings were obtained using data probided by:

  #HOMOSOURCE#

  #LLSOURCE#

  Package built #DATE#
}
\references{
\url{http://www.ncbi.nlm.nih.gov}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#HGID)
        # Remove probe ids that do not map to any HDID
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # The HGIDs for the first two element of XX
xx[1:2]
                # Get the first one
                xx[[1]]
}
}
\keyword{datasets}

