\name{GOTERM}
\alias{GOTERM}
\title{Annotation of GO identifiers by the textural description of genes
  represented by the GO identifiers}
\description{
  This is an R environment (hash table) mapping GO ids to the specific
  textural description of the biological process, cellular component, or
  molecular function the genes represented by the GO ids are involved
}
\details{
  GO ids are keys and the corresponding GO textural descriptions are
  values. Values are name vectors of length 1. Names of the vectors
  indicating the GO category a term belongs to (MF = mocular function,
  BP = biological process, and CC = cellular component).

  All the obsolete GO textural descriptions are under the nodes
  "obsolete molecular function" (GO:0008369), "obsolete cellular
  component" (GO id GO:0008370), and "obsolete biological process"
  (GO:0008371). Each of these GO ids has a group of GO ids as their
  direct children (nodes directly linked to but below the GO ids along
  the directed acyclic graph defined by GO) with GO terms that were
  defined by GO but are deprecated in the current build. These
  deprecated GO terms were appended by "(obsolete)" when the data
  package was built.  

  Mappings were based on data provided by:

  #LLSOURCE#

  Package built: #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
    	require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
	xx <- as.list(GOTERM)
	if(length(xx) > 0){
		# Get the TERMS for the first two elents of xx
		terms <- xx[1:2]
                # Get the GO category the terms belong to 
                sapply(terms, names)
	}
}
\keyword{datasets}

