\name{#PKGNAME#PATH2PROBE}
\alias{#PKGNAME#PATH2PROBE}
\title{Annotation of KEGG pathway identifiers by probe identifiers}
\description{

  This is an R environment (hash table) object mapping KEGG pathway
  identifiers to probe identifier
}
\details{

  KEGG pathway ids are keys and the corresponding probe ids are
  values. Values are vectors of length 1 or greater depending on whether
  a given pathway id can be mapped to only one or more probe
  ids. Pathway ids can not be mapped to a probe identifier are assigned
  a value NA.

  Pathway name for a given pathway id can be obtained using the KEGG
  data package that can either be built using AnnBuilder or downloaded
  from Bioconductor \url{http://www.bioconductor.org}.
  
  Mappings were based on data provided by:

  #KEGGSOURCE#

  #LLSOURCE#

  Package built #DATE#
}
\references{
\url{http://www.genome.ad.jp/kegg/} and \url{http://www.ncbi.nlm.nih.gov}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#PATH2PROBE)
        # Remove patheay ids that do not map to any probe id
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # The probe ids for the first two elements of XX
xx[1:2]
                # Get the first one
                xx[[1]]
} 
}

\keyword{datasets}

