\name{#PKGNAME#GO2ALLPROBES}
\alias{#PKGNAME#GO2ALLPROBES}
\title{Annotation of GO identifiers by probe ids corresponding to the GO
  ids}
\description{

  A GO id can be associated with a group of genes directly through
  various approaches. #PKGNAME#GO2ALLPROBES maps each GO
  id to the genes (represented by probe ids) that are directly and
  associated with the GO id. 

}
\details{
  
  #PKGNAME#GO2ALLPROBES is an environment object with key and value pairs.
  Keys are GO ids and values are the probe ids that are directly or
  associated with the GO ids. Values are vectors of length 1 
  or greater depending on whether a given GO id can be mapped to only
  one or more probe ids. Names for values are the evidence codes for the
  GO ids indicating what kind of evidence is found to support the
  association. The evidence codes in use include: 
  
  IMP - inferred from mutant phenotype
  
  IGI - inferred from genetic interaction

  IPI - inferred from physical interaction  

  ISS - inferred from sequence similarity  

  IDA - inferred from direct assay  

  IEP - inferred from expression pattern  

  IEA - inferred from electronic annotation  

  TAS - traceable author statement  

  NAS - non-traceable author statement  

  ND - no biological data available  

  IC - inferred by curator
  
  GO ids can not be mapped to any probe identifier are assigned a value
  of NA. A GO id may be mapped to the same probe id more than once but
  the evidence code can be different. Mappings between Gene Ontology ids
  an Gene Ontology terms and other information are available in a
  separate data package named GO. 
  
  Mappings were based on data provided by:

  LocusLink #LLSOURCE#. Built #LLBUILT

  Package built #DATE#
}
\references{
\url{ftp://ftp.ncbi.nih.gov/refseq/LocusLink/LL_tmpl.gz}
}
\examples{
        # Convert to a list
xx <- as.list(#PKGNAME#GO2ALLPROBES)
if(length(xx) > 0){
  # Gets the probe ids for the top 2nd and 3nd GO ids
goids <- xx[2:3]
                # Gets the probe ids for the first element of goids
                goids[[1]]
                # Evidence code for the mappings
                names(goids[[1]])
}
}
\keyword{datasets}

