\name{#PKGNAME#ENZYME}
\alias{#PKGNAME#ENZYME}
\title{Annotation of probe ids by enzyme commission number}
\description{
This is an R environment (hash table) mapping probe ids to enzyme commission
numbers. 
}
\details{
  Probe ids are keys and the corresponding enzyme commission numbers are
  values. Values are vectors of length 1 or greater depending on whether
  a given probe identifier can be associated with only one or more
  enzyme commission numbers. NAs are assigned to probe identifiers that
  can not be associated with any enzyme commission numbers. Mappings
  between probe ids and enzyme ids were obtained their mappings to
  LocusLink ids. NA is assigned to probe identifiers that can not be
  associated with any enzyme id at this time.

  Mappings between probe ids and enzyme ids were obtained using files
  provided by:

  #KEGGSOURCE#
  
  Package built #DATE#
}
\references{
\url{ftp://ftp.genome.ad.jp/pub/kegg/pathways}
}
\examples{
        # Convert to a list
xx <- as.list(env = #PKGNAME#ENZYME)
        # Remove probe ids that do not map to any enzyme EC number
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # Gets the enzyme commission numbers for the first five
                #probes
xx[1:5]
                # Get the first one
                xx[[1]]
}
}
\keyword{datasets}

