.packageName <- "widgetTools"
dropdownList <- function(base, options, textvariable, width = 10,
                         default, editable = FALSE){

    upDateEntry <- function(){
        if(!editable){
            tkconfigure(entry, state = "normal")
        }
        options(show.error.messages = FALSE)
        opt <- try(getListOption(entry, options))
        options(show.error.messages = TRUE)
        if(!inherits(opt, "try-error")){
            writeList(entry, opt, clear = TRUE)
            if(!editable){
                tkconfigure(entry, state = "disabled")
            }
        }
    }

    if(!missing(default)){
        if(!is.element(default, options)){
            tkmessageBox(title = "Data error warning",
                         message = paste("The default value \"",
                         default, "\" is not an element of ",
                         "the options \"", paste(options, sep = "",
                                   collapse = ","), "\"", sep = ""),
                         icon = "warning", type = "ok")
        }
        tclvalue(textvariable) <- default
    }else{
        tclvalue(textvariable) <- options[1]
    }
    dropFrame <- tkframe(base, borderwidth = 2, relief = "sunken")
    entry <- tkentry(dropFrame, width = width, textvariable = textvariable,
                     borderwidth = 1)
    if(!editable){
        tkconfigure(entry, state = "disabled")
    }
    tkpack(entry, side = "left", expand = TRUE, fill = "both")
    dropBut <- tkbutton(dropFrame, width = 1, text = "v", font = "bold",
                        command = upDateEntry)
    tkpack(dropBut, side = "left", expand = FALSE, fill = "both")
    tkpack(dropFrame)

    return(invisible())
}

getListOption <- function(targetWidget, options){
    newEntry <- NULL
    end <- function(){
        newEntry <<- as.character(tclObj(selection))[as.integer(
                                                 tkcurselection(list)) + 1]
        tkgrab.release(base)
        tkdestroy(base)
    }
    selection <- tclVar()
    tclObj(selection) <- options
    tipX <- as.numeric(tkwinfo("rootx", targetWidget))
    tipY <- as.numeric(tkwinfo("rooty", targetWidget)) +
        as.numeric(tkwinfo("height", targetWidget))
    # Takes out the frame and title bar
    tkwm.overrideredirect(base <- tktoplevel(), TRUE)
    on.exit(tkdestroy(base))
    # Put the TW in the right place
    tkwm.geometry(base, paste("+", tipX, "+", tipY, sep = ""))
    list <- tklistbox(base, listvariable = selection,
                      height = length(options),
                      width = max(unlist(sapply(options, nchar))))
    tkbind(list, "<Double-Button-1>", end)
    tkpack(list, expand = FALSE)

    tkgrab.set(base)

    tkwait.window(base)

    return(newEntry)
}
# This group of functions initialize all the classes needed for
# widgetTools that renders pWidgets on a widget that hosts several
# interactive tk widget elements. We define a pWidget to be a tk
# widget element such as a button, entry box, label....

# This cuntion initilizes a basic class that all the pWidgets
# contains.
# name - a vector of character string(s) for the names of the tk widget
# elements corresponding to the pWidgets to be created. The name is
# required and assumed to be unique and will be used as the identifier
# for the pWidget. The length of name should be one except for select
# boxes and radio buttons where more than one names can be given;
# type - a character string for the type (e. g. button, list, ...) of
# the pWidget. This slot will be populated automatically by the system;
# value - an optional character string for the value associated with
# the pWidget. If the pWidget is an entry box, a list box, or a text
# box, the value will also be displayed inside the tk widget element
# corresponding to the pWidget;
# width - an integer for the width of the tk widget element
# corresponding to the pWidget to be created;
# funs - an optional list of functions that are to be executed when a
# given action is performed on the tk widget element corresponding to
# the pWidget. The name for the element in the list defines the type
# of action. Currently, only sClick(a single click), dClick(a double
# click), and kPress(a key strick) are the valid action types;
# preFun - an optional function that is to be executed to format the
# string that will be used to set the value of the pWidget gets updated;
# postFun - an optional function that is to be executed to format the
# string stored as the value of the pWidget when it is reterived by
# any operation;
# notify - an optional list of functions that will be executed each
# time the value of the pWidget gets updated.
#

    setClass("basicPW", representation(wName = "character",
                                       wType = "character",
                                       wValue = "ANY",
                                       wWidth = "numeric",
                                       wHeight = "numeric",
                                       wFuns = "list",
                                       wPreFun = "function",
                                       wPostFun = "function",
                                       wNotify = "list",
                                       wEnv = "environment",
                                       wView = "widgetView"))
    # Set the get methods
    if(!isGeneric("wName")){
        setGeneric("wName",
                   function(object) standardGeneric("wName"))
    }

    setMethod("wName", "basicPW",
              function(object) object@wName)

if(!isGeneric("wType")){
        setGeneric("wType",
                   function(object) standardGeneric("wType"))
    }
    setMethod("wType", "basicPW",
              function(object) object@wType)
    if(!isGeneric("wValue")){
        setGeneric("wValue",
                   function(object) standardGeneric("wValue"))
    }
    setMethod("wValue", "basicPW",
              function(object) wPostFun(object)(object@wValue))
    if(!isGeneric("wWidth")){
        setGeneric("wWidth",
                   function(object) standardGeneric("wWidth"))
    }
    setMethod("wWidth", "basicPW",
              function(object) object@wWidth)
    if(!isGeneric("wHeight")){
        setGeneric("wHeight",
                   function(object) standardGeneric("wHeight"))
    }
    setMethod("wHeight", "basicPW",
              function(object) object@wHeight)
    if(!isGeneric("wFuns")){
        setGeneric("wFuns",
                   function(object) standardGeneric("wFuns"))
    }
    setMethod("wFuns", "basicPW",
              function(object) object@wFuns)
    if(!isGeneric("wNotify")){
        setGeneric("wNotify",
                   function(object) standardGeneric("wNotify"))
    }
    setMethod("wNotify", "basicPW",
              function(object) object@wNotify)
    if(!isGeneric("wPreFun")){
        setGeneric("wPreFun",
                   function(object) standardGeneric("wPreFun"))
    }
    setMethod("wPreFun", "basicPW",
              function(object) object@wPreFun)
    if(!isGeneric("wPostFun")){
        setGeneric("wPostFun",
                   function(object) standardGeneric("wPostFun"))
    }
    setMethod("wPostFun", "basicPW",
              function(object) object@wPostFun)
    if(!isGeneric("wEnv")){
        setGeneric("wEnv",
                   function(object) standardGeneric("wEnv"))
    }
    setMethod("wEnv", "basicPW",
              function(object) object@wEnv)
    if(!isGeneric("wView")){
        setGeneric("wView",
                   function(object) standardGeneric("wView"))
    }
    setMethod("wView", "basicPW",
              function(object) object@wView)
    # Define the replace methods
    if(!isGeneric("wName<-")){
        setGeneric("wName<-", function(object, value)
                   standardGeneric("wName<-"))
    }
    setReplaceMethod("wName", "basicPW", function(object, value){
                  object@wName <- value; object})
    if(!isGeneric("wType<-")){
        setGeneric("wType<-", function(object, value)
                   standardGeneric("wType<-"))
    }
    setReplaceMethod("wType", "basicPW", function(object, value){
                  object@wType <- value; object})
    if(!isGeneric("wValue<-")){
        setGeneric("wValue<-", function(object, value)
                   standardGeneric("wValue<-"))
    }
    setReplaceMethod("wValue", "basicPW", function(object, value){
                  object@wValue <- wPreFun(object)(value);
                  if(!is.null(wView(object))){
                      updateDisplay(wView(object), wName(object),
                                    wType(object), value)};
                  object})
    if(!isGeneric("wWidth<-")){
        setGeneric("wWidth<-", function(object, value)
                   standardGeneric("wWidth<-"))
    }
    setReplaceMethod("wWidth", "basicPW", function(object, value){
                  object@wWidth <- value; object})
    if(!isGeneric("wHeight<-")){
        setGeneric("wHeight<-", function(object, value)
                   standardGeneric("wHeight<-"))
    }
    setReplaceMethod("wHeight", "basicPW", function(object, value){
                  object@wHeight <- value; object})
    if(!isGeneric("wFuns<-")){
        setGeneric("wFuns<-", function(object, value)
                   standardGeneric("wFuns<-"))
    }
    setReplaceMethod("wFuns", "basicPW", function(object, value){
                  object@wFuns <- value; object})
    if(!isGeneric("wNotify<-")){
        setGeneric("wNotify<-", function(object, value)
                   standardGeneric("wNotify<-"))
    }
    setReplaceMethod("wNotify", "basicPW", function(object, value){
                  object@wNotify <- value; object})
    if(!isGeneric("wPreFun<-")){
        setGeneric("wPreFun<-", function(object, value)
                   standardGeneric("wPreFun<-"))
    }
    setReplaceMethod("wPreFun", "basicPW", function(object, value){
                  object@wPreFun <- value; object})
    if(!isGeneric("wPostFun<-")){
        setGeneric("wPostFun<-", function(object, value)
                   standardGeneric("wPostFun<-"))
    }
    setReplaceMethod("wPostFun", "basicPW", function(object, value){
                  object@wPostFun <- value; object})
    if(!isGeneric("wEnv<-")){
        setGeneric("wEnv<-", function(object, value)
                   standardGeneric("wEnv<-"))
    }
    setReplaceMethod("wEnv", "basicPW", function(object, value){
                  object@wEnv <- value; object})
    if(!isGeneric("wView<-")){
        setGeneric("wView<-", function(object, value)
                   standardGeneric("wView<-"))
    }
    setReplaceMethod("wView", "basicPW", function(object, value){
                  object@wView <- value; object})


# This function initilizes a win class with default functions
# title - a character string for the text to be displayed as the title
# of the widget to be created
# name - a character string for the name of window holding the widget
# elements;
# winid - a tkwin object holding the id for the window;
# widgetids - a list whose elements are the name and tkwin ids for the
# widget elements to be created.
#
    setClass("widgetView", representation(WVTitle = "character",
                                   vName = "character",
                                   winid = "tkwin",
                                   widgetids = "list",
                                   theWidget = "widget"))
    # Set the get methods
    if(!isGeneric("vName")){
        setGeneric("vName",
                   function(object) standardGeneric("vName"))
    }
    setMethod("vName", "widgetView",
              function(object) object@vName)
    if(!isGeneric("winid")){
        setGeneric("winid",
                   function(object) standardGeneric("winid"))
    }
    setMethod("winid", "widgetView",
              function(object) object@winid)
    if(!isGeneric("WVTitle")){
        setGeneric("WVTitle",
                   function(object) standardGeneric("WVTitle"))
    }
    setMethod("WVTitle", "widgetView",
              function(object) object@WVTitle)
    if(!isGeneric("widgetids")){
        setGeneric("widgetids",
                   function(object) standardGeneric("widgetids"))
    }
    setMethod("widgetids", "widgetView",
              function(object) object@widgetids)
    if(!isGeneric("theWidget")){
        setGeneric("theWidget",
                   function(object) standardGeneric("theWidget"))
    }
    setMethod("theWidget", "widgetView",
              function(object) object@theWidget)
    if(!isGeneric("vName<-")){
        setGeneric("vName<-", function(object, value)
                   standardGeneric("vName<-"))
    }
    setReplaceMethod("vName", "widgetView", function(object, value){
                  object@vName <- value; object})
    if(!isGeneric("winid<-")){
        setGeneric("winid<-", function(object, value)
                   standardGeneric("winid<-"))
    }
    setReplaceMethod("winid", "widgetView", function(object, value){
                  object@winid <- value; object})
    if(!isGeneric("widgetids<-")){
        setGeneric("widgetids<-", function(object, value)
                   standardGeneric("widgetids<-"))
    }
    setReplaceMethod("widgetids", "widgetView", function(object, value){
                  object@widgetids <- value; object})
    if(!isGeneric("theWidget<-")){
        setGeneric("theWidget<-", function(object, value)
                   standardGeneric("theWidget<-"))
    }
    setReplaceMethod("theWidget", "widgetView", function(object, value){
                  object@theWidget <- value; object})
    if(!isGeneric("renderWidgets")){
        setGeneric("renderWidgets",
                   function(widgetView, pWidgets)
                   standardGeneric("renderWidgets"))
    }
    setMethod("renderWidgets", c("widgetView", "list"),
              function(widgetView, pWidgets)
              return(.doWidgets(widgetView, pWidgets)))
    if(!isGeneric("renewView")){
        setGeneric("renewView",
                   function(widgetView, pWidgets)
                   standardGeneric("renewView"))
    }
    setMethod("renewView", c("widgetView", "list"),
              function(widgetView, pWidgets)
                  .renew(widgetView, pWidgets))
    if(!isGeneric("updateDisplay")){
        setGeneric("updateDisplay",
                   function(widgetView, PWName, PWType, value)
                   standardGeneric("updateDisplay"))
    }
    setMethod("updateDisplay", "widgetView",
              function(widgetView, PWName, PWType, value){
                  widgetids <- widgetids(widgetView)
                  if(PWType == "entry"){
                      writeList(widgetids[[PWName]], value)
                  }else{
                      if(PWType == "text"){
                          writeText(widgetids[[PWName]], value)
                      }
                  }
              })
    if(!isGeneric("killWin")){
        setGeneric("killWin",
                   function(tkWidget) standardGeneric("killWin"))
    }
    setMethod("killWin", "widgetView",
              function(tkWidget) tkdestroy(winid(tkWidget)))
    if(!isGeneric("winWait")){
        setGeneric("winWait",
                   function(tkWidget) standardGeneric("winWait"))
    }
    setMethod("winWait", "widgetView",
              function(tkWidget) tkwait.window(winid(tkWidget)))


.doWidgets<- function(tkWidget, pWidgets){
    ENV <- parent.frame(1)
    funlist <- list()
    widgetids <- list()
    doOne <- function(pWidget, parent){
        if(any(wType(pWidget) == c("radio", "check"))){
            tempFrame <- tkframe(parent)
            var <- tclVar(match(TRUE, wValue(pWidget)))
            for(i in 1:length(wValue(pWidget))){
                temp <- .getWidget(pWidget, tempFrame, i, var)
                fun <- function() {}
                if(wType(pWidget) == "radio"){
                    body <- list(as.name("{"),
                             substitute(eval(tkfocus(k), env = ENV),
                                                       list(k = temp)),
                             substitute(eval(updateRadio(
                                    theWidget(tkWidget), wName(pWidget),
                                    names(wValue(pWidget)[z])),
                                    env = ENV), list(z = i)))
                }else{
                    body <- list(as.name("{"),
                             substitute(eval(tkfocus(k), env = ENV),
                                                    list(k = temp)),
                             substitute(eval(updateCheck(
                                    theWidget(tkWidget), wName(pWidget),
                                    names(wValue(pWidget)[z])),
                                    env = ENV), list(z = i)))
                }
                body(fun) <- as.call(body)
                assign(paste("cmd", wValue(pWidget)[i],sep=""), fun)
                tkconfigure(temp, command = get(paste("cmd",
                                            wValue(pWidget)[i],sep="")))
                tkpack(temp, side = "left", padx = 2, pady = 1)
                widgetids[[names(wValue(pWidget)[i])]] <<- temp
            }
            tkpack(tempFrame)
        }else if(any(wType(pWidget) == c("list", "text", "entry"))){
            if(wType(pWidget) == "entry"){
                temp <- .getWidget(pWidget, parent, 1)
                tkpack(temp, side = "left", padx = 2, pady = 1)
            }else{
                tempFrame <- tkframe(parent)
                temp <- .getWidget(pWidget, tempFrame, 1)
                tkpack(tempFrame, side = "left", padx = 2, pady = 1)
            }
            widgetids[[wName(pWidget)]] <<- temp

            if(wType(pWidget) == "list"){
                funlist[[wName(pWidget)]] <- function(){
                    tkfocus(temp)
                    .getViewerCmd(tkWidget, pWidget, temp)
                }
                tkbind(temp, "<B1-ButtonRelease>", funlist[[wName(pWidget)]])
            }else{
                funlist[[wName(pWidget)]] <- function(){
                    .getViewerCmd(tkWidget, pWidget, temp)
                }
                tkbind(temp, "<FocusOut>", funlist[[wName(pWidget)]])
            }
        }else{
            temp <- .getWidget(pWidget, parent, 1)
            tkpack(temp, side = "left", padx = 2, pady = 1)
            widgetids[[wName(pWidget)]] <<- temp
        }
    }


    doRow <- function(aRow){
        if(length(aRow) > 1){
            tempFrame <- tkframe(winid(tkWidget))
            lapply(aRow, doOne, tempFrame)
            tkpack(tempFrame, padx = 5, pady = 5)
        }else{
            tempFrame <- tkframe(winid(tkWidget))
            doOne(aRow[[1]], tempFrame)
            tkpack(tempFrame, padx = 5, pady = 5)
        }
    }

    lapply(pWidgets, doRow)
    return(widgetids)
}

.getWidget <- function(pWidget, parent, index = NULL, var = NULL){
    temp <- NULL
    switch(tolower(wType(pWidget)),
           "entry" = temp <- .renderEntry(pWidget, parent),
           "text" = ,
           "list" = temp <- .renderViewer(pWidget, parent),
           "label" = temp <- .renderLabel(pWidget, parent),
           "radio" = temp <- .renderRadio(pWidget, parent, index, var),
           "button" = temp <- .renderButton(pWidget, parent),
           "check" = temp <- .renderCheck(pWidget, parent, index),
           stop("Invalid pWidget type"))

    return(temp)
}

.renderEntry <- function(pWidget, parent){
    temp <- tkentry(parent, width = wWidth(pWidget), font = "courier 11")
    if(wValue(pWidget) != "" && !is.na(wValue(pWidget)) &&
       !is.null(wValue(pWidget))){
        writeText(temp, wValue(pWidget), FALSE)
    }
    return(temp)
}

.renderViewer <- function(pWidget, parent){
    tempFrame <- tkframe(parent)
    if(wType(pWidget) == "list"){
        toShow <- names(wValue(pWidget))
    }else{
        toShow <- wValue(pWidget)
    }
    temp <- makeViewer(tempFrame, text = toShow,
                    vWidth = wWidth(pWidget), vHeight = wHeight(pWidget),
                    hScroll = TRUE, vScroll = TRUE, what = wType(pWidget))
    if(wType(pWidget) == "list"){
        tkconfigure(temp, selectmode = "extended")
    }
    tkpack(tempFrame)
    return(temp)
}

.renderRadio <- function(pWidget, parent, index, var){
    temp <- tkradiobutton(parent, text = names(wValue(pWidget)[index]),
                          value = index, variable = var)
    return(temp)
}

.renderLabel <-function(pWidget, parent){
    temp <- tklabel(parent, text = wValue(pWidget),
                    width = wWidth(pWidget))
    return(temp)
}

.renderButton <- function(pWidget, parent){
    fun <- list()
    temp <- tkbutton(parent, text = wValue(pWidget),
                     width = wWidth(pWidget))
    fun[[wName(pWidget)]] <- function(){
        tkfocus(temp)
        wFuns(pWidget)[["command"]]()
    }
    tkconfigure(temp, command = fun[[wName(pWidget)]])
    return(temp)
 }

.renderCheck <- function(pWidget, parent, index){
    temp <- tkcheckbutton(parent, text = names(wValue(pWidget)[index]))
    if(wValue(pWidget)[index]){
        tkselect(temp)
    }
    return(temp)
}

.getViewerCmd <- function(widgetView, pWidget, widget){
    if(wType(pWidget) == "list"){
        tempValue <- getListValue(widget)
        updateRadio(theWidget(widgetView), wName(pWidget), tempValue)
    }else if(wType(pWidget) == "text"){
        tempValue <- getTextValue(widget)
        updateText(theWidget(widgetView), wName(pWidget), tempValue)
    }else{
        tempValue <- getEntryValue(widget)
        updateText(theWidget(widgetView), wName(pWidget), tempValue)
    }
}

.renew <- function(widgetView, pWidgets){
    renewOne <- function(pWidget){
        if(wType(pWidget) == "radio"){
            tkselect(widgetids(widgetView)
                         [[names(wValue(pWidget)[wValue(pWidget) == TRUE])]])
        }else if(wType(pWidget) == "check"){
            for(i in names(wValue(pWidget)[wValue(pWidget) == TRUE])){
                tkselect(widgetids(widgetView)[[i]])
            }
            for(i in names(wValue(pWidget)[wValue(pWidget) != TRUE])){
                tkdeselect(widgetids(widgetView)[[i]])
            }
        }else if(wType(pWidget) == "text"){
            writeText(widgetids(widgetView)[[wName(pWidget)]],
                                                     wValue(pWidget))
        }else if(wType(pWidget) == "entry"){
            writeList(widgetids(widgetView)[[wName(pWidget)]],
                                                     wValue(pWidget))
        }else if(wType(pWidget) == "list"){
            writeList(widgetids(widgetView)[[wName(pWidget)]],
                                               names(wValue(pWidget)))
        }
    }
    for(i in pWidgets){
        if(length(i) > 1){
            lapply(i, renewOne)
        }else{
            renewOne(i)
        }
    }
}

# This function initilizes the widget class and the associsted
# functions.
    setClass("widget", representation(wTitle = "character",
                                      pWidgets = "list",
                                      env = "environment",
                                      funs = "list",
                                      preFun = "function",
                                      postFun = "function"))
    # Set the get methods
    if(!isGeneric("wTitle")){
        setGeneric("wTitle",
                   function(object) standardGeneric("wTitle"))
    }
    setMethod("wTitle", "widget",
              function(object) object@wTitle)
    if(!isGeneric("pWidgets")){
        setGeneric("pWidgets",
                   function(object) standardGeneric("pWidgets"))
    }
    setMethod("pWidgets", "widget",
              function(object) object@pWidgets)
     if(!isGeneric("env")){
        setGeneric("env",
                   function(object) standardGeneric("env"))
    }
    setMethod("env", "widget",
              function(object) object@env)
    if(!isGeneric("funs")){
        setGeneric("funs",
                   function(object) standardGeneric("funs"))
    }
    setMethod("funs", "widget",
              function(object) object@funs)
    if(!isGeneric("preFun")){
        setGeneric("preFun",
                   function(object) standardGeneric("preFun"))
    }
    setMethod("preFun", "widget",
              function(object) object@preFun)
    if(!isGeneric("postFun")){
        setGeneric("postFun",
                   function(object) standardGeneric("postFun"))
    }
    setMethod("postFun", "widget",
              function(object) object@postFun)
    if(!isGeneric("wTitle<-")){
        setGeneric("wTitle<-", function(object, value)
                   standardGeneric("wTitle<-"))
    }
    setReplaceMethod("wTitle", "widget", function(object, value){
                  object@wTitle <- value; object})
    if(!isGeneric("pWidgets<-")){
        setGeneric("pWidgets<-", function(object, value)
                   standardGeneric("pWidgets<-"))
    }
    setReplaceMethod("pWidgets", "widget", function(object, value){
                  object@pWidgets <- value; object})
    if(!isGeneric("env<-")){
        setGeneric("env<-", function(object, value)
                   standardGeneric("env<-"))
    }
    setReplaceMethod("env", "widget", function(object, value){
                  object@env <- value; object})
    if(!isGeneric("funs<-")){
        setGeneric("funs<-", function(object, value)
                   standardGeneric("funs<-"))
    }
    setReplaceMethod("funs", "widget", function(object, value){
                  object@funs <- value; object})
    if(!isGeneric("preFuns<-")){
        setGeneric("preFuns<-", function(object, value)
                   standardGeneric("preFuns<-"))
    }
    setReplaceMethod("preFuns", "widget", function(object, value){
                  object@preFuns <- value; object})
    if(!isGeneric("postFuns<-")){
        setGeneric("postFuns<-", function(object, value)
                   standardGeneric("postFuns<-"))
    }
    setReplaceMethod("postFuns", "widget", function(object, value){
                  object@postFuns <- value; object})

    # Set the interface methods
    if(!isGeneric("updateRadio")){
        setGeneric("updateRadio",
                   function(object, PWName, bName)
                   standardGeneric("updateRadio"))
    }
    setMethod("updateRadio", "widget",
              function(object, PWName, bName) {
                  tempPW <- get(PWName, env = env(object))
                  tempValue <- wValue(tempPW)
                  tempValue[1:length(tempValue)] <- FALSE
                  tempValue[bName] <- TRUE
                  wValue(tempPW) <- tempValue
                  assign(wName(tempPW), tempPW, env = wEnv(tempPW))
              })
    if(!isGeneric("updateList")){
        setGeneric("updateList",
                   function(object, PWName, opts)
                   standardGeneric("updateList"))
    }
    setMethod("updateList", "widget",
              function(object, PWName, opts) {
                  tempPW <- get(PWName, env = env(object))
                  tempValue <- wValue(tempPW)
                  tempValue[1:length(tempValue)] <- FALSE
                  tempValue[bName] <- TRUE
                  wValue(tempPW) <- tempValue
                  assign(wName(tempPW), tempPW, env = wEnv(tempPW))
              })
    if(!isGeneric("updateCheck")){
        setGeneric("updateCheck",
                   function(object, PWName, bName)
                   standardGeneric("updateCheck"))
    }
    setMethod("updateCheck", "widget",
              function(object, PWName, bName) {
                  tempPW <- get(PWName, env = env(object))
                  tempValue <- wValue(tempPW)
                  if(tempValue[bName]){
                      tempValue[bName] <- FALSE
                  }else{
                      tempValue[bName] <- TRUE
                  }
                  wValue(tempPW) <- tempValue
                  assign(wName(tempPW), tempPW, env = wEnv(tempPW))
              })
    if(!isGeneric("updateText")){
        setGeneric("updateText",
                   function(object, PWName, value)
                   standardGeneric("updateText"))
    }
    setMethod("updateText", "widget",
              function(object, PWName, value) {
                  tempPW <- get(PWName, env = env(object))
                  wValue(tempPW) <- value
                  assign(wName(tempPW), tempPW, env = wEnv(tempPW))
              })



# This function makes a viewer that shows the content of an object.
# A viewer is a list box with a scroll bar attached.
#

makeViewer <- function (target, vWidth = NULL, vHeight = NULL,
                        hScroll = FALSE, vScroll = TRUE,
                        what = "list", side = "left", text = ""){

    if(!is.null(vWidth)){
        if(vWidth <= 0){
            stop("Invalid width value!")
        }
    }else{
        if(!is.null(vHeight)){
            if(vWidth <= 0){
                stop("Invalid height value!")
            }
        }
    }

    aViewer <- .getViewer(target, vWidth, vHeight, what, text)

    if(vScroll){
        vScr <- tkscrollbar(target, orient = "vertical",
                    command = function(...) tkyview(aViewer,...))
        tkconfigure(aViewer,
                yscrollcommand = function(...) tkset(vScr, ...))
        tkpack(vScr, side = "right", fill = "y")
    }
    if(hScroll){
       hScr <- tkscrollbar(target, orient = "horizontal",
                    command = function(...) tkxview(aViewer,...))
       tkconfigure(aViewer,
                xscrollcommand = function(...) tkset(hScr, ...))
       tkpack(hScr, side = "bottom", fill = "x")
    }
    tkpack(aViewer, side = side, fill = "both", expand = TRUE)

    aViewer
}

.getViewer <- function(target, vWidth, vHeight, what, text){

    switch(tolower(what),
           "canvas" = aViewer <- tkcanvas(target),
           "text" = aViewer <- .doText(target, text = text),
           "list" = aViewer <- .doList(target, text = text),
           stop("Wrong viwer definition"))
    if(!is.null(vWidth)){
        tkconfigure(aViewer, width = vWidth)
    }
    if(!is.null(vHeight)){
        tkconfigure(aViewer, height = vHeight)
    }

   return(aViewer)
}

.doList <- function(target, text){
    temp <- tklistbox(target, font = "courier 11")
    writeList(temp, text, clear = TRUE)
    return(temp)
}

.doText <- function(target, text){
    temp <- tktext(target, wrap = "none", font = "courier 11")
    tkinsert(temp, "end", text)
    return(temp)
}



oneVScrList <- function (base, data){

    lists <- list()

    colNames <- colnames(data)
    sortData <- function(colNum){
        for(i in 1:length(lists)){
            if(i == colNum){
                writeList(lists[[i]], sort(data[,i]), clear = TRUE)
            }else{
                writeList(lists[[i]], data[match(sort(data[,colNum]),
                              data[,colNum]), i], clear = TRUE)
            }
        }
    }
    for (i in 1:length(colNames)) {
        tempFrame <- tkframe(base)
        tkpack(tkbutton(tempFrame, text = colNames[i],
                  width = nchar(colNames[i])), expand = FALSE, fill = "x")
        lists[[colNames[i]]] <- tklistbox(tempFrame, exportselection = FALSE,
                                     width = max(sapply(data[,i], nchar)))
        writeList(lists[[colNames[i]]], data[,i])
        tkpack(lists[[colNames[i]]], expand = TRUE, fill = "both")
        fun <- function() {}
        body <- list(as.name("{"),
                     substitute(sortData(j), list(j = i)))
        body(fun) <- as.call(body)
        tempBut <- tkbutton(tempFrame, text = "Sort", width = 5,
                            command = fun)
        tkpack(tempBut, expand = FALSE, fill = "x")
        tkpack(tempFrame, side = "left", expand = FALSE, fill = "y")
    }
    bindYView <- function(...){
        for(i in lists){
            tkyview(i,...)
        }
    }

    vScr <- tkscrollbar(base, orient = "vertical", command = bindYView)
    tkpack(vScr, side = "right", fill = "y")
    for (i in lists) {
        tkconfigure(i, yscrollcommand = function(...) tkset(vScr,
            ...))
    }
    return(lists)
}
# This group of functions are constructors of objects of the classes
# defined by init.R.
#

entryBox <- function(wName, wEnv, wValue = "", wWidth = 50, wHeight = 0,
                     wFuns = list(), wNotify = list(),
                     wPreFun = function (x) x,
                     wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "entry", wValue = wValue,
        wWidth = wWidth, wHeight = wHeight, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

textBox <- function(wName, wEnv, wValue = "", wWidth = 25, wHeight = 12,
                    wFuns = list(), wNotify = list(),
                    wPreFun = function (x) x,
                    wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "text", wValue = wValue,
        wWidth = wWidth, wHeight = wHeight, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

listBox <- function(wName, wEnv, wValue = "", wWidth = 25, wHeight = 10,
                    wFuns = list(), wNotify = list(),
                    wPreFun = function (x) x,
                    wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "list", wValue = wValue,
        wWidth = wWidth, wHeight = wHeight, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

checkButton <- function(wName, wEnv, wValue, wWidth = 50,
                        wFuns = list(), wNotify = list(),
                        wPreFun = function (x) x,
                        wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "check", wValue = wValue,
        wWidth = wWidth, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

radioButton <- function(wName, wEnv, wValue, wWidth = 50,
                        wFuns = list(), wNotify = list(),
                        wPreFun = function (x) x,
                        wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "radio", wValue = wValue,
        wWidth = wWidth, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

label <- function(wName, wEnv, wValue = "", wWidth = 0, wHeight = 0,
                  wFuns = list(), wNotify = list(),
                  wPreFun = function (x) x,
                  wPostFun = function(x) x, wView = new("widgetView")){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "label", wValue = wValue,
        wWidth = wWidth, wHeight = wHeight, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

button <- function(wName, wEnv, wValue = "", wWidth = 12, wHeight = 0,
                   wFuns = list(), wNotify = list(), wPreFun = function (x) x,
                   wPostFun = function(x) x, wView = new("widgetView") ){

    .nameGood(name = wName)
    new("basicPW", wName = wName, wType = "button", wValue = wValue,
        wWidth = wWidth, wHeight = wHeight, wFuns = wFuns, wNotify = wNotify,
        wPreFun = wPreFun, wPostFun = wPostFun, wEnv = wEnv, wView = wView)
}

.nameGood <- function(name){
    if(name == "" || is.null(name) || is.na(name)){
        stop("Invalid name!")
    }
}

widgetView <- function(WVTitle, vName, widgetids = list(),
                       theWidget = new("widget"), winid = NULL){
    if(is.null(winid)){
         winid <- ""
         class(winid) <- "tkwin"
    }
    temp <- new("widgetView", WVTitle = WVTitle, vName = vName,
                widgetids = widgetids, theWidget = theWidget, winid = winid)
    base <- tktoplevel()
    tktitle(base) <- WVTitle
    winid(temp) <- base
    return(temp)
}

# This function constructs a widget object with default values if not
# supplied.
# pWidgets - a list of lists with each element being a pWidget object;
# funs - a list of functions that will be associated with buttons on
# the interface of the tcltk widget to be created. The name of the
# function will be the text appears on the button and the function
# will be executed when the button is pressed;
# preFun - a function that will be executed when the tcltk widget is
# constructed;
# postFun - a function that will be executed when the tcltk widget is
# destroyed.

widget <- function(wTitle, pWidgets, funs = list(),
                   preFun = function() print("Hello"),
                   postFun = function() print("Bye"), env,
                   defaultNames = c("Finish", "Cancel")){
    # Execute the function that is supposed to run first
    preFun()
    # A variable to keep track of the status
    END <- FALSE
    # A local copy of pWidgets to work on
    localPWs <- pWidgets
    # Construct a widgetView object
    widgetView <- widgetView(WVTitle = wTitle, vName = "widget1")
    # Construct a widget object and assign it to widgetView
    temp <- new("widget", wTitle = wTitle, env = env)
    theWidget(widgetView) <- temp
    # A Clear, Cancel, and Finish are the default buttons
    cancelBut <- function(){
        killWin(widgetView)
    }
    finishBut <- function(){
        END <<-  TRUE
        killWin(widgetView)
    }
#    clearBut <- function(){
#        .putPW2Env(localPWs, widgetView)
#        renewView(widgetView, pWidgets)
#    }
    tkcmd("tk_focusFollowsMouse")
    finish <- button(wName = "finish", wValue = defaultNames[1], wWidth = 8,
                     wFuns = list(command = finishBut), wEnv = new.env())
    cancel <- button(wName = "cancel", wValue = defaultNames[2], wWidth = 8,
        wFuns = list(command = cancelBut), wEnv = new.env())
#    clear <- button(wName = "clear", wValue = "Clear", wWidth = 8,
#        wFuns = list(command = clearBut), wEnv = new.env())
    defaultFuns <- list(finish = finish, cancel = cancel)
    if(length(funs) > 0){
        for(i in names(wFuns)){
            temp <- button(wName = i, wValue = i, wWidth = 12,
                           wFuns = wFuns[[i]], wEnv = new.env())
            userFuns[[i]] <- temp
        }
        localPWs[["userFuns"]] <- userFuns
    }
    localPWs[["default"]] <- defaultFuns
    # Render the widgets using the local copy
    widgetids(widgetView) <- renderWidgets(widgetView, localPWs)
    # Keep a copy of pWidgets and the widgetView in a specified
    # environment
    .putPW2Env(localPWs, widgetView)

    winWait(widgetView)
    # Execute the function to be run at the end
    postFun()
    # Act accordingly based on either the Cancel or Finish botton was
    # clicked
    if(END){
        pWidgets(temp) <- .getChanges(pWidgets)
        return(temp)
    }else{
        #pWidgets(temp) <- pWidgets
        return(NULL)
    }
#    return(temp)
}
# Write the value of the primary widgets to the enviroment
.putPW2Env <- function(pWidgets, widgetView){
    putOne <- function(pWidget){
        if(!is.null(widgetView)){
            wView(pWidget) <- widgetView
        }
        assign(wName(pWidget), pWidget, env = wEnv(pWidget))
    }

    for(i in names(pWidgets)){
#        if(length(pWidgets[[i]]) > 1){
            lapply(pWidgets[[i]], putOne)
#        }else{
#            putOne(pWidgets[[i]])
#        }
    }
}
# Gets the values for each primary widget object stored in the
# environment and uses the values to update the values of the a list
# primary widgets passed as an argument.
.getChanges <- function(pWidgets){
    for(i in names(pWidgets)){
        if(length(pWidgets[[i]]) > 0){
            for(j in names(pWidgets[[i]])){
                pWidgets[[i]][[j]] <- get(wName(pWidgets[[i]][[j]]),
                                            env = wEnv(pWidgets[[i]][[j]]))
            }
        }else{
            pWidgets[[i]] <- get(wName(pWidgets[[i]]),
                                            env = wEnv(pWidgets[[i]]))
        }
    }
    return(pWidgets)
}
# This functions provide common operations that may be performed on
# tcltk widgets.

writeText <- function(widget, value, clear = TRUE){
    if(clear){
        tkdelete(widget, "0.0", "end")
    }
    tkinsert(widget, "end", value)
}

writeList <- function(widget, value, clear = TRUE){
    if(clear){
        tkdelete(widget, 0, "end")
    }
    do.call("tkinsert", c(list(widget, "end"), as.list(value)))
}

getListValue <- function(which){
    listValue <- NULL
    index <- as.numeric(tkcurselection(which))
    for(i in index){
        listValue <- c(listValue, as.character(tkget(which, i)))
    }
    return(listValue)
}

getTextValue <- function(which){
    return(tclvalue(tkget(which, "0.0", "end")))
}

getEntryValue <- function(which){
    return(tclvalue(tkget(which)))
}

# A function to mimic a tooltip using tcltk only
# text - the content of the tool tip
# targetWidget - the widget to which the tooltip is going to be associated
# width - the width of the tooltip measured as pisels.

tooltip <- function(text, targetWidget, width = 350){

    end <- function(){
        tkdestroy(base)
    }

    tipX <- as.numeric(tkwinfo("rootx", targetWidget)) +
            as.numeric(tkwinfo("width", targetWidget))
    tipY <- as.numeric(tkwinfo("rooty", targetWidget))

    # Takes out the frame and title bar
    tkwm.overrideredirect(base <- tktoplevel(), TRUE)
    on.exit(tkdestroy(base))
    # Put the TW in the right place
    tkwm.geometry(base, paste("+", tipX, "+", tipY, sep = ""))
    tip <- tklabel(base, text = text, background = "white",
                   wraplength = width)
    tkpack(tip)

    tkbind(targetWidget, "<Leave>", end)

    tkwait.window(base)

    return(invisible())
}
# This function loads the required libraries and initializes the classes

.First.lib <- function(libname, pkgname, where) {
    capable <- capabilities()
    if(!capable["tcltk"]){
        stop(paste("The tcl/tk library is not available in your system.",
                   "Download/install the tcltk library from",
                   "www.tcl.tk/software/tcltk/"))
    }else{
        if(interactive()){
            out <- paste("Package tcltk not able to be loaded!")
            if (.Platform$OS.type == "windows")
                out <- paste(out,"\nThe most likely cause of this",
                             "is that your Tcl/Tk installation is",
                             "misconfigured\nPlease see the R",
                             "Windows FAQ, question 3.6:\n",
                             "http://cran.r-project.org/bin/windows/contrib/rw-FAQ.html#Package%20TclTk%20does%20not%20work.")

            require(tcltk) || stop(out)
        }
    }

    if(.Platform$OS.type == "windows" && require(Biobase) && interactive()
        && .Platform$GUI ==  "Rgui"){
        addPDF2Vig("widgetTools")
    }

}
