\name{DPExplorer}
\alias{DPExplorer}
\alias{getTopLevel}
\alias{loadDataPkg}

\title{Functions constuct a widget to explore BioC's data packages}
\description{
  These functions construct a widget that allow users to visually
  explore a data package of Bioconductor and read selected elements to R
}
\usage{
DPExplorer(pkgName = "", title = "BioC Data Package Explorer")
getTopLevel(title)
loadDataPkg(pkgName)
}

\arguments{
  \item{pkgName}{\code{pkgName} a character string for the name of a
    Bioconductor's data package that has already been loaded}
  \item{title}{\code{title} a character string for the title of the widget}
}
\details{
  If \code{pkgName} is not provided when \code{\link{DPExplorer}} is
  called, an entry box is available for users to put a \code{pkgName} in
  later. In either cases, the data package specified by \code{pkgName}
  should have been loaded.

  \code{\link{getTopLevel}} creates a top level window for the widget.

  \code{\link{loadDataPkg}} filters out valid environment objects from a
  data package.
}
\value{
  If only one key is selected, \code{\link{DPExplorer}} returns a vector
  of one to more elements. If more than one key is selected,
  \code{\link{loadDataPkg}} returns a list of vectors.

  \code{\link{getTopLevel}} returns a tkwin object for the top level
  window.

  \code{\link{loadDataPkg}} returns a vector of character strings for
  available data environments.
}
\references{Documents for a Bioconductor data package}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\examples{
if(interactive() && require(hgu95av2)){
    DPExplorer("hgu95av2")
}
}
\keyword{interface}


\eof
\name{WName}
\title{Accessors for Primitive Widget Objects}
\alias{WName}
\alias{WValue}
\alias{WValue<-}
\alias{WtoText}
\alias{WfromText}
\alias{WcanEdit}
\alias{WbuttonText}
\alias{WbuttonFun}
\alias{WwList}
\alias{"WwList<-"}
\alias{WLValue}
\alias{WLValue<-}
\alias{WRButtons}
\alias{WpreFun}
\alias{WpostFun}
\alias{WEnd}
\alias{"WValue<-"}
\description{
  Currently primitive widget objects (\code{pwidget}s) are implemented
  as \code{\link{list}}s, but this will change.  Users should only rely
  on these accessors functions, not the implementation.
}
\usage{
WName(x)
WValue(x)
WValue(x) <-  value
WtoText(x)
WfromText(x)
WcanEdit(x)
WbuttonText(x)
WbuttonFun(x)
WwList(x)
WwList <- value
WLValue(x, index)
WLValue(x, index) <- value
WRButtons(x)
WpreFun(x)
WpostFun(x)
WEnd{x}
}
\arguments{
  \item{x}{list of lists with a Name, Value, toText, fromText,
    canEdit, buttonText, buttonFun, preFun, postFun element.}
  \item{index}{integer or character string as an index or name for
    the list in the first list of a list of lists for a widget.}
  \item{value}{An \R data type that is going to be used to update the value.}
}
\details{
  \code{WName(x)} returns the \code{Name} element of \code{x}.
  \code{WValue(x)} returns the \code{Value} element of \code{x}.
  \code{WValue(x) <- value} will change the \code{Value} element of
  \code{x} to \code{value}.

  \code{WtoText(x)} returns the \code{toText} element of \code{x}.
  \code{WfromText(x)} returns the \code{fromText} element of \code{x}.
  \code{WcanEdit(x)} returns the \code{canEdit} element of \code{x}.

  \code{WbuttonText(x)} returns the \code{buttonText} element of \code{x}.
  \code{WbuttonFun(x)} returns the \code{buttonFun} element of \code{x}.
  \code{WwList(x)} returns the \code{wList} element of \code{x}.
  \code{WwList <- value} will update the \code{wList} element of a
  Widget list with \code{value}.

%% FIXME: the following is not well understandable...
  \code{WLValue(x, index)} returns a list indicated by the
  index in the wList of a widget list.
  \code{WLValue(x, index) <- value} will update indicated
  by the index in the wList of a widget list with the value.

  \code{WpreFun(x)} returns the preFun element of \code{x}.
  \code{WpostFun(x)} returns  the post element of \code{x}.
  \code{WEnd(x)} returns  the end element of \code{x}.
}
\value{
  A character string or \R function represented by the element
  of the list whose value is to be retrieved.
}
\author{Jianhua (John) Zhang}
\seealso{\code{\link{widgetRender}} for references etc.
}
\examples{
# Create the list of lists
pW1 <- list(Name="AAA", Value="bbb",
            toText = function(x) paste(x,collapse = ","),
            fromText = NULL, canEdit = TRUE,
            buttonFun = ls, buttonText = "Browse")

widget1 <- list(wList = list(a = pW1),
                preFun = function() "Hi",
                postFun = function() "Bye")

# Call the functions
WName(pW1)
WValue(pW1)
WValue(pW1) <- "lll"
WtoText(pW1)
WfromText(pW1)
WcanEdit(pW1)
WbuttonText(pW1)
WbuttonFun(pW1)
WwList(widget1)
WwList(widget1) <- list(Name = "New list", Value = "New value")
WLValue(widget1, 1)
WLValue(widget1, 1) <- "New value"
WpreFun(widget1)
WpostFun(widget1)
WEnd(widget1)
}
\keyword{manip}







\eof
\name{appendSepDir}
\alias{appendSepDir}

\title{List File and Directories for a Given Path}
\description{
  Takes a path and returns a vector of string with the
  names of files and directories for the path. The directory names will
  have a system dependent path separator (e. g. / for Unix) appended.
}
\usage{
appendSepDir(path)
}
\arguments{
  \item{path}{\code{path} character string specifying the path whose
    contents are to be listed}
}
\value{
  A character vector containing file and directory names.
}
\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R.}

\seealso{\code{\link{fileBrowser}}, \code{\link{pickFiles}}}

\examples{
# File names and directory names are not differentiated
list.files()

# Put a separater at the end of directory names
appendSepDir(getwd())
}
\keyword{manip}




\eof
\name{args2XML}
\alias{args2XML}

\title{Converting the formal arguments to a function and converts into
  an XML format} 
\description{
  This function reads the formal arguments to a given function and
  converts the content into an XML format
}
\usage{
args2XML(fun, xml.name = "", full.names = NULL, priority = NULL)
}

\arguments{
  \item{fun}{\code{fun} name of the function of interests}
  \item{xml.name}{\code{xml.name} a character string for the name of the
    xml file holding the content of the formal arguments to the function}
  \item{full.names}{\code{full.names} a vector of character string with
    full description of each of the formal arguments to the
    function. The order of apperance of each description much correspond
    to the oreder of their appeerance in the formal argument list}
  \item{priority}{\code{priority} a vector of integers or character
    strings indicating the priority of the arguments.}
}
\details{
  Priority values are currently used to determine whether the argument
  will appear on a widget that has entry boxes for modifying the values
  of the arguments. Users of args2XML may not have any concern of the
  priority values
}
\value{
  No value will be returned.
}

\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{fileWizard}}}

\examples{
fullNames <- c("Full path names", "Pattern to match",
"Visiable file names", "Include path")
args2XML(list.files, "temp.xml", fullNames, c(1, 2, 2, 2)) 
readLines("temp.xml")
unlink("temp.xml")
}
\keyword{misc}


\eof
\name{argsWidget}
\alias{argsWidget}
\alias{getPWidget}
\alias{formatArg}
\alias{getSymbol}
\alias{funcs2Char}
\alias{getTrueNullNa}
\title{Functions to construct a widget that takes inputs from users}
\description{
   Given a argument list, the functions construct a widget to allow
   users to entry or select values for arguments defined by the names of
   the argument list.
}
\usage{
argsWidget(argsList, defaultNames, inst = "")
getPWidget(argsList, PWEnv, inst = "")
formatArg(toFormat)
getSymbol(args)
funcs2Char(args,funcs)
getTrueNullNa(toFormat)
}

\arguments{
  \item{argsList}{\code{argsList} a list of arguments with or without
    default values. The list can be derived from
    e.g. \code{\link{formals}}}
  \item{PWEnv}{\code{PWEnv} an R environment used object to store data for
    the argument list}
  \item{toFormat}{\code{toFormat} element to be formated by
    \code{\link{formatArg}}}
  \item{args}{\code{args} arguments to be formated}
  \item{funcs}{\code{funcs} a list containing the arguments that are
    functions}
  \item{defaultNames}{\code{defaultNames} a vector of character strings
    of length 2 for two default buttons to be rendered. The first one is
    to end the process and the second to abort the process}
  \item{inst}{\code{inst} a character string for a short instuction that
    will appear on the top of a widget}
}
\details{
  \code{\link{argsWidget}} builds a widget with widget elements to allow
  users to input values for the arguments.

  \code{\link{getPWidget}} instatiates primary widgets that will be used
  to construct the widget for argements.

  \code{\link{formatArg}} formats the value for a given argument so that
  the calue can be displayed by a tcltk widget.

  \code{\link{getSymbol}} filters out functions from the argument list.

  \code{\link{funcs2Char}} converts functions to character
  representations of the functions.

  \code{\link{getTrueNullNa}} converts string "true", "false", "null",
  and "na" to R primitives for these items.
}
\value{
  \code{\link{argsWidget}} returns a list with user input values for
  elements of the argument list passed.

  \code{\link{getPWidget}} returns a list of primary widgets.

  \code{\link{formatArg}} returns a list containing the formated values.

  \code{\link{getSymbol}} returns a list containing arguments that are
  functions.

  \code{\link{funcs2Char}} returns a list containing character
  representations of functions.

   \code{\link{getTrueNullNa}} returns an R object.
}
\references{R tcltk}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{basicPW-class}}}
\examples{
  if(interactive()){
      argsWidget(list("Entry with default" = "default",
                      "Entry without default" = ""))
  }
}
\keyword{interface}


\eof
\name{colInfo-class}
\docType{class}
\alias{colInfo-class}
\alias{colInfo}
\alias{colName<-}
\alias{colName}
\alias{colType}
\alias{colType<-}
\alias{dropOrNot}
\alias{dropOrNot<-}
\alias{colInfo}
\alias{colName<-,colInfo-method}
\alias{colName,colInfo-method}
\alias{colType,colInfo-method}
\alias{colType<-,colInfo-method}
\alias{dropOrNot,colInfo-method}
\alias{dropOrNot<-,colInfo-method}
\title{Class "colInfo" presents column information for a data frame}
\description{This class is for keeping information about a data frame to
be processed. The class is mainly for use by \code{\link{importWizard}}}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("colInfo", ...)}
}
\section{Slots}{
  \describe{
    \item{\code{colName}:}{Object of class \code{"character"} - a
      character string for the name of the column}
    \item{\code{colType}:}{Object of class \code{"character"} - a
      character string for the data type of the column. Can only be
      "character" or "numeric"}
    \item{\code{dropOrNot}:}{Object of class \code{"logical"} - a
      boolean indicationg whether the column will be droped}
  }
}
\section{Methods}{
  \describe{
    \item{colName}{\code{signature(object = "character")}: The get
      method for slot "colName"}
    \item{colName<-}{\code{signature(object = "character")}: The set
      method for slot "colName"}
    \item{colType}{\code{signature(object = "character")}: The get
      method for slot "colType"}
    \item{colType<-}{\code{signature(object = "character")}: The set
      method for slot "colName"}
    \item{dropOrNot}{\code{signature(object = "logical")}: The get
      method for slot "dropOrNot"}
    \item{dropOrNot}{\code{signature(object = "logical")}: The set
      method for slot "dropOrNot"}
  }
}
\author{Jianhua Zhang}
\note{This class is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{
  \code{\link{importWizard}}
}
\examples{
  newInfo <- new("colInfo", colName = "aaaa", colType = "character",
dropOrNot = FALSE)  
}
\keyword{classes}


\eof
\name{dataViewer}
\alias{dataViewer}
\title{Function to view a data object passed}
\description{
  This function creates a widget to allow users to view the content of a
  data frame passed and decide whether to save the data or not.
}
\usage{
dataViewer(data, caption = "", save = TRUE)
}

\arguments{
  \item{data}{\code{data} a data frame (or alike) to be viewed}
  \item{caption}{\code{caption} a character string for the title of the
    widget}
  \item{save}{\code{save} a boolean to indicate whether to have the
    option to allow users to save the data}
}
\details{
  Taking a data frame as one of the arguments, this function builds a
  widget that allows users to view the content of the data and save the
  data as a file.
}
\value{
  This function does not return any value
}
\references{R tcltk}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{importWizard}}}
\examples{
# Create matrix
data <- matrix(1:20, ncol = 4)
if(interactive()){
    # View data using dataViewer
    dataViewer(data, "test", TRUE)
}
}
\keyword{interface}

\eof
\name{dbArgsWidget}
\alias{dbArgsWidget}

\title{Function to build a widget for inputing database arguments}
\description{
  This functions creates a interactive widget to allow users to input
  arguments for database connection for Unix.
}
\usage{
dbArgsWidget()
}

\details{
  Database arguments include database name, user name, password, host
  name, and table name.
}
\value{
  The function returns a list containing the following elements:
  \item{dbname}{a charater string for the name of the database}
  \item{host}{a character string for the name or IP address of the host
    machine}
  \item{user}{a character string for the name of the user}
  \item{password}{a character string for the password}
  \item{tablename}{a character string for the name of the database table}
}
\references{Rdbi}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{argsWidget}}}
\examples{
if(interactive()){
    test <- dbArgsWidget()
}
}
\keyword{interface}


\eof
\name{eSetFilter}
\alias{eSetFilter}
\alias{getFilterNames}
\alias{getFuncDesc}
\alias{getRdAsText}
\alias{parseDesc}
\alias{parseArgs}
\alias{eSet}
\alias{setESetArgs}
\alias{isESet}
\alias{showESet}
\title{A function to filter an eSet object}
\description{
  Given a Bioconductor's eSet object, this function filters genes using
  a set of selected filters.
}
\usage{
eSetFilter(eSet)
getFilterNames()
getFuncDesc(lib = "genefilter", funcs = getFilterNames())
getRdAsText(lib)
parseDesc(text)
parseArgs(text)
showESet(eSet)
setESetArgs(filter)
isESet(eSet)
}
\arguments{
  \item{eSet}{\code{eSet} an eSet object}
  \item{lib}{\code{lib} a character string for the name of an R library
    where functions of interests reside}
  \item{funcs}{\code{funcs} a vector of character strings for names of
    functions of interest}
  \item{text}{\code{text} a character of string from a filed
    (e. g. description, argument, ..) filed of an Rd file for a
    fucntion}
  \item{filter}{\code{filter} a character string for the name of a
  filter function} 
}
\details{
  A set of filters may be selected to filter genes in through each of
  the filters in the order the filters have been selected
}
\value{
  A logical vector of length equal to the number of rows of 'expr'.
  The values in that vector indicate whether the corresponding row
  of 'expr' passed the set of filter functions.
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functonalities through R}

\seealso{\code{\link{genefilter}}}
\examples{
  if(interactive()){
      library(genefilter)
      library(Biobase)
      data(geneData)
      data(geneCov)
      covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
      names(covdesc) <- names(geneCov)
      pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
      eset <- new("exprSet", exprs=geneData, phenoData=pdata)

      res <- eSetFilter(eset)
  }
}
\keyword{manip}


\eof
\name{fileBrowser}
\alias{fileBrowser}
\title{Simple Interface to View and Pick Files}
\description{
  This function provides the widget for users to go up and down a path and
  view the files.  When files are selected and the \code{"End"} button
  is pressed, the function returns a vector of character strings with
  the full paths of the selected files.
}
\usage{
fileBrowser(path="", testFun = function(x) TRUE, prefix = NULL,
	    suffix = NULL, textToShow = "Choose file(s) to be read in.",
	    nSelect = -1)
}
\arguments{
  \item{path}{character string for the full path to be view. Defaults
    to the current working directory if no path is provided.}
  \item{testFun}{function that checks to see if a given file name
    satisfies predefined requirements. The default is no checking.}
  \item{prefix}{character string for a prefix used to screen out file
    names that do not have that prefix as part of their names.}
  \item{suffix}{character string for a suffix used to screen out file
    names that do not have that suffix as part of their names.}
  \item{textToShow}{character string to be shown on the widget to given
    instructions to users.}
  \item{nSelect}{integer indicating the number of files that should be
    selected.  No limitation if \code{nSelect = -1} as per default.}
}
\details{
  When a path is viewed, files will be displayed as they are and
  directories will be displayed with a system file separator appended
  (e.g. \code{"/"} for Unix systems).
%
  Single click on a file name will make the file selectable when the
  select button is pressed.  Multiple selection is possible by dragging
  with mouse button 1 pressed.
%
  Double click on a directory name will go into that directory and
  display its files.  When a file/directory is selected and the "End" button
  pressed, the full path for the selected files selected will be
  returned.

  The widget is modal and has to be closed by pressing the "End" button
  before doing any other operations. Functions, prefix, and suffix can
  be specified.	 Examples of validity functions are
  \code{\link{hasPrefix}} and \code{\link{hasSuffix}}.

  The following is a list of the buttons and their associated behavior:
  \describe{
    \item{\code{Up}}{Moves the directory whose content is to be
      displayed in the box for file names one level up along the
      directory tree.  No action if already on top of the tree.}

    \item{\code{Select \>\> }}{When a file or files in the box for file
      names in a directory have been highlighted by clicking or dragging
      mouse button 1 and this button is pushed, the highlighted file(s)
      will be displayed in the box for selected file(s) on the right.}

    \item{\code{\<\< Remove}}{When a file or files in the box for
      selected files have been highlighted by clicking or dragging this
      button is pushed, the highlighted file(s) will be removed from the box.}

    \item{\code{Clear}}{Clears everything in the box for selected files
      when pushed.}

    \item{\code{end}}{Returns a vector containing all the names in the box for
      selected files or \code{NULL} if the box is empty.  The full path
      will be appended to the file names.}
  }
}
\value{
  A vector of character strings containing the full path of each file
  selected.
}
\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functions using \R.}

\seealso{\code{\link{makeViewer}}, \code{\link{pickFiles}},
  \code{\link{hasPrefix}}, \code{\link{hasSuffix}}} 

\examples{
## The example here is only run interactively since it requires user
## interference which may cause problems if not available:
if(interactive()) {

  # Call the function to view the current directory
  flist <- fileBrowser()
  flist

  # To call the function with a path do
  # fileBrowser(path = "yourPath")
}
}
\keyword{interface}



\eof
\name{fileWizard}
\alias{fileWizard}

\title{A function that import a text file into R}
\description{
  Given a file name, this function imports the text file into R.
}
\usage{
fileWizard(filename = "", fun = read.table, file = "file",
basic = c("header", "sep"))
}

\arguments{
  \item{filename}{A character string for the name of the text file to be
    imported}
  \item{fun}{An R function that is going to be used to read the
    file. Default to    \code{\link{read.table}}}
  \item{file}{A character string for the name of the argument to fun
    that defines the name of the file to be read}
  \item{basic}{A vector of character strings for names of the arguments
    to fun that will have separate entry boxes on the widget to be
    produced. Default to "header" and "sep"}
}
\details{
  This function is only partially finished and will be improved soon. It
  currently allows uesrs to view a given file and change the settings
  for header and sep arguments of read.table. A file will be read in
  based on the values of the two arguments and return.
}
\value{
  This function returns a data frame for the file read in.
}
\references{R News Vol. 1/3, September 2001}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{fileBrowser}}}

\examples{
if(interactive()) {
  # Only the interface is displyed as no real file is given
  fileWizard()  
}
}
\keyword{interface}

\eof
\name{getLightTW}
\alias{getLightTW}

\title{Function to create a light weight widget showing a text string}
\description{
  Given a text string and coordinations, this function creates a light
  weight tcltk widget with showing the text string passed.
}
\usage{
getLightTW(x, y, text)
}

\arguments{
  \item{x}{\code{x} an interger for the horizontal position for the
    widget to appear}
  \item{y}{\code{y} an integer for the vertical position for the widget
    to appear}
  \item{text}{\code{text} a character string to be show in the widget}
}
\details{
  When the function is invoked, a box containing the text will appear at
  the position specified by x, and y. Click the widget makes it disappear.
}
\value{
  This function does not return any value
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\examples{
if(interactive()){
    getLightTW(200, 200, "Click Me!")
}
}
\keyword{interface}

\eof
\name{getWvalues}
\alias{getWvalues}

\title{Obtaining values of widgets on a given widget}
\description{
   This function returns a list containing the values for widgets on a
   widget created by function widgetRender. It takes a list defining the
   widget and returns a named list containing the values for each of the
   widgets.
}
\usage{
getWvalues(W)
}

\arguments{
  \item{W}{\code{W} a list of lists defining the widgets that are used
    to make a widget}
}
\details{
  For a widget containing 3 widgets each with some associated
  functionalities, the list is defined as this:

  pW1 <- list(Name="AAA", Value="bbb",
            toText=function(x) paste(x,collapse= ","), fromText=NULL,
            canEdit=TRUE,
            buttonFun = fileBrowser, buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z",
            toText=function(x) paste(x, collapse=","), fromText=NULL,
            canEdit=TRUE, buttonFun = ls, buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc",
            toText=function(x) paste(x, collapse = ","), fromText=NULL,
            canEdit=TRUE, buttonFun=NULL,  buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                preFun  = function() "Hi",
                postFun = function() "Bye")

  widget1 will be used to create a widget with 3 entry boxes. When users
  modify the values through the widget created, new values will be kept
  in the list and widget1 will be returned up exist. getWvalues is
  useful to capture the values for each widgets on the widget.
}
\value{
  This function returns a list of:

  \item{comp1 }{Description of `comp1'}
  \item{comp2 }{Description of `comp2'}

}

\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics funcitonalities through R}

\seealso{\code{\link{widgetRender}}}

\examples{
# Define the widgets
  pW1 <- list(Name="AAA", Value="bbb",
            toText=function(x) paste(x,collapse= ","), fromText=NULL,
            canEdit=TRUE,
            buttonFun = fileBrowser, buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z",
            toText=function(x) paste(x, collapse=","), fromText=NULL,
            canEdit=TRUE, buttonFun = ls, buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc",
            toText=function(x) paste(x, collapse = ","), fromText=NULL,
            canEdit=TRUE, buttonFun=NULL,  buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                preFun  = function() "Hi",
                postFun = function() "Bye")

  if(interactive()){
      tt <- widgetRender(widget1, "try")
      getWvalues(tt)
  }else{
      getWvalues(widget1)
  }
}
\keyword{misc}


\eof
\name{guess.sep}
\alias{guess.sep}
\alias{guess.header}
\alias{find.type}
\alias{charOrNum}

\title{Automatically determines whether a data file has a header and
  what delimiter is used to separate data columns}
\description{
  This function reads a few lines from a data text file and determines
  whether a header exists, what the delimiter, and what data type each
  column is for a given file.
}
\usage{
guess.sep(file.name, numLine = 5, seps = "", isFile = TRUE)
guess.header(twoLines, sep)
find.type(line, sep, header = FALSE)
charOrNum(vect)
}

\arguments{
  \item{file.name}{\code{file.name} a character string for the name of
    the file of interests}
  \item{numLine}{\code{n} an integer or character indicating the total number
    of lines to be read from the file for making the determination}
  \item{seps}{\code{seps} a vector of characters of potential delimiters
    to be used to make the determination. Default delimiters include " ",
    ",", ";", and "\t". Anything inaddition to the default will have to
    be included in seps}
  \item{twoLines}{\code{twoLines} a vector of character string including
    the first two lines of a file that will be used to determine whether
    the file has a header}
  \item{sep}{\code{sep} a character for the delimiter used to separate
    columns in a file}
  \item{line}{\code{line} a vector of character strings including the
    first few lines of file to be checked for data type of whose
    columns}
  \item{vect}{\code{vect} a vector of character or numeric string}
  \item{header}{\code{header} a boolean indicating whether a file has
    headers}
  \item{isFile}{\code{isFile} a boolean that is TRUE when
    \code{file.name} is a file or FALSE an object}
}
\details{
  guess.sep calls \code{\link{guess.sep}} and \code{\link{find.type}} to
  determine the header, delimiter, and column data type of a file.

  \code{\link{charOrNum}} determines which elements of a vector are
  numeric or character.
}
\value{
  This function returns a list containing
  \item{header}{TRUE if there is a header and FALSE otherwise}
  \item{separater}{A character string indicating the delimiter used}
  \item{type}{A vector of character strings that are either character or
    numeric} 
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{fileWizard}}}

\examples{
# Create a temp file
tempData <- matrix(1:20, ncol = 4)
write.table(tempData, file = "tempData", quote = FALSE, sep =
"\t", row.names = FALSE, col.names = TRUE)

guess.sep("tempData")

unlink("tempData")
}
\keyword{misc}

\eof
\name{hasChar}
\alias{hasChar}
\alias{hasPrefix}
\alias{hasSuffix}

\title{String Prefix and Suffix Checking}
\description{
  These functions return a \emph{function} for determining if a
  given prefix, suffix, or set of characters passed to this function
  exists in a character string passed to the returned function.
}
\usage{
hasChar(toCheck, what = "")
hasPrefix(aPrefix)
hasSuffix(aSuffix)
}
\arguments{
  \item{aPrefix}{character string to be used as the prefix to be checked for}
  \item{aSuffix}{character string to be used as the suffix to be checked for}
  \item{toCheck}{\code{toCheck} a character string to be used to check
    to see if it exists in a character string passed to the returned
    function}
  \item{what}{\code{what} a character string defining whether toCheck
    will be used as a prefix (what = "prefix"), suffix (what =
    "suffix"), or a set of characters (what = "") to check the character
    string passed to the returned function} 
}
\details{
  The prefix (or suffix) is passed to \code{hasPrefix} (or
  \code{hasSuffix}) and then the returned function can be used to check
  for the existence of that prefix (suffix) in a string passed to that
  function.

  hasChar is a more general function that determines the existence of
  prefix, sufix, or a set of a characters in a character string passed
  to the returned function.
}
\value{
  A \bold{function} which itself returns a logical (of length 1)
  indicating if the prefix/suffix is found (\code{\link{TRUE}}) or not.
}

\author{Jianhua (John) Zhang}
\note{These function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R.}

\seealso{\code{\link{pickFiles}}}

\examples{
# Function for checking for a prefix "xxx" :
chkPfun <- hasChar("xxx", what = "prefix")
# Function for checking for a suffix ".tex" :
chkSfun <- hasChar(".tex", what = "suffix")

chkPfun("xxx.tex")
chkPfun(".xxx")
chkSfun("xxx.tex")
chkSfun("yyyyy")
chkSfun("yxxx.text")
}
\keyword{manip}

\eof
\name{importWizard}
\alias{importWizard}
\alias{initImportWizard}
\alias{getTopCan}
\alias{getAFrame}
\alias{finish}
\alias{getState1Frame}
\alias{setState1BFrame}
\alias{setState1TFrame}
\alias{showData4State1}
\alias{setState1MFrame}
\alias{getState2Frame}
\alias{setState2MFrame}
\alias{setSepRadios}
\alias{setQuoteList}
\alias{setQuote}
\alias{setState2BFrame}
\alias{showData4State2}
\alias{getState3Frame}
\alias{setState3TFrame}
\alias{setState3BFrame}
\alias{getName4Data}
\alias{writeCol4Matrix}
\title{A widget for importing data to R}
\description{
  Functions constructs a widget that allows users to inport data
  file to R. The imported data will be returned as an R data frame
  together with the argument list used to import the data using read.table
}
\usage{
importWizard(filename = "", maxRow = 200)
initImportWizard(env)
getTopCan(base, env)
getAFrame(base, env)
finish(env)
getState1Frame(base, env)
setState1BFrame(frame, env)
setState1TFrame(frame, viewer, delims, env)
showData4State1(widget, env)
setState1MFrame(frame, env, dataViewer)
getState2Frame(base, env, state = "state2", reset = FALSE)
setState2MFrame(frame,env)
setSepRadios(frame, env, state = "state2")
setQuoteList(frame, env)
setQuote(listBox, env, state = "state2")
setState2BFrame(frame, env)
showData4State2(canvas, env, state = "state2")
getState3Frame(base, env)
setState3TFrame(frame, env)
setState3BFrame(frame, env)
getName4Data(filename)
writeCol4Matrix(tempFrame, dataFile, colInfos, env)
}

\arguments{
  \item{filename}{\code{filename} a character string for the name of the
    file to be imported. The default is an empty string and users have to
    click a browse button to get the file name through
    \code{\link{fileBrowser}}}  
  \item{maxRow}{\code{maxRow} an integer for the maximum number of rows
    of the data file to be imported to be shown on the widget. The
    default is 200 rows}
  \item{env}{\code{env} an R environment object for storing the required
    information}
  \item{base}{\code{base} a tcltk window to hold a canvas on the top and
    frames in the bottom}
  \item{frame}{\code{frame} a tcktl frame}
  \item{viewer}{\code{viewer} a tkwin object for a widget}
  \item{delims}{\code{delims} a character string for a file separater}
  \item{widget}{\code{widget} a tcltk widget}
  \item{state}{\code{state} a character string for the state of
    importing process}
  \item{listBox}{\code{listBox} a tcltk list box}
  \item{canvas}{\code{canvas} a tcltk canvas}
  \item{tempFrame}{\code{tempFrame} a tcltk frame that will be used to
    hold widget elements}
  \item{dataFile}{\code{dataFile} a data matrix holding data to be
    displayed}
  \item{colInfos}{\code{colInfos} an object of class colInfo with a
    name, type, and drop slot}
  \item{reset}{\code{reset} a boolean that is TRUE when the window needs
    to be reset}
  \item{dataViewer}{\code{dataViewer} a tkwin object for a list box}
}
\details{
  \code{\link{importWizard}} mimics the interface of MS Excel and
  collects arguments for the function \code{\link{read.table}}. Due to
  performace concern, a maximum number of rows (maxRow) set by 
  users will be displayed. Overly long data set may cause slow response
  of the system.

  \code{\link{initImportWizard}} initializes the interface for
  importWizard by creating a widget with an empty top canvas and bottom
  frame filled with four buttons.

  \code{\link{getTopCan}} Creates a canvas that is going to be filled by
  a frame created by other functions depending on the state of the
  importing process.

  \code{\link{getAFrame}} Gets a frame for the canvas created by
  \code{\link{initImportWizard}} based on the current state of importing
  process.

  \code{\link{finish}} Finishes the importing process and returns a data
  frame read from a file using \code{\link{read.table}}.

  \code{\link{getState1Frame}} Returns a tcltk frame containing a list
  box to show a data file read by \code{\link{readLines}} and widgets
  for user imports.

  \code{\link{setState1BFrame}} Fills the bottom frame of the frame
  created by \code{\link{getState1Frame}} with a list box.

  \code{\link{setState1TFrame}} Fills the top frame of the frame
  created by \code{\link{getState1Frame}} with a list box.

  \code{\link{showData4State1}} Populates a tcltk list or text widget
  with data read using readLines.

  \code{\link{setState1MFrame}} Fills the mid frame of the frame
  created by \code{\link{getState1Frame}}.

  \code{\link{getState2Frame}} Returns a tcltk frame containing a canvas
  to show a data file read by \code{\link{read.table}} and widgets
  for user imports.

  \code{\link{setState2MFrame}} Fills the mid frame of the frame
  created by \code{\link{getState2Frame}}.

  \code{\link{setSepRadios}} Renders radio buttons for options of file
  separators in the frame created by \code{\link{setState2MFrame}}.

  \code{\link{setQuoteList}} Renders the selection list for the quote
  used by a data file in the frame created by
  \code{\link{setState2MFrame}}.

  \code{\link{setQuote}} Sets the value when a user has selected the
  quote used by a data file.

  \code{\link{setState2BFrame}} Fills the bottom frame of the frame
  created by \code{\link{getState2Frame}} with a canvas.

  \code{\link{showData4State2}} Populates the canvas created by
  \code{\link{setState2BFrame}} using data read by
  \code{\link{read.table}}.
  
  \code{\link{getState3Frame}} Returns a tcltk frame containing a canvas
  to show a data file read by \code{\link{read.table}} and widgets
  for user imports.

  \code{\link{setState3TFrame}} Fills the top frame of the frame
  created by \code{\link{getState3Frame}}.

  \code{\link{setState3BFrame}} Fills the bottom frame of the frame
  created by \code{\link{getState3Frame}}.

  \code{\link{getName4Data}} Takes user input for a file name using a
  widget.

  \code{\link{writeCol4Matrix}} Creates a tcltk frame with list boxes as
  columns displaying data of a data matrix.
}
\value{

  \code{\link{getTopCan}} returns a tcltk canvas.

  \code{\link{getAFrame}} returns a tcltk frame.

  \code{\link{finish}} returns a data.frame.

  \code{\link{getState1Frame}} returns a tcltk frame with several
  widgets.

  \code{\link{setState1BFrame}} returns the tkwin object of list box.

  \code{\link{getState2Frame}} returns a tcltk frame with several
  widgets.

  \code{\link{getState3Frame}} returns a tcltk frame with several
  widgets.
  
  \code{\link{getName4Data}} returns a character string for the name of
  a file to be saved.
}

\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{fileBrowser}}, \code{\link{argsWidget}}}

\examples{
  if(interactive()){
      importWizard()
  }
}
\keyword{interface}


\eof
\name{listSelect}
\alias{listSelect}
\alias{writeSelBox}
\alias{writeBut}
\alias{writeLabel}
\title{Utilities Creating a Widget With Selection Boxes}
\description{
  These functions create a widget with selection boxes allowing users to
  view and make selections of items shown on the interface.
}
\usage{
listSelect(aList, topLbl = "Select Elements From The Following List",
           typeFun = stdType, valueFun = objViewer)
writeSelBox(baseW, aList, typeFun = NULL, valueFun = NULL)
   writeBut(baseW, butList, butWidth = 6)
 writeLabel(baseW, typeFun, valueFun)
}

\arguments{
  \item{aList}{list with names and object pairs (e. g. \code{a = "AAA"}).}
  \item{topLbl}{character string for the text to be shown as a title.}
  \item{typeFun}{function that takes an \R object as an arguement and
    returns a description of the object.}
  \item{valueFun}{function that takes an \R object as an argument
    and shows the content of the object.  The function should get the
    representation of the object and calls \code{\link{objViewer}} to have
    the representation rendered in a widget.}
  \item{baseW}{a window widget to which the selection boxes will be put.}
  \item{butList}{a list with names and function pairs that define the
    name and behavior of buttons to be put on the widget to be
    generated}
  \item{butWidth}{numerical value specifying the width of buttons to
    be created.}
}
\details{
  Both \code{typeFun} and \code{valueFun} have to take an argument (the
  \R object to be shown).  It works well for the \code{valueFun}
  function to call \code{\link{objViewer}()} with whatever to be shown
  passed to \code{objViewer} as an argument.
}
\value{
   \code{listSelect()} returns a list with the names of the \R objects in the
   original list associated with \code{TRUE} (selected) or \code{FALSE}
   (deselected).
}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioninformatics functionalities through \R.
}
\seealso{\code{\link{objViewer}}}

\examples{
aList <- list(a = "AAA", b = c(123, 456, 789),
              c = as.data.frame(matrix(1:10, ncol = 2)),
              d = stdType)
# Since user interference is required, the example code does not run
# automatically
if(interactive())
  listSelect(aList)}
}
\keyword{interface}

\eof
\name{neighborGeneFinder}
\alias{neighborGeneFinder}
\title{A widget for locating genes neighboring a target gene}
\description{
  Given a set of data (matrix) with entries for LocusLink or UniGene
  ids, the neighboring genes of a gene selected from a list on the
  interface can be located.
}
\usage{
neighborGeneFinder(geneData, keyName = c("unigene", "locuslink"),
organism = c("human", "mouse", "rat")) 
}
\arguments{
  \item{geneData}{\code{geneData} a matrix with columns named. The name
    for one of the columns has to be either "locuslink" or "unigene"}
  \item{keyName}{\code{keyName} a character string for the name of the
    key columns of \code{geneData}. Has to be either "locuslink" or
    "unigene"} 
  \item{organism}{\code{organism} a character string for the name of the
    organism of interest. Has to be "human", "mouse", or "rat"} 
}
\details{
  Bioconductor's data package XXXCHRLLOC has to be instatlled for the
  widget to work. If \code{keyName} is "unigene", XXXLLMappings is
  required, where XXX is the name of the organism of interest.
}
\value{
  This function returns a list of lists. Elements of the top level list
  are either LocusLink or UniGene ids. A sublist is inturn a list of
  lists whose top level elements are chromosome numbers, each of which
  is a list with an "upstream" and "downstream" elements.
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\examples{
  if(interactive()){
     require(annotate) || stop("Package annotate is not availble")
     geneData <- cbind(paste("100", 1:16, "_at", sep = ""), c(1, 50,
                       10044, 51, 71, 51371, 81, 51426, 188, 293, 360,
                       364, 375, 387, 513, 10572))
     colnames(geneData) <- c("Probe", "locuslink")
     neighborGeneFinder(geneData, "locuslink", "human")
  }
  
}
\keyword{interface}


\eof
\name{objNameToList}
\alias{objNameToList}

\title{Convert Object Names to List of Lists with (name, object) Pairs}
\description{
  This function supports \code{\link{objectBrowser}} by converting a
  vector of selected object names to a list of lists with object names
  and the corresponding objects. 
}
\usage{
objNameToList(objNames, env)
}
\arguments{
  \item{objNames}{character vector giving the names of objects.}
  \item{env}{an R environment where R objects are stored}
}
\details{
  Each list in the list that is going to be returned contains a name for
  the object and the real value of the object. If the object name is a
  package name, the contents of the package will be the value associated
  with the package name.
}
\value{
  A list of lists each with a \code{name} and an \code{obj} component.
}

\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconducter project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionality through R.}

\seealso{\code{\link{objectBrowser}}}

\examples{
# Create two R objects
obj1 <- c("aaa", "bbb", "ccc")
env1 <- new.env(parent = NULL)

# Get a list containing the two objects
nl <- objNameToList(c("obj1", "env1"), parent.frame())
str(nl)

}
\keyword{manip}


\eof
\name{objViewer}
\alias{objViewer}
\title{Show the Content of an R Object in a Widget}
\description{
  This function takes an \R object and shows the content in a list box on
  a widget.
}
\usage{
objViewer(toView, width = 40, height = 10)
}

\arguments{
  \item{toView}{\R object whose content is to be viewed}
  \item{width, height}{positive values specifying the width and height
    of the widget.}
}
\details{
  The function makes no check of the \R object passed and will show
  whatever the object will be shown when the name is type at an \R
  prompt.  Formatting is required before passing the \R object to the function.
}
\value{
  This function does not return any value
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through \R.
}
\seealso{\code{\link{listSelect}}}

\examples{
# Since user interference is required, the example code only runs
# interactively
if(interactive())
   objViewer("Just to show that the content gets posted")
}
\keyword{interface}


\eof
\name{objectBrowser}
\alias{objectBrowser}

\title{View the Objects in the Workspace.}
\description{
  This function provides a widget to view objects and select some which
  are going to be returned.  When the \code{End} button is pressed, the
!  selected objects will be returned.
}
\usage{
objectBrowser(env = parent.frame(1), fun = function(x) TRUE,
              textToShow = "Select object(s)", nSelect = -1)
}
\arguments{
  \item{fun}{function to test whether certain conditions are met by
    the objects.  Only objects that meet the conditions will be displayed.}
  \item{textToShow}{character with the message to be shown on the
    widget as an instruction.}
  \item{nSelect}{integer indicating the number of objects to select.
      No limitation if \code{nSelect = -1} as per default.}
  \item{env}{an R environment object whose objects will be browsed}  
}
\details{
  This function will return a list of lists with a "name" and "obj" pair
  for each object. The "name" will be the name of the object and "obj"
  will be the value of the object. If the object is a package, a
  description of the contents of the package will be the value. If the
  selected object is a function, a text string of the original code will
  be the value. A function can be passed to impose a filtering mechanisms
  on the objects to be displayed. See function isCharacter for an
  example of writing a filtering function for objectBrowser.

  The buttons and their expected behavior are
  \describe{
    \item{\code{Up}}{Moves one level up along the search list and
      displays the content in the box for object names on the left of the
      widget.}

    \item{\code{Select \>\>}}{When objects in the box for object names
      have been highlighted by clicking or clicking/dragging, this
      button will display the highlighted object names in the box
      for selected objects on the right.}

    \item{\code{Reset}}{Moves back to \code{\link{.GlobalEnv}} which
      is the default starting point of the system.}

    \item{\code{\<\< Remove}}{When object names in the box for selected
      objects have been highlighted by clicking or clicking/dragging and
      this button is pressed, the highlighted object names will be removed
      from the display.}

    \item{\code{Clear}}{Removes all the object names from the box for
      selected objects.}

    \item{\code{Cancel}}{Exits the widget and returns \code{NULL} when
      pressed.}

    \item{\code{End}}{Returns a \code{list} of lists with names of the
      objects in the box for selected objects and their corresponding values
      or \code{NULL} if nothing exists in the box.}
  }
}
\value{
  A \code{\link{list}} of lists with a name and value pair for each object.
}
\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through \R.}

\seealso{\code{\link{fileBrowser}}}

\examples{
## The example here is only run interactively since it requires user
## interference which may cause problems if not available:
if(interactive()) {

# Call the function with the isCharacter function.
r <- objectBrowser()
str(r) # show what we've got
}
}
\keyword{interface}


\eof
\name{pickFiles}
\alias{pickFiles}

\title{Pick Elements From Vector of Strings}
\description{
 Takes a vector of strings and then checks to see if the
  predefined conditions are met for each element.  Elements that meet the
  conditions will be included in the vector returned and the others not.
}
\usage{
pickFiles(fileNames, fun = function(x) TRUE,
          prefix = NULL, suffix = NULL, exclude = .Platform$file.sep)
}
\arguments{
  \item{fileNames}{vector of strings that will be checked.}
  \item{fun}{function to be used to check the strings.  Default is no checking.}
  \item{prefix}{character used to check to see if strings in the vector
    have the prefix.}
  \item{suffix}{character used to check to see if strings in the vector
    have the suffix.}
  \item{exclude}{character string with which strings in the vector
    will be excluded form the checking.  The default is to exclude all
    the directory names and always return them.}
}
\details{
  The function fun will be used only when both prefix and suffix are
  NULL. If a prefix is not NULL, that prefix will be checked. A suffix
  is going to be checked when prefix is NULL.
}
\value{
  Character vector of file names satisfying the conditions.}
}

\author(Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R.}

\seealso{\code{\link{fileBrowser}}, \code{\link{hasPrefix}}, \code{\link{hasSuffix}} }

\examples{
# Return every thing from the current directory
pickFiles(list.files())

# Create a temp file
file.create("myFile")

# Returns subdirectory names and file names with a prefix of "my"
pickFiles(list.files(), prefix = "my")

# create another temp file
file.create("temp.tex")

# Return subdirectory names and file names with a suffix of ".tex"
pickFiles(list.files(), suffix = ".tex")

# clearn up
unlink("myFile")
unlink("temp.tex")
}
\keyword{manip}














\eof
\name{pickItems}
\alias{pickItems}

\title{Function that builds a widget to allow users to select items from
available sources} 
\description{
  Given a vector of characters, this function creates a widget
  containing list box to allow users to visually select elements from
  the vector.
}
\usage{
pickItems(items)
}

\arguments{
  \item{items}{\code{items} a vector for the available source elements
    to be selected}
}
\details{
  This function is to provide visual support to other functions and thus
  may not have much use otherwise.
}
\value{
  This function returns a vector of select items.
}
\references{R tcltk}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{dataViewer}}}
\examples{
options <- paste("Option", 1:10, sep = "")
if(interactive()){
    pickItems(options)
}
}
\keyword{interface}

\eof
\name{pickObjs}
\alias{pickObjs}
\alias{noAuto}

\title{Determine What to Be Sent to a Widget}
\description{
  This function takes a vector of object names and determines what will
  be sent to (e.g. the \code{\link{objectBrowser}}) widget for display
  based on the default and user input requirements.
}
\usage{
pickObjs(objNames, fun = function(x) TRUE)
noAuto(x)
}

\arguments{
  \item{objNames}{\code{objNames} character vector with object names to
    be processed} 
  \item{fun}{\code{fun} function checking the object names for satisfaction of
    certain requirement} 
  \item{x}{\code{x} a character string for the name of an object}
}
\details{
  Packages and environments are always displayed.
}
\value{
  Character vector of object names that satisfy the requirements.}
}

\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R.}

\seealso{\code{\link{objectBrowser}}}

\examples{
# Returns names of package and environment objects in the search path.
pickObjs(search())
}
\keyword{manip}


\eof
\name{setArgsList}
\alias{setArgsList}
\alias{whatDeli}
\alias{getMoreArgs}
\alias{assignArgs}
\alias{getArgs}
\alias{assignShowNum}
\alias{getShowNum}
\alias{assignCState}
\alias{getCState}
\alias{assignColInfo}
\alias{getColInfo}
\alias{setColInfos}
\alias{changeState}
\alias{setNewState}
\alias{addArgs}
\alias{dropArgs}
\alias{setSkip}
\alias{moreArgs}
\alias{dropColumn}
\alias{setColName}
\alias{setColType}
\alias{assignLineData}
\alias{getLineData}
\title{Functions to support importWizard}
\description{
  The functions are to support importWizard and may not have much
  practical use otherwise.
}
\usage{
setArgsList(filename, env, isFile = TRUE, init = TRUE)
whatDeli(delimiter)
getMoreArgs()
assignArgs(value, env)
getArgs(env)
assignShowNum(value, env)
getShowNum(env)
assignCState(value, env)
getCState(env)
assignColInfo(value, env)
getColInfo(env)
setColInfos(types, env)
changeState(canvas, backBut, nextBut, env, forward = TRUE, endBut, viewBut)
setNewState(env, backBut, nextBut, forward = TRUE, endBut, viewBut)
addArgs(env)
dropArgs(env)
setSkip(widget, env, state = "state1")
moreArgs(env)
dropColumn(index, env)
setColName(index, entryBox, env)
setColType(index, entryBox, env)
assignLineData(lineData, env)
getLineData(env)
}

\arguments{
  \item{filename}{\code{filename} a character string for the full name
    of a file}
  \item{env}{\code{env} an R environment object for storing information}
  \item{delimiter}{\code{delimiter} a character string for the delimiter
    whose letter representation is sought}
  \item{value}{\code{value} a character or numerical value to be
    assigned to a variable}
  \item{backBut}{\code{backBut} a tkwin object for the button that
    shifts back to the previous state}
  \item{nextBut}{\code{nextBut} a tkwin object for the button that
    shifts to the next state}
  \item{forward}{\code{forward} a boolean indicating the direction of
    state change}
  \item{widget}{\code{widget} a tcltl widget}
  \item{state}{\code{state} a character string for the state of
    importing process}
  \item{index}{\code{index} an integer for the index of the list for
    column information}
  \item{entryBox}{\code{entryBox}} a tcltk entry box.
  \item{canvas}{\code{canvas} a tcltk canvas}
  \item{types}{\code{types} a vecter of string indicating the types of
    data columns}
  \item{lineData}{\code{lineData} a vector of character strings read in
    using \code{\link{readLines}}}
  \item{endBut}{\code{endBut} a tkwin object for the button that ends
    the process when pressed}
  \item{viewBut}{\code{viewBut} a tkwin object for the button that
    refresh the window when pressed}
  \item{init}{\code{init} a boolean that is TRUE when the widget is
    first set up and FALSE otherwise}
  \item{isFile}{\code{isFile} a boolean that is TRUE if \code{fileName}
    is a file}
}
\details{
  \code{\link{setArgsList}} calls function \code{\link{guess.sep}} to
  figure out the the header, sep, and data type of a file and sets the
  values for argument list and colInfo.

  \code{\link{whatDeli}} gets the word representation of delimiters
  (e.g. tab for "\t").

  \code{\link{getMoreArgs}} generates a widget using widgetTools to
  collect some of the arguments for read.table.

  \code{\link{assignArgs}} updates "argsList" stored in a predefined
  environment. 

  \code{\link{getArgs}} Gets "argsList" from a predefined environment.
  
  \code{\link{assignShowNum}} Updates the value for "showNum" (number of
  rows to show in the interface.
  
  \code{\link{getShowNum}} Gets the value for "showNum" (number of
  rows to show in the interface. 
  
  \code{link{assignCState}} Updates the value of "currentState" that is
  stored in a predefined environment.
  
  \code{\link{getCState}} Gets the vlaue of "currentState" that is
  stored in a predefined environment.
  
  \code{\link{assignColInfo}} Updates the values of "colInfos" (column
  information) that is stroed in a predefined environment.
  
  \code{\link{getColInfo}} Gets the values of "colInfos" (column
  information) that is stroed in a predefined environment.
  
  \code{\link{setColInfos}} Creates colInfo objects and sets the value
  of 'colInfos' list.

  \code{\link{changeState}} changes the state and thus the interface of
  a widget.

  \code{\ling{setNewState}} sets the state of a importing process.

  \code{\link{addArgs}} adds a new state to the argument list for
  states.

  \code{\link{dropArgs}} removes a state from the argument list for
  states.

  \code{\link{setSkip}} Sets the value for the number of lines to skip
  when readling a data file.

  \code{\link{moreArgs}} Gets some of the arguments for importing data
  using \code{\link{read.table}}.

  \code{\link{dropColumn}} Sets the index values for data columns that
  are going to be droped when read using \code{\link{read.table}}.

  \code{\link{setColName}} Sets the column names for a data file by
  getting column names from correct entry boxes.

  \code{\link{setColType}} Sets the column type for a data file by
  getting column type information from correct entry boxes.
}
\value{
  \code{\link{whatDeli}} returns a character string.

  \code{\link{getMoreArgs}} returns a list of arguments.

  \code{\link{getArgs}} returns a list of the arguments for read.table.

  \code{\link{getShowNum}} returns an integer for the number of rows to
  show.

  \code{\link{getCState}} returns a character string for the current
  state.

  \code{\link{getColInfo}} returns a colInfo object contains column
  information.
}

\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics funcitonalities through R}

\seealso{\code{\link{importWizard}}}
\examples{
  # No example is given as functions require the set up of the working
  # environment. 
}
\keyword{misc}


\eof
\name{stdType}
\alias{stdType}
\alias{stdView}
\title{Provide Default Behavior for listSelect Helper Functions}
\description{
  The function \code{\link{listSelect}} takes two functions which define
  how the type information and content of \R objects will be shown on
  the widget created by \code{listSelect}.
  Functions \code{stdType()} and \code{stdView()} provide the default
  behavior.
}
\usage{
stdType(toCheck)
stdView(toView)
}
\arguments{
  \item{toCheck, toView}{arbitrary \R object.}
}
\details{
  These functions can be viewed as exmaples of defining functions for
  the \code{typeFun} and \code{valueFun} arguments of the
  \code{\link{listSelect}} function.
}
\value{
  %% FIXME:
  \code{stdType()} returns a character string describing the type of the
  \R object.

  \code{stdView()}
}
\author{Jianhua Zhang}
\note{These functions are part of the Bioconductor project at
  Dana-Farber Cancer Institute to provide Bioinformatics functionalities
  through R}

\seealso{\code{\link{listSelect}}}

\examples{
stdType(123)
stdType("What am I")

str(mydf <- data.frame(x = 2:8, ch = letters[1:7]))
stdType(mydf)# "list"
stdType(stdType)

if(interactive()) {## stdView() needs UI:
  stdView(1:10)
  stdView(mydf)
 }
}
\keyword{misc}


\eof
\name{tkMIAME}
\alias{tkMIAME}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simple Interface to enter experimental design information}
\description{This function provides a widget for users to enter
  experimental design MIAME information.
}
\usage{
tkMIAME()
}

\details{
This widget provides an interface to enter experimental information following
the MIAME (Minimum Information About a Microarray Experiment) standard.

A draft of the latest document (v. 1.1) is
\url{http://www.mged.org/Workgroups/MIAME/miame_1.1.html}

Brazma et al. divide the MIAME into 6 sections
1. Experimental design, 2. Array design, 3. Samples, 4. Hybridizations,
5. Measurements, and 6. Normalization controls
This widget is for the first section.
We ask for the user to enter: experimenter name,
laboratory, contact information, a single-sentence experiment title, an
abstract describing the experiment, URLs. This slot could also include a
formal statistical description of the experimental design (e.g. using
factors). Some of this info is already stored in phenoData or elsewhere.

The function returns a list that is intended for the creation of an
object of class \code{\link[Biobase]{MIAME}}. However, we return a list
so that the function can work independently of the Biobase package.
}
\value{
  A list containing entries:
  
   \item{ExperimentName}{character string}
   \item{LabName}{character string}
   \item{ContactInfo}{character string}
   \item{ExperimentTitle}{character string}
   \item{Description}{character string}
   \item{URL}{character string}
}
\references{``Minimum information about a microarray experiment
  (MIAME)-toward standards for microarray data'', A. Brazma, et al.,
  Nature Genetics, vol. 29 (December 2001), pp. 365-371,
  \url{http://www.mged.org/Workgroups/MIAME/miame_1.1.html}} 
\author{Majnu John}
\seealso{\code{\link[Biobase]{MIAME}}}


\keyword{interface}% __ONLY ONE__ keyword per line

\eof
\name{tkSampleNames}
\alias{tkSampleNames}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simple interface to associate sample names with files}
\description{
This widget provides an interface to enter names to be associated with
files containing array expression information related to a particular
sample.}

}
\usage{
tkSampleNames(..., filenames = character(0))
}
\arguments{
  \item{\dots}{ the filenames to be associated with a sample name,
    supplied individually and/or as a  character vector}
  \item{filenames}{a character vector of filenames to be associated
    with a sample name.}
}
\details{
  \code{\link[Biobase]{phenoData-class}} objects will use sample names as row
    names for the \code{pData} slot. The colnames of the expression
    matrices in \code{\link[Biobase]{exprSet-class}} use this as well. Many
      times, each of these columns are obtained from a file. Rather than
      use the, sometimes ugly, filename we can use the sample names that
      this interface associates with each file.
      
      The function returns a character matrix intended to be used to
      create sample
      names in phenoData and exprSet. However, the function can be used
      independetly of the Biobase package.
    }
\value{
  A character matrix with the first column the filenames the second
  column the sample names to associate.
}
\author{Majnu John}
\keyword{interface}% __ONLY ONE__ keyword per line

\eof
\name{tkphenoData}
\alias{tkphenoData}
\title{Simple interface to enter phenoData}
\description{
This widget provides an interface to create
\code{\link[Biobase]{phenoData-class}} instances.
}
\usage{
tkphenoData(sampleNames)
}
\arguments{
  \item{sampleNames}{sampleNames for which we will enter phenotypic data.}
}
\details{
  The function returns a list of character matrices intended to be used
  as the \code{pData} and \code{varLabels} slots of an instance of
  \code{\link[Biobase]{phenoData-class}}.
}
\value{
  A list of two matrices
  \item{pData}{a character matrix containing phenotypic data.}
  \item{varLabels }{a character vector with covariate description}
}
\author{Majnu John} 

\seealso{\code{\link[Biobase]{phenoData-class}}}
\keyword{interface}

\eof
\name{vExplorer}
\alias{vExplorer}
\alias{viewVignette}

\title{An interface to interact with vignette code chunks}
\description{
  This function provides a widget for viewing, editing, and executing
  code chunks of vignettes.
}
\usage{
vExplorer(title = "BioC Vignettes Browser", pkgName = "",  font =
ifelse(.Platform$OS.type  == "unix", "arial 14", "arial 11"))
viewVignette(title, packName, vigPath, pdfPath, font = "arial 11")
}

\arguments{
  \item{title}{character string for the name to be
    displayed as the title of the widget to interact with code chunks.}
  \item{pkgName}{vector (of length 1 for \code{pkgName}) of
    character strings for names of Bioconductor packages the code chunks
    of whose vignettes will be explored.}
  \item{packName}{same as pkgName}
  \item{vigPath}{character string for the full qualified name of a
    vignette to be explored.}
  \item{pdfPath}{character string for the full path of a pdf file (if
    any) associated with a vignette.}
  \item{font}{a character string for the name and size of the font to be
    used for text rendered on the widgets (e. g. "arial 11")}
}
\details{
  By default, \code{packNames = ""}, all the installed packages will be
  examined and those that have vignettes will be listed to allow users
  to choose from.
}
\value{
  This function does not return any useful value.
}
\references{\url{http://www.bioconductor.org}}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Faber
  Cancer Institute to provide Bioinformatics functionalities through \R.
}
\examples{
if(interactive()){
    require(DynDoc)
    require(tools)
    require(widgetTools)
    vExplorer()
    path <- .path.package("widgetTools")
    vigList <- getPkgVigList(path)
    viewVignette("BioC VignetteBrowser", "widgetTools", vigList[[1]]$VigPath,
     file.path(path, "doc"))
}
}
\keyword{interface}


\eof
\name{values.Widget}
\alias{values.Widget}
\alias{print.Widget}
\alias{print.pWidget}
\title{Deal with Names and Values of Widget Created by widgetRender()}
\description{
  Functions in this group print or list the names or/and values of the
  widget elements on a widget created by \code{\link{widgetRender}()}.
}
\usage{
values.Widget(x)
}

\arguments{
  \item{x}{A list (print.pWidget) or list of lists(print.Widget,
    values.Widget) that representing a widget element (list) on a widget
    or a widget (list of lists) generated by using the function widgetRender.}
}
\details{
  print.pWidget takes a list defining a widget element on a widget
  generated by using the function widgetREnder. An example of a valid
  list will be:

  pW1 <- list(Name="AAA", Value="bbb", toText=function(x)
  paste(x,collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun =
  fileBrowser, buttonText = "Browse")

  print.Widget and values.Widget take a list of lists defining all the
  widget elements on a widget generated using the function
  widgetRender. An example of a valid list will be:

  pW1 <- list(Name="AAA", Value="bbb", toText=function(x)
  paste(x,collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun =
  fileBrowser, buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z", toText=function(x) paste(x,
  sep=","), fromText=NULL, canEdit=TRUE, buttonFun = ls,  buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc", toText=function(x) paste(x,
  collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun=NULL,
  buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3), preFun =
  function() "Hi", postFun = function() "Bye")

}
\value{
  \item{returnList}{values.Widget returns a list of lists each with the
    name and value of an entry box on the widget created.}
}

\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R.}

\seealso{\code{\link{widgetRender}}}

\examples{
# Create the lists and list of lists
  pW1 <- list(Name="AAA", Value="bbb",
              toText=function(x) paste(x,collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun = fileBrowser,
              buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z", toText=function(x) paste(x, sep=","),
            fromText=NULL, canEdit=TRUE, buttonFun = ls,
           buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc",
              toText=function(x) paste(x, collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun=NULL,
              buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                  preFun = function() "Hi",
                  postFun = function() "Bye")

# Define the classes
class(pW1) <- c("pWidget", "textbox")
class(widget1) <- "Widget"

# Call the funcitons
print.pWidget(pW1)
print.Widget(widget1)
values.Widget(widget1)
}
\keyword{manip}

\eof
\name{widgetRender}
\alias{widgetRender}

\title{Render a Tk Widget from Given Specifications}
\description{
  This function takes a list that specifies the appearance and behavior
  of a Tk widget and renders the widget accordingly.
}
\usage{
widgetRender(iWidget, tkTitle)
}

\arguments{
  \item{iWidget}{list of lists that specifies the appearance and
    behavior of the widget to be rendered.}
  \item{tkTitle}{character string for the text to appear in the
    title bar of the widget to be rendered.}
}
\details{
  The widget to be rendered normally consists of frames with three
  widgets arranged in a row. The first widget is normally a label for
  the name of the second widget. The second widget can be any type of
  widgets. The third widget is a button widget that defines some
  behavior to be associated with the second widget. For example, a
  button that will cause something to be displayed in the second widget
  when pressed. The third widget can be missing if no such association
  is required.

  The widget to be rendered also has two buttons at the bottom part of
  the widgets. The followings are the name and behavior of the buttons:

  \describe{
    \item{\bold{Cancel} -}{The unmodified list passed to the function at
      the time of invocation will be returned when pressed.}

    \item{\bold{End} -}{A modified version of the \code{iWidget}
      argument will be returned when pressed.  The returned list has the
      same number of elements as the original one but with the values
      modified based on the entries in corresponding widgets items.}
    }
}
\value{
  A \code{\link{list}} of lists with the original values of the passed
  modified or unmodified depending on whether the cancel or end button
  pressed.}
}
\references{
  Peter Dalgaard (2001)
  A Primer on the R-Tcl/Tk Package;
  R News \bold{1} (3), 27--31
  \url{http://CRAN.R-project.org/doc/Rnews/}
}
\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through \R.}

\seealso{\code{\link{fileBrowser}},
  \code{\link{objectBrowser}}.
}

\examples{
# Create the list to be passed
pW1 <- list(Name="AAA", Value="bbb",
            toText=function(x) paste(x,collapse= ","), fromText=NULL,
            canEdit=TRUE,
            buttonFun = fileBrowser, buttonText = "Browse")

pW2 <- list(Name="BBB", Value="x,y,z",
            toText=function(x) paste(x, collapse=","), fromText=NULL,
            canEdit=TRUE, buttonFun = ls, buttonText = "List")

pW3 <- list(Name="CCC", Value="ccc",
            toText=function(x) paste(x, collapse = ","), fromText=NULL,
            canEdit=TRUE, buttonFun=NULL,  buttonText=NULL)

widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                preFun  = function() "Hi",
                postFun = function() "Bye")

# Call the function
if(interactive()){
    x <- widgetRender(widget1, "Test Widget")
    str(x)
}
}
\keyword{interface}





\eof
