\name{Probes-class}
\docType{class}
\alias{Probes-class}
\alias{initialize}
\alias{show}
\alias{plot}
\alias{plot}

\alias{initialize,Probes-method}
\alias{show,Probes-method}
\alias{plot,Probes-method}
\alias{plot,Probes-method}
\alias{grid.plot,Probes,missing-method}
\alias{grid.plot,Probes,SpliceSites-method}
\alias{plot,Probes,missing-method}
\alias{plot,Probes,SpliceSites-method}

\title{Class "Probes" }
\description{Information about a set of probes }
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("Probes", pos)}
  or \code{new("Probes", pos, info)}.
  The object are primarily storing the location of the probe on a
  matching sequence sequence. Optional information can be stored
  in the slot \code{info} (a \code{data.frame}).
}
\section{Slots}{
  \describe{
    \item{\code{pos}:}{Object of class \code{"matrix"}. It expects one
      row per probe. The first column should give the start position
      while the second column should give the end position}
    \item{\code{info}:}{Object of class \code{"data.frame"}. Optional
      information one wishes to carry around can be stored here.}
  }
}

\section{Methods}{
  \describe{
    \item{initialize}{\code{signature(.Object = "Probes")}: ... }
    \item{show}{\code{signature(object)}: show minimal information}
    \item{plot}{\code{signature(x = "Probes", y = "missing")}: plot the
      position of the probes. (see \code{\link{plot.Probes}}) }
    \item{plot}{\code{signature(x = "Probes", y = "SpliceSites")}: plot
      the positions of the probes and the positions of the splice sites}
  }
}

\seealso{ \code{\link{SpliceSites-class}}, \code{\link{SpliceExprSet-class}}, }

\examples{
data(probes)

plot(probes)
}
\keyword{classes}

\eof
\name{SpliceExprSet-class}
\docType{class}
\alias{SpliceExprSet-class}

\alias{grid.plot}
\alias{spliceSites}
\alias{grid.plot.SpliceExprSet}
\alias{grid.plot,SpliceExprSet,missing-method}
\alias{plot,SpliceExprSet,missing-method}
\alias{show,SpliceExprSet-method}
\alias{spliceSites,SpliceExprSet-method}
\alias{exprs,SpliceExprSet-method}
\alias{exprs<-,SpliceExprSet-method}
\alias{grid.plot,SpliceSites,missing-method}


\title{Class "SpliceExprSet"}
\description{A class to store probe expression values with alternative
  splicing information}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SpliceExprSet", ...)}.

}
\section{Slots}{
  \describe{
    \item{\code{spliceSites}:}{Object of class \code{"SpliceSites"}. The
    probes and splice site information.}
    \item{\code{probes}:}{Object of class \code{"Probes"}. The matching expression
      values.}
    \item{\code{eset}:}{Object of class \code{"exprSet"}. The matching expression
      values.}
  }
}
\section{Methods}{
  \describe{
    \item{grid.plot}{\code{signature(x = "SpliceExprSet", y = "missing")}: ... }
    \item{plot}{\code{signature(x = "SpliceExprSet", y = "missing")}: a
      ploting method.}
    \item{show}{\code{signature(object = "SpliceExprSet")}: a printing method. }
    \item{spliceSites}{\code{signature(object = "SpliceExprSet")}:
      accessor. }
  }
}
\references{ a manuscript in preparation } %FIXME: poster
\author{ laurent@cbs.dtu.dk}

\seealso{\code{\link{as.data.frame.SpliceExprSet}}, \code{\link{sort.SpliceExprSet}}
 and \code{\link{SpliceSites-class}} }
\examples{
data(eset, package="splicegear")
data(probes, package="splicegear")
data(spsites, package="splicegear")

spliceset <- new("SpliceExprSet", eset=eset,
                       probes=probes, spliceSites=spsites)

plot(spliceset)
}
\keyword{classes}

\eof
\name{SpliceSites-class}
\docType{class}
\alias{SpliceSites-class}

\alias{show,SpliceSites-method}
\alias{plot,SpliceSites-method}
\alias{initialize,SpliceSites-method}
\alias{plot,SpliceSites,missing-method}

\title{Class "SpliceSites"}
\description{ A class to store (putative) splice sites }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SpliceSites", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{probepos}:}{Object of class \code{"matrix"}. A two-columns
      matrix to store the begin and end positions of probes (one row per
      probe).}
    \item{\code{seq}:}{Object of class \code{"character"}. The reference
      sequence.}
    \item{\code{seq.length}:}{Object of class \code{"integer"}. The length for
      the reference sequence (used when the slot \code{seq} is set to
      \code{""}).}
    \item{\code{spsiteIpos}:}{Object of class \code{"matrix"}. A
      two-columns
      matrix to store the begin and end positions of type I splice variant.}
    \item{\code{spsiteIIpos}:}{Object of class \code{"integer"}. A
      vector to store the positions for type II splice variants.}
    \item{\code{spsiteIIIpos}:}{Object of class \code{"matrix"}. Idem
      \code{spsiteIpos}, but for type III splice variants.
    }
    \item{\code{spsiteIpos.pData}:}{Object of class
      \code{\link[Biobase]{"phenoData"}}. Used to store covariate
      information related to the splice variants}.
    \item{\code{spsiteIIpos.pData}:}{Object of class
      \code{\link[Biobase]{"phenoData"}}}.
    \item{\code{spsiteIIIpos.pData}:}{Object of class \code{\link[Biobase]{"phenoData"}}}. 
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "SpliceSites")}: A printing method. }
    \item{plot}{\code{signature(x = "SpliceSites", y = "missing")}: A
      plotting method }
  }
}
\references{ "Plenty of splicin' or 'can regular Affymetrix chips be used
  to observe alternative splicing ?'", Gautier L. et al., 2003, manuscript in
  preparation (and the title might have to chang\ldots).} %FIXME: NAR paper + poster
\author{ laurent@cbs.dtu.dk }
\seealso{ \code{\link{isSpliceSiteOnProbe}},
  \code{\link{isProbeOnSpliceSite}},
  \code{\link{plot.SpliceSites}},
  \code{\link{spliceset}}.
}

\examples{
data(spliceset)

print(spliceset)

par(mfrow=c(1,2))

plot(spliceset, main=attr(spliceset, "name"))

## filter out supporting matches with unique positions
filter.typeI <- function(x) {unique(x[duplicated(x), , drop=FALSE])}
spliceset.filter <- spliceset
sSites <- spliceset.filter@spliceSites
sSites@spsiteIpos <- filter.typeI(sSites@spsiteIpos)
spliceset.filter@spliceSites <- sSites
## plot the resulting new object
plot(spliceset.filter)

}
\keyword{classes}

\eof
\name{SpliceSitesGenomic-class}
\docType{class}
\alias{SpliceSitesGenomic-class}

\alias{plot,SpliceSitesGenomic-method}
\alias{plot,SpliceSitesGenomic,missing-method}

\title{Class "SpliceSitesGenomic" }
\description{A class to store alternative splicing information on a
  genomic point of view}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SpliceSitesGenomic", seq, seq.length, spsiteIpos, spsiteIIpos, spsiteIIIpos, spsiteIpos.pData, spsiteIIpos.pData, spsiteIIIpos.pData, ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{variants}:}{Object of class \code{"list"}. There is one
      element per splice variant. Each element
      in the list should be a vector of integers. Each integer refers to
      an exon. The sequence of integers determines the sequence of exons
      in the splice variant.}
    \item{\code{seq}:}{Object of class \code{"character", from class "SpliceSites"} }
    \item{\code{seq.length}:}{Object of class \code{"integer", from class "SpliceSites"} }
    \item{\code{spsiteIpos}:}{Object of class \code{"matrix", from class "SpliceSites"} }
    \item{\code{spsiteIIpos}:}{Object of class \code{"integer", from
	class "SpliceSites"}. This should not have any practical use in this class.}
    \item{\code{spsiteIIIpos}:}{Object of class \code{"matrix", from
	class "SpliceSites"}. This should not have any practical use in this class.}
    \item{\code{spsiteIpos.pData}:}{Object of class \code{"phenoData", from class "SpliceSites"}}
    \item{\code{spsiteIIpos.pData}:}{Object of class \code{"phenoData",
	from class "SpliceSites"}. This should not have any practical use in this class.}
    \item{\code{spsiteIIIpos.pData}:}{Object of class \code{"phenoData",
	from class "SpliceSites"}. This should not have any practical use in this class.}
  }
}
\section{Extends}{
Class \code{"SpliceSites"}, directly.
}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(x = "SpliceSitesGenomic", y =
	"missing")}: a plotting method for demonstration purposes. }
  }
}
\seealso{ \code{\link{SpliceSites-class}} and \code{\link{plot.SpliceSitesGenomic}}.}

\examples{
## a 10 bp window
seq.length <- as.integer(10)
## positions of the exons
spsiteIpos <- matrix(c(1, 3.5, 5, 9, 3, 4, 8, 10), nc=2)
## known variants
variants <- list(a=c(1,2,3,4), b=c(1,2,3), c=c(1,3,4))

spvar <- new("SpliceSitesGenomic", spsiteIpos=spsiteIpos,
         variants=variants, seq.length=seq.length)

plot(spvar)

}
\keyword{classes}

\eof
\name{as.data.frame.SpliceExprSet}
\alias{as.data.frame.SpliceExprSet}
\alias{as.data.frame.SpliceSites}
\title{ convert to a data.frame }
\description{
  Convert a SpliceExprSet object to a data.frame
}
\usage{
as.data.frame.SpliceSites(x, row.names = NA, optional = NA)

as.data.frame.SpliceExprSet(x, row.names = NA, optional = NA)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{object \code{\link{SpliceSites-class}} or \code{\link{SpliceExprSet-class}} }
  \item{row.names}{ \code{NULL} or a character vector giving the row names for the
    data frame.  Missing values are not allowed}
  \item{optional}{ logical. If \code{TRUE}, setting row names is optional.}
}
\details{
  Data are traditionally stored in objects of class \code{data.frame}.
  This function links the object-oriented design of the package with
  the large amount of functions working on data.frames.
}
\value{
A \code{data.frame}. For both functions the first column names are \code{begin},
\code{end}, \code{isintypeI}, \code{isintypeII}, \code{exprs} and
\code{genenames}.
In the case of \code{as.data.frame.SpliceExprSet}, the next variable names will the ones in the
\code{\link[Biobase]{phenoData-class}} attribute of the
  \code{\link[Biobase]{exprSet-class}} object belonging the
  \code{\link{SpliceExprSet-class}}. The last variable names will be the
  ones in the slot \code{info} of the \code{\link{Probes-class}} object.
}
\author{ Laurent }

\examples{
data(spliceset)

dataf <- as.data.frame(spliceset)

lm.panel <- function(x, y, ...) {
                                  points(x,y,...)
                                  p.lm <- lm(y~x); abline(p.lm)
                                }

## probe intensity values conditioned by the position of the probes on
## the mRNA
coplot(log(exprs) ~ Material | begin, data=dataf, panel=lm.panel)

}
\keyword{ manip }


\eof
\name{barplot.SpliceSites}
\alias{barplot.SpliceSites}
\title{ barplot for SpliceSites }
\description{
  Display a barplot of the associated phenoData
}
\usage{
barplot.SpliceSites(height, type.as = c("typeI", "typeII", "all"),
                    info = "tissue", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{height}{ object of class \code{\link{SpliceSites-class}} }
  \item{type.as}{ the type of alternative splicing (see
    \code{SpliteSites-class} for futher details) }
  \item{info}{ the name of the covariate in the phenoData (see details)}
  \item{\dots}{ optional parameters to be passed to the underlying
    function \code{\link{barplot}}. }
}
\details{
  When the objects are built from the XML format we propose as an
  exchange, the parameter \code{info} can at least take the values
  \code{"tissue"} and \code{"histology"}. One can refer to the
  slots \code{spsiteIpos.pData} and \code{spsiteIIpos.pData} to
  know what are the possible choices.
}
\value{
  See the value returned by the function \code{\link{barplot}}.
}
\seealso{ \code{\link{SpliceSites-class}}, \code{\link{barplot}} }
\examples{

data(spsites)

barplot(spsites)

}
\keyword{ hplot }

\eof
\name{buildSpliceSites}
\alias{buildSpliceSites}
\alias{queryPALSdb}
\alias{getPALSdbURL}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Functions to query PALSdb }
\description{
  Functions to make a query on PALSdb, and build objects from the result
  of a query.
}
\usage{
queryPALSdb(query, disp = c("data", "browser"),
            field = c("keyword", "ug_id", "gb_id", "cluster_count"),
            species = c("human", "mouse"),
            e.value = "1e-1",
            ident.threshold = c("90% 50b", "95% 50b", "90% 45b"),
            verbose = FALSE)

getPALSdbURL(query, disp = c("data", "browser"),
            field = c("keyword", "ug_id", "gb_id", "cluster_count"),
            species = c("human", "mouse"),
            e.value = "1e-1",
            ident.threshold = c("90% 50b", "95% 50b", "90% 45b"),
            verbose = FALSE)

buildSpliceSites(xml, verbose=TRUE)
}
\arguments{
  \item{query}{query string}
  \item{xml}{an object of class XML (as returned by
    \code{\link[XML]{xmlTreeParse}})}
  \item{disp}{(idem \code{\link[annotate]{genbank}} and \code{\link[annotate]{pubmed}})}
  \item{field}{The field on which the query will be based}
  \item{species}{the specie to work with}
  \item{e.value}{}
  \item{ident.threshold}{threshold for matching sequences}
  \item{verbose}{verbose output.}
}
\details{
  \code{queryPALSdb} returns an an object of class XML when \code{disp =
    "data"}.

  The function \code{buildSpliceSites} constructs \code{SpliceSites}
  objects from the XML data. The variables in the slots
  \code{spsiteIpos.pData} and \code{spsiteIIpos.pData} are at least
  \code{tissue} (tissue information), \code{histology} and \code{site}
  (site numbering).
}
\value{
  An object of class \code{XML} for \code{queryPALSdb}, an URL for
  \code{getPALSdbURL} or a \code{list} of objects of class \code{SpliceSites}.
}
\references{"Standardazed output for putative alternative splicing: application to the study of 
splice variants with microarrays", Gautier L. et al., 2003, manuscript
in preparation.}
\author{ laurent@cbs.dtu.dk }

\seealso{\code{\link{queryPALSdb}}}
\examples{
library(XML)

filename <- system.file("data", "example.xml", package="splicegear")

xml <- xmlTreeParse(filename, asTree=TRUE)

spsites <- buildSpliceSites(xml)

}
\keyword{ manip }

\eof
\name{getRelSignStrength}
\alias{getRelSignStrength}
\alias{getFinalRatio}
\title{ functions to perform SPLICE }
\description{
  Implementations of the SPLICE algorithm
}
\usage{
getRelSignStrength(x, tissue = as.factor(1:ncol(x)), fun = mean, nipt = 30, nitt = 30, ...)

getFinalRatio(x, tissue=as.factor(1:ncol(x)), fun=mean, ...)
}
\arguments{
  \item{x}{ a matrix. One probe per line, one column per
    sample. Typically this would be the slot \code{exprs} of an instance
    of class \code{ExprSet}.}
  \item{tissue}{ a covariate (factor) about the samples.}
  \item{fun}{ a function to obtain a summary value (\code{mean} by default) }
  \item{nipt}{ see reference. }
  \item{nitt}{ see reference. }
  \item{\dots}{ optional parameters for the function \code{fun} }
}
\details{
  \code{getFinalRatio} will call \code{getRelSignStrength}. The
  values are log-transformed. It is probably a good idea to avoid
  feeding function with values that are already on log scale.
}
\value{
  A matrix of the same dimension than the input \code{x}, holding
  'RSS' (Relative Signal Strength) or 'final ratios' respectively, as described in the reference. Two
  attributes \code{nip} and \code{nit} are attached the returned matrix.
}
\references{ Genome Research (2001), Hu et. al., vol. 11, p.1244 }
\author{ laurent@cbs.dtu.dk }
\examples{
data(spliceset)

## The intensity values in the example are log-transformed.
## Undo by taking the exponential
exprs(spliceset) <- exp(exprs(spliceset))

## Re-order the rows of different slots to have the probes sorted by
## position
spliceset <- sort.SpliceExprSet(spliceset)
## extract the expression matrix
expr.m <- exprs(spliceset)
fr <- getFinalRatio(expr.m, tissue=pData(spliceset@eset)[[1]])

}
\keyword{ manip }

\eof
\name{grid.expand.gp}
\alias{grid.expand.gp}
\alias{grid.make.numeric2npc}

\title{ convenience functions for grid }
\description{
  Convenience function to use the package grid
}
\usage{
grid.expand.gp(n, parlist = list())
grid.numeric2npc(x, xlim=NULL, lower.blank=0, upper.blank=0

}
\arguments{
  \item{n}{ number of parameters }
  \item{parlist}{ list of parameters }
  \item{x}{numeric value}
  \item{xlim}{range for Xs}
  \item{lower.blank}{size for margins}
}
\details{
  call the function \code{gpar} on the list of parameters.
}
\value{
  Function used for its side effect.
}
\seealso{ \code{\link[grid]{lattice}}}
}
\keyword{ hplot }





\eof
\name{grid.plot.Probes}
\alias{grid.plot.Probes}
\alias{grid.plot.SpliceSites}
\alias{grid.plot.SpliceSitesExprSet}

\title{ Plot splicegear objects }
\description{
  Plot objects defined in the package splicegear
}
\usage{
grid.plot.Probes(x, col = "black", add = FALSE, probepos.yscale = NULL,
              xlim = NULL, vp = NULL, ...)

grid.plot.SpliceSites(x, col.typeI = "orange", col.typeI.window = "yellow", 
    col.typeII = "red", add = FALSE, ylim = NULL, vp = NULL, 
    ...)

grid.plot.SpliceExprSet(function (x, probes.opt = list(), expr.opt = list(col = NA, lty = 1:6),
    fig.xratio = c(2, 1), fig.yratio = c(2, 1), probepos.yscale = NULL,
    ylim = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ object of \code{\link{Probes-class}},
    \code{\link{SpliceSites-class}} or
\code{\link{SpliceExprSet-class}}}
  \item{add}{ add to an existing plot }
  \item{col}{ color(s) for the probes (recycled if necessary). }
  \item{col.typeI}{ color(s) for the type I spliced out exons }
  \item{col.typeI.window}{ background color for the type I spliced
    out `windows' }
  \item{col.typeII}{ color for the type II splicing events }
  \item{expr.opt}{list of options to plot expression values}
  \item{probepos.yscale}{ specify coordinates on the y-axis for the
probes.}
  \item{vp}{ a viewport (grid package stuff)}
  \item{xlim}{ range for the x-axis (see \code{plot}).}
  \item{ylim}{ range for the y-axis}
  \item{\dots}{ optional parameters }
}
\details{
  The `type I'/'type II' thing is described in the references found in
  the help files for \code{\link{plot.SpliceSites}}.
}
\value{
  These functions are mainly used for their side effects.
  \code{grid.plot.SpliceSites} returns the range for the y-axis when
  needed.
}
\seealso{ plot.SpliceSites, plot.Probes}
\examples{
## plot splice sites
data(spsites)
grid.plot(spsites)

## plot probes
data(probes)
grid.plot(probes)

## combined plot
grid.plot(probes, spsites)

}
\keyword{ hplot }

\eof
\name{isProbeOnSpliceSite}
\alias{isProbeOnSpliceSite}
\alias{isSpliceSiteOnProbe}
\title{ Check the presence of probes on certain exons }
\description{
  Return whether the probes are located on exons involved in (putative)
  alternative splicing or not.
}
\usage{
isProbeOnSpliceSite(probes, spSites)
## isSpliceSiteOnProbe is not yet implemented
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{probes}{ object of class \code{Probes}}
  \item{spSites}{ object of class \code{spliceSites}}
}
\details{
}
\value{
  The returned value in a list of two vectors of mode \code{logical}
  of the same length:
  \item{isintypeI}{whether the probes are in a `type I' region or not.}
  \item{isintypeII}{whether the probe are in a `type II' region or not.}
}
\references{ For details about `type I' and `type II', please refer to
  Huang Y.-H and Chen Y.-T and Lai J.-J. and Yang S.-T. and
  Yang U.-C., PALSdb: Putative Alternative Splicing database, Nucleic Acids Research,
  2002, pages 186-190 }
\author{ Laurent }
\examples{

}
\keyword{ manip }


\eof
\name{matchprobes2Probes}
\alias{matchprobes2Probes}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ create Probes object from matchprobes results }
\description{
  Create Probes object from results the results of the function
  matchprobes (in the package 'matchprobes').
}
\usage{
matchprobes2Probes(mpo, probes.length, names = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mpo}{\code{Probes-class} object}
  \item{probes.length}{ Length for the probes (see details). }
  \item{names}{ names for the elements in the list returned.} 
}
\details{
  Currently only probes of unique length are assumed.
  In the case of Affymetrix chips, 25 base pairs is the value you
  probably want.
}
\value{
  A \code{list} of \code{Probes-class} objects.
}
\references{ http://www.cbs.dtu.dk/laurent/download/splicegear/ }

\seealso{ \code{\link{Probes-class}}, the package \code{matchprobes}}

\keyword{ hplot }

\eof
\name{plot.SpliceExprSet}
\alias{plot.SpliceExprSet}
\title{ plot a SpliceExprSet }
\description{
  Plot a object of class \code{SpliceExprSet}
}
\usage{
plot.SpliceExprSet(x,
                   probes.opt = list(), expr.opt = list(col = NA, lty = 1:6),
                   fig.xratio = c(2, 1), fig.yratio = c(2, 1),
                   probepos.yscale = NULL, ylim,
                   ...)
}
\arguments{
  \item{x}{ a \code{\link{SpliceExprSet-class}}}
  \item{probes.opt}{ optional parameters to be passed for the plotting of
    the \code{\link{Probes-class}} }
  \item{expr.opt}{ optional parameters to be passed for the plotting of
    the \code{\link[Biobase]{exprSet-class}} }
  \item{fig.xratio}{ ratio between the left and right parts of the plot }
  \item{fig.yratio}{ ratio between the upper and lower parts of the plot }
  \item{probepos.yscale}{ enforce `y' positions for the probes. }
  \item{ylim}{range for the y-axis}
  \item{\dots}{ optional parameters to be passed to the function \code{plot} }
}
\details{
  The argument \code{probepos.yscale} can be used to scale probes
  according to their position on the reference sequence, as shown
  in the last example below.
}
\value{
  function used for its side-effect(s).
}

\author{ laurent }

\seealso{\code{\link{SpliceExprSet-class}} }
\examples{
data(spliceset)


levels(pData(spliceset@eset)$Material)
## Liver, Mix and SNB19
cl.mat <- c("red", "yellow","blue")[as.integer(pData(spliceset@eset)$Material)]
## colored in red, yellow and blue respectively
plot(spliceset, expr.opt = list(col = cl.mat, log = "x"))

begin.pos <- spliceset@probes@pos[, 1]
plot(spliceset, expr.opt = list(col=cl.mat), probepos.yscale = begin.pos)

}
\keyword{ hplot }

\eof
\name{plot.SpliceSites}
\alias{plot.SpliceSites}
\alias{plot.Probes}
\title{ plot a SpliceSites object }
\description{
  plot objects.
}
\usage{
plot.Probes(x, col="black", add=FALSE,
            probepos.yscale=NULL, xlim=NULL, ...)
plot.SpliceSites(x, col.typeI = "greenyellow",
            col.typeI.window = "yellow",
            col.typeII = "red",
            add=FALSE, ylim=NULL, ...)
}
\arguments{
  \item{x}{ object of class \code{Probes} or \code{SpliceSites}. }
  \item{col}{ color argument for the probes. }
  \item{col.typeI}{ color argument for the type I splice sites }
  \item{col.typeI.window}{ color argument for the type I `window' }
  \item{col.typeII}{ color argument for the type II splice sites }
  \item{add}{ add the plot to an existing plot. Make a new plot if `FALSE'}
  \item{probepos.yscale}{ scaling argument }
  \item{xlim}{range of plotting window}
  \item{ylim}{range of plotting window}
  \item{\dots}{ optional parameters to be passed to the function \code{plot}. }
}
\details{
  If the parameter \code{main} is not specified, the function tries to
  extract the attribute `name' from \code{x}. 
  
  The two functions can be combined to display both objects on the same plot.
}
\value{
  The range for the y-axis is returned whenever needed (see \code{invisible}).
}
\references{"Standardized output for putative alternative splicing; a R package as an 
application to combine them with microarray data", Gautier L. Dao C. and
Yang U.C., 2003, submitted.}
\author{ Laurent }

\seealso{\code{\link{SpliceSites-class}}}
\examples{
data(spsites)

plot(spsites, main=attr(spsites, "name"))

sp.pData <- spsites@spsiteIpos.pData

##col <- as.integer(factor(sp.pData$tissue))

##plot(spsites, col.typeI=col, main=attr("name", spsites))

}
\keyword{ hplot }% at least one, from doc/KEYWORDS

\eof
\name{plot.SpliceSitesGenomic}
\alias{plot.SpliceSitesGenomic}
\title{ Function to plot SpliceSitesGenomic objects }
\description{
  Function to plot SpliceSitesGenomic objects }
}
\usage{
plot.SpliceSitesGenomic(x, col.variant = par("col"), col.exon = "white",
                        split = FALSE, main = NULL, ...)
}
\arguments{
  \item{x}{ \code{SpliceSitesGenomic-class} }
  \item{col.variant}{ a vector of colors for the different variants. The
    colors are recycled as necessary.}
  \item{col.exon} { a vector of colors for the exons. The
    colors are recycled as necessary.}
  \item{split}{ split the plot of the variants in individual plots}
  \item{main}{\code{character} to use as a title. Recycled as necessary.}
  \item{\dots}{ optional graphical parameters }
}
\value{
  This function is used for its side-effect.
}
\author{ Laurent }
\seealso{ \code{\link{SpliceSitesGenomic-class}} }
\examples{
## a 10 bp window
seq.length <- as.integer(10)
## positions of the exons
spsiteIpos <- matrix(c(1, 3.5, 5, 9, 3, 4, 8, 10), nc=2)
## known variants
variants <- list(a=c(1,2,3,4), b=c(1,2,3), c=c(1,3,4))
##
n.exons <- nrow(spsiteIpos)

spvar <- new("SpliceSitesGenomic", spsiteIpos=spsiteIpos,
         variants=variants, seq.length=seq.length)

par(mfrow = c(3,1), mar = c(3.1, 2.1, 2.1, 1.1))

plot(spvar, split=TRUE, col.exon=rainbow(n.exons))

}
\keyword{ hplot }

\eof
\name{sort.SpliceExprSet}
\alias{sort.SpliceExprSet}
\title{ A function to sort a SpliceExprSet }
\description{
  Sort the probes in a SpliceExprSet (and reflect this in all the
  relevant places.
}
\usage{
sort.SpliceExprSet(x, fun = function(x) order(x@probes@pos[, 1]), reverse = FALSE)
}
\arguments{
  \item{x}{ a \code{SpliceExprSet}.}
  \item{fun}{ a function to do the sorting }
  \item{reverse}{ return the reverse of the sorting order }
}
\details{

}
\value{
  An object of class \code{SpliceExprSet}
}
\author{ Laurent }
\seealso{\code{\link{SpliceExprSet-class}}}
\examples{
data(spliceset)

s.spliceset <- sort.SpliceExprSet(spliceset)

}
\keyword{ manip }

\eof
\name{spliceset}
\alias{spliceset}
\alias{probes}
\alias{spsites}
\alias{eset}
\docType{data}
\title{Example data for splicegear}
\description{
  The putative splice variants for a reference sequence,
  the matching probes from the Affymetrix chip 'HG-U95A'
  and probe intensities from the 'dilution' dataset.
}
\usage{
#data(eset, package="splicegear")
#data(probes, package="splicegear")
#data(spsites, package="splicegear")
#data(spliceset, package="splicegear")
}
\format{
  The formats are objects of class \code{\link[Biobase]{exprSet-class}},
  \code{\link{Probes-class}}, \code{\link{SpliceSites-class}} and
  \code{\link{SpliceExprSet-class}} respectively.
}
\details{
  The attribute "name" is set to the ID of the Unigene cluster from
  which the reference sequence is taken.
}
\source{
  
}
\references{
  "PALSdb", ref.
  GeneLogic's dilution dataset.
}
\examples{
data(spliceset, package="splicegear")

plot(spliceset, main=attr(spliceset, "name"))
}
\keyword{datasets}

\eof
\name{split.SpliceSites}
\alias{split.SpliceSites}

\title{ split an instance of SpliceSites }
\description{
  Split an instance of SpliceSites into several instances of SpliceSites
}
\usage{
split.SpliceSites(x, f = list(typeI = NA, typeII = NA))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an instance of class \code{\link{SpliceSites-class}}.  }
  \item{f}{ a list of two factors (see details). }
}
\details{
  The split usually is performed on a factor. Two factors are required
  because of the two categories of splicing events (type I (deletion of
  a fragment of the reference sequence) and type II (insertion of an
  element of the reference sequence). A \code{character} can be used
  instead of a \code{factor}. In this case the covariates with the
  given name, in the slots \code{spsiteIpos.pData} and
  \code{spsiteIIpos.pData} respectively, are used to make the split.
  When equal to \code{NA}, the covariate named \code{site} will be
  used.
}
\value{
  A list of objects of class \code{SpliceSites}
}
\seealso{ \code{\link{SpliceSites-class}} }
\examples{
data(spsites)
split(spsites)
}
\keyword{ manip }

\eof
