sam.plot              package:siggenes              R Documentation

_S_A_M _A_n_a_l_y_s_i_s _f_o_r _a _s_p_e_c_i_f_i_c _t_h_r_e_s_h_o_l_d

_D_e_s_c_r_i_p_t_i_o_n:

     This functions performs a SAM or a SAM-Wilc analysis,
     respectively, for a specific threshold Delta, and (optionally)
     stores information on the differentially expressed genes in a
     file.

_U_s_a_g_e:

         sam.plot(sam.out,delta,data,q.values=TRUE,R.fold=TRUE,na.rm=FALSE,pty.square=TRUE,file.out=NA,
             col.accession=NA,col.gene.name=NA,use.numbers=sam.out$use.numbers,rand=sam.out$rand)

_A_r_g_u_m_e_n_t_s:

 sam.out: the object to which the output of a previous analysis with
          'sam' or 'sam.wilc' was stored.

   delta: the value of the threshold Delta for which the analysis
          should be performed.

    data: the used data set. If the fold change should be computed,
          this data set can be a transformed version of the data set
          used in the previous analysis with 'sam' or 'sam.wilc'.

q.values: if 'TRUE' (default), the q-value for each gene will be
          computed.

  R.fold: if 'TRUE' (default), the fold change for each differentially 
          expressed gene will be computed. If the previous SAM analysis
          was an one class analysis 'R.fold' is automatically set to
          'FALSE'.

   na.rm: if 'FALSE' (default), the fold change of genes with at least
          one missing value will be set to 'NA'. If 'TRUE', missing
          values will be replaced by the genewise mean.

pty.square: if 'TRUE' (default), a square SAM Plot will be generated
          with x and y axes having the same range.

file.out: if specified (i.e. not 'NA'), general information like the
          number of significant genes and the estimated FDR and
          gene-specific information is stored in the corresponding
          file.

col.accession: the column of 'data' containing the accession numbers of
          the genes. If specified, the accession numbers of the
          significant genes will be added to the output.

col.gene.name: the column of 'data' that contains the names of the
          genes. If specified, the names of the significant genes will
          be added to the output.

use.numbers: if 'TRUE', the number of observations that correspond to a
          point in the SAM Plot will be used as symbol for this point.
          Will only be used, if 'sam.out' contains the results of
          'sam.wilc'.

    rand: if specified, the random number generator is set in a
          reproducible state. By default, the same 'set.seed' is used
          as in the previous analysis with either 'sam' or 'sam.wilc'

_V_a_l_u_e:

     a SAM Plot for the specified Delta and (optionally) an output file
     containing general information like the number of significant
     genes and the FDR and information about the differentially
     expressed genes like their names, q-values and fold changes.

 vec.fdr: a list containing the number of p0, significant genes, the
          FDR etc. for the specified Delta.

sam.output: a table containing gene-specific information about the
          differentially expressed genes like their IDs (i.e. the rows
          of the data set that contain the  expression data of these
          genes), their expression score, q-values, the fold changes
          etc.

row.sig.genes: vector that consists of the rows of the data set that
          contain the expression data of the differentially expressed
          genes.

_N_o_t_e:

     SAM was developed by Tusher et al. (2001).

     !!! There is a patent pending for the SAM technology at Stanford
     University. !!!

_A_u_t_h_o_r(_s):

     Holger Schwender holger.schw@gmx.de

_R_e_f_e_r_e_n_c_e_s:

     Tusher, V.G., Tibshirani, R., and Chu, G. (2001). Significance
     analysis of microarrays applied to the ionizing radiation
     response, _PNAS_, 98, 5116-5121.

     Storey, J.D., and Tibshirani, R. (2003). Statistical significance
     for genome-wide experiments, _Technical Report_, Department of
     Statistics, Stanford University.

     Schwender, H. (2003). Assessing the false discovery rate in a
     statistical analysis of gene expression data, Chapters 5 and 6,
     _Diploma thesis_, Department of Statistics, University of
     Dortmund, <URL: http://de.geocities.com/holgerschw/thesis.pdf>.

_S_e_e _A_l_s_o:

     'sam' 'sam.wilc \code{sam.lambda}'

