\name{A.csr}
\alias{A.csr}
\non_function{}
\title{ ~~data-name / kind ...  }
\description{demonstration sparse matrix matrix.csr form}
\usage{data(A.csr)}
\format{
  The format is:
 list()
 - attr(*, "ra")= num [1:27]  2.894 -0.610 -0.714  0.546  0.901 ...
 - attr(*, "ja")= int [1:27] 3 4 5 2 4 1 3 4 5 3 ...
 - attr(*, "ia")= int [1:11] 1 4 6 10 11 14 18 21 22 26 ...
 - attr(*, "dimension")= int [1:2] 10 5
 - attr(*, "class")= atomic [1:1] matrix.csr
  ..- attr(*, "package")= chr ".GlobalEnv"
}
\source{
SparseM library matrix.csr example generated it 
}
\references{
   
}
\keyword{models}

\eof
\name{LLGOMFcp}
\alias{LLGOMFcp}
\non_function{}
\title{ concept probabilities for GO MF terms applied to human LocusLink entries  }
\description{ concept probabilities for GO MF terms applied to human LocusLink entries  }
\usage{data(LLGOMFcp)}
\format{
  The format is:
 Named num [1:5399] 0 0 0 0 0 ...
 - attr(*, "names")= chr [1:5399] "GO:0000005" "GO:0000006" "GO:0000007" "GO:0000008" ...
}
\source{
derived from Bioconductor packages humanLLMappings and GO
}
\keyword{datasets}

\eof
\name{OOC-class}
\docType{class}
\alias{OOC-class}
\alias{OOmap}
\alias{makeOOC}
\alias{OOmap,OOC-method}
\alias{show,OOC-method}
\alias{ontology,OOC-method}
\alias{coverageMat,OOC-method}
\title{Class "OOC" object-ontology complex }
\description{  Object that binds ontology (structured vocabulary) with
an object-term map.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("OOC", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{ontology}:}{Object of class \code{"ontology"} instance of ontoTools::ontology }
    \item{\code{OOmap}:}{Object of class \code{"namedSparse"} SparseM::matrix.csr bound with dimnames facilities }
  }
}
\section{Methods}{
  \describe{
    \item{coverageMat}{\code{signature(x = "OOC")}: return a namedSparse
incidence matrix with r,c element indicating whether term c covers
object r  }
    \item{ontology}{\code{signature(x = "OOC")}: accessor }
    \item{OOmap}{\code{signature(x = "OOC")}: accessor }
    \item{show}{\code{signature(object = "OOC")}: concise printer }
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{ VJ Carey <stvjc@channing.harvard.edu> }
%\note{ notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%  ~~objects to See Also as \code{\link{~~fun~~}}, ~~~
%  or \code{\link{CLASSNAME-class}} for links to other classes
%}
\examples{
data(litOnto)
g1 <- new("rootedDAG", DAG=litOnto, root="A")
o1 <- new("ontology", name="demo", version="0.1",
        rDAG=g1)
kvlist <- list(W="E", X="K", Y="B", Z=c("D","G"))
litMap <- otkvList2namedSparse( names(kvlist), LETTERS[1:12], kvlist )
print(litMap)
ooc1 <- makeOOC( o1, litMap )
show(ooc1)
print(coverageMat(ooc1))
# note the following will be slow with large OOCs
print(conceptProbs(ooc1))
# for larger OOCs it is useful to precompute the accessibility
# matrix of the ontology and the map from objects to terms -- these
# can be supplied as additional arguments to conceptProbs
}
\keyword{classes}

\eof
\name{accessMat}
\alias{accessMat}
\alias{child2parentMatDense}
\alias{child2parentMatSparse}
\alias{coverMat}
\alias{coverageMat}
\alias{daughterMat}
\alias{daughterSpMat}
\alias{getMatrix}
\alias{newadj}
\alias{revArcs}
\title{matrix utilities for ontoTools.}
\description{
A variety of matrix utilities used in ontoTools
}
\usage{
accessMat(object)
}
\arguments{
  \item{object}{ object}
}
\details{
}
%\value{
%}
%\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
%\note{  }


%\seealso{  }

\examples{
}
\keyword{ models }

\eof
\name{buildGOgraph}
\alias{buildGOgraph}
\title{build graphNEL corresponding to bioc GO environment  }
\description{
build graphNEL corresponding to bioc GO environment  
}
\usage{
buildGOgraph(useenv=GOMFPARENTS)
}
\arguments{
  \item{useenv}{ useenv: environment to be used}
}
\details{
all GO MF tags are nodes, edges drawn from node to parent
}
\value{
graphNEL instance
}
%\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
%\note{  }


\seealso{Biograph package  }

\examples{
# takes a while; trivial invocation
}
\keyword{ models }

\eof
\name{compoundGraph-class}
\docType{class}
\alias{adjMat}
\alias{toDot}
\alias{between}
\alias{grList}
\alias{compoundGraph-class}
\alias{adjMat,compoundGraph-method}
\alias{between,compoundGraph-method}
\alias{grList,compoundGraph-method}
\alias{toDot,compoundGraph,character,list,missing-method}
\alias{toDot,compoundGraph,character,list,list-method}
\alias{toDot,compoundGraph,missing,list,missing-method}
\title{Class "compoundGraph" list representation of multiple graph::graph objects}
\description{Class "compoundGraph" list+list representation of multiple graph::graph objects}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("compoundGraph", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{grList}:}{Object of class \code{"list"} list of graph::graph objects}
    \item{\code{between}:}{Object of class \code{"list"} list of node-to-node connections
across graphs }
  }
}
\section{Methods}{
  \describe{
    \item{adjMat}{\code{signature(cg = "compoundGraph")}: ... }
    \item{between}{\code{signature(object = "compoundGraph")}: ... }
    \item{grList}{\code{signature(object = "compoundGraph")}: ... }
    \item{toDot}{\code{signature(G = "compoundGraph", outDotFile = "character", renderList = "list", optList = "missing")}: ... }
    \item{toDot}{\code{signature(G = "compoundGraph", outDotFile = "character", renderList = "list", optList = "list")}: ... }
    \item{toDot}{\code{signature(G = "compoundGraph", outDotFile = "missing", renderList = "list", optList = "missing")}: ... }
  }
}
\references{ ~put references to the literature/web site here ~ }
\author{ VJ Carey <stvjc@channing.harvard.edu> }
\note{Should be supplanted by Rgraphviz facilities before too long.}
\seealso{
Rgraphviz::subgraph
}
\examples{
}
\keyword{classes}

\eof
\name{depthStruct}
\alias{depthStruct}
\alias{DMdepth}
\alias{ontoDepth}
\description{return a list of environments giving mapping from
node name to rooted DAG depth and from depth to vector of names of nodes
at that depth  }
\title{tools for manipulating depth concepts for rooted DAGs
}
\usage{
depthStruct(rg)
ontoDepth(rg)
DMdepth(g, maxd)
}
\arguments{
  \item{rg}{ rg: instance of class rootedDAG}
  \item{g}{ rg: instance of class depth}
  \item{maxd}{ maxd: bound on depth to be measured}
}
%\details{
%}
\value{depthStruct: a list of two environments (see examples).
}
%\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
\note{ontoDepth is the workhorse for depthStruct.
DMdepth is a function that works on a plain graph, creating
the 'daughter matrix' and computing depths.  }


%\seealso{  }

\examples{
data(litOnto)
print(litOnto)
g1 <- new("rootedDAG", DAG=litOnto, root="A")
o1 <- new("ontology", name="demo", version="0.1",
        rDAG=g1)
print(ds <- depthStruct(g1))
ds$tag2depth("A")
ds$tag2depth("H")
ds$depth2tag(2)
}
\keyword{ models }

\eof
\name{gomfAmat}
\alias{gomfAmat}
\alias{goMFgraphDemo}
\non_function{}
\title{ sparse matrix representing accessibilities
of terms in GO MF graph; graph also documented here  }
\description{ sparse matrix representing accessibilities
of terms in GO MF graph  }
\usage{data(gomfAmat); data(goMFgraphDemo)}
\format{
  The format is:
 list()
 - attr(*, "Dimnames")=List of 2
  ..$ : chr [1:5399] "GO:0000005" "GO:0000006" "GO:0000007" "GO:0000008" ...
  ..$ : chr [1:5399] "GO:0000005" "GO:0000006" "GO:0000007" "GO:0000008" ...
 - attr(*, "mat")= list()
  ..- attr(*, "ra")= num [1:33263] 0 1 1 1 1 1 1 1 1 1 ...
  ..- attr(*, "ja")= int [1:33263] 1 261 203 3073 1741 1744 2820 5367 2035 5356 ...
  ..- attr(*, "ia")= int [1:5400] 1 4 14 22 24 30 34 45 50 56 ...
  ..- attr(*, "dimension")= int [1:2] 5399 5399
  ..- attr(*, "class")= atomic [1:1] matrix.csr
  .. ..- attr(*, "package")= chr ".GlobalEnv"
 - attr(*, "rowindex")=List of 2
  ..$ n2i:length 0 <environment>
  ..$ i2n:length 0 <environment>
 - attr(*, "colindex")=List of 2
  ..$ n2i:length 0 <environment>
  ..$ i2n:length 0 <environment>
 - attr(*, "class")= atomic [1:1] namedSparse
  ..- attr(*, "package")= chr ".GlobalEnv"
}
\source{
built from bioconductor graph, GO and ontoTools package tools 
}
\keyword{datasets}

\eof
\name{litOnto}
\alias{litOnto}
\alias{litObj}
\non_function{}
\title{ litOnto: graph illustrating the ontology concept;
litObj: matrix illustrating the  object-ontology mapping }
\description{ litOnto: graph illustrating the ontology concept;
litObj: matrix illustrating the  object-ontology mapping }
\usage{data(litOnto)}
\format{
  The format is:
 list()
 - attr(*, "nodes")= chr [1:12] "A" "B" "C" "D" ...
 - attr(*, "edgeL")=List of 12
  ..$ A:List of 1
  .. ..$ edge: NULL
  ..$ B:List of 1
  .. ..$ edges: int 1
  ..$ C:List of 1
  .. ..$ edges: int 1
  ..$ D:List of 1
  .. ..$ edges: int 2
  ..$ E:List of 1
  .. ..$ edges: int 2
  ..$ F:List of 1
  .. ..$ edges: int 3
  ..$ G:List of 1
  .. ..$ edges: int 3
  ..$ H:List of 1
  .. ..$ edges: int [1:2] 4 5
  ..$ I:List of 1
  .. ..$ edges: int [1:3] 4 3 5
  ..$ J:List of 1
  .. ..$ edges: int 6
  ..$ K:List of 1
  .. ..$ edges: int 6
  ..$ L:List of 1
  .. ..$ edges: int 7
 - attr(*, "edgemode")= chr "directed"
 - attr(*, "class")= chr "graphNEL"
}
\source{
 
}
\references{
   
}
\keyword{datasets}

\eof
\name{namedSparse-class}
\docType{class}
\alias{namedSparse-class}
\alias{colSums}
\alias{rowSums}
\alias{nsparse}
\alias{Arith,namedSparse,namedSparse-method} 
\alias{[,namedSparse-method}
  \alias{\%*\%,namedSparse,namedSparse-method}
  \alias{+,namedSparse,namedSparse-method}
  \alias{as.matrix,namedSparse-method}
  \alias{colSums,namedSparse,missing,missing-method}
  \alias{colindex,namedSparse-method} 
   \alias{dimnames,namedSparse-method}
  \alias{dimnames<-,namedSparse,list-method} 
  \alias{mat,namedSparse-method}
  \alias{maxval,matrix.csr-method} 
  \alias{ncol,namedSparse-method}
  \alias{nrow,namedSparse-method}
  \alias{rowSums,namedSparse,missing,missing-method}
  \alias{rowindex,namedSparse-method} 
  \alias{show,namedSparse-method}
  \alias{t,namedSparse-method}
\alias{\%+\%}
\alias{AMN}
\alias{as.matrix.ok}
\alias{colSumsSp}
\alias{colindex}
\alias{exns}
\alias{makeNamedSparse}
\alias{makeSparseZero}
\alias{mapNamesInds}
\alias{mat}
\alias{maxval}
\alias{mkNS}
\alias{multiget}
\alias{rowSumsSp}
\alias{rowindex}
\alias{sumSp}
\alias{sumSpSLOW}
\title{Class "namedSparse" adds margin names to sparse matrices}
\description{  manages margin names for sparse matrices }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("namedSparse", ...)}.
These are S4 objects that include a SparseM::matrix.csr,
associated dimnames in the customary form, and two
lists of name-to-index mapping environments (for row and column name resolution,
with forward (name to index) and backward (index to name) mapping).
}
\section{Slots}{
  \describe{
    \item{\code{Dimnames}:}{Object of class \code{"list"} ordinary
dimnames matrix metadata }
    \item{\code{mat}:}{Object of class \code{"matrix.csr"} sparse matrix }
    \item{\code{rowindex}:}{Object of class \code{"list"} a list
of two environments, n2i for mapping names to numeric indices,
and i2n for mapping indices to names }
    \item{\code{colindex}:}{Object of class \code{"list"} see rowindex}
  }
}


\section{Methods}{
  \describe{
    \item{Arith}{\code{signature(e1 = "namedSparse", e2 = "namedSparse")}: ... }
    \item{show}{\code{signature(object = "namedSparse")}: ... }
  }
}

%Undocumented data sets:
%  A.csr
%Undocumented S4 classes:
%  mapStruct
%Undocumented S4 methods:

%\section{Methods}{
%  \describe{
%    \item{%*%}{namedSparse,namedSparse}: matrix multiplication 
%    \item{as.matrix}{\code{signature(x = "namedSparse")}: coerce to R matrix --
%will not coerce very large matrices 
%    \item{show}{\code{signature(object = "namedSparse")}: pretty print 
%    \item{+}{\code{signature(e1 = "namedSparse", e2 = "namedSparse")}: add 
%    \item{Arith}{\code{signature(e1 = "namedSparse", e2 = "namedSparse")}: arithmetic 
%    \item{[}{\code{signature(x = "namedSparse")}: standard subsetting 
%    \item{colSums}{\code{signature(x = "namedSparse", na.rm = "missing", dims = "missing")}: column sums 
%    \item{colindex}{\code{signature(x = "namedSparse")}: ... 
%    \item{dimnames}{\code{signature(x = "namedSparse")}: ...
%    \item{dimnames<-}{\code{signature(x = "namedSparse", value = "list")}: ... 
%    \item{mat}{\code{signature(x = "namedSparse")}: ... 
%    \item{ncol}{\code{signature(x = "namedSparse")}: ... 
%    \item{nrow}{\code{signature(x = "namedSparse")}: ... 
%    \item{rowSums}{\code{signature(x = "namedSparse", na.rm = "missing", dims = "missing")}: ... 
%    \item{rowindex}{\code{signature(x = "namedSparse")}: ... 
%  }
%}

%\references{ ~put references to the literature/web site here ~ }
\author{ VJ Carey <stvjc@channing.harvard.edu>}
\note{ A constructor makeNamedSparse is illustrated in the
example.}
%
% ~Make other sections like Warning with \section{Warning }{....} ~
%
%\seealso{
%  ~~objects to See Also as \code{\link{~~fun~~}}, ~~~
%  or \code{\link{CLASSNAME-class}} for links to other classes
%}
\examples{
data(A.csr)
namedA <- mkNS(A.csr) # installs default dimnames letters,LETTERS
print(namedA)
print(colSums(namedA))
print(colindex(namedA))
dimnames(namedA) <- list(paste("A",1:10,sep=""),paste("B",1:5,sep=""))
print(namedA)
print(namedA \%*\% t(namedA))
}
\keyword{classes}

\eof
\name{ontology-class}
\docType{class}
\alias{ontology-class}
\alias{ontology}
\alias{name}
\alias{OVersion}
\alias{name,ontology-method}
\alias{OVersion,ontology-method}
\alias{show,ontology-method}
\alias{makeOntology}
\S4method{rDAG,ontology-method}
\alias{rDAG,ontology-method}
\alias{accessMat,ontology-method}
\alias{rDAG}
\title{Class "ontology" wraps a rooted DAG with some
ontology metadata }
\description{  instances of class ontology are used to
represent things like Gene Ontology }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("ontology", ...)}.
This simply possesses information on name and version of ontology.
}
\section{Slots}{
  \describe{
    \item{\code{name}:}{Object of class \code{"character"} name of ontology }
    \item{\code{version}:}{Object of class \code{"character"} version tag }
    \item{\code{rDAG}:}{Object of class \code{"rootedDAG"} the rooted
DAG representing the terminlogy hierarchy }
  }
}
\section{Methods}{
  \describe{
    \item{accessMat}{\code{signature(object = "ontology")}: returns
square matrix with 1 in element r,c if term corresponding
to r can be reached from term corresponding to c}
    \item{name}{\code{signature(x = "ontology")}: access name }
    \item{OVersion}{\code{signature(x = "ontology")}:  access version}
    \item{rDAG}{\code{signature(x = "ontology")}: access the rooted DAG }
    \item{show}{\code{signature(object = "ontology")}: concise report }
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{ ~~who you are~~ }
\note{ This class was written to deal with ontologies
that are representable as rooted DAGs.  It is not clear
that this is a good use of the term 'ontology', which
has broader implications.  However this does work for
Gene Ontology.
}

% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%  ~~objects to See Also as \code{\link{~~fun~~}}, ~~~
%  or \code{\link{CLASSNAME-class}} for links to other classes
%}
\examples{
data(litOnto)
print(litOnto)
g1 <- new("rootedDAG", DAG=litOnto, root="A")
o1 <- new("ontology", name="demo", version="0.1",
        rDAG=g1)
# can also use
o1b <- makeOntology( name="demo", version="0.1", 
   graph=litOnto, root="A")
show(o1)
print(accessMat(o1))
print(OVersion(o1))
}
\keyword{classes}

\eof
\name{ooMapLL2GOMFdemo}
\alias{ooMapLL2GOMFdemo}
\non_function{}
\title{ object-term mapping for human locuslink entries and GO MF  }
\description{ object-term mapping for human locuslink entries and GO MF  }
\usage{data(ooMapLL2GOMFdemo)}
\format{
  The format is:
 list()
 - attr(*, "Dimnames")=List of 2
  ..$ : chr [1:10776] "1" "10" "100" "1000" ...
  ..$ : chr [1:5399] "GO:0000005" "GO:0000006" "GO:0000007" "GO:0000008" ...
 - attr(*, "mat")= list()
  ..- attr(*, "ra")= num [1:19679] 0 1 1 1 1 1 1 1 1 1 ...
  ..- attr(*, "ja")= int [1:19679] 1 1842 541 3528 3753 485 3799 1594 1804 1098 ...
  ..- attr(*, "ia")= int [1:10777] 1 3 6 8 10 13 14 17 23 28 ...
  ..- attr(*, "dimension")= int [1:2] 10776 5399
  ..- attr(*, "class")= chr "matrix.csr"
 - attr(*, "rowindex")=List of 2
  ..$ n2i:length 0 <environment>
  ..$ i2n:length 0 <environment>
 - attr(*, "colindex")=List of 2
  ..$ n2i:length 0 <environment>
  ..$ i2n:length 0 <environment>
 - attr(*, "class")= chr "namedSparse"
}
\source{
bioconductor GO, humanLLMapping and ontoTools otkv tools.
}
\references{
   
}
\keyword{datasets}

\eof
\name{otkvEnv2namedSparse}
\alias{otkvEnv2namedSparse}
\alias{otkvList2namedSparse}
\title{  
obtain sparse matrix representation of key-value structures
}
\description{
obtain sparse matrix representation of key-value structures
}
\usage{
otkvEnv2namedSparse(obs, tms, otkvEnv)
otkvList2namedSparse(obs, tms, otkvlist)
}
\arguments{
  \item{obs}{ obs: vector of object tags}
  \item{tms}{ tms: vector of terms to which objects are mapped}
  \item{otkvEnv}{ otkvEnv: environment encoding the key-value mapping}
  \item{otkvlist}{ otkvlist: list encoding the key-value mapping}
}
%\details{
%}
%\value{
%}
%\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
%\note{  }


%\seealso{  }

\examples{
otkvList2namedSparse(c("A","B","D","E"), letters[1:7], 
   list("A"=c("a","b"), "B"=c("b","d"),"E"="c"))
}
\keyword{ models }

\eof
\name{rootedDAG-class}
\docType{class}
\alias{rootedDAG-class}
\alias{DAG}
\alias{root}
\alias{getMatrix,rootedDAG,character,character-method}
\alias{DAG,rootedDAG-method}
\alias{root,rootedDAG-method}
\title{Class "rootedDAG" }
\description{wraps a graph that can be 
shown to be a DAG and has a root (one node with no ancestor) }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("rootedDAG", ...)}.
Does not extend graph but probably should.
}
\section{Slots}{
  \describe{
    \item{\code{root}:}{Object of class \code{"character"} name of root }
    \item{\code{DAG}:}{Object of class \code{"graph"} DAG }
  }
}
\section{Methods}{
  \describe{
    \item{DAG}{\code{signature(x = "rootedDAG")}: extract the graph }
    \item{getMatrix}{\code{signature(g = "rootedDAG", type = "character", mode = "character")}: Currently only 'child2parent' can be used
for type, meaning that row corresponds to child,
column corresponds to ancestor and mat[row,column] is 1
if node corresponding to row is a child of node corresponding to ancestor. 
Type can be 'sparse' (return sparse representation)
or 'dense'.}
    \item{root}{\code{signature(x = "rootedDAG")}: extract name of root }
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{ VJ Carey <stvjc@channing.harvard.edu> }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%  ~~objects to See Also as \code{\link{~~fun~~}}, ~~~
%  or \code{\link{CLASSNAME-class}} for links to other classes
%}
\examples{
}
\keyword{classes}

\eof
\name{semsim}
\alias{semsim}
\alias{pms}
\alias{subsumers}
\alias{conceptProbs}
\alias{usageCount}
\title{Compute semantic similarity measure for terms in
an object-ontology complex  }
\description{Compute semantic similarity measure for terms in
an object-ontology complex
}
\usage{
semsim(c1, c2, ooc, acc=NULL, pc=NULL)
conceptProbs(ooc,acc=NULL,inds=NULL) 
subsumers(c1, c2, ont, acc=NULL) 
pms(c1, c2, ooc, acc=NULL, pc=NULL) 
usageCount(map,acc,inds)
}
\arguments{
  \item{c1}{ c1, c2: "character" terms to be compared}
  \item{c2}{ c1, c2: "character" terms to be compared}
  \item{ooc}{ ooc: an object of class "OOC": object-ontology
complex}
  \item{ont}{ ont: an object of class "ontology": annotated rooted DAG}
  \item{acc}{ acc: optional (sparse) accessibility matrix for
the ontology}
  \item{pc}{ pc: optional vector of concept probabilities, if
pre-computed}
  \item{map}{ map: OOmap component of an ooc}
  \item{inds}{ inds: vector of numeric indices, row indices of
object-ontology map to be processed}
}
\details{
For large ontologies, computation of the term accessibility
relationships and term probabilities can be costly.
Once these are computed to support one semsim calculation,
they should be saved.  The acc and pc parameters allow use
of this saved information.
}
\value{
semsim returns the measure of semantic similarity cited by Lord et al (2003).
}
\references{PW Lord et al, Bioinformatics, 19(10)2003:1275  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
%\note{  }


%\seealso{  }

\examples{
#
# we are given a graph of GOMF and the OOmap between LL and GOMF
# derived from humanLLMappings and stored as data resources in
# ontoTools -- these will have to be updated regularly
#
data(goMFgraphDemo)
data(ooMapLL2GOMFdemo)
#
# build the rooted DAG, the ontology, and the OOC objects
#
gomfrDAG <- new("rootedDAG", root="GO:0003674", DAG=goMFgraphDemo)
GOMFonto <- new("ontology", name="GOMF", version="bioc 1.3.1", rDAG=gomfrDAG)
LLGOMFOOC <- makeOOC(GOMFonto, ooMapLL2GOMFdemo)
#
# we are given the accessibility matrix for the GO MF graph as a 
# data resource, and we can compute some term probabilities
#
data(gomfAmat)
pc <- conceptProbs(LLGOMFOOC, gomfAmat, inds=1:20)
#
# now we will get a sample of GO MF terms and compute the
# semantic similarities of pairs of terms in the sample
#
data(LLGOMFcp) # full set of precomputed concept probabilities
library(GO)
library(Biobase)
library(combinat)
GO() # get the GO environments
GOMFtags <- ls(env=GOMFID2TERM)
GOMFterms <- unlist(multiget(GOMFtags,env=GOMFID2TERM))
ntags <- length(GOMFtags)
if (any(duplicated(GOMFterms)))
 {
 dups <- (1:ntags)[duplicated(GOMFterms)]
 GOMFterms[dups] <- paste(GOMFterms[dups],".2",sep="")
 }
names(GOMFterms) <- GOMFtags
set.seed(1234)
st <- sample(names(GOMFterms),size=10) # take the sample
pst <- combn(st,2)   # get a matrix with the pairs of terms in columns
npst <- ncol(pst)
ss <- rep(NA,npst)
for (i in 1:npst)  # compute semantic similarities
  {
  cat(i)
  ss[i] <- semsim( pst[1,i], pst[2,i], ooc=LLGOMFOOC, acc=gomfAmat, pc=LLGOMFcp )
  }
print(summary(ss))
top <- (1:npst)[ss==max(ss)][1]  # index of the most similar pair
print( GOMFterms[ as.character(pst[,top]) ] )
pen <- (1:npst)[ss==max(ss[-top])][1] # second most similar
print( GOMFterms[ as.character(pst[,pen]) ] )
}
\keyword{ models }

\eof
\name{toDot-methods}
\docType{methods}
\alias{between}
\alias{toDot}
\alias{grList}
\alias{toDot-methods}
\alias{toDot,graphNEL,character,list,list-method}
\alias{toDot,graphNEL,character,missing,missing-method}
\alias{toDot,graphNEL,character,missing,list-method}
\alias{toDot,graphNEL,missing,missing,missing-method}
\alias{toDot,graphNEL,missing,missing,list-method}
\alias{toDot,graphNEL,missing,character,missing-method}
\alias{toDot,graphNEL,missing,list,list-method}
\alias{toDot,graphNEL,missing,list,missing-method}
\alias{toDot,compoundGraph,character,list,missing-method}
\alias{toDot,compoundGraph,character,list,list-method}
\alias{toDot,compoundGraph,missing,list,missing-method}
\S4method{toDot,graphNEL,character,list,list-method}
\S4method{toDot,graphNEL,character,missing,missing-method}
\S4method{toDot,graphNEL,character,missing,list-method}
\S4method{toDot,graphNEL,missing,missing,missing-method}
\S4method{toDot,graphNEL,missing,missing,list-method}
\S4method{toDot,graphNEL,missing,character,missing-method}
\S4method{toDot,graphNEL,missing,list,list-method}
\S4method{toDot,graphNEL,missing,list,missing-method}
\S4method{toDot,compoundGraph,character,list,missing-method}
\S4method{toDot,compoundGraph,character,list,list-method}
\S4method{toDot,compoundGraph,missing,list,missing-method}
\title{ Methods for Function toDot in Package `ontoTools' -- should be replaced
by Rgraphviz facilities soon}
\description{These methods write graphviz dot language for
various graph structures encountered with ontologies.  This
activity should be moved to Rgraphviz ASAP, but there are
aspects of representation and portability that need to be
resolved.}
\section{Methods}{\describe{

\item{G = "graphNEL", outDotFile = "character", renderList = "list", optList = "list"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "character", renderList = "missing", optList = "missing"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "character", renderList = "missing", optList = "list"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "missing", renderList = "missing", optList = "missing"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "missing", renderList = "missing", optList = "list"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "missing", renderList = "character", optList = "missing"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "missing", renderList = "list", optList = "list"}{ create dot language descriptionof graph }

\item{G = "graphNEL", outDotFile = "missing", renderList = "list", optList = "missing"}{ create dot language descriptionof graph }

\item{G = "compoundGraph", outDotFile = "character", renderList = "list", optList = "missing"}{ create dot language descriptionof graph }

\item{G = "compoundGraph", outDotFile = "character", renderList = "list", optList = "list"}{ create dot language descriptionof graph }

\item{G = "compoundGraph", outDotFile = "missing", renderList = "list", optList = "missing"}{ create dot language descriptionof graph }
}}
\keyword{methods}

\eof
