### Name: namedSparse-class
### Title: Class "namedSparse" adds margin names to sparse matrices
### Aliases: namedSparse-class colSums rowSums nsparse
###   Arith,namedSparse,namedSparse-method [,namedSparse-method
###   \%*\%,namedSparse,namedSparse-method +,namedSparse,namedSparse-method
###   as.matrix,namedSparse-method
###   colSums,namedSparse,missing,missing-method
###   colindex,namedSparse-method dimnames,namedSparse-method
###   dimnames<-,namedSparse,list-method mat,namedSparse-method
###   maxval,matrix.csr-method ncol,namedSparse-method
###   nrow,namedSparse-method rowSums,namedSparse,missing,missing-method
###   rowindex,namedSparse-method show,namedSparse-method
###   t,namedSparse-method \%+\% AMN as.matrix.ok colSumsSp colindex exns
###   makeNamedSparse makeSparseZero mapNamesInds mat maxval mkNS multiget
###   rowSumsSp rowindex sumSp sumSpSLOW
### Keywords: classes

### ** Examples

data(A.csr)
namedA <- mkNS(A.csr) # installs default dimnames letters,LETTERS
print(namedA)
print(colSums(namedA))
print(colindex(namedA))
dimnames(namedA) <- list(paste("A",1:10,sep=""),paste("B",1:5,sep=""))
print(namedA)
print(namedA %*% t(namedA))



