### Name: OOC-class
### Title: Class "OOC" object-ontology complex
### Aliases: OOC-class OOmap makeOOC OOmap,OOC-method show,OOC-method
###   ontology,OOC-method coverageMat,OOC-method
### Keywords: classes

### ** Examples

data(litOnto)
g1 <- new("rootedDAG", DAG=litOnto, root="A")
o1 <- new("ontology", name="demo", version="0.1",
        rDAG=g1)
kvlist <- list(W="E", X="K", Y="B", Z=c("D","G"))
litMap <- otkvList2namedSparse( names(kvlist), LETTERS[1:12], kvlist )
print(litMap)
ooc1 <- makeOOC( o1, litMap )
show(ooc1)
print(coverageMat(ooc1))
# note the following will be slow with large OOCs
print(conceptProbs(ooc1))
# for larger OOCs it is useful to precompute the accessibility
# matrix of the ontology and the map from objects to terms -- these
# can be supplied as additional arguments to conceptProbs



