\name{maBoxplot}
\alias{maBoxplot}
\alias{boxplot,marrayRaw-method}
\alias{boxplot,marrayNorm-method}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Boxplots for cDNA microarray spot statistics}
\description{
The function \code{maBoxplot} produces boxplots of microarray spot statistics for the classes  \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, and  \code{"\link{marrayTwo}"}.
}

\usage{
maBoxplot(m, x="maPrintTip", y="maM", ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{m}{Microarray object of class \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, or  \code{"\link{marrayTwo}"}.}
  \item{x}{Name of accessor method for the spot statistic used to stratify the data, typically a slot name for the microarray layout object (see \code{"\link{marrayLayout}"}) such as \code{maPlate} or a method such as \code{maPrintTip}. If \code{x} is NULL, the data are not stratified.}
  \item{y}{Name of accessor method for the spot statistic of interest, typically a slot name for the microarray object \code{m}, such as \code{maM}.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\details{
If there are more than one array in the batch, the function produces a boxplot for each array in the batch. Such plots are useful when assessing the need for between array normalization, for example, to deal with scale differences among different arrays. Default graphical parameters are chosen for convenience using the function \code{\link{maDefaultPar}} (e.g. color palette,  axis labels,  plot title) but the user has the option to overwrite these parameters at any point.
}

\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{boxplot}}, \code{\link{maDefaultPar}}.}

\examples{

# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Boxplots of pre-normalization log-ratios M for each of the 16 
# print-tip-groups for the Swirl 93 array. 
# - Default arguments
maBoxplot(swirl[,3])  

# All spots 
maBoxplot(swirl[,3], x=NULL, col="green")  

# Boxplots of pre-normalization red foreground intensities for each grid row
# for the Swirl 81 array. 
maBoxplot(swirl[,1], x="maGridRow", y = "maRf", main = "Swirl array 81: pre-normalization red foreground intensity")

# Boxplots of pre-normalization log-ratios for each array in swirl
maBoxplot(swirl, main="Swirl arrays: pre-normalization log-ratios")

# Boxplots for marrayTwo class
two<-new("marrayTwo", maX=maA(swirl), maY=maM(swirl), maLayout=maLayout(swirl), maTargets=maTargets(swirl))
maBoxplot(two, y="maX", col="purple")


}
\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{maColorBar}
\alias{maColorBar}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Calibration bar for color images}
\description{
This function produces a color image (color bar) which can be used for
the legend to another color image obtained from the functions
\code{\link{image}}, \code{\link{maImage}}, or
\code{\link{maImage.func}}.} 
} 
\usage{
maColorBar(x, horizontal=TRUE, col=heat.colors(50), scale=1:length(x), k=10, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{If "numeric", a vector containing the "z" values in the
    color image, i.e., the values which are represented in the color
    image. Otherwise, a "character" vector representing colors.}
  \item{horizontal}{If \code{TRUE}, the values of \code{x} are
    represented as vertical color strips in the image, else, the values
    are represented as horizontal color strips.} 
  \item{col}{Vector of colors such as that generated by
    \code{\link{rainbow}}, \code{\link{heat.colors}},
    \code{\link{topo.colors}}, \code{\link{terrain.colors}}, or similar
    functions. In addition to these color palette functions, a new
    function  \code{\link{maPalette}} was defined to generate color
    palettes from user supplied low, middle, and high color values.} 
  \item{scale}{A "numeric" vector specifying the "z" values in the color
    image. This is used when the argument \code{x} is a
    "character" vector representing color information.}
\item{k}{Object of class "numeric", for the number of labels displayed on 
    the bar.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}, Yee Hwa (Jean) Yang.}

\seealso{\code{\link{image}}, \code{\link{maImage}}, \code{\link{maImage.func}}, \code{\link{maPalette}}.}

\examples{

par(mfrow=c(3,1))
Rcol <- maPalette(low="white", high="red", k=10)
Gcol <- maPalette(low="white", high="green", k=50)
RGcol <- maPalette(low="green", high="red", k=100)
maColorBar(Rcol)
maColorBar(Gcol, scale=c(-5,5))
maColorBar(1:50, col=RGcol)

par(mfrow=c(1,3))
x<-seq(-1, 1, by=0.01)
maColorBar(x, col=Gcol, horizontal=FALSE, k=11)
maColorBar(x, col=Gcol, horizontal=FALSE, k=21)
maColorBar(x, col=Gcol, horizontal=FALSE, k=51)

}

\keyword{aplot}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line

\eof
\name{maDefaultPar}
\alias{maDefaultPar}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Default graphical parameters for microarray objects}
\description{
This function returns default graphical parameters for microarray objects. The parameters may be passed as arguments to the functions \code{\link{maBoxplot}} and \code{\link{maPlot}}.
}

\usage{
maDefaultPar(m, x, y, z)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{m}{Microarray object of class \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, or \code{"\link{marrayTwo}"}.}
  \item{x}{Name of accessor method for the abscissa spot statistic, typically a slot name for the microarray object \code{m}, such as \code{maA}.}
  \item{y}{Name of accessor method for the ordinate spot statistic, typically a slot name for the microarray object \code{m}, such as \code{maM}.}
  \item{z}{Name of accessor method for the spot statistic used to stratify the data, typically a slot name for the microarray layout object (see \code{"\link{marrayLayout}"}) such as \code{maPlate} or a method such as \code{maPrintTip}.}

}

\value{
A list with elements
  \item{def.box}{default graphical parameters for \code{\link{maBoxplot}}.}
  \item{def.plot}{default graphical parameters for \code{\link{maPlot}}.}
  \item{def.lines}{default graphical parameters for functions such as \code{\link{maLoessLines}} used in \code{\link{maPlot}}.}  
  \item{def.legend}{default graphical parameters for functions such as \code{\link{maLegendLines}} used in \code{\link{maPlot}}.}   
  \item{def.text}{default graphical parameters for functions such as \code{\link{maText}} used in \code{\link{maPlot}}.} 

}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{maBoxplot}}, \code{\link{maPlot}}, \code{\link{maLegendLines}}, \code{\link{maLoessLines}}, \code{\link{maText}}, \code{\link{maDotsDefaults}}.}

\examples{
# See examples for maPlot.

}
\keyword{iplot}% at least one, from doc/KEYWORDS
\keyword{dplot}% __ONLY ONE__ keyword per line
\keyword{color}% __ONLY ONE__ keyword per line

\eof
\name{maDiagnPlots}
\alias{maDiagnPlots}

\title{Basic diagnostic plots}
\description{
  These three functions produce sets of basic diagnostic plots for pre-
  and post-normalization cDNA microarray data. 
}
\usage{
maDiagnPlots(mraw, mNorm = NULL, save = TRUE, fname = NULL,
dev= c("jpeg", "postscript"), pch, col, DEBUG = FALSE, ...)
}

\arguments{
  \item{mraw}{Microarray object of class `"marrayRaw"'.
    By default, plots are done for the first array in the batch.}
  \item{mNorm}{Microarray object of class `"marrayNorm"'. By default,
    this value is NULL and the function maNorm is call to perform normalization.}
  \item{save}{If `TRUE', the figures will be saved to the file named in
          `fname'.}
  \item{fname}{A "character" string naming the output file.}
  \item{dev}{A "character" string naming the graphics device, "postscript"
          or "jpeg".}
  \item{pch}{point style for different control samples.}
  \item{col}{color code for different control samples.}
  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  \item{\dots}{Optional graphical parameters, see `par'.}
}
\details{
  \code{maDiagnPlots} produces plots of pre- and  post-normalization cDNA
  microarray data: color images of log-ratios (M) and log-intensities
  (A) pre- and post-normalization. MA-plots of pre- and post-normalization
  log-ratios M. Log foreground to background ratios for both Cy5 and Cy3
  channels. Dot plots for replicate control spots. 
}


\author{Yee Hwa (Jean) Yang}

\note{This function may not work properly when "save=FALSE".}

\seealso{\code{\link{maPlot}}, \code{\link{maImage}}, \code{\link{maBoxplot}}}


\examples{
data(swirl)
## maDiagnPlots(swirl, dev="postscript", save=TRUE)
}

\keyword{hplot}


\eof
\name{maDiagnPlots1}
\alias{maDiagnPlots1}
\alias{maRawPlots}
\alias{maNormPlots}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Basic diagnostic plots}
\description{
  These three functions produce sets of basic diagnostic plots for pre-- and post--normalization cDNA microarray data.
}
\usage{
maDiagnPlots1(mraw, title=NULL, save=TRUE,
	fname=paste(as.character(maLabels(maTargets(mraw))[1]), ".ps", sep = ""), 
	dev=c("postscript", "jpeg"))

maRawPlots(mraw, title=NULL, save = TRUE, 
	fname = paste(as.character(maLabels(maTargets(mraw))[1]), ".ps", sep = ""), 
	dev = c("postscript", "jpeg"))


maNormPlots(mnorm, title=NULL, save = TRUE, 
	fname = paste(as.character(maLabels(maTargets(mnorm))[1]),".ps", sep = ""), 
	dev = c("postscript", "jpeg"))

}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{mraw}{Microarray object of class \code{"\link{marrayRaw}"}, for \code{maDiagnPlots1} \code{maRawPlots}. By default, plots are done for the first array in the batch.}
 \item{mnorm}{Microarray object of class \code{"\link{marrayNorm}"}, for \code{maNormPlots}. By default, plots are done for the first array in the batch.}
 \item{title}{A "character" string for the plot title. If \code{NULL} a default title is shown.}
  \item{save}{If \code{TRUE}, the figures will be saved to the file named in \code{fname}.}
  \item{fname}{A "character" string naming the output file.}
  \item{dev}{A "character" string naming the graphics device, "postscript" or "jpeg".}
}
\details{
\code{maDiagnPlots1} produces eight plots of pre-- and post--normalization cDNA microarray data: color images of Cy3 and Cy5 background intensities, and of pre-- and post--normalization log--ratios M; boxplots of pre-- and post--normalization log--ratios M by print--tip--group; MA--plots of pre-- and post--normalization log--ratios M by print--tip--group.\cr \cr

\code{maRawPlots} produces six plots of pre--normalization cDNA microarray data: color images of Cy3 and Cy5 background intensities and log--ratios M; boxplots of log--ratios M by print--tip--group and plate; MA--plot of log--ratios M by print--tip--group.\cr \cr

\code{maNormPlots} produces four plots of post--normalization cDNA microarray data: color images of location normalization values Mloc and normalized log--ratios M; boxplots of normalized log--ratios M by print--tip--group; MA--plot of normalized log--ratios M by print--tip--group.
}

\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}, Yee Hwa (Jean) Yang.}

\note{This function maynot work properly when "save=FALSE".}

\seealso{\code{\link{maPlot}}, \code{\link{maBoxplot}}, \code{\link{maImage}}.}

\examples{
library(marrayNorm)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

maPlate(swirl)<-maCompPlate(swirl,384)

# Pre-normalization
maRawPlots(swirl[,3])

# Post-normalization
mnorm<-maNorm(swirl[,3], norm="twoD")
maNormPlots(mnorm, title="Swirl array 93 -- 2D normalization")

}
\keyword{hplot}

\eof
\name{maDotPlots}
\alias{maDotPlots}

\title{Produce a dot plot for replicated controls genes}
\description{
  A dot plot showing the values of replicated control genes
}
\usage{
maDotPlots(data, x = list("maA"), id = "ID", pch, col, nrep = 3, ...)
}

\arguments{
  \item{data}{Microarray object of class `"marrayRaw"'. By default, plots
    are done for the first array in the batch.}
  \item{x}{Name of accessor method for the spot statistic to be display.
    E.g. maM to display log-ratios and maA to display log-intensities}
  \item{id}{Integer value specifying the index of the array.}
  \item{pch}{point style for different control samples.}
  \item{col}{color code for different control samples.}
  \item{nrep}{Integer value indicating the minimum number of replicated
    spots required.}
  \item{\dots}{Optional graphical parameters, see `par'.}
}

\value{
  Produce a dot plot showing the values of replicated control genes.
}

\examples{
  data(swirl)
  maControls(swirl) <- maGenControls(maGnames(swirl), id="Name")
  maDotPlots(swirl[,1])
}

\author{Yee Hwa (Jean) Yang}

\keyword{hplot}

\eof
\name{maDotsDefaults}
\alias{maDotsDefaults}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Replace graphical default parameters by user supplied parameters}

\description{
This function may be used to compare default graphical parameters for microarray diagnostic plots to user supplied parameters given in \code{...}. User supplied parameters overwrite the defaults. It is used in \code{\link{maBoxplot}}, \code{\link{maPlot}}, and \code{\link{maImage}}.}


\usage{
maDotsDefaults(dots, defaults)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{dots}{List of user supplied parameters, e.g. from \code{list(...)}.}
  \item{defaults}{List of default parameters, e.g. from the function \code{\link{maDefaultPar}}.}
}

\value{
  \item{args}{List of graphical parameters.}
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{maDefaultPar}}, \code{\link{maBoxplot}}, \code{\link{maPlot}}, \code{\link{maImage}}.}

\examples{
dots<-list(xlab="X1", ylab="Y1")
defaults<-list(xlab="X1", ylab="Y2", col=2)
pars<-maDotsDefaults(dots, defaults)

do.call("plot",c(list(x=1:10), pars))

}
\keyword{misc}% at least one, from doc/KEYWORDS


\eof
\name{maImage}
\alias{maImage}
\alias{image,marrayRaw-method}
\alias{image,marrayNorm-method}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Color image for cDNA microarray spot statistics}
\description{
The function \code{maImage} creates spatial images of shades of gray or colors that correspond to the values of a statistic for each spot on the array. The statistic can be the intensity log-ratio M, a spot quality measure (e.g. spot size or shape), or a test statistic. This function can be used to explore whether there are any spatial effects in the data, for example, print-tip or cover-slip effects. 
}
\usage{
maImage(m, x="maM", subset=TRUE, col, contours=FALSE, bar=TRUE, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{m}{Microarray object of class \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, or \code{"\link{marrayTwo}"}.}
  \item{x}{Name of accessor function for the spot statistic of interest, typically a slot name for the microarray object \code{m}, such as \code{maM}.}
  \item{subset}{A "logical" or "numeric" vector indicating the subset of spots to display on the image.}
  \item{col}{List of colors such as that generated by \code{\link{rainbow}}, \code{\link{heat.colors}}, \code{\link{topo.colors}}, \code{\link{terrain.colors}}, or similar functions. In addition to these color palette functions, a new function \code{\link{maPalette}} was defined to generate color palettes from user supplied low, middle, and high color values. }
  \item{contours}{If \code{contours=TRUE}, contours are plotted, otherwise they are not shown.}
  \item{bar}{If \code{bar=TRUE}, a calibration color bar is shown to the right of the image.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}
\details{
 This function calls the general function \code{\link{maImage.func}}, which is not specific to microarray data. If there are more than one array in the batch, the plot is done for the first array, by default. Default color palettes were set for different types of spot statistics using the \code{\link{maPalette}} function. When \code{x=c("maM", "maMloc", "maMscale")}, a green-to-red color palette is used. When \code{x=c("maGb", "maGf", "maLG")}, a white-to-green color palette is used. When \code{x=c("maRb", "maRf", "maLR")}, a white-to-red color palette is used. The user has the option to overwrite these parameters at any point. 
}

\value{
 A list with elements 
  \item{x.col}{vector of colors to be used for calibration color bar.}
  \item{x.bar}{vector of values to be used for calibration color bar.}
  \item{summary}{six number summary of the spot statistics, from the function \code{\link{summary}}.}

}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{image}}, \code{\link{maImage.func}}, \code{\link{maColorBar}}, \code{\link{maPalette}}, \code{\link{summary}}.}

\examples{

# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Microarray color palettes
Gcol <- maPalette(low = "white", high = "green", k = 50)
Rcol <- maPalette(low = "white", high = "red", k = 50)
RGcol <- maPalette(low = "green", high = "red", k = 50)

# Color images of green and red background and foreground intensities
maImage(swirl[, 3], x="maGb")
maImage(swirl[, 3], x = "maGf", subset = TRUE, col = Gcol, contours = FALSE, bar = TRUE, main="Swirl array 93")
maImage(swirl[, 3], x = "maRb", contour=TRUE)
maImage(swirl[, 3], x = "maRf", bar=FALSE)

# Color images of pre-normalization intensity log-ratios
maImage(swirl[, 1])
maImage(swirl[, 3], x = "maM", subset = maTop(maM(swirl[, 3]), h = 0.1, l = 0.1), col = RGcol, contours = FALSE, bar = TRUE, main = "Swirl array 93: image of pre-normalization M for \% 10 tails")

# Color image of print-tip-group
maImage(swirl[, 1],x="maPrintTip")

}
\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{maImage.func}
\alias{maImage.func}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Color image for cDNA microarray spot statistics}
\description{
This function creates spatial images of shades of gray or colors that correspond to the values of a statistic for each spot on the array. The statistic can be the intensity log-ratio M, a spot quality measure (e.g. spot size or shape), or a test statistic. This function can be used to explore whether there are any spatial effects in the data, for example, print-tip or cover-slip effects. This function is called by \code{\link{maImage}}.
}

\usage{
maImage.func(x, L, subset=TRUE, col=heat.colors(12), contours=FALSE, ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{A "numeric" vector of spot statistics.}
  \item{L}{An object of class \code{"\link{marrayLayout}"}.}
  \item{subset}{A "logical" or "numeric" vector indicating the subset of spots to display on the image.}
  \item{col}{A list of colors such as that generated by \code{\link{rainbow}}, \code{\link{heat.colors}}, \code{\link{topo.colors}}, \code{\link{terrain.colors}}, or similar functions. In addition to these color palette functions, a new function  \code{\link{maPalette}} was defined to generate color palettes from user supplied low, middle, and high color values.}
  \item{contours}{If \code{contours=TRUE}, contours are plotted, otherwise they are not shown.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{image}}, \code{\link{maImage}}, \code{\link{maColorBar}}, \code{\link{maPalette}}.}

\examples{
# See examples for maImage.
}
\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{maLegendLines}
\alias{maLegendLines}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Add a legend to a plot}
\description{
This function may be used to add a legend for lines in plots such as those produced by \code{\link{plot}}, \code{\link{maPlot}}, or \code{\link{maPlot.func}}.
}

\usage{
maLegendLines(legend="", col=2, lty=1, lwd=2.5, ncol=1, ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{legend}{A vector of "character" strings to appear in the legend.}
  \item{col}{Line colors for the legend.}
  \item{lty}{Line types for the legend.}
  \item{lwd}{Line widths for the legend.}
  \item{ncol}{The number of columns in which to set the legend items (default is 1, a vertical legend).}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}


\value{
A function with bindings for \code{legend}, \code{col}, \code{lty}, \code{lwd}, \code{ncol}, and \code{\ldots}. This latter function takes as arguments \code{x} and \code{y}, the coordinates for the location of the legend on the plot, and it adds the legend to the current plot.
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{legend}}, \code{\link{maPlot}}, \code{\link{maPlot.func}}.}

\examples{
# See examples for maPlot.

}
\keyword{aplot}% at least one, from doc/KEYWORDS


\eof
\name{maLoessLines}
\alias{maLoessLines}
\alias{maLowessLines}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Add smoothed fits to a plot}
\description{
This function may be used to compute and plot loess or lowess fits for an existing plot. The plot can be produced by \code{\link{plot}}, \code{\link{maPlot}}, or \code{\link{maPlot.func}}.
}

\usage{
maLoessLines(subset=TRUE, weights=NULL, loess.args=list(span = 0.4, na.action = na.omit), col=2, lty=1, lwd=2.5, ...)

maLowessLines(subset = TRUE, f = 0.3, col = 2, lty = 1, lwd = 2.5, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{subset}{A "logical" or "numeric" vector indicating the subset of points used to compute the fits. }
  \item{weights}{Optional "numeric" vector of weights -- for \code{maLoessLines} only.} 
  \item{loess.args}{List of optional arguments for the \code{\link{loess}} functions -- for \code{maLoessLines} only.}
  \item{f}{The smoother span for the \code{\link{lowess}} function -- for \code{maLowessLines} only.}
  \item{col}{The fitted line colors.}
  \item{lty}{The fitted line types.}
  \item{lwd}{The fitted line widths.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\value{
A function with bindings for \code{subset}, \code{weights}, \code{loess.args},  \code{col}, \code{lty}, \code{lwd}, and \code{\ldots}. This latter function takes as arguments \code{x} and \code{y}, the abscissa and ordinates of points on the plot, and \code{z} a vector of discrete values used to stratify the points. Loess (or lowess) fits are performed separately within values of \code{z}.
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{loess}}, \code{\link{lowess}}, \code{\link{maPlot}}, \code{\link{maPlot.func}}.}

\examples{
# See examples for maPlot.

}

\keyword{aplot}% at least one, from doc/KEYWORDS
\keyword{smooth}% __ONLY ONE__ keyword per line

\eof
\name{maPalette}
\alias{maPalette}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Microarray color palette}
\description{
This function returns a vector of color names corresponding to a range of colors specified in the arguments.  
}
\usage{
maPalette(low = "white", high = c("green", "red"), mid=NULL, k =50)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{low}{Color for the lower end of the color palette, specified using any of the three kinds of R colors, i.e., either a color name (an element of \code{\link{colors}}), a hexadecimal string of the form \code{"#rrggbb"}, or an integer \code{i} meaning \code{palette()[i]}.}
  \item{high}{Color for the upper end of the color palette, specified
  using any of the three kinds of R colors, i.e., either a color name
  (an element of \code{\link{colors}}), a hexadecimal string of the form
  \code{"#rrggbb"}, or an integer \code{i} meaning \code{palette()[i]}.}
 \item{mid}{Color for the middle portion of the color palette, specified using any of the three kinds of R colors, i.e., either a color name (an element of \code{\link{colors}}), a hexadecimal string of the form \code{"#rrggbb"}, or an integer \code{i} meaning \code{palette()[i]}.}
  \item{k}{Number of colors in the palette.}
}

\value{
  A "character" vector of color names. This can be used to create a user-defined color palette for subsequent graphics by \code{\link{palette}}, in a \code{col=} specification in graphics functions, or in \code{\link{par}}.
}

\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}, Yee Hwa (Jean) Yang.}

\seealso{\code{\link{palette}}, \code{\link{rgb}},
\code{\link{colors}}, \code{\link{col2rgb}}, \code{\link{image}}, \code{\link{maColorBar}}, \code{\link{maImage}}, \code{\link{maImage.func}}.}

\examples{
par(mfrow=c(1,4))
pal <- maPalette(low="red", high="green")
maColorBar(seq(-2,2, 0.2), col=pal, horizontal=FALSE, k=21)
pal <- maPalette(low="red", high="green", mid="yellow")
maColorBar(seq(-2,2, 0.2), col=pal, horizontal=FALSE, k=21)
pal <- maPalette()
maColorBar(seq(-2,2, 0.2), col=pal, horizontal=FALSE, k=21)
pal <- maPalette(low="purple", high="purple",mid="white")
maColorBar(seq(-2,2, 0.2), col=pal, horizontal=FALSE, k=21)
}
\keyword{color}% at least one, from doc/KEYWORDS


\eof
\name{maPlot}
\alias{maPlot}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Scatter-plots for cDNA microarray spot statistics}
\description{The function \code{maPlot} produces scatter-plots of microarray spot statistics for the classes \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, and \code{"\link{marrayTwo}"}. It also allows the user to highlight and annotate subsets of points on the plot, and display fitted curves from robust local regression or other smoothing procedures.
}

\usage{
maPlot(m, x="maA", y="maM", z="maPrintTip", lines.func, text.func, legend.func, ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{m}{Microarray object of class \code{"\link{marrayRaw}"}, \code{"\link{marrayNorm}"}, or \code{"\link{marrayTwo}"}.}
  \item{x}{Name of accessor function for the abscissa spot statistic, typically a slot name for the microarray object \code{m}, such as \code{maA}.}
  \item{y}{Name of accessor function for the ordinate spot statistic, typically a slot name for the microarray object \code{m}, such as \code{maM}.}
  \item{z}{Name of accessor method for the spot statistic used to stratify the data, typically a slot name for the microarray layout object (see \code{"\link{marrayLayout}"}) such as \code{maPlate} or a method such as \code{maPrintTip}. If \code{z} is NULL, the data are not stratified.}
  \item{lines.func}{Function for computing and plotting smoothed fits of \code{y} as a function of \code{x}, separately within values of \code{z}, e.g. \code{\link{maLoessLines}}. If \code{lines.func} is NULL, no fitting is performed.}
  \item{text.func}{Function for highlighting a subset of points, e.g., \code{\link{maText}}. If \code{text.func} is NULL, no points are highlighted.}
  \item{legend.func}{Function for adding a legend to the plot, e.g. \code{\link{maLegendLines}}. If \code{legend.func} is NULL, there is no legend.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\details{
This function calls the general function \code{\link{maPlot.func}}, which is not specific to microarray data. If there are more than one array in the batch, the plot is done for the first array, by default. Default graphical parameters are chosen for convenience using the function \code{\link{maDefaultPar}} (e.g. color palette,  axis labels,  plot title) but the user has the option to overwrite these parameters at any point.}
}

\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{maPlot.func}}, \code{\link{maDefaultPar}}, \code{\link{maLoessLines}}, \code{\link{maLegendLines}}, \code{\link{maText}}, \code{\link{plot}}, \code{\link{lowess}}, \code{\link{loess}}, \code{\link{legend}}.}

\examples{

# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Pre-normalization MA-plot for the Swirl 93 array, with the lowess fits for 
# individual print-tip-groups. 
# - Default arguments
maPlot(swirl[,3])

# Lowess fit using all spots
maPlot(swirl[,3], z=NULL, legend.func=NULL)

# Loess fit using all spots
maPlot(swirl[,3], z=NULL, legend.func=maLegendLines(legend="All spots",col="green"), lines.func=maLoessLines(loess.args=list(span=0.3),col="green"))


# Pre-normalization MA-plot for the Swirl 81 array, with the lowess fits for 
# individual grid columns and 1\% tails of M highlighted
defs <- maDefaultPar(swirl[, 1], x = "maA", y = "maM", z = "maGridCol")
legend.func <- do.call("maLegendLines", defs$def.legend)
lines.func <- do.call("maLowessLines", c(list(TRUE, f = 0.3), defs$def.lines))
text.func<-maText(subset=maTop(maM(swirl)[,1],h=0.01,l=0.01), labels="o", col="violet")
maPlot(swirl[, 1], x = "maA", y = "maM", z = "maGridCol", lines.func=lines.func, text.func = text.func, legend.func=legend.func, main = "Swirl array 81: pre-normalization MA-plot")

}

\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{maPlot.func}
\alias{maPlot.func}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Scatter-plots with fitted curves and text}
\description{
 This function produces scatter-plots of \code{x} vs. \code{y}. It also allows the user to highlight and annotate subsets of points on the plot, and display fitted curves from robust local regression or other smoothing procedures.
}

\usage{
maPlot.func(x, y, z, 
	lines.func = maLowessLines(subset = TRUE, f = 0.3, col = 1:length(unique(z)), lty = 1, lwd = 2.5),
    	text.func = maText(), 
	legend.func = maLegendLines(legend = as.character(unique(z)), col = 1:length(unique(z)), lty = 1, lwd = 2.5, ncol = 1),
	 ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{A "numeric" vector for the abscissa.}
  \item{y}{A "numeric" vector for the ordinates.}
  \item{z}{A vector of statistic used to stratify the data, smoothed curves are fitted separately within values of \code{z}}
  \item{lines.func}{A function for computing and plotting smoothed fits of \code{y} as a function of \code{x}, separately within values of \code{z}, e.g. \code{\link{maLoessLines}}.}
  \item{text.func}{A function for highlighting a subset of points, e.g., \code{maText}.}
  \item{legend.func}{A function for adding a legend to the plot, e.g. \code{\link{maLegendLines}}.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{maPlot}}, \code{\link{maLoessLines}}, \code{\link{maLegendLines}}, \code{\link{maText}}, \code{\link{plot}}, \code{\link{lowess}}, \code{\link{loess}}, \code{\link{legend}}.}

\examples{
# See examples for maPlot.


}
\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{maText}
\alias{maText}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Highlight points on a plot}
\description{
This function may be used to highlight a subset of points on an existing plot, such as a plot produced by \code{\link{plot}}, \code{\link{maPlot}}, or \code{\link{maPlot.func}}.
}

\usage{
maText(subset=NULL, labels=as.character(1:length(subset)), ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{subset}{A "logical" or "numeric" vector indicating the subset of points to
  highlight.}
\item{labels}{One or more character strings or expressions specifying the text to be written.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\value{
A function with bindings for \code{subset}, \code{labels}, and \code{\ldots}. This latter function takes as arguments \code{x} and \code{y}, the absissa and ordinates of points on the plot.
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}

\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{text}}, \code{\link{maPlot}}, \code{\link{maPlot.func}}.}

\examples{
# See examples for maPlot.


}
\keyword{aplot}% at least one, from doc/KEYWORDS


\eof
\name{maTop}
\alias{maTop}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Identify extreme values}
\description{
This function determines which values in a numeric vector are above or below user supplied cut-offs.
}
\usage{
maTop(x, h=1, l=1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{A "numeric" vector.}
  \item{h}{A "numeric", upper cut-off.}
  \item{l}{A "numeric", lower cut-off.}
}

\value{
A "logical" vector indicating which entries are above or below the cut-offs.}
}

\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
 }


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{maPlot}}, \code{\link{maImage}}, \code{\link{quantile}}.}

\examples{
# See examples for maPlot.

}
\keyword{misc}% at least one, from doc/KEYWORDS

\eof
