### Name: heatdiagram
### Title: Stemmed Heat Diagram
### Aliases: heatdiagram heatDiagram
### Keywords: hplot

### ** Examples

library(sma)
data(MouseArray)
MA <- stat.ma(mouse.data,layout=mouse.setup)
design <- cbind(c(1,1,1,0,0,0),c(0,0,0,1,1,1))
fit <- lm.series(MA$M,design=design)
contrasts.mouse <- cbind(c(1,0),c(0,1),c(-1,1))
colnames(contrasts.mouse) <- c("First3","Second3","Difference")
fit <- contrasts.fit(fit,contrasts=contrasts.mouse)
eb <- ebayes(fit)
heatdiagram(abs(eb$t),fit$coef,primary="Difference")



