\name{glpls1a}
\alias{glpls1a}
\title{Fit IRWPLS and IRWPLSF model}
\description{
  Fit Iteratively ReWeighted Least Squares (IRWPLS) with an option of
  Firth's bias reduction procedure (IRWPLSF) for two-group classification
}
\usage{
glpls1a(X, y, K.prov = NULL, eps = 0.001, lmax = 100, b.ini = NULL, denom.eps = 1e-20, family = "binomial", link = NULL, br = T)
}

\arguments{
  \item{X}{ n by p design matrix (with no intercept term)}
  \item{y}{ response vector 0 or 1}
  \item{K.prov}{ number of PLS components, default is the rank of X}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{b.ini}{ initial value of regression coefficients}
  \item{denom.eps}{ small quanitity to guarantee nonzero denominator in
    deciding convergence}
  \item{family}{ glm family, \code{binomial} is the only relevant one here }
  \item{link}{ link function, \code{logit} is the only one practically implemented now}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{
  
}
\value{
  \item{coefficients }{regression coefficients}
  \item{convergence }{whether convergence is achieved}
  \item{niter}{total number of iterations}
  \item{bias.reduction}{whether Firth's procedure is used}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a.mlogit}}, \code{\link{glpls1a.logit.all}},
  \code{\link{glpls1a.train.test.error}},
  \code{\link{glpls1a.cv.error}}, \code{\link{glpls1a.mlogit.cv.error}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(0:1,10,TRUE)
 ## no bias reduction
 glpls1a(x,y,br=FALSE)
  
 ## no bias reduction and 1 PLS component
 glpls1a(x,y,K.prov=1,br=FALSE)

 ## bias reduction
 glpls1a(x,y,br=TRUE)
}

\keyword{regression}



\eof
\name{glpls1a.cv.error}
\alias{glpls1a.cv.error}
\title{Leave-one-out cross-validation error using IRWPLS and IRWPLSF model}
\description{
  Leave-one-out cross-validation training set classification error for
  fitting IRWPLS or IRWPLSF model for two group classification
}
\usage{
glpls1a.cv.error(train.X,train.y, K.prov=NULL,eps=1e-3,lmax=100,family="binomial",link="logit",br=T)
}

\arguments{
  \item{train.X}{ n by p design matrix (with no
    intercept term) for training set}
  \item{train.y}{ response vector (0 or 1) for training set}
  \item{K.prov}{ number of PLS components, default is the rank of
    train.X}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{family}{ glm family, \code{binomial} is the only relevant one here }
  \item{link}{ link function, \code{logit} is the only one practically implemented now}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{
  
}
\value{
  \item{error}{LOOCV training error}
  \item{error.obs}{the misclassified error observation indices}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a.train.test.error}},
  \code{\link{glpls1a.mlogit.cv.error}}, \code{\link{glpls1a}}, \code{\link{glpls1a.mlogit}},\code{\link{glpls1a.logit.all}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(0:1,10,TRUE)

 ## no bias reduction
 glpls1a.cv.error(x,y,br=FALSE)
 ## bias reduction and 1 PLS component
 glpls1a.cv.error(x,y,K.prov=1, br=TRUE)
}

\keyword{regression}



\eof
\name{glpls1a.logit.all}
\alias{glpls1a.logit.all}
\title{Fit MIRWPLS and MIRWPLSF model separately for logits }
\description{
  Apply Iteratively ReWeighted Least Squares (MIRWPLS) with an
  option of Firth's bias reduction procedure (MIRWPLSF) for multi-group
  (say C+1 classes) classification by fitting logit models for all C
  classes vs baseline class separately.
}
\usage{
glpls1a.logit.all(X, y, K.prov = NULL, eps = 0.001, lmax = 100, b.ini = NULL, denom.eps = 1e-20, family = "binomial", link = NULL, br = T)
}

\arguments{
  \item{X}{ n by p design matrix (with no intercept term)}
  \item{y}{ response vector with class lables 1 to C+1 for C+1 group
    classification,  baseline class should be 1}
  \item{K.prov}{ number of PLS components}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{b.ini}{ initial value of regression coefficients}
  \item{denom.eps}{ small quanitity to guarantee nonzero denominator in
    deciding convergence}
  \item{family}{ glm family, \code{binomial} (i.e. multinomial here) is the only relevant one here }
  \item{link}{ link function, \code{logit} is the only one practically implemented now}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{
  
}
\value{
  \item{coefficients }{regression coefficient matrix}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a.mlogit}},\code{\link{glpls1a}},\code{\link{glpls1a.mlogit.cv.error}},
  \code{\link{glpls1a.train.test.error}},
  \code{\link{glpls1a.cv.error}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(1:3,10,TRUE)
 ## no bias reduction
 glpls1a.logit.all(x,y,br=FALSE)
 ## bias reduction
 glpls1a.logit.all(x,y,br=TRUE)
}

\keyword{regression}



\eof
\name{glpls1a.mlogit}
\alias{glpls1a.mlogit}
\title{Fit MIRWPLS and MIRWPLSF model}
\description{
  Fit multi-logit Iteratively ReWeighted Least Squares (MIRWPLS) with an
  option of Firth's bias reduction procedure (MIRWPLSF) for multi-group
  classification
}
\usage{
glpls1a.mlogit(x, y, K.prov = NULL, eps = 0.001, lmax = 100, b.ini = NULL, denom.eps = 1e-20, family = "binomial", link = NULL, br = T)
}

\arguments{
  \item{x}{ n by p design matrix (with intercept term)}
  \item{y}{ response vector with class lables 1 to C+1 for C+1 group
    classification,  baseline class should be 1}
  \item{K.prov}{ number of PLS components}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{b.ini}{ initial value of regression coefficients}
  \item{denom.eps}{ small quanitity to guarantee nonzero denominator in
    deciding convergence}
  \item{family}{ glm family, \code{binomial} (i.e. multinomial here) is the only relevant one here }
  \item{link}{ link function, \code{logit} is the only one practically implemented now}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{
  
}
\value{
  \item{coefficients }{regression coefficient matrix}
  \item{convergence }{whether convergence is achieved}
  \item{niter}{total number of iterations}
  \item{bias.reduction}{whether Firth's procedure is used}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a}},\code{\link{glpls1a.mlogit.cv.error}},
  \code{\link{glpls1a.train.test.error}},
  \code{\link{glpls1a.cv.error}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(1:3,10,TRUE)
 ## no bias reduction and 1 PLS component
 glpls1a.mlogit(cbind(rep(1,10),x),y,K.prov=1,br=FALSE)
 ## bias reduction
 glpls1a.mlogit(cbind(rep(1,10),x),y,br=TRUE)
}

\keyword{regression}



\eof
\name{glpls1a.mlogit.cv.error}
\alias{glpls1a.mlogit.cv.error}
\title{Leave-one-out cross-validation error using MIRWPLS and MIRWPLSF model}
\description{
  Leave-one-out cross-validation training set error for
  fitting MIRWPLS or MIRWPLSF model for multi-group classification
}
\usage{
glpls1a.mlogit.cv.error(train.X, train.y, K.prov = NULL, eps = 0.001,lmax = 100, mlogit = T, br = T)
}

\arguments{
  \item{train.X}{ n by p design matrix (with no
    intercept term) for training set}
  \item{train.y}{  response vector with class lables 1 to C+1 for C+1 group
    classification,  baseline class should be 1}
  \item{K.prov}{ number of PLS components}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{mlogit}{if \code{TRUE} use the multinomial logit model,
    otherwise fit all C-1 logistic models (vs baseline class 1) separately}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{}

\value{
  \item{error}{LOOCV training error}
  \item{error.obs}{the misclassified error observation indices}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a.cv.error}}, \code{\link{glpls1a.train.test.error}},\code{\link{glpls1a}}, \code{\link{glpls1a.mlogit}},\code{\link{glpls1a.logit.all}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(1:3,10,TRUE)

 ## no bias reduction
 glpls1a.mlogit.cv.error(x,y,br=FALSE)
 glpls1a.mlogit.cv.error(x,y,mlogit=FALSE,br=FALSE)
 ## bias reduction
 glpls1a.mlogit.cv.error(x,y,br=TRUE)
 glpls1a.mlogit.cv.error(x,y,mlogit=FALSE,br=TRUE)

}

\keyword{regression}



\eof
\name{glpls1a.train.test.error}
\alias{glpls1a.train.test.error}
\title{out-of-sample test set error using IRWPLS and IRWPLSF model}
\description{
  Out-of-sample test set error for fitting IRWPLS or IRWPLSF model on the
  training set for two-group classification
}
\usage{
glpls1a.train.test.error(train.X,train.y,test.X,test.y,K.prov=NULL,eps=1e-3,lmax=100,family="binomial",link="logit",br=T)
}

\arguments{
  \item{train.X}{  n by p design matrix (with no
    intercept term) for training set}
  \item{train.y}{ response vector (0 or 1) for training set}
  \item{test.X}{ transpose of the design matrix (with no
    intercept term) for test set}
  \item{test.y}{ response vector (0 or 1) for test set}
  \item{K.prov}{ number of PLS components, default is the rank of
    train.X}
  \item{eps}{tolerance for convergence}
  \item{lmax}{ maximum number of iteration allowed }
  \item{family}{ glm family, \code{binomial} is the only relevant one here }
  \item{link}{ link function, \code{logit} is the only one practically implemented now}
  \item{br}{TRUE if Firth's bias reduction procedure is used}
}
\details{
  
}
\value{
  \item{error}{out-of-sample test error}
  \item{error.obs}{the misclassified error observation indices}
  \item{predict.test}{the predicted probabilities for test set}
}

\references{
 \item Ding, B.Y. and Gentleman, R. (2003) Classification using generalized partial least squares.
 \item Marx, B.D (1996) Iteratively reweighted partial least squares estimation for generalized linear regression. Technometrics 38(4): 374-381.
}
\author{Beiying Ding, Robert Gentleman}
\note{}

\seealso{ \code{\link{glpls1a.cv.error}},
  \code{\link{glpls1a.mlogit.cv.error}}, \code{\link{glpls1a}}, \code{\link{glpls1a.mlogit}}, \code{\link{glpls1a.logit.all}}}

\examples{
 x <- matrix(rnorm(20),ncol=2)
 y <- sample(0:1,10,TRUE)
 x1 <- matrix(rnorm(10),ncol=2)
 y1 <- sample(0:1,5,TRUE)

 ## no bias reduction
 glpls1a.train.test.error(x,y,x1,y1,br=FALSE)
 ## bias reduction
 glpls1a.train.test.error(x,y,x1,y1,br=TRUE)
}

\keyword{regression}



\eof
