\name{checkerboard}

\alias{checkerboard}

\title{Checkerboard plot for Global Test result}

\description{Produces a plot to visualize the test result produced
by \code{\link{globaltest}}, by showing the association between
pairs of samples.}

\usage{checkerboard(testresult, sort = TRUE)}

\arguments{
    \item{testresult}{The output of a call to \code{\link{globaltest}}.}
    \item{sort}{A logical flag to indicate whether the samples should be sorted
by the clinical outcome to give a clearer picture.}}

\details{The checkerboard shows the pairs of samples which have
high covariance in white and the pairs with low covariance in
black. This can be used to visualize the data and to search for
outlying arrays.}

\value{A matrix giving the old and the new sample numbers.}

\references{J. J. Goeman, S.A. van de Geer, F. de Kort and J. C.
van Houwelingen, \emph{A global test for association of a group of
genes with a clinical outcome}, Technical Report MI 2003-03,
Mathematical Institute, Leiden University. Available from 
\url{http://www.math.leidenuniv.nl/~jgoeman}.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}}

\seealso{\code{\link{globaltest}}, \code{\link{regressionplot}},
  \code{\link{geneplot}}, \code{\link{permutations}}.} 

\examples{
if(interactive()){
    data(exampleX)      # Expression data (40 samples; 1000 genes)
    data(exampleY)      # Clinical outcome for the 40 samples
    pathway <- 1:25     # A pathway contains genes 1 to 25
    gt <- globaltest(exampleX, exampleY, test.genes = pathway)
    gt
    checkerboard(gt)
}
}

\keyword{hplot}




\eof
\name{exampleX}

\docType{data}

\alias{exampleX}

\title{Example expression data for package "globaltest".}

\description{A simulated gene expression dataset used in the 
examples of the package "globaltest".}

\usage{data(exampleX)}

\format{A matrix containing expressions for 1000 genes and 40
samples.}

\seealso{\code{\link{exampleY}}.}

\keyword{datasets}

\eof
\name{exampleY}

\docType{data}

\alias{exampleY}

\title{Example clinical variable for package "globaltest".}

\description{A simulated clinical variable used used in the 
examples of the package "globaltest".}

\usage{data(exampleY)}

\format{A vector of length 40 containing values 0 and 1.}

\seealso{\code{\link{exampleX}}.}

\keyword{datasets}

\eof
\name{gene2ix}

\alias{gene2ix}

\title{Gene to index}

\description{Gives the index numbers where genes of interest are 
present on a chip.}

\usage{ 
gene2ix(genes, chip, logic = FALSE) }

\arguments{
    \item{genes}{A vector of gene names of the genes of interest.}
    \item{chip}{A vector of gene names present on the chip.} 
    \item{logic}{Determines the format of the return value. If 
    \code{FALSE}, the function returns list of index numbers, if 
    \code{TRUE} it returns a logical vector as long as \code{chip}.}
}

\details{Given a list of gene names and the complete list of the 
names of genes on a chip, the function returns the locations of 
the genes of interest on the chip. The names must match exactly.}

\note{The result of \code{gene2ix} can be used as input of the 
test.genes option of the function \code{\link{globaltest}}.}

\value{If \code{logic = FALSE} (default), a list of index numbers 
is returned. If \code{logic = TRUE}}, a vector of length 
\code{length(chip)} is returned, having \code{TRUE} if the gene 
on the chip is among the genes of interest.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}.}

\examples{ 
    my.chip = c("a", "b", "c", "d", "e")
    my.genes = c("a", "b", "f")
    ix <- gene2ix(my.genes, my.chip)
    ix
    
    ix <- gene2ix(my.genes, my.chip, logic = TRUE)
    ix
}

\keyword{character}
    
  
    

\eof
\name{geneplot}

\alias{geneplot}

\title{Geneplot for Global Test result}

\description{Produces a plot to show the influence of individual
genes on the test result produced by \code{\link{globaltest}}.}

\usage{geneplot(testresult)}

\arguments{
    \item{testresult}{The output of a call to \code{\link{globaltest}}.}}

\details{The geneplot shows a bar an a reference line for each
gene. The bar shows the influence of each gene on the test result;
the reference line shows the expected influence if the gene was
not associated with the outcome. The color of the bar indicates
positive or negative correlation of the gene with the clinical
outcome, to distinguish between up and downregulation.}

\value{If gene names were supplied in the call to 
\code{\link{globaltest}}, geneplot returns a data.frame referring 
the gene names to the gene numbers appearing in the plot. 
Otherwise \code{NULL}.}

\references{J. J. Goeman, S.A. van de Geer, F. de Kort and J. C. 
van Houwelingen, \emph{A global test for association of a group 
of genes with a clinical outcome}, Technical Report MI 2003-03, 
Mathematical Institute, Leiden University. Available from 
\url{http://www.math.leidenuniv.nl/~jgoeman}.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}}

\seealso{\code{\link{globaltest}}, \code{\link{regressionplot}},
  \code{\link{checkerboard}}, \code{\link{permutations}}.}  

\examples{
if(interactive()){
    data(exampleX)      # Expression data (40 samples; 1000 genes)
    data(exampleY)      # Clinical outcome for the 40 samples
    pathway <- 1:25     # A pathway contains genes 1 to 25
    gt <- globaltest(exampleX, exampleY, test.genes = pathway)
    gt
        geneplot(gt)
}
}

\keyword{hplot}

\eof
\name{globaltest}

\alias{globaltest}

\title{Global Test}

\description{In microarray data, tests whether a given group of 
genes is significantly associated with a given clinical variable.}

\usage{ globaltest(X, Y, test.genes = NULL, model = 'logistic', 
                            permutation = FALSE, nperm = NULL) }

\arguments{
    \item{X}{A matrix of gene expression data, where columns correspond to 
samples and rows to genes. The data should be properly normalized 
beforehand (and log- or otherwise transformed), but missing 
values are allowed (coded as \code{NA}). Gene and sample names 
can be included as the row and column names of \code{X}.}
    \item{Y}{A vector with the clinical outcome of interest, having one value
for each sample.} 
    \item{test.genes}{Indicates the group of genes to be tested. \code{test.genes} can 
be given in two formats. Either it can be a vector with 1 
(\code{TRUE}) or 0 (\code{FALSE}) for each gene in \code{X}, with 
1 indicating that the gene belongs to the group. Or it can be a 
vector containing the column numbers (in \code{X}) of the genes 
belonging to the group. The default is to test all genes.}
    \item{model}{Indicates the model the test uses: Use \code{model = 'logistic'} 
for a two-valued outcome \code{Y} (the default) or \code{model = 
'linear'} for a continuous outcome.}
    \item{permutation}{A logical flag. If \code{TRUE} permutations are used to 
calculate the p-value, if \code{FALSE} (the default) the 
formula's based on asymptotic theory are used. Choose 
\code{permutation = TRUE} for small sample sizes.}
    \item{nperm}{The number of permutations to be used. The default is 10,000. If 
a number is specified for \code{nperm}, \code{permutation} is 
automatically set to \code{TRUE}.} }

\details{The Global Test tests whether a group of genes (of any 
size from one single gene to all genes on the array) is 
significantly associated with a clinical outcome. The group could 
be for example a known pathway, an area on the genome or all 
genes. For a significant result it is not important if the genes 
in the group are positively or negatively correlated with the 
outcome. More precisely the test investigates whether samples 
with similar clinical outcomes tend to have similar gene 
expression patterns.}

\note{If the number of rows of \code{X} does not match the length 
of the vector \code{Y}, but the number of columns does, the 
matrix \code{X} given is tacitly replaced by \code{t(X)} to make 
\code{X} and \code{Y} match. A warning is printed if \code{X} is 
square.}

\value{The function returns an object of type \code{gt.result}.}

\references{J. J. Goeman, S.A. van de Geer, F. de Kort and J. C. 
van Houwelingen, \emph{A global test for association of a group 
of genes with a clinical outcome}, Technical Report MI 2003-03, 
Mathematical Institute, Leiden University. Available from 
\url{http://www.math.leidenuniv.nl/~jgoeman}.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}.}

\seealso{\code{\link{geneplot}}, \code{\link{regressionplot}},
  \code{\link{checkerboard}}, \code{\link{permutations}},
  \code{\link{gt.result}}.}  

\examples{
    if(interactive()){
        data(exampleX)      # Expression data (40 samples; 1000 genes)
        data(exampleY)      # Clinical outcome for the 40 samples
        pathway <- 1:25     # A pathway contains genes 1 to 25
        gt <- globaltest(exampleX, exampleY, test.genes = pathway)
        gt

        # For comparison: test all genes:
        gt <- globaltest(exampleX, exampleY)
        gt
    
        # For comparison: the permutation version:
        gt <- globaltest(exampleX, exampleY, test.genes = pathway, 
                                                permutation = TRUE)
        gt
   
        permutations(gt)
    }

}

\keyword{htest}
    
  
    

\eof
\name{gt.result-class}

\docType{class}

\alias{gt.result}
\alias(gt.result-class}

\title{Class gt.result, for results of the function globaltest}

\description{The class gt.result is the output of a call to
\code{\link{globaltest}} and the input of various plotting functions to
visualize the test reult.}

\section{Slots}{
\describe{
    \item{Q}{The test statistic.}
    \item{EQ}{The expected value of \code{Q} under the null
    hypothesis.}
    \item{seQ}{The standard deviation of \code{Q} under the null
    hypothesis.}
    \item{p.value}{The p-value resulting from the test.}
    \item{Qs}{Values of \code{Q} for permutations of the clinical
    variable}
    \item{matrixR}{The covariance matrix between the expression
    patterns of the samples.}
    \item{Y}{The centered clinical variable.}
    \item{influence}{The influence of each gene on the test
    statistic.}
    \item{exp.influence}{The expected influence of each gene on
    the test statistic under the null hypothesis.}
    \item{test.genes}{A logical vector indicating which genes were
    to be tested.}
    }
}

\section{Methods}{
\describe{
    \item{show}{Summarizes the test result}
    \item{checkerboard}{Produces a plot to visualize the test result
    produced by \code{\link{globaltest}} by showing the association
    between pairs of samples.}
    \item{geneplot}{Produces a plot to show the influence of individual
    genes on the test result produced by \code{\link{globaltest}}.}
    \item{permutations}{Produces a histogram for visualization of the
    permutations used in \code{\link{globaltest}}.}
    \item{regressionplot}{Produces a plot which can be used to visualize
    the effect of specific samples on the test result produced by
    \code{\link{globaltest}}.}
    }
}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}}

\seealso{\code{\link{globaltest}}, \code{\link{regressionplot}},
\code{\link{geneplot}}, \code{\link{permutations}}, 
\code{\link{checkerboard}}.}

\keyword{methods}

\eof
\name{permutations}

\alias{permutations}

\title{Histogram for Global Test result}

\description{Produces a histogram for visualization of the permutations
used in \code{\link{globaltest}}.}

\usage{permutations(testresult)}

\arguments{
    \item{testresult}{The output of a call to \code{\link{globaltest}}.}}

\details{Produces a histogram of the value of the test statistic
calculated for permutations of the clinical outcome, compared with
the test statistic for the true clinical outcome.}

\note{Only works if the option \code{permutation = TRUE} was
chosen when calling \code{\link{globaltest}}.}

\value{\code{NULL} (no output).}

\references{J. J. Goeman, S.A. van de Geer, F. de Kort and J. C.
van Houwelingen, \emph{A global test for association of a group of
genes with a clinical outcome}, Technical Report MI 2003-03,
Mathematical Institute, Leiden University. Available from 
\url{http://www.math.leidenuniv.nl/~jgoeman}.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}}

\seealso{\code{\link{globaltest}}, \code{\link{checkerboard}},
  \code{\link{geneplot}}, \code{\link{regressionplot}}.} 

\examples{
if(interactive()){
    data(exampleX)      # Expression data (40 samples; 1000 genes)
    data(exampleY)      # Clinical outcome for the 40 samples
    pathway <- 1:25     # A pathway contains genes 1 to 25
    gt <- globaltest(exampleX, exampleY, test.genes = pathway, 
                                                permutation = TRUE)
    gt
    permutations(gt)
}
}

\keyword{hplot}

\eof
\name{regressionplot}

\alias{regressionplot}

\title{Regression plot for Global Test result}

\description{Produces a plot which can be used to visualize the
effect of specific samples on the test result produced by
\code{\link{globaltest}}.}

\usage{regressionplot(testresult, samplenr = NULL)}

\arguments{
    \item{testresult}{The output of a call to \code{\link{globaltest}}.}
    \item{samplenr}{A vector giving row numbers of samples of interest.}}

\details{The regressionplot plots, for all pairs of samples, the
covariance between the expression patterns against the covariance
between their clinical outcomes. Each point in the plot therefore
represents a pair of samples. A regression line is fitted through
the samples, which visualizes the test result of the function
\code{\link{globaltest}}. A steeply increasing slope indicates a
high (possibly significant) value of the test statistic.

An optional argument \code{samplenr} can be supplied, giving
sample numbers of possibly outlying arrays. In this case, all
pairs of arrays involving one of the arrays in \code{samplenr} is
marked as a red cross, while the other pairs are marked as a blue
dot. The blue line which is fitted through all points can now be
compared to a red dotted line which is fitted though only the red
crosses.}

\value{\code{NULL} (no output).}

\references{J. J. Goeman, S.A. van de Geer, F. de Kort and J. C.
van Houwelingen, \emph{A global test for association of a group of
genes with a clinical outcome}, Technical Report MI 2003-03,
Mathematical Institute, Leiden University. Available from 
\url{http://www.math.leidenuniv.nl/~jgoeman}.}

\author{Jelle Goeman: \email{j.j.goeman@lumc.nl}}

\seealso{\code{\link{globaltest}}, \code{\link{checkerboard}},
  \code{\link{geneplot}}, \code{\link{permutations}}.} 

\examples{
if(interactive()){
    data(exampleX)      # Expression data (40 samples; 1000 genes)
    data(exampleY)      # Clinical outcome for the 40 samples
    pathway <- 1:25     # A pathway contains genes 1 to 25
    gt <- globaltest(exampleX, exampleY, test.genes = pathway)
    gt
    regressionplot(gt)
    regressionplot(gt,40)
}
}

\keyword{hplot}

\eof
