\name{GetColor}
\alias{GetColor}
\alias{dChip.colors}
\alias{greenred.colors}
\title{ A function to get the Red-Blue color scheme used by dChip }
\description{
 A simple, vectorized function that computes a Red/Blue color for
 plotting microarray expression data.
}
\usage{
GetColor(value, GreenRed=FALSE, DisplayRange=3)
dChip.colors(n)
greenred.colors(n)
}

\arguments{
  \item{value}{The vector of expression values. }
  \item{GreenRed}{If \code{TRUE} the Green-Red colors are produced,
    otherwise Red-Blue are procduced. }
  \item{DisplayRange}{ A parameter controlling the range of
    \code{value}'s that will be plotted. }
  \item{n}{An integer saying how many colors to be in the palette.}
}
\details{
  \code{GetColor} is a simple mapping into RGB land provided by Cheng
  Li.
  \code{dChip.colors} provides functionality similar to that of
  \code{\link{topo.colors}} for the red--blue colors used for genome
  plots. \code{greenred.colors} does the same for the green-black-red gradient. 
}
\value{
 A vector of RGB colors suitable for plotting in R.
}

\author{R. Gentleman, based on an original by C. Li. }

\examples{
  set.seed(10)
  x <- rnorm(10)
  GetColor(x)
  dChip.colors(10)
}
\keyword{ manip }


\eof
\name{alongChrom}
\alias{alongChrom}
\alias{buildACMainLabel}
\alias{doACImagePlot}
\alias{fixACPhysPoints}
\alias{getACGeneSyms}
\alias{limitACXRange}
\alias{cullACXPoints}
\alias{doACLocalPlot}
\alias{getACClosestPos}
\alias{getACPlotLabs}
\alias{scaleACData}
\alias{dispACXaxis}
\alias{doACMatPlot}
\alias{getACDataEnv}
\alias{getACStrandVals}
\alias{doACCumPlot}
\alias{emptyACPlot}
\alias{getACExprs}
\alias{highlightACDups}
\title{A function for plotting expression data from an exprset for a
  given chromosome. }
\description{
  Given a particular exprset object, a chromLocation object, and a
  chromosome name, will plot selected exprSet data using various methods.
}
\usage{
   alongChrom(eSet, chrom, specChrom,  xlim, whichGenes, 
   plotFormat=c("cumulative", "local","image"),
   xloc=c("equispaced", "physical"), 
   scale=c("none","zscale","rankscale","rangescale","zrobustscale"),
   geneSymbols=FALSE, byStrand=FALSE, colors="red", lty=1, type="S",
   ...)}
\arguments{
  \item{eSet}{The exprset object to be used.}
  \item{chrom}{The desired chromosome.}
  \item{specChrom}{An object of type chromLocation for the species being
    represented.}
  \item{xlim}{A pair of values - either character or integer, which will
    denote the range of genes to display (based on base pair: either directly
    in the case of integers, or using the locations of the named genes if
    character).  If not supplied, the entire chromosome is used.}
  \item{whichGenes}{If supplied, will limit the displayed genes to the ones
    provided in this vector.}
  \item{xloc}{Determines whether the X axis points (gene names) will be
    displayed according to their relative position on the chromosome
    (physical), or spaced evenly (equispaced).  Default is equispaced.}
  \item{plotFormat}{Determines the method which to plot the data.}
  \item{scale}{Determines what method of scaling will be applied to the
    data.  Default is none.}
  \item{geneSymbols}{Notes whether to use Affy IDs or Gene Symbols,
    default is Affy IDs}
  \item{byStrand}{Determines whether to show the entire plot at once, or
    a split plot by strands.  Default is a singular plot}
  \item{lty}{A vector of line types, which will be cycled. }
  \item{type}{Plot type, from par.  Defaults to "S".}
  \item{colors}{A vector of colors for the plots, which will be cycled.}
  \item{...}{Any remaining graphics commands may be passed along as per plot()}
}
\details{
  The genes on the chromosome of interest are extracted from the
  \code{chromLocation} object passed in, which are then intersected with the
  genes listed in the exprset.  These remaining genes will then be
  plotted according to the \code{plotFormat} argument.  If \code{image} is
  specified, an image plot is created showing the expression levels of
  the samples by gene, using a colour map to denote the levels.  If
  \code{cumulative} is chosen, the cumulative expression level is plotted
  against the genes for each sample.  Likewise, if \code{local} is used, the
  raw data is plotted for each sample against the genes using a boxplot format.

  Not all parameters are honored for all plotformats.  \code{xloc},
  \code{lty}, and \code{type} are only used with the \code{cumulative}
  plotformat.
}
\author{Jeff Gentry}
\examples{
   data(eset)
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
      z <- buildChromLocation("hgu95av2")
      lty <- c(1, 2, 3, 4, 5)
      cols <- c("red", "green", "blue", "orange", "magenta", "black")
      cols <- cols[eset$cov3]
      if (interactive()) {
         par(ask=TRUE)
      }

      ## Here we're using xlim to denote a physical region to display
      xlim <- c(87511280,127717880)
      for (xl in c("equispaced", "physical"))
        for (sc in c("none","rangescale"))
        {
           alongChrom(eset, "1", z, xlim=xlim, xloc=xl,
              plotFormat="cumulative", scale=sc,lty=lty, col=cols)
        }

     ## Here we're looking for specific genes
     which <- c("31540_at","31583_at", "31508_at", "31529_at", "31439_f_at",
               "31729_at")
     ## Gene "31529_at" does not exist in the current set of genes,
     ## here it demonstrates how genes not available are dropped.
      for (xl in c("equispaced", "physical"))
        for (sc in c("none","rangescale"))
        {
            alongChrom(eset, "1", z, which=which, xloc=xl,
               plotFormat="cumulative", scale=sc,lty=lty, col=cols)
         }

      ## Do an image plot
      for (bs in c(TRUE,FALSE))
         alongChrom(eset, "1",z, xlim=xlim, plotFormat="image",
                   scale="zscale", byStrand=bs)

      ## A boxplot
      for (st in c(TRUE,FALSE))
         alongChrom(eset, "1", z, plotFormat="local",
                    colors=cols, byStrand=st)
    } else print("Example can not be run without the hgu95av2 data package")
}
  
\keyword{utilities}


\eof
\name{amplicon.plot}
\alias{amplicon.plot}
\title{Create an amplicon plot  }
\description{
  Given a two-sample test statistic and an exprSet this function plots
  regions of the genome that are either highly expressed (in red) or
  have low expression (blue) differentially in the two groups.
}
\usage{
amplicon.plot(ESET, FUN, genome)
}
\arguments{
  \item{ESET}{an object of class \code{exprSet}}
  \item{FUN}{A two sample test function suitable for \code{\link{esApply}}. }
  \item{genome}{A character string of the base name for the annotation. }
}
\details{
  In some genetic studies we are interested in finding regions of the
  genome where there are a set of highly expressed genes in some
  subgroup of the population. This set of highly (or lowly) expressed
  genes is often of great interest. For example in breast cancer the
  HER--2 gene is on an amplicon. In some patients approximately 5 genes
  located near HER--2 are all amplified.

  These plot should help in the search for such regions.
}
\value{
  No value is returned. This function is executed purely for side
  effect.
}

\author{Robert Gentleman }

\seealso{\code{\link{esApply}}, \code{\link{make.chromOrd}}}

\examples{
  ##none yet; takes too long
}
\keyword{ hplot }

\eof
\name{cColor}
\alias{cColor}
\title{A function for marking specific probes on a cPlot. }
\description{
  Given a set of probes, will highlight them in the color desired on
  a plot which has already been created via the function cPlot().
}
\usage{
cColor(probes, color, plotChroms, scale=c("relative","max"),glen=0.4)
}
\arguments{
  \item{probes}{The probes that are being highlighted.}
  \item{color}{The color to highlight the probes.}
  \item{plotChroms}{An object of type \code{chromLocation} which contains all
    the gene information to be plotted. }
  \item{scale}{Whether to plot the graph scaled absolutely or relative
    by chromosome.  Default is absolute.}
  \item{glen}{The length of the gene line plotted}
}
\details{
  It is important to call the function \code{cPlot()} first.  This function
  will then search for the specific locations of the probes desired,
  which are contained within the \code{plotChroms} instance of a
  \code{chromLocation} class.  It will then pass these on to the
  plotting routine to highlight the desired locations.  NOTE:  It
  is important that \code{plotChroms}, \code{scale} and \code{glen}
  parameters are the same as used for \code{cPlot()}.
}
\author{Jeff Gentry}
\seealso{
  \code{\link{cPlot}}, \code{\link{chromLocation-class}}
}
\examples{
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {

     z <- buildChromLocation("hgu95av2")
     cPlot(z)
     probes <- c("266_s_at", "31411_at", "610_at", "failExample")
     cColor(probes, "red", z)
     probes2 <- c("960_g_at", "41807_at", "931_at", "39032_at")
     cColor(probes2, "blue", z)
 } else print("Need hgu95av2 data package to run example")
}
\keyword{utilities}


\eof
\name{cPlot}
\alias{cPlot}
\title{A plotting function for chromosomes. }
\description{
  Given a chromLocation object, will plot all the gene locations from
  that object.
}
\usage{
cPlot(plotChroms, useChroms=chromNames(plotChroms),
      scale=c("relative","max"), fg="white", bg="lightgrey", glen=0.4)
}
\arguments{
  \item{plotChroms}{An object of type chromLocation which contains all
    the gene information to be plotted. }
  \item{useChroms}{A vector of chromosome names to be used in the plot.
  Default is to use all the chromosomes from the plotChroms object.}
  \item{scale}{Passed on to cScale as it's scale argument.  Determines
    whether the graph is scaled on a relative or absolute basis.}
  \item{fg}{The colour to be used for the genes.  Default is white.}
  \item{bg}{The colour to be used for the background of the plot.
    Defaults to lightgrey/}
  \item{glen}{A scaling factor applied to the plotted length of each
    gene.  Defaults to 0.4 - it is recommended that this not be set
    larger then 0.5 as it will cause overlap between chromosomes.}
}
\details{
  This function will first use the lengths of the chromosomes, stored in
  the object to create scaling factors for the X axis.  Once the
  scaling factors are determined, the \code{chromLocation} object which is
  passed in is used to determine all the gene locations/strand
  information/etc, which is then plotted for the user.
}
\author{Jeff Gentry}
\seealso{\code{\link{cScale}}, \code{\link{cColor}},
  \code{\link{chromLocation-class}}}
\examples{
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
    z <- buildChromLocation("hgu95av2")

     if (interactive()) {
       par(ask=TRUE)
     }

     for (sc in c("max","relative"))
       cPlot(z,c("1","5","10","X","Y"),sc)
  } else print("This example can not be run without hgu95av2 data package")
}
\keyword{utilities}


\eof
\name{cScale}
\alias{cScale}
\title{A function for mapping chromosome length to a number of points. }
\description{
  Given a number of points (generally representing the number of points
  on a plot's axis), and a vector of chromosome lengths - will generate
  a vector of the same length as the one passed in containing scaling
  factors for each chromosome.
}
\usage{
cScale(points, cLengths, method=c("relative","max"), chrom)
}
\arguments{
  \item{points}{The number of points to scale the chromosome length to.}
  \item{cLengths}{A vector of chromosome lengths. }
  \item{method}{Determines whether to use relative or absolute scaling.
    Default is "max" (absolute).}
  \item{chrom}{Which chrom to determine the scale for}
}
\details{
  The scale factor is calculated in a manner based on the \code{method}
  argument.  If method is \code{max}, the factor is derived by dividing the
  points argument by each chromosome's length (in base pairs).  If the
  method chosen is \code{relative}, then the scale is determined by dividing
  the points argument by the maximum chromsome length, and applying that
  value to each chromosome.
}
\author{Jeff Gentry}
\seealso{\code{\link{cPlot}}}
\examples{

   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
      z <- buildChromLocation("hgu95av2")

     for (sc in c("max","relative"))
       scale <- cScale(1000, chromLengths(z),sc,"Y")
   } else print("This example needs the hgu95av2 data package")
}
\keyword{utilities}


\eof
\name{colorRampPalette}
\alias{colorRampPalette}
\alias{colorRamp}
\title{Extend a color palette to a color ramp }
\description{
These functions are useful for converting hand-designed `sequential' or `diverging' color schemes into continous color ramps eg for image and filled contour plots.
}
\usage{
colorRampPalette(palette, bias = 1,method=c("linear","spline"))
colorRamp(palette, bias=1,method=c("linear","spline"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{palette}{A vector of colors}
  \item{bias}{Bias >1 puts more colors at high values, <1 puts more at low values}
\item{method}{Interpolation method. Spline interpolation may give smoother results but can end up outside the valid RGB space, especially with highly saturated palettes or those based on a small starting set.}
}

\value{
\code{colorRampPalette} returns a palette generating function like \code{\link{terrain.colors}} or \code{\link{heat.colors}} that takes an integer argument and generates a palette with that many colors.

\code{colorRamp} returns a color generating function, that takes a number between 0 and 1 and generates the corresponding color.

}
\author{Thomas Lumley}

\seealso{\url{www.colorbrewer.org} }

\examples{
   m<-outer(1:20,1:20,function(x,y) sin(sqrt(x*y)/3))

   redblue<-colorRampPalette(c("red","orange","blue"))
   filled.contour(m,color.palette=redblue)

   yb<-colorRampPalette(c("yellow2","goldenrod","darkred"))
   filled.contour(m,color.palette=yb)

   yb<-colorRampPalette(c("yellow2","goldenrod","darkred"),bias=0.5)
   filled.contour(m,color.palette=yb)

   ## Two ColorBrewer sequential palettes
   ylOrBn4<-c("#FFFFD4", "#FED98E", "#FE9929","#CC4C02")
   ylGnBl5<-c("#FFFFCC","#C7E9B4","#7FCDBB","#40B6C4","#2C7FB8" ,"#253494")

   ylOrBn<-colorRampPalette(ylOrBn4)
   ylGnBl<-colorRampPalette(ylGnBl5,method="spline")
   filled.contour(m,color.palette=ylOrBn)
   filled.contour(m,color.palette=ylGnBl)

   if(require("RColorBrewer")){
	RdBu7<-colorRampPalette(brewer.pal(7,"RdBu"),method="spline")
        RWB<-colorRampPalette(c("red","white","blue"))
        redblue<-colorRampPalette(c("red","blue"))
	filled.contour(m,color.palette=redblue,main="naive red-blue")
        filled.contour(m,color.palette=RWB,main="naive red-white-blue")
        filled.contour(m,color.palette=RdBu7,main="ColorBrewer RdBu7")
   }

}
\keyword{color}% at least one, from doc/KEYWORDS

\eof
\name{identifyLines}
\alias{identifyLines}
\title{A function for identifying sample lines on an alongChrom()
  plot. }
\description{
  Given an environment returned from alongChrom(), will call identify()
  on the alongChrom() plot.
}
\usage{
identifyLines(identEnvir,...)
}
\arguments{
  \item{identEnvir}{An environment created by alongChrom.}
  \item{...}{Any extra arguments are passed on to identify().}
}
\details{
  The environment contains two vectors of points - "X" and "Y" are their
  labels, and contain the X and Y points respectively.  These vectors
  are extracted out of the environment and fed into an identify() call
  (with some extra processing to get the labeling correct.)  As with
  identify(), one need only to right click to exit from the function.
}
\author{Jeff Gentry}
\seealso{
  \code{\link{alongChrom}}, \code{\link{identify}}.
}
\examples{
   data(eset)

   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
     z <- buildChromLocation("hgu95av2")
     lty <- c(1, 2, 3, 4, 5)
     cols <- c("red", "green", "blue", "orange", "magenta", "black")
     identEnv <- alongChrom(eset,"1", z, xloc="equispaced",
                          plotFormat="cumulative", scale="none",
                          lty,cols)
     if (interactive()) {
       identifyLines(identEnv)
     }
  } else print("This example needs the hgu95av2 data package")
}
\keyword{utilities}

\eof
\name{make.chromOrd}
\alias{make.chromOrd}
\title{Make a chromOrd object  }
\description{
  This function makes a chromOrd object.
}
\usage{
make.chromOrd(genome, gnames)
}
\arguments{
  \item{genome}{A character string. }
  \item{gnames}{A character vector of the genes to be selected. }
}
\details{
  This function reads in a lot of annotation data and creates a list
  with one element for each chromosome. The elements of this list are
  indices indicating the order of the genes that are on that chromosome
  (and in the annotation data set being used).
}
\value{
 A list of chromOrd type. One element for each chromosome. Suitable for
 reordering other values according to the chromosomal location.
}

\author{ Robert Gentleman }

\seealso{ \code{\link{amplicon.plot}} }

\examples{
  data(eset)
  make.chromOrd("hgu95A", geneNames(eset))
}
\keyword{ utilities }

\eof
