\name{bg.adjust.gcrma}
\alias{bg.adjust.gcrma}
\alias{bg.parameters}
\title{Background ajustment with sequence information (internal function)}
\description{
An internal function to be used by \code{\link{bg.correct.gcrma}}.
}
\usage{
bg.adjust.gcrma(Data, gcgroup, estimate = c("eb", "mle"), rho = 0.8, 
    step = 60, lower.bound = 1, baseline = 0.25,triple.goal, ...) 
%bg.parameters(pm, n.pts = 2^14)
}
\arguments{
  \item{Data}{matrix of 2 columns, column 1: pm intensities,column 2: mm intensities.}
  \item{gcgroup}{A list of indexes indicating G,C strata.}
  \item{estimate}{method of background correction, "eb" for empirical Bayes, "mle" for maximum likelihood} 
   \item{rho}{correlation coefficient of log background intensity in a pair of pm/mm probes. Default=.8.}
  \item{baseline}{For estimate="mle" only. The lowest log(expression) value allowed. Default=.25}
  \item{lower.bound}{For estimate="eb" only. Lower bound of signal intensity allowed a priori. Default=1.}
   \item{triple.goal} {logical value. If \code{TRUE} Shen and Louis'
    triple-goal adjustment is used.}
   
  \item{step}{a parameter in approximating "eb" estimates.}
  \item{...}{extra arguments to pass to bg.adjust.}

}
\details{ Assumes PM=background1+signal,mm=background2, (log(background1),log(background2))'
follow bivariate normal distribution, signal distribution follows power law.
\code{bg.parameters.gcrma} and \code{sg.parameters.gcrma}
provide adhoc estimates of the parameters.}
\value{a vector of length nrow(Data).}
\seealso{\code{\link{bg.correct.gcrma}}}
\author{Jean Wu, Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{bg.correct.gcrma}
\alias{bg.correct.gcrma}
\title{Background Correction Using sequence information}
\description{
Background corrects probe intensities in an object of class
\code{\link[affy:AffyBatch-class]{AffyBatch}}.
}
\usage{
bg.correct.gcrma(object,gcgroup=getGroupInfo(Dilution)),...)
}

\arguments{
  \item{object}{An object of class \code{\link[affy:AffyBatch-class]{AffyBatch}}.}
  \item{gcgroup}{A list of indexes indicating G,C strata.}
  \item{...}{estimate:method of background correction, "eb" for empirical Bayes, "mle" for maximum likelihood. 

rho:correlation coefficient of log background intensity in a pair of pm/mm probes. Default=.8.

baseline:For estimate="mle" only. The lowest log(expression) value allowed. Default=.25

lower.bound:For estimate="eb" only. Lower bound of signal intensity allowed a priori. Default=1.
}}
\details{Assumes PM=background1+signal,mm=background2, (log(background1),log(background2))'
follow bivariate normal distribution, signal distribution follows power law.
\code{bg.parameters.gcrma} and \code{sg.parameters.gcrma} provide
 adhoc estimates of the parameters.}

\value{
  An \code{\link[affy:AffyBatch-class]{AffyBatch}} for which the PM
  intensities have been background adjusted and MMs remain the
  same. 
}

\examples{
 require(affydata)
data(Dilution)
Dil.adj<-bg.correct.gcrma(Dilution,gcgroup=getGroupInfo(Dilution),estimate="mle")}
\author{Jean Wu, Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS

\eof
\name{bg.parameters.gcrma}
\alias{bg.parameters.gcrma}
\alias{sg.parameters.gcrma}
\alias{average}
\alias{PAV}
\title{Estimating parameters for gcrma background correction}
\description{
An internal function to be used by \code{\link{bg.adjust.gcrma}}.
}
\usage{
bg.parameters.gcrma(mm,gcgroup,n.pts=2^10,adjust=1)
sg.parameters.gcrma(pm,pars.bg,gcgroup)
}
\arguments{
  \item{mm}{A vector of mm intensities on an array}
   \item{pm}{A vector of pm intensities on an array}
  \item{gcgroup}{A list of indexes indicating G,C strata. Array type must match that of the mm.}
  \item{pars.bg}{A matrix returned by bg.parameters.gcrma} 
  \item{n.pts}{number of points to use in call to `density'.}
  \item{adjust}{The parameter "adjust" used in function
    \code{density}.See help for  \code{density} for details.}
}
\details{}
\value{
  bg.parameters.gcrma returns a matrix.
   sg.parameters.gcrma returns a vector.}
\seealso{\code{\link{bg.adjust.gcrma}}}
\author{Jean Wu, Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{gcrma}
\alias{gcrma}
\title{Robust Multi-Array expression measure using sequence information}
\description{
  This function converts an `AffyBatch' into an `exprSet' using the
     robust multi-array average (RMA) expression measure with help of probe sequence.
}
\usage{
gcrma(object,estimate="eb",summary.method = "rlm",summary.subset=geneNames(object)[1:10]),...)
}
\arguments{
   \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{estimate}{"eb" or "mle". An character indicating background correction method.
"eb" for empirical Bayes, "mle" for maximum likelihood} 
  \item{summary.method}{"medianpolish" or "rlm". Method to extract the expression value of a probeset from  background adjusted intensities. }
 \item{normalize}{logical value. If \code{TRUE} normalize data using
    normalize.method (default as quantile normalization)}
  \item{rho}{correlation coefficient of log background intensity in a pair of pm/mm probes. Default=.8}
  \item{triple.goal} {logical value. If \code{TRUE} Shen and Louis'
 triple-goal adjustment is used.}
  \item{baseline}{For estimate="mle" only. The lowest log(expression) value allowed. Default=.25}
  \item{lower.bound}{For estimate="eb" only. Lower bound of signal intensity allowed a priori. Default=1.}
  \item{step}{a parameter in approximating "eb" estimates.}
}
\details{
  Note that this expression measure is given to you in log base 2
     scale. This differs from most of the other expression measure
     methods.
}
\value{
 An `exprSet'
}
\author{Jean Wu, Rafeal Irizarry}
\references{Wei Shen and Thomas Louis.  Triple-goal estimates in
  two-stage hierarchical models. J.R.Statist.Soc.B(1998)}
   


\examples{
require(affydata)
data(Dilution)
Dil.expr<-gcrma(Dilution,estimate="mle",summary.method = "medianpolish",summary.subset=geneNames(Dilution)[1:10])

}
\keyword{manip}

\eof
\name{gcrma.rlm}
\alias{gcrma.rlm}
\title{robust linear model for ProbeSet}
\description{
An internal function to be used by \code{\link{bg.correct.gcrma}}.
}
\usage{
gcrma.rlm(x,maxit=50,k=.5)
}
\arguments{
  \item{x}{A matrix. By rows are intensities of probes in a probeset,by columns are intensities of a probe on arrays.} 
  \item{maxit}{maximum iterations in rlm. As maxit in rlm}
 \item{k}{As k in rlm.}
}
\details{}
\value{a list of two elements, estimated expression measure on each array and standard error from rlm}
\author{Jean Wu, Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{generateExprVal.method.rlm}
\alias{generateExprVal.method.rlm}
\title{Compute a summary expression value from the probes intensities}
\description{
  Compute a summary expression value from the probes intensities
}
\usage{
generateExprVal.methods # vector of names of methods
generateExprVal.method.rlm(probes,...)
}
\arguments{
  \item{probes}{A matrix. By rows are intensities of probes in a probeset,by columns are intensities of a probe on arrays.} 
  \item{...}{maxit:maximum iterations in rlm. As maxit in rlm
  
             k: As k in rlm.}
}
\value{
  Returns a vector of expression values.
}

\keyword{manip}

\eof
\name{getGroupInfo}
\alias{getGroupInfo}
\title{Group probes by G/C contents in sequence}
\description{
An internal function to be used by \code{\link{bg.adjust.gcrma}}.
}
\usage{
getGroupInfo(object)
}
\arguments{
  \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
}
\details{ Probes with known sequences are grouped into 5X5 strata according to number of C/G bases, probes without available sequences are grouped into the 26th stratum.}
\value{a list of 26 elements}
\author{Jean Wu, Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
