\name{contrastTest}
\alias{contrastTest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{'contrastTest' performs simultaneous tests of linear contrasts on the parameters estimates from a linear model. }
\description{
'contrastTest' performs an F test for simultaneous tests of linear contrasts using an appropriately specified lambda matrix and an lm object.
}
\usage{
contrastTest(model, lambda, cVec = NA, p = 0.01)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{An lm object. }
  \item{lambda}{A matrix of coefficients in the appropriate order to be multiplied by the estromated coefficients of the lm object. }
  \item{cVec}{A vector of constants for testing that the linear contrasts equal something other than zero.  If this is unspecified, it is assumed to be zero. }
  \item{p}{The significance level at which to perform the contrast test. }
}
%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}
\value{
  \item{test }{Returns "REJECT" or "FAIL TO REJECT" based on the result of the test of hypothesis.}
  \item{pvalue}{The pvalue from the F test.}
  \item{cEst}{The contrast estimate.}
}
%\references{ ~put references to the literature/web site here ~ }
\author{Denise Scholtens}
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{par2lambda}},\code{\link{lm}}  }
\examples{

data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]   
fit <- lm(exprs(estrogen)[6,] ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("TIME48h","ESP:TIME48h"))
coefs <- list(c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
contrastTest(fit,lambda)




}
\keyword{models }
\keyword{design }
\keyword{htest }

\eof
\name{estrogen}
\alias{estrogen}
\docType{data}
\title{Microarray Data from an Experiment on Breast Cancer Cells}
\description{
  Gene expression levels for 500 genes from a 2x2 factorial experiment on MCF7 breast cancer cells using Affymetrix HGU95av2 arrays.  
}
\usage{data(estrogen)}
\format{
  
 An exprSet with 500 genes, 8 samples, and 2 variables.

}
\details{
The factors in this experiment were estrogen (ES: P or A) and length of exposure (TIME: 10 or 48 hours).   Gene expression values were estimated using the PM-only method in dChip after normalization using the Invariant Set Method (Li and Wong, 2001).
}
\source{
  Scholtens et al.  Analyzing Factorial Designed Microarray Experiments.  Journal of Multivariate Analysis.  To appear. 
}
\references{
  Li and Wong (2001).  Model-based analysis of oligonucleotide arrays: Expression index computation and outlier detection.  PNAS. 98:31-36.
}
\examples{
data(estrogen)
pData(estrogen)
plot(exprs(estrogen)[1,])
}
\keyword{datasets}

\eof
\name{findFC}
\alias{findFC}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{A function to find the fold change between two experimental conditions in a factorial experiment based on the linear model parameter estimates. }
\description{

'findFC' constructs a point estimate of fold change using the linear model coefficients in an lm object.  

}
\usage{
findFC(model, lambdaNum, lambdaDenom)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{An lm object.}
  \item{lambdaNum}{A numeric vector of coefficients for the parameters to be used in the numerator of the fold change estimate. }
  \item{lambdaDenom}{A numeric vector of coefficients for the parameters to be used in the denominator of the fold change estimate. }
}
%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}
\value{
  A point estimate of the fold change between the experimental conditions specified in the lambdaNum and lambdaDenom vectors.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Denise Scholtens}
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{par2lambda}}, \code{\link{findFClog}}}
\examples{

data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]   
fit <- lm(exprs(estrogen)[6,] ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("(Intercept)","ESP","TIME48h","ESP:TIME48h"),
					c("(Intercept)","ESP"))
coefs <- list(c(1,1,1,1),c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
findFC(fit,lambda[1,],lambda[2,])




}
\keyword{models }
\keyword{design }

\eof
\name{findFClog}
\alias{findFClog}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A function to find the fold change between two experimental conditions in a factorial experiment based on the linear model parameter estimates for the data that has been log-transformed.}
\description{

'findFClog' contructs a point estimate of fold change using the linear model coefficients in an lm object for data that has been log-transformed.

}
\usage{
findFClog(model, lambdaNum, lambdaDenom)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{An lm object.}
  \item{lambdaNum}{A numeric vector of coefficients for the parameters to be used in the numerator of the fold change estimate. }
  \item{lambdaDenom}{A numeric vector of coefficients for the parameters to be used in the denominator of the fold change estimate.}
}
%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}
\value{
A point estimate of the fold change between the experimental conditions specified in the lambdaNum and lambdaDenom vectors for data that has been log-transformed for the linear model estimation.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Denise Scholtens }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{par2lambda}}, \code{\link{findFC}}}
\examples{
data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]
fit <- lm(log(exprs(estrogen)[6,]) ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("(Intercept)","ESP","TIME48h","ESP:TIME48h"),
					c("(Intercept)","ESP"))
coefs <- list(c(1,1),c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
findFClog(fit,lambda[1,],lambda[2,])




}
\keyword{ models }
\keyword{ design }

\eof
\name{kRepsOverA}
\alias{kRepsOverA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{A filter function for at least k sets of replicates in a factorial experiment to have mean larger than A.}
\description{
`kRepsOverA' returns a filter function with bindings for `k' and `A'.  This function evalutes `TRUE' is at least `k' of the means of the replicates are larger than `A'.
}
\usage{
kRepsOverA(k, A = 100, INDEX)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{k}{The number of sets of replicates with mean greater than A.}
  \item{A}{The value to exceed. }
  \item{INDEX}{List of factors, each of the same length as the input vector. }
}
%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}
\value{
  A function with bindings for `A', `k', and `INDEX'.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Denise Scholtens }
%\note{ ~~further notes~~ }

%~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{kOverA}},\code{\link{pOverA}} }
\examples{

library(affy)
library(genefilter)
data(estrogen)
f1 <- kRepsOverA(1,100,INDEX=phenoData(estrogen))
genefilter(estrogen[1:30],f1)

}
\keyword{design }
\keyword{univar }

\eof
\name{madOutPair}
\alias{madOutPair}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{A function to determine if the pair with the largest difference between replicates is the result of a single outlier. }
\description{
This function is intended to be used in conjunction with outlierPair.  After outlierPair detects a pair of replicate observations with a significantly large difference between the observations, madOutPair uses median absolute deviation criteria for determining if one of the replicates is a single outlier.
}
\usage{
madOutPair(x, whichPair, c = 4)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A vector of observations. }
  \item{whichPair}{A result of outlierPair, recording which pair has largest difference between replicate observations. }
  \item{c}{The number of median absolute deviations to be used as a cutoff for determining single outliers.  }
}
\details{

Once pairs with significantly large differences are identified using outlierPair, madOutPair is applied.  If only one of the tagged replicates falls outside the range of (med(x)-c*mad(x),med(x)+c*mad(x)), the observation is designated the single outlier.

}
\value{
  The index of the single outlier observation, or "NA" if no single outliers are detected.
}
\references{Scholtens et al. Analyzing Factorial Designed Microarray Experiments.  Journal of Multivariate Analysis.  To appear.  }
\author{Denise Scholtens }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{outlierPair}}}
\examples{

data(estrogen)
outP <- outlierPair(exprs(estrogen)[247,],INDEX=pData(estrogen))[["whichPair"]]
madOutPair(exprs(estrogen)[247,],outP)
outP <- outlierPair(exprs(estrogen)[495,],INDEX=pData(estrogen))[["whichPair"]]
madOutPair(exprs(estrogen)[495,],outP)


}
\keyword{models }
\keyword{design }


\eof
\name{outlierPair}
\alias{outlierPair}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A method for detecting single outliers in experimental designs with only two replicates per treatment condition. }
\description{

This function detects pairs of observations with unexpectedly large differences compared to the rest of the data.  Pairs with large differences may include single outlier observations.

}
\usage{
outlierPair(x, INDEX, p = 0.05, na.rm = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A vector of observations. }
  \item{INDEX}{A list of factors, each the same length as x, used to indicate the replicate observations. }
  \item{p}{The significance level at which to perform the test. }
  \item{na.rm}{If TRUE, will remove missing values.}
}
\details{
This outlier detection method is useful for small factorial designs in which the usual residuals from a linear model would have a large number of linear dependencies compared to the actual number of residuals.  The function first calculates n difference between 2n replicates (call these pure residuals), and then constructs an F-statistic: f=(large squared p.r.)/((sum of remaining squared p.r.'s)/(n-1)).  An p-value (adjusted for taking the largest of the p.r.'s) is calculated by n*Pr(F(1,n-1)>f). If f>=n-1, this p-value is exact, otherwise it is an upper bound.
}
\value{

  \item{test}{Returns TRUE if an outlier pair is detected at the specified level of significance p.}
  \item{pval}{The actual value of n*Pr(F(1,n-1)>f).}
  \item{whichPair}{The index of the pair of observations with the largest difference.}
}
\references{Scholtens et al.  Analyzing Factorial Designed Microarray Experiments.  Journal of Multivariate Analysis.  To appear. }
\author{Denise Scholtens}
%\note{ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{madOutPair}} }
\examples{

data(estrogen)

outlierPair(exprs(estrogen)[1,],INDEX=pData(estrogen),p=.05)
outlierPair(exprs(estrogen)[247,],INDEX=pData(estrogen),p=.05)
outlierPair(exprs(estrogen)[495,],INDEX=pData(estrogen),p=.05)







}
\keyword{models }
\keyword{design }

\eof
\name{par2lambda}
\alias{par2lambda}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{A function to construct the appropriate lambda matrix for a test of contrast of linear model parameters. }
\description{

'par2lambda' takes list of lm coefficient names and a corresponding list of numeric vectors corresponding to hypothesis tests of linear contrasts and returns a lambda matrix suitable for an F-test of the linear contrasts.  'par2lambda' is intended to be used in conjunction with 'contrastTest', 'findFC', or 'findFClog'.

}
\usage{
par2lambda(betaNames, betas, coefs)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{betaNames}{A character vector of the names of the coefficients in a linear model. }
  \item{betas}{A list of vectors of the parameters to be used in the contrasts. }
  \item{coefs}{A list of vectors of numeric coefficients corresponding to betas. }
}
%\details{
%}
\value{
A lambda matrix constructed for testing linear contrasts using lm output.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Denise Scholtens }
%\note{ ~~further notes~~ }

\seealso{\code{\link{contrastTest}},\code{\link{findFC}},\code{\link{findFClog}} }
\examples{
data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]
fit <- lm(exprs(estrogen)[1,] ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("ESP","ESP:TIME48h"),c("TIME48h","ESP:TIME48h"))
coefs <- list(c(1,1),c(1,1))
par2lambda(betaNames,betas,coefs)

}
\keyword{models }
\keyword{design }

\eof
