\name{hc2Newick}
\alias{hc2Newick}
\title{Convert hclust objects to Newick format files}
\description{
  Convert hclust objects to Newick format files.
}
\usage{
  hc2Newick(hc, flat=TRUE)
}
\arguments{
  \item{hc}{a \code{hclust} object (as returned by the function \code{hclust}
    in the package \code{mva})}
  \item{flat}{a boolean (see section value).}
}
\value{
  If \code{flat=TRUE} the result is a string (that you can write in a
  file).

  If \code{flat=FALSE} the result is a list (of lists). Each list
  is consituted of the elements \code{left}, \code{right} and \code{dist}.  
}

\author{
  Laurent (laurent@cbs.dtu.dk)
}
\keyword{manip}

\eof
\name{r2cluster}
\alias{r2cluster}
\title{Write to Cluster file format}
\description{Converting data to Cluster format}
\usage{
r2cluster(data,labels=FALSE,colname="ACC",description=FALSE,file="cluster.txt",dec='.')
}

\arguments{
  \item{file}{the path of the file}
  \item{data}{a matrix (or data frame) which provides the data to put into the file} 
  \item{labels}{a logical value indicating whether we use the frist
    column as labels (UNIQID column for cluster file)}
  \item{colname}{Should be one of: YORF,MCLID,CLID,ACC}
   \item{description}{a logical value indicating whether we use the second column as description (NAME column for cluster file)}
   \item{dec}{the character used in the file for decimal points}  
}


\note{
\emph{Cluster} is a program made by \emph{Michael Eisen} that performs
hierarchical clustering, K-means and SOM. 

\emph{Cluster} is copyrighted. 
To get or have information
about
\emph{Cluster}: \url{http://rana.lbl.gov/EisenSoftware.htm}
}

\examples{
#    Create data
.Random.seed <- c(1,  416884367 ,1051235439)
m <- matrix(rep(1,3*24),ncol=3)  
m[9:16,3] <- 3 ; m[17:24,] <- 3    #create 3 groups
m <- m+rnorm(24*3,0,0.5)           #add noise
m <- floor(10*m)/10                #just one digits

r2cluster(m)

}
\keyword{file}

\author{Antoine Lucas, \url{http://genopole.toulouse.inra.fr/~lucas/R}}
\seealso{\code{\link{xcluster}}, \code{\link{r2xcluster}}, \code{\link[mva]{hclust}}}

\eof
\name{r2gtr}
\alias{r2gtr}
\alias{r2atr}
\alias{r2cdt}
\title{Write to gtr, atr, cdt file format}
\description{Write data frame and hclust object to gtr atr,
  cdt files (Xcluster or Cluster output).
  Visualisation of cluster can be
  done with tools like treeview}
\usage{
r2gtr(hr,file="cluster.gtr",distance="euclidean",dec='.',digits=5)
r2atr(hc,file="cluster.atr",distance="euclidean",dec='.',digits=5)
r2cdt(hr,hc,data,labels=FALSE,description=FALSE,file="cluster.cdt",dec='.')
}

\arguments{
  \item{file}{the path of the file}
  \item{data}{a matrix (or data frame) which provides the data to put into the file} 
  \item{hr,hc}{objects of class hclust (rows and columns)}
  \item{distance}{The distance measure used. This must be one of
          `"euclidean"', `"maximum"', `"manhattan"', `"canberra"' or
          `"binary"'. Any unambiguous substring can be given.} 
  \item{digits}{number digits for precision} 
  \item{labels}{a logical value indicating whether we use the frist column as labels (NAME column for cluster file)}
  \item{description}{a logical value indicating whether we use the second column as description (DESCRIPTION column for cluster file)}
  \item{dec}{the character used in the file for decimal points}

}

\examples{
#    Create data
.Random.seed <- c(1,  416884367 ,1051235439)
m <- matrix(rep(1,3*24),ncol=3)  
m[9:16,3] <- 3 ; m[17:24,] <- 3    #create 3 groups
m <- m+rnorm(24*3,0,0.5)           #add noise
m <- floor(10*m)/10                #just one digits

library(mva)
# Cluster columns
hc <- hclust(dist(t(m)))
# Cluster rows
hr <- hclust(dist(m))

# Export files
r2atr(hc,file="cluster.atr")
r2gtr(hr,file="cluster.gtr")
r2cdt(hr,hc,m ,file="cluster.cdt")

}
\keyword{cluster}

\author{Antoine Lucas, \url{http://genopole.toulouse.inra.fr/~lucas/R}}
\seealso{\code{\link{r2xcluster}}, \code{\link{xcluster2r}},\code{\link[mva]{hclust}}}

\eof
\name{r2xcluster}
\alias{r2xcluster}
\title{Write to Xcluster file format}
\description{Converting data to Xcluster format}
\usage{
r2xcluster(data,labels=FALSE,description=FALSE,file="xcluster.txt")
}

\arguments{
  \item{file}{the path of the file}
  \item{data}{a matrix (or data frame) which provides the data to put into the file} 
   \item{labels}{a logical value indicating whether we use the frist column as labels (NAME column for cluster file)}
   \item{description}{a logical value indicating whether we use the second column as description (DESCRIPTION column for cluster file)}
}


\note{
\emph{Xcluster} is a C program made by \emph{Gavin Sherlock} that performs
hierarchical clustering, K-means and SOM. 

\emph{Xcluster} is copyrighted. 
To get or have information
about
\emph{Xcluster}: \url{http://genome-www.stanford.edu/~sherlock/cluster.html}
}

\examples{
#    Create data
.Random.seed <- c(1,  416884367 ,1051235439)
m <- matrix(rep(1,3*24),ncol=3)  
m[9:16,3] <- 3 ; m[17:24,] <- 3    #create 3 groups
m <- m+rnorm(24*3,0,0.5)           #add noise
m <- floor(10*m)/10                #just one digits

r2xcluster(m)

# And once you have Xcluster program:

#system('Xcluster -f xcluster.txt -e 0 -p 0 -s 0 -l 0')
#h <- xcluster2r('xcluster.gtr')
#library(mva)
#plot(h,hang=-1)
}
\keyword{file}

\author{Antoine Lucas, \url{http://genopole.toulouse.inra.fr/~lucas/R}}
\seealso{\code{\link{xcluster}}, \code{\link{xcluster2r}}, \code{\link[mva]{hclust}}}

\eof
\name{xcluster}
\alias{xcluster}
\title{Hierarchical clustering}
\description{Performs a hierarchical cluster analysis on a set of
     dissimilarities.}
\usage{
xcluster(data,distance="euclidean",clean=FALSE,tmp.in="tmp.txt",tmp.out="tmp.gtr")
}

\arguments{
  \item{data}{a matrix (or data frame) which provides the data to analyze} 
  \item{distance}{The distance measure used with \emph{Xcluster}. This must be one of
    \code{"euclidean"}, \code{"pearson"} or \code{"notcenteredpearson"}.
    Any unambiguous substring can be given.}
    \item{clean}{a logical value indicating whether you want the true
    distances (\code{clean=FALSE}), or you want a clean dendogramme}
    \item{tmp.in, tmp.out}{temporary files for Xcluster}
}

\details{
  Available distance measures are (written for two vectors \eqn{x} and
  \eqn{y}): 
  \itemize{
    \item Euclidean: Usual square distance between the two vectors (2 norm).
    \item Pearson: \eqn{1- \mbox{cor}(x,y)}{1 - cor(x,y)}
    \item Pearson not centered: \eqn{1 - \frac{\sum_i x_i y_i}{\left(\sum_i x_i^2
     \sum_i y_i^2 \right) ^{1/2}}   }{1 - [ sum x_i y_i ] / sqrt[ sum x_i^2 * sum y_i^2 ] }
    }
    
Xcluster does not use usual agglomerative methods (single, average, complete),
but    compute  the distance between each 
    groups' barycenter  for the distance between two groups.

This have a problem for this kind of data:

\tabular{rll}{
A     \tab  0   \tab     0\cr
B     \tab  0   \tab     1\cr
C     \tab   0.9   \tab  0.5\cr
}

Ie: a triangular in {\bf R}$^2$, the distance between A and B is larger
than the distance between the group A,B and C (with euclidean distance).

For that case it can be useful to use \code{clean=TRUE} and that mean
that you must not consider A and B as a group without C.
}


\value{
  An object of class \bold{hclust} which describes the
  tree produced by the clustering process.
  The object is a list with components:

  \item{merge}{an \eqn{n-1} by 2 matrix.
    Row \eqn{i} of \code{merge} describes the merging of clusters
    at step \eqn{i} of the clustering.
    If an element \eqn{j} in the row is negative,
    then observation \eqn{-j} was merged at this stage.
    If \eqn{j} is positive then the merge
    was with the cluster formed at the (earlier) stage \eqn{j}
    of the algorithm.
    Thus negative entries in \code{merge} indicate agglomerations
    of singletons, and positive entries indicate agglomerations
    of non-singletons.}

  \item{height}{a set of \eqn{n-1} non-decreasing real values.
    The clustering \emph{height}: that is, the value of
    the criterion associated with the clustering
    \code{method} for the particular agglomeration.}

  \item{order}{a vector giving the permutation of the original
    observations suitable for plotting, in the sense that a cluster
    plot using this ordering and matrix \code{merge} will not have
    crossings of the branches.}

  \item{labels}{labels for each of the objects being clustered.}

  \item{call}{the call which produced the result.}

  \item{method}{the cluster method that has been used.}

  \item{dist.method}{the distance that has been used to create \code{d}
    (only returned if the distance object has a \code{"method"}
    attribute).}
}

\note{
\emph{Xcluster} is a C program made by \emph{Gavin Sherlock} that performs
hierarchical clustering, K-means and SOM. 

\emph{Xcluster} is copyrighted. 
To get or have information
about
\emph{Xcluster}: \url{http://genome-www.stanford.edu/~sherlock/cluster.html}
}

\examples{
#    Create data
.Random.seed <- c(1,  416884367 ,1051235439)
m <- matrix(rep(1,3*24),ncol=3)  
m[9:16,3] <- 3 ; m[17:24,] <- 3    #create 3 groups
m <- m+rnorm(24*3,0,0.5)           #add noise
m <- floor(10*m)/10                #just one digits


# And once you have Xcluster program:
#
#h <- xcluster(m)
#
#library(mva)
#plot(h) 
}
\keyword{cluster}

\author{Antoine Lucas, \url{http://genopole.toulouse.inra.fr/~lucas/R}}
\seealso{\code{\link{r2xcluster}}, \code{\link{xcluster2r}},\code{\link[mva]{hclust}}}

\eof
\name{xcluster2r}
\alias{xcluster2r}
\title{Importing Xcluster/Cluster output}
\description{Converting Xcluster/Cluster output (.gtr or .atr) to R hclust file}
\usage{
xcluster2r(file,distance="euclidean",labels=FALSE,fast=FALSE,clean=FALSE,dec='.')
}

\arguments{
  \item{file}{the path of a \emph{Xcluster/Cluster} file (.gtr or .atr)}
  \item{distance}{The distance measure used with \emph{Xcluster/Cluster}. This must be one of
    \code{"euclidean"}, \code{"pearson"} or \code{"notcenteredpearson"}.
    Any unambiguous substring can be given.}
  \item{labels}{a logical value indicating whether we use 
    labels values (in the .cdt file) or not.}
  \item{fast}{a logical value indicating whether we reorganize data
    like R (\code{Fast=FALSE}) or we let them like \emph{Xcluster/Cluster} did} 
  \item{clean}{a logical value indicating whether you want the true
    distances (\code{clean=FALSE}), or you want a clean dendogramme}
  \item{dec}{the character used in the file for decimal points}
}

\details{
See \bold{xcluster} for more details.
}


\value{
  An object of class \bold{hclust} which describes the
  tree produced by the clustering process.
}

\note{
\emph{Xcluster} is a C program made by \emph{Gavin Sherlock} that performs
hierarchical clustering, K-means and SOM. 

\emph{Xcluster} is copyrighted. 
To get or have information
about
\emph{Xcluster}: \url{http://genome-www.stanford.edu/~sherlock/cluster.html}

\emph{Cluster} is a program made by \emph{Michael Eisen} that performs
hierarchical clustering, K-means and SOM. 

\emph{Cluster} is copyrighted. 
To get or have information
about
\emph{Cluster}: \url{http://rana.lbl.gov/EisenSoftware.htm}
}

\examples{
#    Create data
.Random.seed <- c(1,  416884367 ,1051235439)
m <- matrix(rep(1,3*24),ncol=3)  
m[9:16,3] <- 3 ; m[17:24,] <- 3    #create 3 groups
m <- m+rnorm(24*3,0,0.5)           #add noise
m <- floor(10*m)/10                #just one digits

r2xcluster(m)


# And once you have Xcluster program:
#
#system('Xcluster -f xcluster.txt -e 0 -p 0 -s 0 -l 0')
#h <- xcluster2r('xcluster.gtr')
#library(mva)
#plot(h,hang=-1)
}
\keyword{file}

\author{Antoine Lucas, \url{http://genopole.toulouse.inra.fr/~lucas/R}}
\seealso{\code{\link{xcluster}}, \code{\link{r2xcluster}}, \code{\link[mva]{hclust}}}

\eof
