\name{geneInfo}
\alias{geneInfo}
\alias{SNPinfo}
\alias{geneLayout}
\alias{geneSNPs}
\alias{itemsInRange}
\alias{useSNPper}
\alias{useSNPper2}
\alias{ginfoHandler}
\alias{nsnpHandler}
\alias{sinrangeHandler}
\alias{ginrangeHandler}
\alias{snpinfoHandler}
\alias{dot}
\alias{glayHandler}
\alias{outPaste}
\title{use CHIP SNPper XML-RPC service to extract gene or SNP information}
\description{
SNPper is a web service at chip.org (see Riva and Kohane, Bioinformatics 2002).
This function sets up the XML RPC call for the GENEINFO service.
}
\usage{
geneInfo(name=NA, acc=NA, id=NA)
SNPinfo(dbsnpid=NA)
geneLayout(id=NA)
geneSNPs(id=NA, acc=NA)
itemsInRange(item="genes", chr, start, end)
useSNPper(cmd, parmstring)
useSNPper2(cmd, parmstring)
}
\arguments{
  \item{name}{ name: standard gene name}
  \item{acc}{ acc: mrna accession number}
  \item{id}{ id: SNPper gene id.  This is a 'private'
nomenclature, to find the value for a given gene, use
geneInfo.}
  \item{dbsnpid}{ dbsnpid: numeric value after 'rs' in dbSNP id }
  \item{item}{ item: string, either "genes", "snps",
 or "countsnps" }
  \item{cmd}{ cmd: character string identifying an XML-RPC
call honored by SNPPER; see list .rpcCalls in package}
  \item{parmstring}{ parmstring: character string supplying
parm=value information }
  \item{chr}{chr: string beginning with 'chr' identifying
chromosome of interest}
  \item{start}{start: start in base pair count of region
of interest; use a string to avoid problems with scientific notation}
  \item{end}{end: end in base pair count of region
of interest; use a string to avoid problems with scientific notation}
}
\details{
runs an xmlEventParse on the XML-RPC response and packages the
results.
}
\value{
an attributed, named character vector.  The attribute gives
version info for the SNPper database build.
}
\references{Riva A and Kohane IS, SNPper: retrieval and
analysis of human SNPs, Bioinformatics 18(12) 2002, pp1681-1685.  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
\note{The itemsInRange function with item argument 'countsnps'
is a hack that does not use XML parsing because the countsnps
XML-RPC returns illegitimate XML tags.  Thus there is no
toolInfo attribute for this specific call.  All other
functions return textual information coupled with 
a 'toolInfo' attribute which details the SNPper database
version, the golden path build version, and the dbSNP database
version from which the SNPper resources were constructed.

NB: A revised version of the XML package now allows direct
parsing of R connection streams.  This will be employed ASAP,
once the necessary general XML infrastructure becomes prevalent.}


%\seealso{  }

\examples{
if (interactive())
 {
 print(geneInfo("CRP"))
 print(geneLayout("546"))
 tmp <- geneSNPs("546")
 print(length(tmp))
 glist <- itemsInRange("genes","chr1", "155000000", "157000000")
 print(SNPinfo("25"))
 print(length(glist))
 print(itemsInRange("countsnps","chr1", "156000000", "157000000"))
 print(useSNPper("geneinfo","&name=CRP"))
 }
}
\keyword{ models }

\eof
