\name{Am2Al}
\alias{Am2Al}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Convert adjacency matrix to adjacency 'list' in 2xNE format }
\description{
Let NV be the number of nodes of a graph and NE be the number of edges.
This function
converts such an NVxNV adjacency matrix B to a 2 X NE matrix L where NE = sum(B).
The kth column of the matrix represents the edge L[1,k]->L[2,k]
}
\usage{
Am2Al(mat)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{mat}{ a binary square matrix with nc cols representing
a graph with nc vertices}
}
\details{
Note that the resulting matrix has zero-based entries for
convenient use in the Boost library edgelist representation.
}
\value{
2 x NE matrix
}


\examples{
set.seed(223)
V <- 1:10
M <- 1:4
Gm <- randomGraph(V,M,.3)
cat("as adjacency matrix:\n")
print(GmM <- adjMat(Gm))
Gl <- Am2Al(GmM)
cat("as edge list:\n")
print(Gl)
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
\name{FileDep}
\alias{FileDep}
\non_function{}
\title{ FileDep: a graphNEL object representing a file dependency dataset
example in boost graph library }
\description{ FileDep: a graphNEL object representing a file dependency dataset
example in boost graph library }
\usage{#data(FileDep)}
\source{
Boost Graph Library 
}
\references{
}
\examples{
# this is how the graph of data(FileDep) was obtained
library(graph)
fd <- file(system.file("XML/FileDep.gxl",package="RBGL"))
show(fromGXL(fd))
if (require(Rgraphviz))
 {
 data(FileDep)
 plot(FileDep)
 }
}
\keyword{graphs}

\eof
\name{adjMat}
\alias{adjMat}
\title{ adjacency matrix generation for Bioconductor::graph objects }
\description{
}
\usage{
adjMat(x, maxn=100)
}
\arguments{
  \item{x}{ x: an instance of Bioconductor graph}
  \item{maxn}{ maxn: smallest number of nodes beneath which
no query needs to be answered to proceed with matrix construction }
}
\details{
to be supplanted by sparse approach in graph package
}
\value{
}
\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
\note{  }


\seealso{  }

\examples{
set.seed(123)
library(graph)
V <- 1:10
M <- 1:4
g1 <- randomGraph(V,M,.3)
adjMat(g1)
}
\keyword{ graphs }

\eof
\name{bfs}
\alias{bfs}
\alias{dfs}
\alias{dfs,graph-method}
\alias{bfs,graph-method}
\alias{bfs,graph,ANY,ANY-method}
\title{ Breadth and Depth-first search }
\description{
  These functions carry out breadth and depth first search using
  routines from the BOOST library. For \code{dfs} a \code{list}
  containing two \code{vectors} is returned. These indicate the sequence
  in which a node is first visited and last visited. For \code{dfs} a
  single vector is returned indicating the order in which a node was visited.
}
\usage{
bfs(graph, init.node=1, checkConn=FALSE)
\S4method{dfs}{graph}(graph)
\S4method{bfs}{graph}(graph)
}
\arguments{
  \item{graph}{ instance of class graph from Bioconductor graph class}
  \item{init.node}{ index (1 based) of where to start search}
  \item{checkConn}{ logical indicating whether connectivity of
input graph should be checked }
}
\details{
calls to boost bfs or dfs procedures
}
\value{
for bfs: vector of indices in order of BFS visit

for dfs:
list of two vectors of nodes, order of DFS discovery,
and order of DFS completion (finish)
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\examples{
dd <- fromGXL(file(system.file("XML/bfsex.gxl",package="RBGL")))
dd@edgemode <- "undirected"
bfs(dd)
bfs(dd,2)

dd <- fromGXL(file(system.file("XML/dfsex.gxl",package="RBGL")))
dfs(dd)
}
\keyword{ graphs }

\eof
\name{connectedComp}
\alias{connectedComp}
\title{Identify Connected Components in
an Undirected Graph  }
\description{The connected components in
an undirected graph are identified. If the graph is directed then the
weakly connected components are identified.
}
\usage{
connectedComp(g)
}
\arguments{
  \item{g}{ g: graph with \code{edgemode} \dQuote{undirected}}
}
\details{
Uses a depth first search (dfs) approach to identifying all the connected
components of an undirected graph. If the input, \code{g}, is a directed
graph it is first transformed to an undirected graph (using
\code{\link[graph]{ugraph}}). The
mathematical formalism involved can be
found in graph package or in any good book on graph theory.
}

\value{
  A list of length equal to the number of connected components in
  \code{g}. Each element of the list contains a vector of the node
  labels for the nodes that are connected.
}
\references{Boost Graph Library}

\author{ Vince Carey <stvjc@channing.harvard.edu>}
\seealso{\code{\link[graph]{connComp}},\code{\link{strongComp}},
  \code{\link[graph]{ugraph}}}

\examples{
km <- fromGXL(file(system.file("GXL/kmstEx.gxl",package="graph")))
km@nodes <- c(km@nodes,"F","G","H")
km@edgeL$F <- list(edges=numeric(0))
km@edgeL$G <- list(edges=8)
km@edgeL$H <- list(edges=7)
ukm <- ugraph(km)
ukm
edges(ukm)
connectedComp(ukm)
}
\keyword{models }

\eof
\name{dijkstra.sp}
\alias{dijkstra.sp}
\alias{sp.between}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Dijkstra's shortest paths using boost C++ }
\description{
dijkstra's shortest paths
}
\usage{
dijkstra.sp(x,init.ind=1) # now x assumed to be Bioconductor graph graphNEL
sp.between(g,start,finish) # now x assumed to be Bioconductor graph graphNEL
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ instance of class graphNEL from Bioconductor graph class}
  \item{g}{ instance of class graphNEL from Bioconductor graph class}
  \item{init.ind}{ index (1 based) of where to start search}
  \item{start}{ character atom: node name for start of path}
  \item{finish}{ character atom: node name for end of path}
}
\details{
calls to boost dijkstra shortest paths
}
\value{
list of two vectors of nodes, shortest distance to each node,
and penultimate node of shortest path, and of the
staring node, assumes
1-based counting
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }
\note{Very preliminary}

\examples{
dd <- fromGXL(file(system.file("XML/dijkex.gxl",package="RBGL")))
dijkstra.sp(dd)
dijkstra.sp(dd,2)
ospf <- fromGXL(file(system.file("XML/ospf.gxl",package="RBGL")))
dijkstra.sp(ospf,6)
sp.between(ospf, "RT6", "RT1")
if (interactive()) # see an error for query on nonexistent path
sp.between(ospf,"N10", "N13")
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
\name{edgeConnectivity}
\alias{edgeConnectivity}
\title{computed edge connectivity and min disconnecting set
for an undirected graph}
\description{computed edge connectivity and min disconnecting set
for an undirected graph}
}
\usage{
edgeConnectivity(g)
}
\arguments{
  \item{g}{an instance of the \code{graph} class with \code{edgemode}
    \dQuote{undirected}}
}
\details{
Consider a graph G consisting of a single connected component.
The edge connectivity of G is the minimum number
of edges in G that can be cut to produce a graph with two
(disconnected) components.  The set of edges in this cut
is called the minimum disconnecting set.
}
\value{
A list the first element is \emph{the connectivity} which is the number
of edges that must be cut to separate the graph. The second element is a list
of pairs of nodes defining the edges of the minimum disconnecting set
}
\references{Boost Graph Library by Siek et al.  }
\author{Vince Carey <stvjc@channing.harvard.edu>}

\seealso{\code{\link{connectedComp}}  }

\examples{
coex <- fromGXL(file(system.file("XML/conn.gxl",package="RBGL")))
edgeConnectivity(coex)
}
\keyword{ models }

\eof
\name{makeRecip}
\alias{makeRecip}
\title{ revise edgeL of an graphNEL to include all reciprocal edges }
\description{
 revise edgeL of an graphNEL to include all reciprocal edges 
}
\usage{
makeRecip(g)
}
\arguments{
  \item{g}{ an instance of graphNEL class }
}
\details{
}
\value{
a graphNEL with revised edgeL, so that if A->B is an
edge, so is B->A, according to the edgeL protocol.
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }

\seealso{ \code{\link[graph]{ugraph}} }
\examples{
example(edgeConnectivity)
coex
makeRecip(coex)
}
\keyword{ models }

\eof
\name{mstree.kruskal}
\alias{mstree.kruskal}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Kruskal's minimum spanning tree in boost }
\description{
returns list of two matrices: 2XNE of edges of MST and
1XNE of weights of these edges, and of the vector of nodes
}
\usage{
mstree.kruskal(x) # now x assumed to be Bioconductor graph graphNEL
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ instance of class graphNEL from Bioconductor graph class}
}
\details{
calls to kruskal minimum spanning tree
}
\value{
list of two matrices and vector of nodes, see above
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }
\note{Very preliminary}

\examples{
km <- fromGXL(file(system.file("GXL/kmstEx.gxl",package="graph")))
mstree.kruskal(km)
km@edgeL$B$weights <- c(1.1,.95)
mstree.kruskal(km)
km2 <- fromGXL(file(system.file("XML/telenet.gxl",package="RBGL")))
m <- mstree.kruskal(km2)
print(sum(m[[2]]))
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
\name{strongComp}
\alias{strongComp}
\title{Identify Strongly Connected Components}

\description{The strongly connected components in
a directed graph are identified and returned as a list.
}
\usage{
strongComp(g)
}
\arguments{
  \item{g}{ g: graph with \code{edgemode} \dQuote{directed}.}
}
\details{
Tarjan's algorithm is used to determine all strongly connected
components of a \emph{directed graph}.
The mathematical formalism is described in the \pkg{graph} package
or any good book on graph theory.
}
\value{
A list whose length is the number of strongly connected components in
\code{g}. Each element of the list is a vector of the node labels for
the nodes in that component.
}

\references{Boost Graph Library  }
\author{Vince Carey <stvjc@channing.harvard.edu>}

\seealso{\code{\link[graph]{connComp}},\code{\link{connectedComp}} }

\examples{
km <- fromGXL(file(system.file("XML/kmstEx.gxl",package="RBGL")))
km@nodes <- c(km@nodes,"F","G","H")
km@edgeL$F <- list(edges=numeric(0))
km@edgeL$G <- list(edges=8)
km@edgeL$H <- list(edges=7)
strongComp(km)
connectedComp(ugraph(km))
}
\keyword{ models }

\eof
\name{tsort}
\alias{tsort}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ topological sort of vertices of a digraph }
\description{
returns vector of zero-based indices of vertices
of a DAG in topological sort order
}
\usage{
tsort(x) # now x assumed to be Bioconductor graph graphNEL
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ instance of class graphNEL from Bioconductor graph class}
}
\details{
calls to the topological\_sort algorithm of BGL.  will check in BGL
whether the input is a DAG and will report to cerr and return
zeroes if it is not.
}
\value{
a numerical vector enumerating vertices in the
topological sort sequence, 0-based
}
\author{ VJ Carey <stvjc@channing.harvard.edu> }
\note{Very preliminary}

\examples{
data(FileDep)
nodes(FileDep)[tsort(FileDep)+1]
FD2 <- FileDep
if (interactive()) {
  # now introduce a cycle
  FD2@edgeL[["bar_cpp"]]$edges <- c(8,1)
  tsort(FD2)
  }
}
\keyword{ graphs }% at least one, from doc/KEYWORDS

\eof
