.packageName <- "RBGL"
Am2Al <- function (mat) 
{
#
# converts an adjacency or incidence matrix to an adjacency list format
# (see adjListBGL.R for more information)
#
    if (!is.matrix(mat)) 
        stop("needs mat")
    if (nrow(mat) != ncol(mat)) 
        stop("needs square mat")
    rs <- 1:nrow(mat)
    cs <- 1:ncol(mat)
    if (!all(sort(unique(as.double(mat))) == c(0, 1))) 
        stop("needs incidence mat")
    prs <- NULL
    f <- function(x, y) if (length(x) > 0) 
        rbind(x, y)
    else NULL
    for (i in cs) prs <- cbind(prs, f(rs[mat[, i] == 1], i))
    prs-1 # to get zero-base
}

adjMat <- function(x, maxn = 100) {
#
# return full matrix of adjacency indicators for a graph, will
# query user to proceed if graph bigger than maxn nodes
#
# this is to be supplanted by a sparse matrix approach in Bioconductor::graph
#
 nn <- length(no <- nodes(x)) 
 if (nn > maxn) {
   cat(paste("graph has ",nn," nodes, do you want to proceed? (y/n): ",sep=""))
   ans <- scan(n=1,what="")
   if (ans != "y") return(0)
   }
 al <- adj(x,1:nn)
 dum <- function(x,y) # get incidence vector for x=adj nodes in y=all nodes
   { out <- rep(0,length(y)); out[ y %in% x ] <- 1; out }
 sapply(al, dum, no )
}

tsort <- function(x) {
 if (edgemode(x) != "directed") stop("requires directed graph")
 nv <- length(nodes(x))
 em <- edgeMatrix(x)
 ne <- ncol(em)
 .Call("BGL_tsort_D", as.integer(nv), as.integer(ne),
      as.integer(em-1))
}

mstree.kruskal <- function(x) {
 nv <- length(nodes(x))
 em <- edgeMatrix(x, duplicates=TRUE) # conform with edgeWeights unlisted
 ne <- ncol(em)
ans <- .Call("BGL_KMST_D", 
      		as.integer(nv), as.integer(ne),
      		as.integer(em-1), as.double(unlist(edgeWeights(x))))
 names(ans) <- c("edgeList", "weights")
 ans$nodes <- nodes(x)
 ans[["edgeList"]] <- ans[["edgeList"]] + 1  # bring to unit-based counting
 ans
}

if (!isGeneric("bfs")) setGeneric("bfs",
        function( graph, init.node=1, checkConn=FALSE) standardGeneric("bfs"))

setMethod("bfs",c("graph", "ANY", "ANY"), 
  function( graph, init.node, checkConn) {
 if (init.node < 1) stop("use 1-based counting for init.node")
 if (checkConn)
   {
   if (length(connectedComp(graph)>1)) stop("graph is not connected")
   }
 nv <- length(nodes(graph))
 if (init.node > nv) stop(paste("only",nv,"nodes but init.node is ",init.node,sep=" "))
 em <- edgeMatrix(graph)
 ne <- ncol(em)
 ans <- .Call("BGL_bfs_D", as.integer(nv), as.integer(ne),
      as.integer(em-1), as.integer(edgeWeightVector(graph)),
      as.integer(init.node-1))
# names(ans) <- c("edgeList", "weights")
# ans$nodes <- nodes(graph)
# ans[["edgeList"]] <- ans[["edgeList"]] + 1  # bring to unit-based counting
 ans+1
})

if (!isGeneric("dfs")) 
   setGeneric("dfs", function(graph)standardGeneric("dfs"))

setMethod("dfs", "graph", function(graph) {
 nv <- length(nodes(graph))
 em <- edgeMatrix(graph)
 ne <- ncol(em)
 ans <- .Call("BGL_dfs_D", as.integer(nv), as.integer(ne),
      as.integer(em-1), as.double(edgeWeightVector(graph)))
 names(ans) <- c("discovered", "finish")
 lapply(ans,function(x)x+1)
})


dijkstra.sp <- function(x,init.ind=1) {
    init.ind.ok <- init.ind
    if (is.character(init.ind)) 
        if (init.ind %in% nodes(x)) 
            init.ind.ok <- (1:length(nodes(x)))[init.ind == nodes(x)]
        else stop("character init.ind not in nodes(x)")
    else if (init.ind < 1) 
        stop("use 1-based counting for init.ind")
    nv <- length(nodes(x))
    if (init.ind.ok > nv) 
        stop(paste("only", nv, "nodes but init.ind is ", init.ind.ok, 
            sep = " "))
    em <- edgeMatrix(x)
    ne <- ncol(em)
    ans <- .Call("BGL_dijkstra_shortest_paths_D", as.integer(nv), 
        as.integer(ne), as.integer(em-1), as.double(edgeWeightVector(x)), 
        as.integer(init.ind.ok - 1))
    names(ans) <- c("distances", "penult")
    names(ans[[1]]) <- nodes(x)
    ans$penult <- ans$penult + 1
    ans[["start"]] <- init.ind.ok
    ans
}

sp.between <- function (g, start, finish) 
{
# (c) 2003 VJ Carey, all rights reserved
#
# function uses BGL dijkstra shortest paths
# given s=start node, f=end node in graph g,
# return list with length of shortest path joining
# s and f, and vector giving trajectory
#
# debugged 24 sep03, did not need to recompute
# distance, and did not correctly step through
# penultimates!
#
    f <- finish
    s <- start
    no <- nodes(g)
    if (any(is.na(lk <- match(c(s, f), no)))) 
        stop(paste(paste(c(s, f)[is.na(lk)], collapse = " "), 
            "not in nodes of g"))
    s <- (1:length(no))[no == s]
    f <- (1:length(no))[no == f]
    ff <- f
    sp <- dijkstra.sp(g, s)
    if (sp$distances[ff] >= .Machine$double.xmax)
		stop(paste("no path from",no[s],"to",no[f]))
    pens <- sp$penult
    path <- f
    while (path[1] != s) {
        path <- c(pens[f], path)
        f <- pens[f]
    }
    list(length = sp$distances[ff], path = no[path])
}

connectedComp <- function (g) 
{
    if (length(agrep("solaris", version$platform))==1) return(
		"inoperative under solaris at present; try windows, linux or BSD")
    nv <- length(nodes(g))
    em <- edgeMatrix(g)
    ne <- ncol(em)
    x<-.Call("BGL_connected_components_U", as.integer(nv), as.integer(ne), 
        as.integer(em-1), as.double(edgeWeightVector(g)))
    split(nodes(g),x+1)
}

strongComp <- function (g) 
{
    if (edgemode(g) == "undirected") stop("only applicable to directed graphs")
    nv <- length(nodes(g))
    em <- edgeMatrix(g)
    ne <- ncol(em)
    x <- .Call("BGL_strong_components_D", as.integer(nv), as.integer(ne), 
        as.integer(em-1), as.double(edgeWeightVector(g)))
    split(nodes(g),x+1)
}

edgeConnectivity <- function (g) 
{
    if (length(agrep("solaris", version$platform))==1) return(
		"inoperative under solaris at present; try windows, linux or BSD")
    if (edgemode(g) == "directed") stop("only applicable to undirected graphs")
    nv <- length(nodes(g))
    em <- edgeMatrix(g)
    ne <- ncol(em)
    ans <- .Call("BGL_edge_connectivity_U", as.integer(nv), as.integer(ne), 
        as.integer(em-1), as.double(edgeWeightVector(g)))
    mes <- ans[[2]]
    mes <- lapply(mes,function(x,y) y[x+1], nodes(g)) # +1 for zero-based BGL
    list(connectivity=ans[[1]], minDisconSet=mes)
}
makeRecip <- function (g) 
{
#
# still does not handle weights
#
    if (class(g) != "graphNEL") stop("needs graphNEL")
    h <- g # save the input graph
    nn <- length(nodes(g))
    mm <- matrix(nodes(g)[edgeMatrix(g)] , nr = 2) # get names of nodes
                                    # into an adjacency list matrix 2 x NE
    mm <- cbind(mm, rbind(mm[2, ], mm[1, ]))
                                    # mm now has all given edges & their
                                    # reversals, which may be redundant
    tags <- apply(mm, 2, paste, collapse = "")
    kill <- (1:ncol(mm))[duplicated(tags)] # kill off the redundant edges
                                # in mm by mangling and checking for duplicates
    if (length(kill) > 0) 
        mm <- mm[, -kill]
    mmm <- mm[2, ]   # now convert this information into a named vector
    names(mmm) <- mm[1, ]  # mmm[j] is tip, names(mmm)[j] is tail of jth edge
    EL <- list()
    for (n in nodes(h)) {  # create an edgeL based on mmm
        EL[[n]] <- g@edgeL[[n]]  # it has the same structure as that of g
        if (length(ne <- mmm[names(mmm) == n]) > 0) 
            EL[[n]]$edges <- (1:nn)[match(as.character(ne), nodes(g))]
    }
    h@edgeL <- EL
    h
}

.First.lib <- function(libname, pkgname ) {
    require("graph")
    library.dynam("RBGL", pkgname, libname)
}

