\name{ArrayDesignHandler}
\alias{ArrayDesignHandler}
\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the ArrayDesign package }
\details{These are not to be called by user}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046. \cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}

\eof
\name{BioAssayDataHandler}
\alias{BioAssayDataHandler}
\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the BioAssayData package }
\details{These are not to be called by user}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}

\eof
\name{BioSequenceHandler}
\alias{BioSequenceHandler}
\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the BioSequence package.}
\details{These are not to be called by user.}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}

\eof
\name{DesignElementHandler}
\alias{DesignElementHandler}

\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the DesignElement package.}
\details{These are not to be called by user.}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}

















\eof
\name{EMEXP5}
\docType{data}
\alias{EMEXP5}
\alias{A-MEXP-5.xml}
\alias{129DUO_Fe_Cy3}
\alias{129Duo_Fe_Cy5}
\alias{129L_Fe_cy3}
\alias{129L_Fe_cy5}
\alias{B6_Fe-def_Cy3}
\alias{B6_Fe-def_Cy5}
\alias{C282Y_D_Cy3}
\alias{C282YDuo_Cy5}
\alias{C282Y_L_cy3}
\alias{C282Y_L_Cy5}
\alias{C282YL_FE_cy3}
\alias{C282Y_L_Fe_Cy5}
\alias{Duocy3}
\alias{duo_Cy5}
\alias{E-MEXP-5.xml}
\alias{_L_Cy3}
\alias{L_Cy5}
\alias{LFeCy3}
\alias{LFe_cy5}


\title{Example dataset in MAGEML-format}

\description{This dataset is available from ArrayExpress(http://www.ebi.ac.uk/arrayexpress/) as E-MEXP-5. Duodenal and liver gene response patterns in mice with primary (Hfe -/- and C282Y homozygous mice) and secondary iron overload versus 129S6/SvEvTac wild type controls were determined.
 }
\details{See ArrayExpress}
\references{Cindy Roy, Angel Custodio, Belen Minana, Jos de Graaf, Lynne Montross, Nancy Andrews, Matthias Hentze and Martina Muckenthaler (2003). Regulatory defects in liver and intestine implicate abnormal hepcidin and Dcytb expression in murine hemochromatosis. Nature Genetics, 34(1):102-7.}


\keyword{datasets}
\source{ArrayExpress, http://www.ebi.ac.uk/arrayexpress/}

\eof
\name{Iron}
\docType{data}
\alias{Iron}
\alias{230MM-mod}
\alias{235MM-mod}
\title{example dataset in MAGEML-format}

\description{This dataset is available from ArrayExpress (http://www.ebi.ac.uk/arrayexpress/) as E-MANP-1 and is provided by Muckenthaler et al.  HeLa cells grown to subconfluent density and CaCo-2 cells grown to high density were either treated with an iron source (hemin) or an iron chelator (desferal). Cells were harvested and RNA was prepared by RNA-Clean (Hybaid-AGS) and the RNA was subjected to a subsequent clean up using the RNeasy (Qiagen) clean up procedure.
 }
\details{See ArrayExpress}
\references{}
\source{ArrayExpress, http://www.ebi.ac.uk/arrayexpress/}
\keyword{datasets}


\eof
\name{PackageDetectorHandler}
\alias{PackageDetectorHandler}
\title{Event Handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to
handle events generated by parsing the MAGE-ML document for detecting
the different packages.}
\details{These are not to be called by user.}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}




\eof
\name{QuantitationTypeHandler}
\alias{QuantitationTypeHandler}
\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the BioAssayData package and Experiment package.  It allows extraction of information on available QuantitationTypes, experiment name and raw data files}
\details{These are not to be called by user}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}


\eof
\name{TargetHandler}
\alias{TargetHandler}
\title{Event handler for XML parser}

\description{
This function is an internal function that is used by the xmlParser to handle events generated by parsing the BioAssay package, BioMaterial package and BioAssayData package.}
\details{These are not to be called by user}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.\cr
Duncan Temple Lang, XML library for R.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\keyword{}

\eof

\keyword{classes}
\name{arrayDesign-class}
\docType{class}
\alias{arrayDesign-class}
\alias{arrayDesign}
\alias{show,arrayDesign-method}
\alias{show,ANY-method}
\title{ArrayDesign class.}
\description{This class contains the information extracted from the
  ArrayDesign package. The class should be used as such that the elements in the different slots correspond by order in which they appear.  In this way a feature identifier is coupled to a zone (block) and a location within this zone defined as row and column.}
\section{Slots}{
  \describe{
    \item{\code{feature}:}{Object of class \code{"list"}, containing
      the identifier of the feature.}
    \item{\code{zone}:}{Object of class \code{"list"}, containing
      the zone or block of the spot which contains the feature.}
    \item{\code{databaseEntry}:}{Object of class \code{"list"}, containing
      the location as row and column within each zone.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(x = "arrayDesign")}: print method for
      \code{"\link{arrayDesign}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\keyword{classes}
\name{bioAssayData-class}
\docType{class}
\alias{bioAssayData-class}
\alias{bioAssayData}
\alias{show,bioAssayData-method}

\title{BioAssayData class.}
\description{This class contains the information extracted from the
  BioAssayData package. The class has a featureRef slot and an array slot.}
\section{Slots}{
  \describe{
    \item{\code{featureRef}:}{Object of class \code{"list"}, containing
      references to the feature spotted on the array. The orde in which the features are presented corresponds to the order of the data in the raw data files.}
    \item{\code{array}:}{Object of class \code{"character"}, containing
      the array design.}
}
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(x = bioAssayData"")}: print method for
      \code{"\link{bioAssayData}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\keyword{classes}
\name{bioSample-class}
\docType{class}
\alias{bioSample-class}
\alias{bioSample}
\alias{show,bioSample-method}

\title{BioSample class.}
\description{This class contains the information extracted from the BioAssay package and BioMaterial package. The class should be used as such that the elements in the different slots correspond by order in which they appear.  In this way a measured data identifier is coupled to a compound and a biosample name.}
\section{Slots}{
  \describe{
    \item{\code{measuredDataID}:}{Object of class \code{"character"}, containing
      the DATA identifiers of the measured data.}
    \item{\code{compound}:}{Object of class \code{"character"}, containing
      the compound by which the sample was labeled.}
    \item{\code{bioSampleName}:}{Object of class \code{"character"}, containing
      the names of the samples.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "bioSample")}: print method for
      \code{"\link{bioSample}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\keyword{classes}
\name{bioSequence-class}
\docType{class}
\alias{bioSequence-class}
\alias{bioSequence}
\alias{show,bioSequence-method}

\title{BioSequence class.}
\description{This class contains the information extracted from the bioSequence package. The class should be used as such that the elements in the different slots correspond by order in which they appear.  In this way a bioSequence identifier is coupled to a bioSequence name, a database entry and a database reference.}
\section{Slots}{
  \describe{
    \item{\code{bioSequenceID}:}{Object of class \code{"list"}, containing
      the IDs.}
    \item{\code{bioSequenceName}:}{Object of class \code{"list"}, containing
      the name of the bioSequence.}
    \item{\code{databaseEntry}:}{Object of class \code{"list"}, containing
      the database entries.}
    \item{\code{databaseRef}:}{Object of class \code{"list"}, containing
      the database name to which the databaseEntry refers.} 
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "bioSequence")}: describes the
      object of the \code{"\link{bioSequence}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\keyword{classes}
\name{designElement-class}
\docType{class}
\alias{designElement-class}
\alias{designElement}
\alias{show,designElement-method}


\title{DesignElement class.}
\description{This class contains the information extracted from the DesignElement package. The class should be used as such that the elements in the different slots correspond by order in which they appear.  In this way a feature identifier is coupled to a biosequence of its reporter.}
\section{Slots}{
  \describe{
    \item{\code{feature}:}{Object of class \code{"list"}, containing
      the identifier of the feature.}
    \item{\code{reporterBioSeq}:}{Object of class \code{"list"}, containing
      the biosequence of the reporter which corresponds to the feature in the feature slot.}
    }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(x = "designElement")}: print method for
      \code{"\link{designElement}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\name{getArrayDesign}
\alias{getArrayDesign}

\title{Get arrayDesign object}

\description{
This function parses the ArrayDesign package and returns an arrayDesign object.}

\usage{getArrayDesign(file = "", datadir = "")}

\arguments{
\item{file}{XML document containing the DesignElement package.}
\item{datadir}{The directory where XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}
\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{arrayDesign}
\value{List of three lists, called "location", "feature" and "zone".}
\examples{
data <- system.file("data", package="MAGEML")
getArrayDesign(file="Iron.xml",datadir=data)
}
\keyword{}

\eof
\name{getBioAssayData}
\alias{getBioAssayData}
\title{Get bioAssayData object}

\description{
This function parses the BioAssayData package and returns an bioAssayData object which contains a slot with  assayed feature references and a slot with the used array design.}

\usage{getBioAssayData(file = "", datadir = "")}

\arguments{
\item{file}{XML document containing the DesignElement package.}
\item{datadir}{Directory where the XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\value{BioAssayData object containing the assayed feature references and array design used in BioAssay.}

\seealso{bioAssayData}

\examples{
data <- system.file("data", package="MAGEML")
getBioAssayData(file="Iron.xml",datadir=data)
}
\keyword{}

\eof
\name{getBioSequence}
\alias{getBioSequence}


\title{Get BioSequence information}

\description{
This function parses the BioSequence package and returns a bioSequence object.}

\usage{getBioSequence(file = "", datadir = ".")}

\arguments{
\item{file}{XML document containing the BioSequence package.}
\item{datadir}{The directory where XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}
\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{bioSequence}
\value{bioSequence object}
\examples{
data <- system.file("data", package="MAGEML")
getBioSequence(file="Iron.xml",datadir=data)
}
\keyword{}


\eof
\name{getDesignElement}
\alias{getDesignElement}

\title{Get designElement object}

\description{
This function parses the DesignElement package and returns a designElement object}

\usage{getDesignElement(file = "", datadir = ".")}

\arguments{
\item{file}{XML document containing the DesignElement package.}
\item{datadir}{The directory where XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}
\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{designElement}
\value{returns a designElement object.}
\examples{
data <- system.file("data", package="MAGEML")
getDesignElement(file="Iron.xml",datadir=data)
}
\keyword{}

\eof

\name{getQuantitationTypes}
\alias{getQuantitationTypes}


\title{Get quantitationType object}

\description{
This function parses part of the BioAssayData package and returns a quantitationType object.}

\usage{getQuantitationTypes(file = "", datadir = ".")}

\arguments{
\item{file}{XML document containing the BioAssayData package.}
\item{datadir}{The directory where XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}
\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{quantitationType}
\value{quantitationType object}
\examples{
data <- system.file("data", package="MAGEML")
getQuantitationTypes(file="Iron.xml",datadir=data)
}
\keyword{}


\eof
\name{magePackageDetector}
\alias{magePackageDetector}

\title{Find MAGE-ML packages in xml files}

\description{To reduce the size of xml documents it is possible that one splits one MAGE-ML documents into smaller documents, each containing some of the packages. To be able to construct BioConductor objects with the MAGEML library, one needs to specifiy in which files the needed packages reside. This function is handy to find out which MAGE-ML packages are in which xml files.}

\usage{magePackageDetector(fnames = "", datadir = ".")}

\arguments{
\item{fnames}{List of filenames that belong to the same experiment}
\item{datadir}{The directory where XML file resides.}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}
\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{readMageRaw, readMageDesign}
\value{Prints out the filename and MAGE-ML packages present in that file}
\examples{
data <- system.file("data", package="MAGEML")
magePackageDetector(fnames=list("A-MEXP-5.xml", "E-MEXP-5.xml"),datadir=data)
}
\keyword{}


\eof
\keyword{classes}
\name{quantitationType-class}
\docType{class}
\alias{quantitationType-class}
\alias{quantitationType}
\alias{show,quantitationType-method}

\title{QuantitationType class.}
\description{This class contains the information extracted from the BioAssayData package concerning the measured quantitationTypes.}
\section{Slots}{
  \describe{
    \item{\code{quantitationTypes}:}{Object of class \code{"list"}, containing
      the available quantitationTypes.  The order in which the appear corresponds to the order in the raw data file}
    \item{\code{dataExternal}:}{Object of class \code{"list"}, containing
      the names of the raw data files. The order in this list is as such that they correspond with the dataID slot}
    \item{\code{experiment}:}{Object of class \code{"character"}, containing
      the identifier of the experiment.}
   
    \item{\code{dataID}:}{Object of class \code{"list"}, containing the DATA identifiers.  The order in this list is as such that they correspond with the dataExternal slot}

  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(x = "quantitationTypes")}: print method for
      \code{"\link{quantitationType}"} class.}
  }
}

\references{}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\eof
\name{readMageDesign}
\alias{readMageDesign}
\alias{widget.readMageDesign}

\title{Wrapper function for reading MAGE-ML documents}
\description{
The function \code{readMageDesign} is a wrapper function for reading MAGE-ML documents. It returns objects of the classes  \code{\link{marrayLayout}} and \code{\link{marrayInfo}}.
}

\usage{
readMageDesign(file = NULL, datadir = ".",  fArrayDesign = NULL, fBioAssayData = NULL, fDesignElement = NULL, fBioSequence = NULL, ngc=4, skip=0, sep="\t",quote="",...)

widget.readMageDesign(skip=0, sep="\t",quote="",...)
}

\arguments{
  \item{fArrayDesign}{Filename of XML document containing the ArrayDesign package.}
  \item{fBioAssayData}{Filename of XML document containing the BioAssayData package.}
  \item{fDesignElement}{Filename of XML document containing the DesignElement package.}
  \item{fBioSequence}{Filename of XML document containing the BioSequence package.}
  \item{file}{Filename of XML document when the ArrayDesign, BioassayData and DesignElement package are all in one XML file.}
  \item{datadir}{Directory containing the XML document}
  \item{ngc}{The number of grid columns on your array; the default is 4.}
  \item{...}{Further arguments for the `scan' function}
  \item{skip}{Further arguments for the `scan' function}
  \item{quote}{Further arguments for the `scan' function}
  \item{sep}{Further arguments for the `scan' function}
}

\details{
This function executes an event based XML parsing.  Depending on whether the ArrayDesign, BioAssayData and DesignElement package are in one file or not, three different files will be parsed or only one.
}

\value{
A marrayLayout an a marrayInfo object, named layout and info.
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.

}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{\code{\link{getBioAssayData}}, \code{\link{getDesignElement}},\code{\link{getArrayDesign}}.}

\examples{
data <- system.file("data", package="MAGEML")
readMageDesign(file = "Iron.xml", datadir = data)
#To call the widget, you use:
if(interactive()){
widget.readMageDesign()
}
}
\keyword{}% at least one, from doc/KEYWORDS


\eof
\name{readMageRaw}
\alias{readMageRaw}
\alias{widget.readMageRaw}
\title{Creation of marrayRaw object}
\description{
This function creates a marrayRaw object by using the maLayout and maInfo available from readMageDesign and the raw data file.
}
\usage{
readMageRaw(fname, datadir = ".", name.Gf = "", name.Gb ="", name.Rf =
"", name.Rb="", name.W=NULL, layout = NULL, gnames = NULL, notes=NULL, skip=0, sep="\t",quote="",\ldots)
}

\arguments{
  \item{fname}{File name of file which contains the BioAssayData package}
  \item{datadir}{Directory where the files reside}
  \item{name.Gf}{Name of green foreground channel}
  \item{name.Gb}{Name of green background channel}
  \item{name.Rf}{Name of red foreground channel}
  \item{name.Rb}{Name of red background channel}
  \item{name.W}{Name of weights}
  \item{notes}{object of class character, vector of explanatory text}
  \item{layout}{The name of the marnotes=NULLrayLayout object that describes the layout of your experiment (made with readMageDesign).}
  \item{gnames}{The name of the marrayInfo object that describes the genes of your experiment (made with readMageDesign).}
  \item{...}{Further arguments for the `scan' function}
  \item{skip}{Further arguments for the `scan' function}
  \item{quote}{Further arguments for the `scan' function}
  \item{sep}{Further arguments for the `scan' function}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr 
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}

\seealso{\code{\link{showQuantitationTypes}},\code{\link{readMageDesign}}}

\examples{
data<-system.file("data", package="MAGEML")
#To obtain list of available quantitation types.#
showQuantitationTypes("Iron.xml",datadir=data)
readMageRaw(fname="Iron.xml",datadir=data,name.Gf="ch1vol",name.Rf="ch2vol",name.Rb="ch2bgmedian",name.Gb="ch1bgmedian")
if(interactive()){
widget.readMageRaw()
}
}
\keyword{methods}

\eof
\name{showQuantitationTypes}
\alias{showQuantitationTypes}

\title{Show quantitation types}

\description{
This function parses the BioAssayData package and prints out a list of available quantitation types.}

\usage{showQuantitationTypes(file = "", datadir=".")}

\arguments{
\item{file}{XML document containing the BioAssayData package}
\item{datadir}{The directory where XML file resides}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A. 
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.}

\author{Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}\cr
Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}.}


\seealso{}

\examples{
data<-system.file("data", package="MAGEML")
showQuantitationTypes("Iron.xml",datadir=data)
}
\keyword{}

\eof
