.packageName <- "DynDoc"
    setClass("DynDoc", representation(indexEntry="character",
                                        title="character",
                                        path="character",
                                        pdfPath="character",
                                        depends="character",
                                        requires="character",
                                        suggests="character",
                                        keywords="character",
                                        codeChunks="chunkList"
                                        ))

    ####
    #### Simple Accessors
    ####

    if (is.null(getGeneric("indexEntry")))
        setGeneric("indexEntry", function(object)
                   standardGeneric("indexEntry"))
    setMethod("indexEntry", "DynDoc", function(object)
              object@indexEntry)

    if (is.null(getGeneric("path")))
        setGeneric("path", function(object)
                   standardGeneric("path"))
    setMethod("path", "DynDoc", function(object)
              object@path)

    if (is.null(getGeneric("pdfPath")))
        setGeneric("pdfPath", function(object)
                   standardGeneric("pdfPath"))
    setMethod("pdfPath", "DynDoc", function(object)
              object@pdfPath)

    if (is.null(getGeneric("getDepends")))
        setGeneric("getDepends", function(object)
                   standardGeneric("getDepends"))
    setMethod("getDepends", "DynDoc", function(object)
              object@depends)

    if (is.null(getGeneric("getRequires")))
        setGeneric("getRequires", function(object)
                   standardGeneric("getRequires"))
    setMethod("getRequires", "DynDoc", function(object)
              object@requires)

    if (is.null(getGeneric("getSuggests")))
        setGeneric("getSuggests", function(object)
                   standardGeneric("getSuggests"))
    setMethod("getSuggests", "DynDoc", function(object)
              object@suggests)

    if (is.null(getGeneric("getKeywords")))
        setGeneric("getKeywords", function(object)
                   standardGeneric("getKeywords"))
    setMethod("getKeywords", "DynDoc", function(object)
              object@keywords)

    ###
    ### Chunk manipulation
    ###

    if (is.null(getGeneric("codeChunks")))
        setGeneric("codeChunks", function(object)
                   standardGeneric("codeChunks"))
    setMethod("codeChunks", "DynDoc", function(object)
              object@codeChunks)

    if (is.null(getGeneric("chunks")))
        setGeneric("chunks", function(object)
                   standardGeneric("chunks"))
    setMethod("chunks", "DynDoc", function(object)
              chunks(object@codeChunks))

    if (is.null(getGeneric("setChunk<-")))
        setGeneric("setChunk<-", function(object, pos, value)
                   standardGeneric("setChunk<-"))
    setReplaceMethod("setChunk","DynDoc",
                     function(object, pos,value) {
                         setChunk(object@codeChunks,pos) <- value
                         object
                     })
    if (is.null(getGeneric("numChunks")))
        setGeneric("numChunks", function(object)
                   standardGeneric("numChunks"))
    setMethod("numChunks","DynDoc", function(object)
              numChunks(object@codeChunks))
    if (is.null(getGeneric("getChunk")))
        setGeneric("getChunk", function(object, num)
                   standardGeneric("getChunk"))
    setMethod("getChunk","DynDoc", function(object, num)
        getChunk(object@codeChunks, num))

    if (is.null(getGeneric("evalChunk")))
        setGeneric("evalChunk", function(object, ...)
                   standardGeneric("evalChunk"))
     setMethod("evalChunk","DynDoc",function(object,pos)
               evalChunk(object@codeChunks,pos))

    ###
    ### Output methods
    ###

    setMethod("summary","DynDoc", function(object) {
        summary(object@codeChunks)
    })

    setMethod("show","DynDoc", function(object) {
        show(object@codeChunks)
    })

tangleToR <- function() {
        list(setup = tangleToRSetup,
         runcode = tangleToRRuncode,
         writedoc = RtangleWritedoc,
         finish = tangleToRFinish,
         checkopts = RweaveLatexOptions)
}

tangleToRSetup <- function(syntax, ...) {
    options <- list(engine="R")
    list(options=options, syntax=syntax, chunkout=list())
}

tangleToRRuncode <- function(object, chunk, options) {
    if(!(options$engine %in% c("R", "S"))){
        return(object)
    }
    outList <- object$chunkList

    if (is.null(outList))
        curList <- list()
    else
        curList <- chunks(outList)

    if (is.null(options$label))
        name <- character()
    else
        name <- options$label
    curChunk <- new("codeChunk", chunkName=name, chunk=chunk,
                    options=new("SweaveOptions",options=options))
    curList[[length(curList)+1]] <- curChunk
    newList <- new("chunkList", chunks=curList, evalEnv=new.env())
    object$chunkList <- newList
    return(object)
}

tangleToRFinish <- function(object, error=FALSE)
{
    return(object$chunkList)
}

    setGeneric("SweaveOptions", function(object)
               standardGeneric("SweaveOptions"))
    setClass("SweaveOptions", representation(options="list"))

    if (is.null(getGeneric("getOptions")))
        setGeneric("getOptions", function(object)
                   standardGeneric("getOptions"))

    setMethod("getOptions", "SweaveOptions", function(object)
              object@options)

    if (is.null(getGeneric("numOptions")))
        setGeneric("numOptions", function(object)
                   standardGeneric("numOptions"))
    setMethod("numOptions", "SweaveOptions", function(object)
              length(object@options))

    setMethod("show","SweaveOptions", function(object)
              paste(options,collapse=","))

    setGeneric("codeChunk", function(object)
               standardGeneric("codeChunk"))
    setClass("codeChunk", representation(chunkName="character",
                                         chunk="character",
                                         options="SweaveOptions"))

    if (is.null(getGeneric("chunk")))
        setGeneric("chunk", function(object)
                   standardGeneric("chunk"))
    setMethod("chunk", "codeChunk", function(object)
              object@chunk)
    if (is.null(getGeneric("chunk<-")))
        setGeneric("chunk<-", function(object, value)
                  standardGeneric("chunk<-"))
    setReplaceMethod("chunk", "codeChunk", function(object, value) {
                     object@chunk <- value
                     object
                 })

    if (is.null(getGeneric("chunkName")))
        setGeneric("chunkName", function(object)
                   standardGeneric("chunkName"))
    setMethod("chunkName", "codeChunk", function(object)
              object@chunkName)

    if (is.null(getGeneric("SweaveOptions")))
        setGeneric("SweaveOptions", function(object)
                   standardGeneric("SweaveOptions"))
    setMethod("SweaveOptions", "codeChunk", function(object)
              object@options)

    if (is.null(getGeneric("getOptions")))
        setGeneric("getOptions", function(object)
                   standardGeneric("getOptions"))
    setMethod("getOptions", "codeChunk", function(object)
              SweaveOptions(object)@options)

    if (is.null(getGeneric("evalChunk")))
        setGeneric("evalChunk", function(object, ...)
                   standardGeneric("evalChunk"))
    setMethod("evalChunk", "codeChunk", function(object, env) {
        if (missing(env))
            env <- .GlobalEnv
        chunk <- chunk(object)
        chunkexps <- parse(text=chunk)
        outVec <- character()
        if (length(chunkexps) == 0)
            return(outVec)
        tmpCon <- textConnection("output","w")
        sink(file=tmpCon)
        for (nce in 1:length(chunkexps)) {
            ce <- chunkexps[[nce]]
            dce <- deparse(ce, width.cutoff=0.75*getOption("width"))
            cat(getOption("prompt"),
                paste(dce, collapse=paste("\n",
                           getOption("continue"), sep="")),"\n")
            out <- try(.Internal(eval.with.vis(ce,
                                               env,
                                               NULL)))
             if(inherits(out,"try-error")) {
                 sink()
                 close(tmpCon)
                 stop(out)
             }
            if(out$visible) {
                print(out$value)
            }
            cat("\n")
        }
        sink()
        close(tmpCon)
        output <- paste(output,collapse="\n")
        return(paste(output,"\n",sep=""))
    })


    setMethod("show","codeChunk", function(object) {
        cat("Code chunk",object@chunkName,":\n",
            paste(object@chunk,collapse="\n"),"\n")
        if (numOptions(object@options) > 0)
            cat("Options:",object@options,"\n")
    })

    setGeneric("chunkList", function(object)
               standardGeneric("chunkList"))
    setClass("chunkList", representation(chunks="list",
                                            evalEnv="environment"))

    if (is.null(getGeneric("chunks")))
        setGeneric("chunks", function(object)
                   standardGeneric("chunks"))
    setMethod("chunks", "chunkList", function(object)
              object@chunks)

    if (is.null(getGeneric("numChunks")))
        setGeneric("numChunks", function(object)
                   standardGeneric("numChunks"))
    setMethod("numChunks","chunkList", function(object)
              length(object@chunks))

    if (is.null(getGeneric("evalEnv")))
        setGeneric("evalEnv", function(object)
                   standardGeneric("evalEnv"))
    setMethod("evalEnv", "chunkList", function(object)
              object@evalEnv)

    setMethod("summary","chunkList", function(object) {
        num <- numChunks(object)
        print(paste(num,"chunks are available"))
    })

    setMethod("show","chunkList", function(object) {
        for (i in seq(along=object@chunks))
            print(getChunk(object,i))
    })

    if (is.null(getGeneric("getChunk")))
        setGeneric("getChunk", function(object, num)
                   standardGeneric("getChunk"))
    setMethod("getChunk","chunkList", function(object, num)
        object@chunks[[num]])

    if (is.null(getGeneric("setChunk<-")))
        setGeneric("setChunk<-", function(object, pos, value)
                   standardGeneric("setChunk<-"))
    setReplaceMethod("setChunk", "chunkList", function(object, pos, value){
        oldChunk <- object@chunks[[pos]]
        chunk(oldChunk) <- value
        object@chunks[[pos]] <- oldChunk
        object
    })

    if (is.null(getGeneric("getAllCodeChunks")))
        setGeneric("getAllCodeChunks", function(object)
                   standardGeneric("getAllCodeChunks"))
    setMethod("getAllCodeChunks", "chunkList", function(object)
        unlist(lapply(object@chunks,chunk)))

    if (is.null(getGeneric("evalChunk")))
        setGeneric("evalChunk", function(object, ...)
                   standardGeneric("evalChunk"))
    setMethod("evalChunk","chunkList", function(object, pos) {
        chunk <- getChunk(object, pos)
        z <- evalChunk(chunk, evalEnv(object))
        z
    })


vignette <- function(package=.packages(all.available=TRUE),
                     libs, filter, vigDescFun=baseVigDesc,
                     vigPath="/doc") {
    sQuote <- function(s) paste("`", s, "'", sep = "")
    hasPackage <- FALSE

    if (missing(libs))
        libs <- .libPaths()

    if( !missing(package) )
        hasPackage <- TRUE

    ## Get list for packages
    paths <- .find.package(package, libs)
    paths <- unique(paths[file.exists(paths)])
    novigs <- !file.exists(file.path(paths, vigPath))
    if (any(novigs)) {
        if (hasPackage && (length(package) > 0)) {
            packagesWithNoVigs <- package[package %in% sapply(paths[novigs],
                basename)]
            if (length(packagesWithNoVigs) > 1) {
                warning(paste("packages", paste(sQuote(packagesWithNoVigs),
                  collapse = ", "), "contain no vignettes"))
            }
            else if (length(packagesWithNoVigs) == 1) {
                warning(paste("package", sQuote(packagesWithNoVigs),
                  "contains no vignettes"))
            }
        }
        paths <- paths[!novigs]
    }

    vigList <- lapply(paths, function(x) getPkgVigList(x, vigDescFun))
    vigList <- unlist(vigList, recursive=FALSE)
    if (! is.null(vigList))
        class(vigList) <- "pkgFileList"

    ##filter if the user has specified one
    if( !missing(filter) )
	    vigList <- filter(vigList)

    return(vigList)
}

getPkgVigList <- function(pkg,vigDescFun=baseVigDesc,
                          vigPath="/doc/",vigExt="\\.(Rnw|Snw|rnw|snw)$",
                          pkgVers=TRUE) {
    pkgVigList <- list()
    class(pkgVigList) <- "pkgFileList"

    fullVPath <- file.path(pkg,vigPath)
    vigs <- dir(fullVPath,pattern=vigExt)
    if (length(vigs) == 0)
        return(NULL)

    vigPaths <- file.path(fullVPath,vigs)
    ## Take out any broken vignettes
    vigPaths <- vigPaths[sapply(vigPaths,hasVignetteKeyword)]
    vigs <- unlist(lapply(vigPaths,basename))
    if (length(vigPaths) == 0)
        return(NULL)
    for (i in seq(along=vigPaths)) {
        tmpVigEntry<- getVigInfo(vigPaths[i],pkg, vigDescFun,
                                 pkgVers=pkgVers)
        if (is.null(tmpVigEntry))
            stop("Vignette ",vigPaths[i]," returned NULL from ",
                 "getVigInfo().")
        else
            pkgVigList[[i]] <- tmpVigEntry
    }
    names(pkgVigList) <- vigs
    return(pkgVigList)
}

getVigInfo <- function(vig,pkg=NULL, vigDescFun=baseVigDesc, pkgVers=TRUE) {
    ## Passed a filename, if that file is a vignette, will create
    ## a named list of lists to hold all the vignette metadata

    file <- readLines(con=vig)
    lines <- grep("^%[[:space:]]*\\\\Vignette",file)

    splitLines <- strsplit(file[lines],"{")

    listNames <- vector()
    listNames <- unlist(lapply(splitLines, getVigInfoNames, listNames))
    newLst <- lapply(splitLines,transformVigInfoLine)
    ## Remove any NAs from thinkgs like \VignetteXXX{}
    newLst <- lapply(newLst,function(x){if(is.na(x[1])) NULL else x})
    names(newLst) <- listNames

    ## Add in the path starting from the package base
    newLst$VigPath <- vig
    if (!("VignettePackage" %in% names(newLst))) {
        ## Add in the package name
        newLst$VignettePackage <- pkg
    }
    if ((pkgVers==TRUE)&&(!is.null(pkg))) {
        ## Add in package version
        desc <- read.dcf(paste(pkg,"DESCRIPTION",sep="/"))
        newLst$VignettePkgVersion <- desc[,"Version"]
    }
    newLst <- vigDescFun(newLst)

    ## Grab the title as well
    ## !! Should just be merged in with lines above, but need to
    ## figure out generic regexps for the string handling
    line <- grep("\\title{",file)
    if (length(line) > 0) {
        splitLine <- strsplit(file[line],"{")
        tmpTitle <- transformVigInfoLine(splitLine[[1]])
        if ((is.null(tmpTitle))||(is.na(tmpTitle)))
            newLst$VignetteTitle <- "Untitled"
        else {
            ## Remove any latex
            tmpTitle <- gsub("\\\\\\w*[[:space:]]","",tmpTitle)
            newLst$VignetteTitle <- tmpTitle
        }
    }
    else {
        newLst$VignetteTitle <- "Untitled"
    }

    ## Determine if there is a PDF file for this vignette, if so get
    ## the filename
    pdfFile <- gsub("\\.(Rnw|Snw|rnw|snw)$",".pdf",vig)
    if (file.exists(pdfFile)) {
        newLst$PDFpath <- pdfFile
    }
    else {
        newLst$PDFpath <- character()
    }

    return(newLst)
}

print.pkgFileList <- function(x,...) {
    outFile <- tempfile("RpkgFileList")
    outConn <- file(outFile, open="w")

    first <- TRUE
    out <- ""
    for (i in seq(along=x)) {
        if (out != x[[i]]$OutString) {
            out <- x[[i]]$OutString
            writeLines(paste(ifelse(first,"","\n\n"),out,sep=""),outConn)
        }
        VIE = ifelse(is.null(x[[i]]$VignetteIndexEntry), "",
                 x[[i]]$VignetteIndexEntry)
        VT  = ifelse(is.null(x[[i]]$VignetteTitle), "",
                 x[[i]]$VignetteTitle)

        z <- try(writeLines(formatDL(VIE, VT),outConn))

        if (inherits(z, "try-error")) {
            stop("Vignette ", x[[i]]$vigPath,
                 " appears to have a malformed VignetteIndexEntry",
                 " or VignetteTitle")
        }

        first <- FALSE
    }
    if (first) {
        close(outConn)
        unlink(outFile)
        writeLines("no listings found")
    }
    else {
        ## !!! Mimic footer block of print.packageIQR
        close(outConn)

        file.show(outFile, delete.file=TRUE)
    }
    invisible(x)
}

transformVigInfoLine <- function(el) {
    el <- gsub("}","",el[2])
    el <- unlist(strsplit(el,",[[:space:]]*"))
    if (length(el) == 0)
        el <- NA
    return(el)
}

match.vigNames <- function(vigEntry, names) {
    ## !!! Doesnt work, implemented completely in .transformNames
    entry <- match(vigEntry$VignetteIndexEntry,names)
    if (is.na(entry)) {
        return(NULL)
    }
    else {
        names[entry] <- vigEntry$VigPath
        return(names)
    }
}

.transformNames <- function(names, vigList) {
    ## passed a set of IndexEntries, will grab out of the
    ## list the set of vignette file paths and return that
    ## instead

    ## !! Trying to get match.vigNames to work on some sort
    ## of apply() butfor now loop
    for (i in seq(along=vigList)) {
        entry <- match(vigList[[i]]$VignetteIndexEntry,names)
        if (!is.na(entry)) {
            names[entry] <- vigList[[i]]$PDFpath
        }
    }
   return(gsub("\/\/","\/",names))
}

getVigInfoNames <- function(el,nmVec) {
    name <- gsub("%[[:space:]]*\\\\","",el[1])
    nmVec <- c(nmVec,name)
    return(nmVec)
}


baseVigDesc <- function(vigInfo) {
    ## Passed a vignette info list, returns a vigInfo list with
    ## an output string attached
    if (is.null(vigInfo$VignettePackage))
        desc <- "Vignettes:\n\n"
    else
        desc <- paste("Vignettes in package ",
                      basename(vigInfo$VignettePackage),
                      ":\n\n", sep="")
    vigInfo$OutString <- desc
    return(vigInfo)
}

hasVignetteKeyword <- function(vig,kw="VignetteIndexEntry") {
    file <- readLines(con=vig)
    pattern <- paste("^[[:space:]]*%+[[:space:]]*\\\\",kw,sep="")
    lines <- grep(pattern,file)
    if (length(lines) > 0)
        return(TRUE)
    else
        return(FALSE)
}
getVignette <- function(vigPath,eval=TRUE) {
    ## !!! Needs a lot of work right now, this can be made a lot
    ## !!! smarter.  The 'vigInfo' thing also needs to be looked at.

    require(tools) || stop("Requires package tools")
    chunkList <- Stangle(vigPath,driver=tangleToR)

    ## !! Stangle seems to cut out if no code chunks and return
    ## !! NULL.  Trying to figure out how to return an 'empty' chunkList
    ## !! within the Stangle driver
    if ((is.null(chunkList))||(eval==FALSE))
        chunkList <- new("chunkList", chunks=list(), evalEnv=new.env())

    vigInfo <- getVigInfo(vigPath)
    if (!is.null(vigInfo)) {
        if (is.null(vigInfo$VignettePackage)) {
            vigPkg <- "None"
            vigPkgVers <- buildVersionNumber("0")
        }
        else {
            vigPkg <- vigInfo$VignettePackage
            if (vigPkg %in% installed.packages()[,"Package"])
                vigPkgVers <-
                    buildVersionNumber(package.description(vigPkg,
                                                           fields="Version"))
            else
                vigPkgVers <- buildVersionNumber("0")
        }

        if (is.null(vigInfo$VignetteDepends))
            vigDeps <- character()
        else
            vigDeps <- vigInfo$VignetteDepends


        if (is.null(vigInfo$Requires))
            vigInfo$Requires <- character()

        if (is.null(vigInfo$Suggests))
            vigInfo$Suggests <- character()

        vigObj <- new("Vignette",
                      indexEntry=vigInfo$VignetteIndexEntry,
                      title=vigInfo$VignetteTitle,
                      path=vigPath,
                      pdfPath=vigInfo$PDFpath,
                      depends=vigDeps,
                      requires=vigInfo$Requires,
                      suggests=vigInfo$Suggests,
                      codeChunks=chunkList,
                      package=vigPkg,
                      vigPkgVersion=vigPkgVers
                      )

        return(vigObj)
    }
    return(NULL)
}

    setClass("Vignette", representation(package="character",
                                        vigPkgVersion="VersionNumber"),
             contains="DynDoc")


    if (is.null(getGeneric("vigPkgVersion")))
        setGeneric("vigPkgVersion", function(object)
                   standardGeneric("vigPkgVersion"))
    setMethod("vigPkgVersion", "Vignette", function(object)
              object@vigPkgVersion)




getVignetteCode <- function(vigPath,evalEnv=new.env()) {
    require(tools) || stop("Requires package tools")
    chunkList <- Stangle(vigPath,driver=tangleToR)
    vigInfo <- getVigInfo(vigPath)
    if ((!is.null(chunkList))&&(!is.null(vigInfo))) {
        if (is.null(vigInfo$VignettePackage))
            vigPkg <- "None"
        else
            vigPkg <- vigInfo$VignettePackage
        if (is.null(vigInfo$VignetteDepends))
            vigDeps <- character()
        else
            vigDeps <- vigInfo$VignetteDepends

        vigCode <- new("vignetteCode",chunkList=chunkList,
                       path=vigPath,
                       depends=vigDeps,
                       vigPackage=vigPkg,
                       evalEnv=evalEnv)
        return(vigCode)
    }
    return(NULL)
}

editVignetteCode <- function(vigCode, pos, code) {
    ## copyEnv, list2Env, env2List are copied from Biobase to remove
    ## the dependency of DynDoc on Biobase
    env2list <- function(envir, recurse=FALSE) {
        if (!is.environment(envir))
            stop("envir argument is not an environment")

        ans <- list()
        ## This is basically a lot like multiget() except there isn't
        ## need for checking that what you're looking for exists as
        ## you know it does
        vals <- ls(envir)
        for (i in seq(along=vals))
            ans[[i]] <- get(vals[i], envir=envir, inherits=FALSE)
        names(ans) <- vals

        if ((recurse == TRUE)&&(!is.null(parent.env(envir))))
            ans <- c(ans, list2env(parent.env(envir), recurse))

        ans
    }

    list2env <- function(vals, envir, recurse=FALSE) {
        if (!is.environment(envir))
            stop("envir argument is not an environment")

        if (!is.list(vals))
            stop("vals argument is not a list")

        len <- length(vals)
        if (len == 0)
            return(envir)

        names <- names(vals)
        if (length(names) != len)
            stop("Not a properly named list")

        ## !!! Does this work the way it is intended when recurse=TRUE?
        for (i in 1:len)
            assign(names[i], vals[[i]], envir=envir, inherits=recurse)

        envir
    }

    copyEnv <- function(oldEnv, newEnv=new.env(parent=parent.env(oldEnv)),
                        recurse=FALSE) {
        oldVals <- env2list(oldEnv, recurse)
        newEnv <- list2env(oldVals, newEnv)
        return(newEnv)
    }

    chunks <- chunkList(vigCode)
    setChunk(chunks, pos) <- code

    newVig <- new("vignetteCode",
                  chunkList=chunks,
                  path=path(vigCode),
                  depends=getDepends(vigCode),
                  vigPackage=vigPackage(vigCode),
                  evalEnv=copyEnv(evalEnv(vigCode)))
    return(newVig)
}

setClass("vignetteCode", representation(chunkList="chunkList",
                                        path="character",
                                        vigPackage="character",
                                        depends="character",
                                        evalEnv="environment"))

if (is.null(getGeneric("path")))
    setGeneric("path", function(object)
               standardGeneric("path"))
setMethod("path", "vignetteCode", function(object)
          object@path)

if (is.null(getGeneric("getDepends")))
    setGeneric("getDepends", function(object)
               standardGeneric("getDepends"))
setMethod("getDepends", "vignetteCode", function(object)
          object@depends)

if (is.null(getGeneric("chunks")))
    setGeneric("chunks", function(object)
               standardGeneric("chunks"))
setMethod("chunks", "vignetteCode", function(object)
          chunks(object@chunkList))

if (is.null(getGeneric("chunkList")))
    setGeneric("chunkList", function(object)
               standardGeneric("chunkList"))
setMethod("chunkList", "vignetteCode", function(object)
          object@chunkList)

if (is.null(getGeneric("setChunk<-")))
    setGeneric("setChunk<-", function(object, pos, value)
               standardGeneric("setChunk<-"))
setReplaceMethod("setChunk","vignetteCode",
                 function(object, pos,value) {
                     setChunk(object@chunkList, pos) <- value
                     object
                 })

if (is.null(getGeneric("evalEnv")))
    setGeneric("evalEnv", function(object)
               standardGeneric("evalEnv"))
setMethod("evalEnv", "vignetteCode", function(object)
          object@evalEnv)

if (is.null(getGeneric("numChunks")))
    setGeneric("numChunks", function(object)
               standardGeneric("numChunks"))
setMethod("numChunks","vignetteCode", function(object)
          numChunks(object@chunkList))
if (is.null(getGeneric("getChunk")))
    setGeneric("getChunk", function(object, num)
               standardGeneric("getChunk"))
setMethod("getChunk","vignetteCode", function(object, num)
          getChunk(object@chunkList, num))

if (is.null(getGeneric("evalChunk")))
    setGeneric("evalChunk", function(object, ...)
               standardGeneric("evalChunk"))
setMethod("evalChunk","vignetteCode", function(object, pos) {
    chunk <- chunk(getChunk(object, pos))
    chunkexps <- parse(text=chunk)
    outVec <- character()
    if (length(chunkexps) == 0)
        return(outVec)
    tmpCon <- textConnection("output","w")
    sink(file=tmpCon)
    for (nce in 1:length(chunkexps)) {
        ce <- chunkexps[[nce]]
        dce <- deparse(ce, width.cutoff=0.75*getOption("width"))
        cat(getOption("prompt"),
            paste(dce, collapse=paste("\n",
                       getOption("continue"), sep="")),"\n")
        out <- try(.Internal(eval.with.vis(ce,
                                           object@evalEnv,
                                           NULL)))
        if(inherits(out,"try-error")) {
            sink()
            close(tmpCon)
            stop(out)
        }
        if(out$visible) {
            print(out$value)
        }
        cat("\n")
    }
    sink()
    close(tmpCon)
    output <- paste(output,collapse="\n")
    paste(output,"\n",sep="")
})

setMethod("summary","vignetteCode", function(object) {
    summary(object@chunkList)
})

setMethod("show","vignetteCode", function(object) {
    show(object@chunkList)
})


.initDynDocMethods <- function(where) {
    setGeneric("vigPackage", function(object)
               standardGeneric("vigPackage"), where=where)

    setMethod("vigPackage", "vignetteCode", function(object)
              object@vigPackage, where=where)

    setMethod("vigPackage", "Vignette", function(object)
              object@vigPackage, where=where)
}
.First.lib <- function(libname,pkgname,where) {
    #require("Biobase", quietly=TRUE) ||
    #          stop("cannot load DynDoc without Biobase")
    where <- match(paste("package:", pkgname, sep=""), search())
    .initDynDocMethods(where)
}
