\name{Aggregate}
\alias{Aggregate}
\title{ A simple aggregation mechanism.  }
\description{
 Given an environment and an aggregator (an object of class \code{aggregate}
 simple aggregations are made.
}
\usage{
Aggregate(x, agg)
}
\arguments{
  \item{x}{ The data to be aggregated. }
  \item{agg}{The aggregator to be used. }
}
\details{
  Given some data, \code{x} the user can accumulate (or aggregate)
  information in \code{env} using the two supplied functions.
  See the accompanying documentation for a more complete example of this
  function and its use.
}
\value{
 No value is returned. This function is evaluated purely for side
 effects. The symbols and values in \code{env} are altered.
}

\author{R. Gentleman }

\seealso{ \code{\link{new.env}} }

\examples{
  agg1 <- new("aggregator")
  Aggregate(letters[1:10], agg1)
  #the first 10 letters should be symbols in env1 with values
  # of 1
  Aggregate(letters[5:11], agg1)
  ## now letters[5:10] should have value 2
  bb <- multiget(letters[1:11], env=aggenv(agg1))
  t1 <- as.numeric(bb); names(t1) <- names(bb)
  t1
# a b c d e f g h i j k 
# 1 1 1 1 2 2 2 2 2 2 1 

}
\keyword{ programming }

\eof
\name{aaMap}
\alias{aaMap}
\non_function{}
\title{ names and characteristics of amino acids }
\usage{data(aaMap)}
\description{
The \code{aaMap} data frame has 20 rows and 6 columns.
Include elementary information about amino acids.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{name}{amino acid name}
    \item{let.1}{one-letter code}
    \item{let.3}{three-letter code}
    \item{scProp}{side chain property at pH 7 (polar/nonpolar)}
    \item{hyPhilic}{logical: side chain is hydrophilic at pH 7}
    \item{acidic}{logical: side chain is acidic at pH 7}
  }
}
\details{
}
\source{
Nei M and Kumar S: Molecular evolution and phylogenetics (Oxford 2000), Table 1.2
}
\references{
}
\examples{
data(aaMap)
}
\keyword{datasets}

\eof
\name{addVig2Menu}
\alias{addVig2Menu}
\alias{addVig4Win}
\alias{addVig4Unix}
\alias{addNonExisting}
\alias{addPDF2Vig}

\title{Add menu items to an existing/new menu of a window}
\description{
  These functions add menu items dynamically to an existing or new menu
  of a window for an R session. 
}
\usage{
addVig2Menu(itemName, menuName = "Vignettes", itemAction = "")
addVig4Win(menuName, itemName, itemAction)
addVig4Unix(menuName, itemName, itemAction)
addNonExisting(menuName)
addPDF2Vig(pkgName)
}

\arguments{
  \item{menuName}{\code{menuName} - a character string for the name of
    menu that appears in the menu bar of the window of an R session. The
    string should be in the form of "menu/submenu/.." if a menu contains
    submenus} 
  \item{itemName}{\code{itemName} - a character string for the name of
    the item in the menu defined by \code{menuName}}
  \item{itemAction}{\code{itemAction} a character string for the
    action(s) to be taken when menu item \code{itemName} is selected}
  \item{pkgName}{\code{pkgName} - a character string for the name of an
    R package}
}
\details{
  The code checks to see if a menu already exists and adds an item to
  the menu if so. Otherwise, a new memu will be created with the
  item add.
}
\value{
  The functions do not return any value.
}

\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\examples{
    # Only works for windows now
    if(interactive()){
        addPDF2Menu("Biobase")
    }
}
\keyword{interface}


\eof
\name{aggregator-class}
\docType{class}
\alias{aggregator-class}
\alias{aggenv}
\alias{aggenv,aggregator-method}
\alias{aggfun,aggregator-method}
\alias{aggfun}
\alias{initfun}
\alias{initfun,aggregator-method}

\title{Class aggregator, a class of aggregators }
\description{ A class of objects designed to help aggregate
   calculations over an iterative computation. The aggregator consists
   of three objects. An environment to hold the values.
   A function that sets up an initial value the first time an object is
   seen. An aggregate function that increments the value of an object
   seen previously. }
\section{Creating Objects}{
\code{  new('aggregator',}\cr
\code{    aggenv  = ..../, # Object of class environment}\cr
\code{    initfun = ...., # Object of class function}\cr
\code{    aggfun  = ...., # Object of class function}\cr
\code{  )}}
\section{Slots}{
  \describe{
    \item{\code{aggenv}:}{Object of class "environment", holds the
      values between iterations. }
    \item{\code{initfun}:}{Object of class "function" specifies how to
      initialize the value for a name the first time it is encountered. }
    \item{\code{aggfun}:}{Object of class "function" used to increment
      (or perform any other function) on a name. }
  }
}
\section{Prototype}{
  describe{
    \item{\code{aggenv}:}{\code{new.env(hash=TRUE)} }
    \item{\code{initfun}:}{\code{function(name, val) 1} }
    \item{\code{aggfun}:}{ \code{function(name, current, val) current+1} }
  }
}
\details{
  This class is used to help aggregate different values over function
  calls. A very simple example is to use leave one out cross-validation
  for prediction. At each stage we first perform feature selection and
  then cross-validate. To keep track of how often each feature is
  selected we can use an aggregator. At the end of the cross-validation
  we can extract the names of the features chosen from \code{aggenv}.
  }
\section{Methods}{
  \describe{
    \item{aggenv}{(aggregator): Used to access the environment of the
      aggregator. }
    \item{aggfun}{(aggregator): Used to access the function that aggregates. }
    \item{initfun}{(aggregator): Used to access the initializer function. }
  }
}
\keyword{methods}

\eof
\name{as.data.frame.exprSet}
\alias{as.data.frame.exprSet}
\title{ converts an exprSet to a dataframe }
\description{
  
}
\usage{
as.data.frame.exprSet(x, row.names = NA, optional = NA)
}
\arguments{
  \item{x}{ \code{\link[Biobase]{exprSet}}}
  \item{row.names}{ see \code{as.data.frame}}
  \item{optional}{ see \code{as.data.frame}}
}
\details{

}
\value{
  A \code{data.frame}. The first column is called \code{exprs} and
  contains the values returned by the method \code{exprs()}.
  The second column is called genenames and contains the values
  returned by the method \code{geneNames()}.
  The other columns will depend on the contents of the
  \code{\link[Biobase]{phenoData}} slot.
}
\author{ laurent@cbs.dtu.dk }
\examples{
data(eset)

sd.genes <- esApply(eset, 1, sd)

dataf <- as.data.frame(eset)

dataf <- cbind(dataf, sd.genes=rep(unname(sd.genes), length=nrow(dataf)))

coplot(sd.genes ~ exprs | cov1+cov2, data=dataf)

}
\keyword{ manip }


\eof
\name{characterORMIAME-class}
\docType{class}
\alias{characterORMIAME-class}
\alias{characterORMIAME}
\title{Class characterORMIAME, a class to make older versions compatible}
\description{This class can be either \code{character} or
  \code{MIAME}. It is for the description slot in exprSet}
\section{Methods}{
No methods defined with class "characterORMIAME" in the signature.
}
\seealso{ See also \code{\link{MIAME-class}}, \code{\link{exprSet-class}}}
\keyword{classes}

\eof
\name{container-class}
\docType{class}
\alias{container-class}
\alias{[,container-method}
\alias{length,container-method}
\alias{content,container-method}
\alias{content}
\alias{locked}
\alias{locked,container-method}
\alias{[[<-,container-method}
\alias{[[,container-method}
\alias{show,container-method}

 \title{container: a class that specializes the list construct of R
   to provide content and access control }
 \description{ A lockable list structure with constraints on content. }
 \usage{ #new('container', x=[list], content=[character], locked=[logical] )} 
 \section{Slots}{ 
   \item{x}{[class: list] list of entities that are guaranteed to share a
     certain property}
  \item{content}{[class: character] tag describing container contents }
  \item{locked}{[class: logical] boolean indicator of locked status.
    locked==TRUE implies assignments into the container are not permitted }
 }

\section{Methods}{
 \item{\code{content}}{returns \code{content} slot of argument}
 \item{\code{locked}}{returns \code{locked} slot of argument}
 \item{\code{show}}{prints container}
 \item{\code{[[}(replace)}{replace elements in the container }
 \item{\code{[[}(access)}{access elements in a container}
 \item{\code{[}(access)}{make a subset of a container (which will itself
 be a container)}
 }
\examples{
  x1 <- new("container", x=vector("list", length=3), content="lm")
  lm1 <- lm(rnorm(10)~runif(10))
  x1[[1]] <- lm1
 }
\keyword{methods}

\eof
\name{copyEnv}
\alias{copyEnv}
\alias{list2env}
\alias{env2list}
\title{Functionality to copy environments}
\description{
  These functions can be used to make copies of environments, or to
  get/assign all of the objects inside of an environment
}
\usage{
copyEnv(oldEnv, newEnv = new.env(parent = parent.env(oldEnv)), recurse = FALSE)
env2list(envir, recurse=FALSE)
list2env(vals, envir, recurse=FALSE)
}
\arguments{
  \item{oldEnv}{An environment to copy from}
  \item{newEnv}{An environment to copy to.  Default is a new environment
  with the same parent environment as oldEnv.}
  \item{envir}{An environment to get/set values to}
  \item{vals}{A named list of objects to assign into an environment}
  \item{recurse}{Whether to recurse upwards through the environment hierarchy}
}
\details{
  \code{env2list}:  This function will retrieve the objects from an
  environment and return them in a named list (names being the names of
  the objects).
  \code{list2env}:  This function will take a named list and assign all
  of its elements into the environment (using the names to name the
  objects).
  \code{copyEnv}:  This function will make a copy of the contents from
  \code{oldEnv} and place them into \code{newEnv}.
}
\author{Jeff Gentry}
\seealso{\code{\link{environment}}}
\examples{
   z <- new.env()
   multiassign(c("a","b","c"),c(1,2,3),z)

   a <- copyEnv(z)
   ls(a)

   q <- env2list(z)
   g <- new.env()
   g <- list2env(q,g)   
   ls(g)
}
\keyword{utilities}

\eof
\name{copySubstitute}
\alias{copySubstitute}
\title{Copy between connections or from an to files with configure-like
  name-value substitution}
\description{
  Copy files, directory trees or between connections and
  replace all occurences of a symbol by the corresponding value. 
}
\usage{copySubstitute(src, dest, symbolValues, symbolDelimiter="@",
allowUnresolvedSymbols=FALSE, recursive = FALSE, removeExtension = "\\.in$")}
\arguments{
  \item{src}{Source, either a character vector with filenames and/or
    directory names, or a connection object.}
  \item{dest}{Destination, either a character vector of length 1
    with the name of an existing, writeable directory, or a connection
    object. The class of the \code{dest} argument must match that of the
    \code{src} argument.}
  \item{symbolValues}{A named list of character strings.}
  \item{symbolDelimiter}{A character string of length one with a single
    character in it.}
  \item{allowUnresolvedSymbols}{Logical. If \code{FALSE}, then the function
    will execute \code{\link[base:stop]{stop}} if it comes across
    symbols that are not defined in \code{symbolValues}.}
  \item{recursive}{Logical. If \code{TRUE}, the function
    works recursively down a directory tree (see details).}
  \item{removeExtension}{Character. Matches to this regular expression are removed
    from filenames and directory names.}
}

\details{
  Symbol substitution: this is best explained with an example. If the list
  \code{symbolValues} contains an element with name \code{FOO} and value
  \code{bar}, and symbolDelimiter is \code{@}, then any occurence of
  \code{@FOO@} is replaced by \code{bar}. This applies both the text
  contents of the files in \code{src} as well as to the filenames. See examples.
  
  If \code{recursive} is \code{FALSE}, both \code{src} and \code{dest}
  must be connection or a filenames. The text in \code{src} is read
  through the function \code{\link[base:readLines]{readLines}},
  symbols are replaced by their values, and the result is written to
  \code{dest} through the function \code{\link[base:readLines]{writeLines}}. 

  If \code{recursive} is \code{TRUE}, 
  \code{\link[Biobase:copySubstitute]{copySubstitute}}
  works recursively down a directory tree (see details and example).
  \code{src} must be a character vector with multiple filenames or
  directory names, \code{dest} a directory name.

  One use of this function is in
  \code{\link[Biobase:createPackage]{createPackage}}
  for the automatic generation of packages from a template package directory.
}

\value{
  None. The function is called for its side effect.
}

\author{Wolfgang Huber \url{http://www.dkfz.de/mga/whuber}}
\keyword{connection}
\keyword{programming}

\examples{
## create an example file
infile  = tempfile()
outfile = tempfile()

writeLines(text=c("We will perform in @WHAT@:",
  "So, thanks to @WHOM@ at once and to each one,",
  "Whom we invite to see us crown'd at @WHERE@."),
  con = infile) 

## create the symbol table
z = list(WHAT="measure, time and place", WHOM="all", WHERE="Scone")

## run copySubstitute
copySubstitute(infile, outfile, z)

## display the results
readLines(outfile)



##--------------------------------------------------------------
## This is a slightly more complicated example that demonstrates 
## how copySubstitute works on nested directories
##--------------------------------------------------------------
d = tempdir()
my.dir.create = function(x) {dir.create(x); return(x)}

unlink(file.path(d, "src"), recursive=TRUE)
unlink(file.path(d, "dest"), recursive=TRUE)

## create some directories and files:
src  = my.dir.create(file.path(d, "src"))
dest = file.path(d, "dest")
d1   = my.dir.create(file.path(src, "dir1.in"))
d2   = my.dir.create(file.path(src, "dir2@FOO@.in"))
d3   = my.dir.create(file.path(d2, "dir3"))
d4   = my.dir.create(file.path(d3, "dir4"))
d5   = my.dir.create(file.path(d4, "dir5@BAR@"))
writeLines(c("File1:", "FOO: @FOO@"),     file.path(d1, "file1.txt.in"))
writeLines(c("File2:", "BAR: @BAR@"),     file.path(d2, "file2.txt.in"))
writeLines(c("File3:", "SUN: @SUN@"),     file.path(d3, "file3.txt.in"))
writeLines(c("File4:", "MOON: @MOON@"),   file.path(d4, "@SUN@.txt"))

## call copySubstitute
copySubstitute(src, dest, recursive=TRUE,
               symbolValues = list(FOO="thefoo", BAR="thebar", 
                                   SUN="thesun", MOON="themoon"))

## view the result
listsrc  = dir(src,  full.names=TRUE, recursive=TRUE)
listdest = dir(dest, full.names=TRUE, recursive=TRUE)
listsrc
listdest

cat(unlist(lapply(listsrc,  readLines)), sep="\n")
cat(unlist(lapply(listdest, readLines)), sep="\n")
}


\eof
\name{createPackage}
\alias{createPackage}
\title{Create a package directory from a template, with symbol-value substitution}
\description{
  Create a package directory from a template, with symbol-value substitution
}
\usage{createPackage(pkgname, destinationDir, originDir, symbolValues,
                     unlink=FALSE, quiet=FALSE)}
\arguments{
  \item{pkgname}{Character. The name of the package to be written.}
  \item{destinationDir}{Character. The path to a directory where the
    package is to be written.}
  \item{originDir}{Character. The path to a directory that contains
    the template package. Usually, this will contain a file named
    \code{DESCRIPTION}, and subdirectories \code{R}, \code{man},
    \code{data}. In all files and filenames, symbols will be replaced
    by their respectives values, see the parameter \code{symbolValues}.}
  \item{symbolValues}{Named list of character strings. The symbol-to-value
    mapping. See 
    \code{\link[Biobase:copySubstitute]{copySubstitute}} for details.}
  \item{unlink}{Logical. If \code{TRUE}, and \code{destinationDir}
    already contains a file or directory with the name \code{pkgname},
    try to unlink (remove) it.}
  \item{quiet}{Logical. If \code{TRUE}, do not print information
    messages.}
}

\details{The intended use of this function is for the automated mass
  production of data packages, such as the microarray annotation,
  CDF, and probe sequence packages. An example is in the function 
  \code{\link[matchprobes:makeProbePackage]{makeProbePackage}}.
  
  No syntactic or other checking of the package is performed. For this,
  use R CMD check.

  The symbols \code{@PKGNAME@} and \code{@DATE@} are automatically
  defined with the values of \code{pkgname} and \code{\date()}, respectively.
}

\value{
  The function returns a \code{list} with one element
  \code{pkgdir}: the path to the package.
}

\seealso{\code{\link[Biobase:copySubstitute]{copySubstitute}},
  \code{\link[matchprobes:makeProbePackage]{makeProbePackage}},
  the reference manual \emph{Writing R extensions}.}

\author{Wolfgang Huber \url{http://www.dkfz.de/mga/whuber}}

\keyword{programming}

\examples{
  sym  = list(AUTHOR = "Hesiod", VERSION = "1.0",
         TITLE = "the nine muses",
         FORMAT = "Character vector containg the names of the 9 muses.")

  res  = createPackage("muses",
           destinationDir = tempdir(),
           originDir      = file.path(.path.package("Biobase"), "Code"),
           symbolValues   = sym,
           unlink = TRUE, quiet = FALSE)

  muses = c("Calliope", "Clio", "Erato", "Euterpe", "Melpomene",
            "Polyhymnia", "Terpsichore", "Thalia", "Urania")

  dir.create(file.path(res$pkgdir, "data"))

  save(muses, file = file.path(res$pkgdir, "data", "muses.rda"))

  res$pkgdir
}


\eof
\name{dumpPackTxt}
\alias{dumpPackTxt}
\title{dump textual description of a package  }
\description{dump textual description of a package
}
\usage{
dumpPackTxt(package)
}
\arguments{
  \item{package}{ character string naming an R package}
}
\details{
dumps DESCRIPTION and INDEX files from package sources
}
\value{
writes to stdout
}
\references{  }
\author{<stvjc@channing.harvard.edu>}
\note{ Other approaches using formatDL are feasible }


\seealso{  }

\examples{
dumpPackTxt("ctest")
}
\keyword{ models }

\eof
\name{esApply}
\alias{esApply}
\title{ Apply for the expression data in an exprSet }
\description{
esApply is a wrapper to apply for use with exprSets.
Because the application of a function to the rows of the expression
array usually involves variables in the \code{phenoData} slot we have
used a special evaluation paradigm here.
The function \code{FUN} may reference any data in phenoData by name.
}
\usage{
esApply(X, MARGIN, FUN, ...)
}
\arguments{
  \item{X}{ an instance of the exprSet class of the Biobase package.
It is assumed that \code{X} has information
on gene expression for G genes in N tissue samples. }
  \item{MARGIN}{ The margin to apply to, either 1 for rows or 2 for columns.}
  \item{FUN}{ any function }
  \item{...}{additional parameters for FUN.}
}
\details{
 The \code{phenoData} from \code{X} is installed in an
 environment. This environment is installed as the environment of
 \code{FUN}. This will then provide bindings for any symbols in \code{FUN}
 that are the same as the names of the \code{phenoData} of \code{X}.
 If \code{FUN} has an environment already it is retained but placed after
 the newly created environment. Some variable shadowing could occur
 under these circumstances.
}
\value{
The result of \code{apply(exprs(X),MARGIN, FUN, ...)}.
}
\author{ VJ Carey <stvjc@channing.harvard.edu>, R. Gentleman }

\seealso{ \code{\link{apply}} }

\examples{
require(Biobase)
data(eset)

# we know that eset has covariates in
# the pData called "cov1" and "cov2"
#
# here are two functions conforming to the esApply
# protocol

##here cov1 is an unbound value, it will be resolved
##by using the pData

mytt.demo <- function(y) {
 ys <- split( y, cov1 )
 t.test( ys[[1]], ys[[2]] )$p.value
 }

myreg.demo <- function( y ) {
# obtain the p value of the slope
# associated with cov2, adjusting for cov1
# (if we were concerned with sign we could
# save the z statistic instead at coef[3,3]
#
 summary(lm(y~cov1+cov2))$coef[3,4]
 }

# let's try it out

newt <- esApply( eset, 1, mytt.demo )

# here's a resampling method 

resamp <- function( ESET ) {
 ntiss <- ncol(exprs(ESET))
 newind <- sample(1:ntiss, size=ntiss, replace=TRUE)
 ESET[newind,]
 }

# here's a filter

q3g100filt <- function( eset ) {
 apply( exprs(eset), 1, function(x)quantile(x,.75)>100 )
 }

# want to filter after resampling and then apply

set.seed(123)
rest <- esApply( { bool <- q3g100filt(resamp(eset)); eset[bool,] }, 1,
mytt.demo ) 
 
}
\keyword{ models }

\eof
\name{eset}
\alias{eset}
\non_function{}
\title{ A dataset of class exprSet  }
\usage{data(eset)}
\format{
 The data are real but anonymized. There are 26 cases, labeled A to Z
 and 500 genes. The data are from an experiment that used Affymetrix
 U95v2 chips. The data were processed by dChip and then exported to R
 for analysis.
}
\description{
  The data are described above.
  }
\source{
 Sabina Chiaretti of the Ritz Laboratory at the Dana Farber Cancer
 Institute. 
}
\examples{
data(eset)
}
\keyword{datasets}

\eof
\name{exprMatrix-class}
\docType{class}
\alias{exprMatrix-class}

\title{ Class union for objects behaving like a matrix }
\description{  Class union "exprMatrix" represents the type of exprs and
  se.exprs slots in "exprSet" objects. One of the classes in the union
  is always "matrix" }
\section{Objects from the Class}{A virtual Class: No objects may be created from it.}
\section{Methods}{
No methods defined with class "exprMatrix" in the signature.
}
\keyword{classes}

\eof
\name{exprSet-class}
\docType{class}
\alias{annotation}
\alias{annotation<-}
\alias{description}
\alias{description<-}
\alias{exprs}
\alias{exprs2excel}
\alias{exprs<-}
\alias{geneNames}
\alias{geneNames<-}
\alias{notes}
\alias{notes<-}
\alias{pData}
\alias{pData<-}
\alias{phenoData}
\alias{phenoData<-}
\alias{sampleNames}
\alias{se.exprs}
\alias{update2MIAME}
\alias{varLabels}
\alias{update2MIAME,exprSet-method}
\alias{write.exprs}
\alias{exprSet-class}
\alias{exprSet}
\alias{$.exprSet}
\alias{description,exprSet-method}
\alias{description<-,exprSet-method}
\alias{exprs,exprSet-method}
\alias{exprs<-,exprSet-method}
\alias{se.exprs,exprSet-method}
\alias{[,exprSet-method}
\alias{[[<-,exprSet-method}
\alias{[[,exprSet-method}
\alias{se.exprs<-}
\alias{se.exprs<-,exprSet-method}
\alias{notes,exprSet-method}
\alias{notes<-,exprSet-method}
\alias{geneNames,exprSet-method}
\alias{geneNames<-,exprSet-method}
\alias{pData,exprSet-method}
\alias{pData<-,exprSet-method}
\alias{varLabels,exprSet-method}
\alias{sampleNames,exprSet-method}
\alias{phenoData,exprSet-method}
\alias{phenoData<-,exprSet,phenoData-method}
\alias{annotation,exprSet-method}
\alias{annotation<-,exprSet-method}
\alias{show,exprSet-method}
\alias{split,exprSet,vector-method}
\alias{write.exprs,exprSet-method}
\alias{exprs2excel,exprSet-method}
\title{Class exprSet, a class for microarray data, and methods for
  processing them } 
\description{ This is class representation for Microarray Data}
\section{Creating Objects}{
\code{  new('exprSet',}\cr
\code{    exprs       = ...., # Object of class matrix}\cr
\code{    se.exprs    = ...., # Object of class matrix}\cr
\code{    phenoData   = ...., # Object of class phenoData}\cr
\code{    annotation  = ...., # Object of class character}\cr
\code{    description = ...., # Object of class MIAME}\cr
\code{    notes       = ...., # Object of class character}\cr
\code{  )}}
\section{Slots}{
  \describe{
    \item{\code{exprs}:}{Object of class "matrix" The observed
      expression levels. This is 
     a matrix with columns representing patients or cases and rows
     representing genes. }
    \item{\code{se.exprs}:}{Object of class "matrix" This is
     a matrix of the same dimensions as \code{exprs} which contains
     standard error estimates for the estimated expression levels. }
    \item{\code{phenoData}:}{Object of class "phenoData" This is an
      instance of class \code{phenoData} 
    containing the patient (or case) level data. The columns of the
    pData slot of this entity represent
    variables and the rows represent patients or cases. }
    \item{\code{annotation}}{A character string identifying the
      annotation that may be used for the \code{exprSet} instance.}
    \item{\code{description}:}{Object of class "MIAME". For
      compatibility with previous version of this class description can
      also be a "character". The clase \code{characterOrMIAME} has been
      defined just for this.} 
    \item{\code{notes}:}{Object of class "character" Vector of
      explanatory text }
  }
}

\section{Methods}{
  \describe{
    \item{[}{(exprSet): A subset operator. Ensures that both \code{exprs}
      and \code{phenoData} are subset properly. }
    \item{[[}{(exprSet): Extract the named variable from the
      \code{phenoData} component. }    
    \item{exprs}{(exprSet): An accessor function for \code{exprs}. }
    
    \item{se.exprs}{(exprSet): An accessor function for \code{se.exprs}. }
    
    
    \item{description}{(exprSet): Obtain the description (MIAME class) of  \code{exprSet}. }
    \item{description<-}{(exprSet): Set the description (MIAME class) of
      \code{exprSet}. }

    \item{notes}{(exprSet): Obtain the notes of  \code{exprSet}. }
    \item{notes<-}{(exprSet): Set the notes of
      \code{exprSet}. }

    \item{geneNames}{(exprSet): Obtain the gene names (row names) of
      \code{exprs}. }
    \item{geneNames<-}{(exprSet): Set the gene names (row names) of
      \code{exprs}. }
    
    \item{iter}{(exprSet, missing, function): an iterator over genes.
Returns the result of applying \code{function} to the matrix
of expressions on margin 1 (see \code{apply}) }

    \item{iter}{(exprSet, missing, list): a multi-iterator over genes.
Concatenates result of applying each function in the list \code{list}
in a matrix (assumes result of each function evaluation is a scalar). }

    \item{iter}{(exprSet, covlab=character, function): a iterator over
genes: \code{function} is assumed to have arguments x and y;
the pData element named by covlab will be bound to x, the
gene expression values will be iteratively bound to y}

    \item{phenoData}{(exprSet): An accessor function returns the
      \code{phenoData} instance from the \code{exprSet}.}

   \item{pData}{(exprSet): An accessor function for the \code{pData}
     slot of the \code{phenoData} contained in the instance.}

   \item{pData<-}{(exprSet): A replacement method for the \code{pData}
     slot of the \code{phenoData} contained in the instance.}

     \item{sampleNames}{(exprSet): An accessor function for sample
       labels. These are the column labels of \code{exprs} and the row
       labels from \code{pData}. The function takes preferably the
       column labels of \code{exprs} (if any).
     }
     
    \item{show}{(exprSet): renders information about the exprSet
      in a concise way on stdout. }

    \item{split}{(exprSet, vector): splits the exprSet. The returned
      value is a list, each component of which is an \code{exprSet}.
      If the length of \code{vector} is a divisor of the number of rows
      in the expression array then the expression array is
      split. Subsequently, if the length of \code{vector} is a divisor
      of the number of rows of the phenoData data frame then the split
      is made on this.}
    \item{annotation}{(exprSet): An accessor function for the annotation
      information.}
    \item{write.exprs}{(exprSet,...): Writes the expression levels to
      file. It takes the same arguments as \code{\link{write.table}}. If
      called with no arguments it is equivalent to
      write.table(exprs(exprSet),file="tmp.txt",quote=FALSE,sep="\t").} 
    \item{exprs2excel}{(exprSet,...): 
      Writes the expression levels to \code{csv}
      file. This file will open nicely in excel. It takes the same
      arguments as \code{\link{write.table}}. If 
      called with no arguments it is equivalent to
      \code{write.table(exprs(exprSet),file="tmp.csv", sep = ",", col.names = NA)}.}
    \item{\$}{An old-style method.
      It is \code{pData(eset)[[as.character(val)]]} which
      does not quite have the right semantics but it is close. This
      operator extracts the named component of the \code{pData} slot in
      \code{phenoData}.}
    \item{update2MIAME}{(exprSet,...): Converts \code{exprSet}s from
      previous versions, that have a \code{character} in description to
      an object that has an instance of the class \code{MIAME} in
      the description slot. The old description is stored in the
      \code{title} slot. If the object already has a \code{MIAME}
      description the same object is returned.}
    } 
  }
}
\examples{
  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  eset <- new("exprSet", exprs=geneData, phenoData=pdata)
  eset
  eset[,1:10]
  eset[,1]
  eset[1,]
  eset[1,1]
  eset[1:100,]
  eset[1:44,c(2,4,6)]
  Means <- iter(eset, f=mean)

  chkdich <- function(x) if(length(unique(x))!=2) stop("x not dichotomous")
  mytt <- function(x,y) {
     chkdich(x)
     d <- split(y,x)
     t.test(d[[1]],d[[2]])$p.val
  }
  
  Tpvals <- iter(eset, "cov1", mytt )

  sp1 <- split(eset, c(1,2))
  sp2 <- split(eset, c(rep(1,6), rep(2,7)))
}
\seealso{MIAME-class}
\keyword{methods}

\eof
\name{geneData}
\alias{geneData}
\alias{geneCov}
\non_function{}
\title{ A subset of some expression data. }
\usage{data(geneData)}
\description{
The \code{geneData} data frame has 500 rows and 26 columns.
It consists of a subset of real expression data from an Affymetrix U95v2
chip. The data are anonymous. The covariate data \code{geneCov} is made
up. 
}
\format{
  A 500 by 26 data frame.
}

\source{
  The J. Ritz Laboratory (S. Chiaretti).
}

\examples{
data(geneData)
}
\keyword{datasets}

\eof
\name{getPkgVigs}
\alias{getPkgVigs}
\title{A function to list PDF files for a package}
\description{
  This function will return a listing of all vignettes (PDF files)
  stored in a package's \code{doc} directory.
}
\usage{
getPkgVigs(package = NULL)
}
\arguments{
  \item{package}{character vector of packages to search or \code{NULL}.
    The latter is for all attached packages (in \code{\link{search}()}).}
}
\value{
  A named vector, with elements being file paths of PDF files on a
  user's system and the names being the actual PDF filename without the
  \code{.pdf} extension (example: \file{/R/library/test/doc/foo.pdf} has
  \code{foo} as a name).
}
\author{Jeff Gentry}
\seealso{\code{\link{openVignette}}}
\examples{
 z <- getPkgVigs()
 z # and look at them
}
\keyword{utilities}

\eof
\name{iter-methods}
\docType{methods}
\title{ Methods for the generic iter.}
\alias{iter-methods}
\alias{iter}
\alias{iter,exprSet,missing,function-method}
\alias{iter,exprSet,missing,list-method}
\alias{iter,exprSet,character,function-method}
\description{
  This is a set of methods to iterate over different types of
  objects. The behaviour of the methods is similar to that of the
  \code{apply} family.}
\section{Methods}{\describe{
\item{object = exprSet, covlab = missing, f = function}{ Apply the
  function \code{f} to the rows of the expression data, \code{exprs}, of
  \code{object}. } 
\item{object = exprSet, covlab = missing, f = list}{ In this case it is
  presumed that \code{f} is a list of functions, each of which returns a
single value. The functions are applied sequentially to the rows of the
expression data, \code{exprs}, of \code{object}. The answers are stored in
the columns of the return matrix. }
\item{object = exprSet, covlab = character, f = function}{ The function
  \code{f} is assumed to be a function of two arguments. The covariate in
the \code{object} with name specified by \code{covlab} is extracted and
bound to the second argument of \code{f}. Then the resultant function is
passed back through \code{iter} and we effectively obtain the result of
this function applied to the rows of the expression data, \code{exprs}, of
  \code{object}. } 
}}
\keyword{methods}


\eof
\name{MIAME-class}
\docType{class}
\alias{MIAME-class}
\alias{MIAME}
\alias{abstract}
\alias{abstract,MIAME-method}
\alias{abstract,exprSet-method}
\alias{expinfo}
\alias{expinfo,MIAME-method}
\alias{hybridizations}
\alias{hybridizations,MIAME-method}
\alias{normControls}
\alias{normControls,MIAME-method}
\alias{preproc}
\alias{preproc,MIAME-method}
\alias{samples}
\alias{samples,MIAME-method}
\alias{otherInfo}
\alias{otherInfo,MIAME-method}
\alias{show,MIAME-method}

\title{Class MIAME, a class for storing microarray experiment information}
\description{We try to cover the MIAME entries that are not covered by
  other classes in Bioconductor. Namely, experimental design, samples,
  hybridizations, normalization controls, and pre-processing information.}
\section{Slots}{
  \describe{
    \item{\code{name}:}{Object of class \code{"character"} containing
      the experimenter name}
    \item{\code{lab}:}{Object of class \code{"character"} containing the
      laboratory where the experiment was conducted}
    \item{\code{contact}:}{Object of class \code{"character"} containing
      contact information for lab and/or experimenter}
    \item{\code{title}:}{Object of class \code{"character"} containing a single-sentence experiment title }
    \item{\code{abstract}:}{Object of class \code{"character"}
      containing an abstract describing the experiment}
    \item{\code{url}:}{Object of class \code{"character"} containing
      a URL for the experiment}
    \item{\code{samples}:}{Object of class \code{"list"} containg
      information about the samples}
    \item{\code{hybridizations}:}{Object of class \code{"list"}
      containing information about the hybridizations}
    \item{\code{normControls}:}{Object of class \code{"list"}
      containing information about the controls such as house keeping genes}
    \item{\code{preprocessing}:}{Object of class \code{"list"} containing
      information about the pre-processing steps used on the raw data
      from this experiment}
    \item{\code{other}:}{Object of class \code{"list"} containing other 
      information for which none of the above slots does not applies}
  }
}

\section{Methods}{
  \describe{
    \item{abstract}{\code{signature(object = "MIAME")}: An accesor
      function for \code{abstract}}
    \item{expinfo}{\code{signature(object = "MIAME")}: An accesor
      function for \code{name}, \code{lab}, \code{contact}, \code{title},
      and \code{url},}
    \item{hybridizations}{\code{signature(object = "MIAME")}: An accesor
      function for \code{hybridizations} }
    \item{normControls}{\code{signature(object = "MIAME")}: An accesor
      function for \code{normControls} }
    \item{otherInfo}{\code{signature(object = "MIAME")}: An accesor
      function for \code{other} }
    \item{samples}{\code{signature(object = "MIAME")}: An accesor
      function for \code{samples} }
    \item{show}{\code{signature(object = "MIAME")}: renders information
      about the MIAME information }
  }
}
\references{\url{http://www.mged.org/Workgroups/MIAME/miame_1.1.html}}
\author{Rafael A. Irizarry}
\keyword{classes}


\eof
\name{multiassign}
\alias{multiassign}
\title{Assign Values to a Names}
\description{
  Assign values to names in an environment.
}
\usage{
multiassign(x, value, envir = parent.frame(), inherits=FALSE)
}
\arguments{
  \item{x}{A vector or list of names, represented by strings.}
  \item{value}{a vector or list of values to be assigned.}
  \item{envir}{the \code{\link{environment}} to use. See the details section.}
  \item{inherits}{should the enclosing frames of the environment be
    inspected?}
}
\details{
  The \code{pos} argument can specify the  environment in which to assign
  the object in any of several ways:
  as an integer (the position in the \code{\link{search}} list); as
  the character string name of an element in the search list; or as an
  \code{\link{environment}} (including using \code{\link{sys.frame}} to
  access the currently active function calls).
  The \code{envir} argument is an alternative way to specify an
  environment, but is primarily there for back compatibility.

  If \code{value} is missing and \code{x} has names then the values in
  each element of \code{x} are assigned to the names of \code{x}.
}
\value{
  This function is invoked for its side effect, which is assigning
  the \code{values} to the variables in \code{x}.  If no \code{envir} is
  specified, then the assignment takes place in the currently active
  environment.

  If \code{inherits} is \code{TRUE}, enclosing environments of the supplied
  environment are searched until the variable \code{x} is encountered.
  The value is then assigned in the environment in which the variable is
  encountered.  If the symbol is not encountered then assignment takes
  place in the user's workspace (the global environment).

  If \code{inherits} is \code{FALSE}, assignment takes place in the
  initial frame of \code{envir}.
}

\seealso{
  \code{\link{multiget}} }

\examples{
#-- Create objects  'r1', 'r2', ... 'r6' --
nam <- paste("r",1:6, sep=".")

multiassign(nam, 11:16)
ls(pat="^r..$")

#assign the values in y to variables with the names from y

y<-list(a=4,d=mean,c="aaa")
multiassign(y)


}
\keyword{data}













\eof
\name{multiget}
\alias{multiget}
\title{Return a list containing the Values of the supplied variables.}
\description{
  Search for an \R objects with a given names and return the values found.
}
 
\usage{
multiget(x, pos=-1, envir=as.environment(pos), mode="any",
inherits=TRUE, iffail)
}
\arguments{
  \item{x}{a vector or list of variable names (given as a quoted
    character strings).} 
  \item{pos}{where to look for the object (see the details section); if
    omitted, the function will search, as if the name of the object
    appeared in unquoted in an expression.
  }
  \item{envir}{an alternative way to specify an environment to look in;
    see the details section.}
  \item{mode}{the mode of object sought.}
  \item{inherits}{should the enclosing frames of the environment be
    inspected?}
  \item{iffail}{A value to be used for items in the list that are not found.}
}
\details{
  The \code{pos} argument can specify the  environment in which to look
  for the object in any of several ways:
  as an integer (the position in the \code{\link{search}} list); as
  the character string name of an element in the search list; or as an
  \code{\link{environment}} (including using \code{\link{sys.frame}} to
  access the currently active function calls).
  The \code{envir} argument is an alternative way to specify an
  environment, but is primarily there for back compatibility.
  
   The \code{mode} includes collections such as \code{"numeric"} and
   \code{"function"}: any member of the collection will suffice. 
}
\value{
  A named list (the names come from \code{x}) of the variables found.
  If \code{iffail} was specified then any object named in \code{x} that
  is not found will have the value of \code{iffail} as its value.
  Each variable lookup is wrappted in a \code{try} call so that failure
  to find one variable does not prevent finding others.
  
  This function searches the specified environment for a bound variable
  whose name is given by the character string \code{x}.  If the
  variable's value is not of the correct \code{mode}, it is ignored.

  If \code{inherits} is \code{FALSE}, only the first frame of the
  specified environment is inspected.  If \code{inherits} is
  \code{TRUE}, the search is continued up through the parent frames
  until a bound value of the right mode is found.

  Using a \code{NULL} environment is equivalent to using the current
  environment.
}
\seealso{
  \code{\link{exists}}, \code{\link{multiassign}}.
}
\examples{
nam <- paste("r",1:6, sep=".")

multiassign(nam, 11:16)
rm("r.3")
multiget(nam, iffail=NA)

}
\keyword{data}

\eof
\name{openPDF}
\alias{openPDF}
\title{A function to view PDF files}
\description{
Displays the specified PDF file.
}
\usage{
openPDF(file, bg=TRUE)
}
\arguments{
  \item{file}{A character string, indicating the file to view}
  \item{bg}{Should the pdf viewer be opened in the background.}
}
\details{
  Currently this function works on Windows and Unix platforms.  Under
  Windows, whatever program is associated with the file extension will
  be used.  Under Unix, the function will use the program named in the
  option "pdfViewer" (default is 'acroread').

  The \code{bg} argument is only interpreted on Unix.
}
\value{
This function is executed for its side effects.  The specified PDF file
is opened in the PDF viewer and \code{TRUE} is returned.
}
\author{ Jeff Gentry}

\examples{
\dontrun{openPDF("annotate.pdf")}
}
\keyword{utilities}


\eof
\name{openVignette}
\alias{openVignette}
\title{ Open a selected Vignette }
\description{
  Using the data returned by \code{vignette} this function provides a
  simple easy to use interface for opening vignettes.
}
\usage{
openVignette(package=NULL)
}
\arguments{
  \item{package}{character string indicating the package to be used.}
 }
 \details{
   If \code{package} is NULL then all packages are scanned for
   vignettes.  The list of vignettes is presented to the user via the
   \code{menu} command.  The user may select one of the vignettes to be
   opened in a PDF viewer.
}
\value{
 No value is returned; this function is run entirely for the side effect
 of opening the pdf document in the PDF viewer.
}
\author{R. Gentleman }

\seealso{\code{\link{vignette}}, \code{\link{openPDF}},
  \code{\link{menu}}, \code{\link{getPkgVigs}}}

\examples{
  if( interactive() )
    openVignette("Biobase")
}
\keyword{ utilities }

\eof
\name{package.version}
\alias{package.version}
\title{A function to report package versions}
\description{
  Will report the version number of a requested installed package
}
\usage{
package.version(pkg, lib.loc = NULL)
}
\arguments{
  \item{pkg}{The name of the package}
  \item{lib.loc}{a character vector describing the location of R library trees
          to search through, or `NULL'.  The default value of `NULL'
          corresponds to all libraries currently known.}
}
\details{
  This function is a convenience wrapper around
  \code{package.description}, and will report simply the version number
  of the requested package.  If the package does not exist or if the
  DESCRIPTION file can not be read, then an error will be thrown.
}
\value{
  A character string reporting the version number.
}
\author{Jeff Gentry}
\seealso{\code{\link{package.description}}}
\examples{
  package.version("Biobase")
}
\keyword{utilities}

\eof
\name{phenoData-class}
\docType{class}
\alias{phenoData-class}
\alias{$.phenoData}
\alias{phenoData<-,pheno}
\alias{[,phenoData-method}
\alias{pData,phenoData-method}
\alias{pData<-,phenoData-method}
\alias{show,phenoData-method}
\alias{split,phenoData,vector-method}
\alias{varLabels,phenoData-method}
\alias{[[,phenoData-method}
\alias{[[<-,phenoData-method}
\title{Class phenoData, a class for patient or experiment level data. }
\description{ The class consists of a \code{data.frame} and some
  accompanying methods suited to handle patient level data for microarrays.}
\section{Creating Objects}{
\code{  new('phenoData',}\cr
\code{    pData     = ...., # Object of class \code{data.frame}}\cr
\code{    varLabels = ...., # Object of class \code{list}}\cr
\code{  )}}
\section{Slots}{
  \describe{
    \item{\code{pData}:}{Object of class "data.frame". The data. }
    \item{\code{varLabels}:}{Object of class "list". Obtional long
      labels for the different variables. }
  }
}

\section{Methods}{
  \describe{
    \item{[}{(phenoData): A subset operator. }
    \item{pData}{(phenoData): An accessor function for \code{pData}.}
    \item{show}{(phenoData): A method to display the data in a nice manner. }
    \item{varLabels}{(phenoData): A method to display the variable
      labels. }
    \item{split}{(phenoData, vector): A method to \code{split}
      \code{pData} and return a list of \code{phenoData} objects. Unlike
      \code{split} this function requires the number of rows of
      \code{pData} to be a multiple of the length of \code{vector}.}
    \item{\$}{An old-style method.
      It is \code{pData(object)[[as.character(val)]]} which
      does not quite have the right semantics but it is close. This
      operator extracts the named component of the \code{pData} slot in
      \code{phenoData}.}
    \item{pData<-}{(phenoData): A replacement method for the \code{pData}
      slot.}
    \item{phenoData<-}{(exprSet): A replacement method for the
      \code{phenoData} slot.}
  }
}
\keyword{methods}

\eof
\name{read.MIAME}
\alias{read.MIAME}
\title{Read MIAME information}
\description{
Reads MIAME information from file or using a widget.}
}
\usage{
read.MIAME(filename = NULL, widget = getOption("BioC")$Base$use.widgets, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{filename}{filename from which to read MIAME information.}
  \item{widget}{logical. If \code{TRUE} and a filename is not given, a
    widget is used to enter information.}
  \item{\dots}{Further arguments to \code{scan}.}
}
\details{
  Notice that the \code{\link{MIAME}}
  class tries to cover the MIAME entries that are not covered by other
  classes in Bioconductor. Namely, experimental design, samples,
  hybridizations, normalization controls, and pre-processing
  information.

  The function \code{\link{scan}} is used to read.
  The file must be a flat file with the
  different entries for the instance 
  of MIAME class separated by carriage returns. The order should be: name, lab,
  contact, title, abstract, and url.

  Alternatively a widget can be used. 
}
\value{An object of class \code{\link{MIAME}}.}
}
\author{Rafael Irizarry <rafa@jhu.edu>}

\seealso{\code{\link{MIAME}},\code{\link[tkWidgets]{tkMIAME}} }

\examples{
miame <- read.MIAME(widget=FALSE) ##creates an empty instance
show(miame)
}
\keyword{file}








\eof
\name{read.exprSet}
\alias{read.exprSet}
\title{A function to read experimental data and create an exprSet object
using the data read in as a text file}
\description{
  An exprSet object has a slot named exprs for experimental
  data. read.exprSet reads the experimental data stored as a text file
  and then generates an exprSet object using the data. Data for other
  slots can be also read in as options.
}
\usage{
read.exprSet(exprs, se.exprs, phenoData, annotation, description, notes,
seps = "\t") 
}
\arguments{
  \item{exprs}{\code{exprs} a character string for the name of the text
    file that stores the experimental data to be read in. The text file
    is assumed to be a delimited file with observed expression levels
    arranged in rows and columns. The first row of the file is sample
    names and the first column is gene names/ids. The file will be
    read in using read.table with header set to TRUE}
  \item{se.exprs}{\code{se.exprs} a character stirng for the name of a
    delimited text file contains standard error estimates for the estimated
    expression in exprs. The file is of the same dimensions as
    'exprs'}
  \item{phenoData}{\code{phenoData} a character string for the name of an
    optional file containing information for 'pData' slot of a phenoData
    object to be returned. If missing a default phenoData object with
    one covariate ranging from 1 to the number of columns of 'exprs'
    will be provided} 
  \item{annotation}{\code{annotation} a character string for the name of
    an optional text file that contains a string identifying the
    annotation that may be used for the 'exprSet' instance} 
  \item{description}{\code{description} a character string for the name
    of an optional file containing MIAME information}
  \item{notes}{\code{notes} a character string for the name of an
    optional text file containing explanatory text}
  \item{seps}{\code{seps} a vector of character strings defining the
    delimitors used by 'exprs' and 'se.exprs'. The length of 'seps' can
    be 1 when both file have the same delimiter or 'se.exprs' is missing
    or 2 other wise. The delimitor for 'exprs' is expected to be the
    first element}
}
\details{
  If not missing, 'phenoData' will be read in using
  \code{\link{read.phenoData}} and description using
  \code{\link{read.MIAME}}. The help files of the two functions contain
  detailed descriptions of the two functions. 
}
\value{
  This function returns an exprSet object.
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide bioinformatics functionalities through R
}
\seealso{\code{\link{exprSet}}, \code{\link{phenoData}},
  \code{\link{MIAME}}, \code{\link{read.phenoData}},
  \code{\link{read.MIAME}}}
\examples{
# Creating a test data
testFile <- tempfile()
data(geneData)
write.table(geneData, testFile, quote = FALSE, sep = "\t", row.names =
TRUE, col.names = TRUE)
# Create an exprSet object using textFile 
eSet <- read.exprSet(testFile) 
eSet
}
\keyword{manip}

\eof
\name{read.phenoData}
\alias{read.phenoData}
\title{Read phenoData}
\description{
  Create an instance of class phenoData by reading a file or by using widgets.}
\usage{
read.phenoData(filename = NULL, sampleNames = NULL,
widget = getOption("BioC")$Base$use.widgets, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{filename}{filename from which to read information for
    \code{pData} slot.}
  \item{sampleNames}{\code{sampleNames} for rows of \code{pData}. If
    widgets are used this is required.}
  \item{widget}{logical. If \code{TRUE} and a filename is not given, 
    widgets are used to enter information.}
  \item{\dots}{Further arguments to \code{read.table} }
}
\details{
  The function \code{\link{read.table}} is used to read \code{pData}. The
  function must be a flat file. The first row must be the column names
  which are the covariate names. The first column must be the
  sampleNames. Entries must be space delimited unless otherwise specied
  through \dots.
  
  If a filename overides the \code{widget} argument.
  
  If no filename is given and no widgets are used a dummy phenoData
  object is created for the sampleNames. See example.}


\value{
  An instance of class \code{phenoData}}
\author{Rafael A. Irizarry <rafa@jhu.edu>}
\seealso{\code{\link{phenoData}}, \code{\link{tkphenoData}}}

\examples{
pd <- read.phenoData(sampleNames=c("sample1","sample2"),widget=FALSE)
show(pd)
show(pData(pd))
}
\keyword{file}


\eof
\name{setOptionPdfViewer}
\alias{setOptionPdfViewer}
\title{A function to set the PDF viewer option}
\description{
  Will set the user's \code{pdfViewer} option, either by determining it
  automatically or specified by the user.
}
\usage{
setOptionPdfViewer(viewer, verbose=FALSE)
}
\arguments{
  \item{viewer}{A file path to a working PDF viewer application}
  \item{verbose}{Outputs extra diagnostics}
}
\details{
  If the \code{viewer} argument is given, the option is set to this.
  Otherwise, the system will attempt to locate a PDF viewer and set the
  option to this.

  Currently, the option is "pdfViewer", and located in the "BioC"
  option list (BioC$Base$pdfViewer).
}
\value{
  TRUE on success, FALSE on failure
}
\author{Jeff Gentry}
\seealso{\code{\link{openPDF}}}

\examples{
   setOptionPdfViewer()
}
\keyword{utilities}

\eof
\name{testBioCConnection}
\alias{testBioCConnection}
\title{A function to check internet connectivity to Bioconductor}
\description{
  This function will attempt to determine if the user has internet
  connectivity to the Bioconductor website.  This is useful in many
  situations dealing with code that uses automated downloads and other
  such things.
}
\usage{
testBioCConnection()
}
\value{
  TRUE if a connection is possible, FALSE if not.
}
\author{Jeff Gentry}
\examples{
 z <- testBioCConnection()
}
\keyword{utilities}

\eof
