### Name: exprSet-class
### Title: Class exprSet, a class for microarray data, and methods for
###   processing them
### Aliases: annotation annotation<- description description<- exprs
###   exprs2excel exprs<- geneNames geneNames<- notes notes<- pData pData<-
###   phenoData phenoData<- sampleNames se.exprs update2MIAME varLabels
###   update2MIAME,exprSet-method write.exprs exprSet-class exprSet
###   $.exprSet description,exprSet-method description<-,exprSet-method
###   exprs,exprSet-method exprs<-,exprSet-method se.exprs,exprSet-method
###   [,exprSet-method [[<-,exprSet-method [[,exprSet-method se.exprs<-
###   se.exprs<-,exprSet-method notes,exprSet-method notes<-,exprSet-method
###   geneNames,exprSet-method geneNames<-,exprSet-method
###   pData,exprSet-method pData<-,exprSet-method varLabels,exprSet-method
###   sampleNames,exprSet-method phenoData,exprSet-method
###   phenoData<-,exprSet,phenoData-method annotation,exprSet-method
###   annotation<-,exprSet-method show,exprSet-method
###   split,exprSet,vector-method write.exprs,exprSet-method
###   exprs2excel,exprSet-method
### Keywords: methods

### ** Examples

  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  eset <- new("exprSet", exprs=geneData, phenoData=pdata)
  eset
  eset[,1:10]
  eset[,1]
  eset[1,]
  eset[1,1]
  eset[1:100,]
  eset[1:44,c(2,4,6)]
  Means <- iter(eset, f=mean)

  chkdich <- function(x) if(length(unique(x))!=2) stop("x not dichotomous")
  mytt <- function(x,y) {
     chkdich(x)
     d <- split(y,x)
     t.test(d[[1]],d[[2]])$p.val
  }
  
  Tpvals <- iter(eset, "cov1", mytt )

  sp1 <- split(eset, c(1,2))
  sp2 <- split(eset, c(rep(1,6), rep(2,7)))



