/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.handler;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.storm.daemon.logviewer.utils.LogFileDownloader;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.daemon.logviewer.utils.WorkerLogs;
import org.apache.storm.metric.StormMetricsRegistry;

public class LogviewerLogDownloadHandler {
    private WorkerLogs workerLogs;
    private final LogFileDownloader logFileDownloadHelper;

    public LogviewerLogDownloadHandler(String logRoot, String daemonLogRoot, WorkerLogs workerLogs, ResourceAuthorizer resourceAuthorizer, StormMetricsRegistry metricsRegistry) {
        this.workerLogs = workerLogs;
        this.logFileDownloadHelper = new LogFileDownloader(logRoot, daemonLogRoot, resourceAuthorizer, metricsRegistry);
    }

    public Response downloadLogFile(String host, String fileName, String user) throws IOException {
        this.workerLogs.setLogFilePermission(fileName);
        return this.logFileDownloadHelper.downloadFile(host, fileName, user, false);
    }

    public Response downloadDaemonLogFile(String host, String fileName, String user) throws IOException {
        return this.logFileDownloadHelper.downloadFile(host, fileName, user, true);
    }
}

