/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.core.server.ServerFactory;
import io.dropwizard.core.setup.AdminEnvironment;
import io.dropwizard.core.setup.ExceptionMapperBinder;
import io.dropwizard.jersey.filter.AllowedMethodsFilter;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jersey.validation.HibernateValidationBinder;
import io.dropwizard.jetty.GzipHandlerFactory;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.ZipExceptionHandlingServletFilter;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.metrics.jetty12.InstrumentedQueuedThreadPool;
import io.dropwizard.metrics.jetty12.ee10.InstrumentedEE10Handler;
import io.dropwizard.metrics.servlets.AdminServlet;
import io.dropwizard.metrics.servlets.HealthCheckServlet;
import io.dropwizard.metrics.servlets.MetricsServlet;
import io.dropwizard.request.logging.LogbackAccessRequestLog;
import io.dropwizard.request.logging.LogbackAccessRequestLogAwareHandler;
import io.dropwizard.request.logging.LogbackAccessRequestLogFactory;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.servlets.ThreadNameFilter;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.ValidationMethod;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.GracefulHandler;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.setuid.SetUIDListener;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerFactory
implements ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    @Valid
    private @Nullable RequestLogFactory<?> requestLog;
    @Valid
    @NotNull
    private GzipHandlerFactory gzip = new GzipHandlerFactory();
    @Valid
    @NotNull
    private ResponseMeteredLevel responseMeteredLevel = ResponseMeteredLevel.COARSE;
    private @Nullable String metricPrefix = null;
    @Min(value=4L)
    private @Min(value=4L) int maxThreads = 1024;
    @Min(value=1L)
    private @Min(value=1L) int minThreads = 8;
    @MinDuration(value=1L)
    private @MinDuration(value=1L) Duration idleThreadTimeout = Duration.minutes((long)1L);
    @Min(value=1L)
    private @Min(value=1L) @Nullable Integer nofileSoftLimit;
    @Min(value=1L)
    private @Min(value=1L) @Nullable Integer nofileHardLimit;
    private @Nullable Integer gid;
    private @Nullable Integer uid;
    private @Nullable String user;
    private @Nullable String group;
    private @Nullable String umask;
    private @Nullable Boolean startsAsRoot;
    private Boolean registerDefaultExceptionMappers = Boolean.TRUE;
    private Boolean detailedJsonProcessingExceptionMapper = Boolean.FALSE;
    private Duration shutdownGracePeriod = Duration.seconds((long)30L);
    @NotNull
    private Set<String> allowedMethods = AllowedMethodsFilter.DEFAULT_ALLOWED_METHODS;
    private Optional<String> jerseyRootPath = Optional.empty();
    private boolean enableThreadNameFilter = true;
    private boolean dumpAfterStart = false;
    private boolean dumpBeforeStop = false;
    private boolean enableVirtualThreads = false;

    @JsonIgnore
    @ValidationMethod(message="must have a smaller minThreads than maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @JsonProperty(value="requestLog")
    public synchronized RequestLogFactory<?> getRequestLogFactory() {
        if (this.requestLog == null) {
            this.requestLog = new LogbackAccessRequestLogFactory();
        }
        return this.requestLog;
    }

    @JsonProperty(value="requestLog")
    public synchronized void setRequestLogFactory(RequestLogFactory<?> requestLog) {
        this.requestLog = requestLog;
    }

    @JsonProperty(value="gzip")
    public GzipHandlerFactory getGzipFilterFactory() {
        return this.gzip;
    }

    @JsonProperty(value="gzip")
    public void setGzipFilterFactory(GzipHandlerFactory gzip) {
        this.gzip = gzip;
    }

    @JsonProperty(value="responseMeteredLevel")
    public ResponseMeteredLevel getResponseMeteredLevel() {
        return this.responseMeteredLevel;
    }

    @JsonProperty(value="metricPrefix")
    public @Nullable String getMetricPrefix() {
        return this.metricPrefix;
    }

    @JsonProperty
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty
    public void setMaxThreads(int count) {
        this.maxThreads = count;
    }

    @JsonProperty
    public int getMinThreads() {
        return this.minThreads;
    }

    @JsonProperty
    public void setMinThreads(int count) {
        this.minThreads = count;
    }

    @JsonProperty
    public Duration getIdleThreadTimeout() {
        return this.idleThreadTimeout;
    }

    @JsonProperty
    public void setIdleThreadTimeout(Duration idleThreadTimeout) {
        this.idleThreadTimeout = idleThreadTimeout;
    }

    @JsonProperty
    public @Nullable Integer getNofileSoftLimit() {
        return this.nofileSoftLimit;
    }

    @JsonProperty
    public void setNofileSoftLimit(Integer nofileSoftLimit) {
        this.nofileSoftLimit = nofileSoftLimit;
    }

    @JsonProperty
    public @Nullable Integer getNofileHardLimit() {
        return this.nofileHardLimit;
    }

    @JsonProperty
    public void setNofileHardLimit(Integer nofileHardLimit) {
        this.nofileHardLimit = nofileHardLimit;
    }

    @JsonProperty
    public @Nullable Integer getGid() {
        return this.gid;
    }

    @JsonProperty
    public void setGid(Integer gid) {
        this.gid = gid;
    }

    @JsonProperty
    public @Nullable Integer getUid() {
        return this.uid;
    }

    @JsonProperty
    public void setUid(Integer uid) {
        this.uid = uid;
    }

    @JsonProperty
    public @Nullable String getUser() {
        return this.user;
    }

    @JsonProperty
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty
    public @Nullable String getGroup() {
        return this.group;
    }

    @JsonProperty
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty
    public @Nullable String getUmask() {
        return this.umask;
    }

    @JsonProperty
    public void setUmask(String umask) {
        this.umask = umask;
    }

    @JsonProperty
    public @Nullable Boolean getStartsAsRoot() {
        return this.startsAsRoot;
    }

    @JsonProperty
    public void setStartsAsRoot(Boolean startsAsRoot) {
        this.startsAsRoot = startsAsRoot;
    }

    public Boolean getRegisterDefaultExceptionMappers() {
        return this.registerDefaultExceptionMappers;
    }

    @JsonProperty
    public void setRegisterDefaultExceptionMappers(Boolean registerDefaultExceptionMappers) {
        this.registerDefaultExceptionMappers = registerDefaultExceptionMappers;
    }

    public Boolean getDetailedJsonProcessingExceptionMapper() {
        return this.detailedJsonProcessingExceptionMapper;
    }

    @JsonProperty
    public void setDetailedJsonProcessingExceptionMapper(Boolean detailedJsonProcessingExceptionMapper) {
        this.detailedJsonProcessingExceptionMapper = detailedJsonProcessingExceptionMapper;
    }

    @JsonProperty
    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    @JsonProperty
    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    @JsonProperty
    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @JsonProperty
    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    @JsonProperty(value="rootPath")
    public Optional<String> getJerseyRootPath() {
        return this.jerseyRootPath;
    }

    @JsonProperty(value="rootPath")
    public void setJerseyRootPath(String jerseyRootPath) {
        this.jerseyRootPath = Optional.ofNullable(jerseyRootPath);
    }

    @JsonProperty
    public boolean getEnableThreadNameFilter() {
        return this.enableThreadNameFilter;
    }

    @JsonProperty
    public void setEnableThreadNameFilter(boolean enableThreadNameFilter) {
        this.enableThreadNameFilter = enableThreadNameFilter;
    }

    @JsonProperty
    public boolean getDumpAfterStart() {
        return this.dumpAfterStart;
    }

    @JsonProperty
    public void setDumpAfterStart(boolean dumpAfterStart) {
        this.dumpAfterStart = dumpAfterStart;
    }

    @JsonProperty
    public boolean getDumpBeforeStop() {
        return this.dumpBeforeStop;
    }

    @JsonProperty
    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        this.dumpBeforeStop = dumpBeforeStop;
    }

    @JsonProperty
    public boolean isEnableVirtualThreads() {
        return this.enableVirtualThreads;
    }

    @JsonProperty
    public void setEnableVirtualThreads(boolean enableVirtualThreads) {
        this.enableVirtualThreads = enableVirtualThreads;
    }

    protected Handler createAdminServlet(Server server, MutableServletContextHandler handler, MetricRegistry metrics, HealthCheckRegistry healthChecks, AdminEnvironment admin) {
        this.configureSessionsAndSecurity(handler, server);
        handler.setServer(server);
        handler.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)metrics);
        handler.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)healthChecks);
        handler.getServletContext().setAttribute("healthcheck-enabled", (Object)admin.isHealthCheckServletEnabled());
        handler.addServlet(AdminServlet.class, "/*");
        String allowedMethodsParam = String.join((CharSequence)",", this.allowedMethods);
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", allowedMethodsParam);
        return handler;
    }

    private void configureSessionsAndSecurity(MutableServletContextHandler handler, Server server) {
        handler.setServer(server);
        if (handler.isSecurityEnabled()) {
            handler.getSecurityHandler().setServer(server);
        }
        if (handler.isSessionsEnabled()) {
            handler.getSessionHandler().setServer(server);
        }
    }

    protected Handler createAppServlet(Server server, JerseyEnvironment jersey, ObjectMapper objectMapper, Validator validator, MutableServletContextHandler handler, @Nullable Servlet jerseyContainer, MetricRegistry metricRegistry) {
        this.configureSessionsAndSecurity(handler, server);
        String allowedMethodsParam = String.join((CharSequence)",", this.allowedMethods);
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", allowedMethodsParam);
        handler.addFilter(ZipExceptionHandlingServletFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (this.enableThreadNameFilter) {
            handler.addFilter(ThreadNameFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if (jerseyContainer != null) {
            this.jerseyRootPath.ifPresent(arg_0 -> ((JerseyEnvironment)jersey).setUrlPattern(arg_0));
            jersey.register((Object)new JacksonFeature(objectMapper));
            jersey.register((Object)new HibernateValidationBinder(validator));
            if (this.registerDefaultExceptionMappers == null || this.registerDefaultExceptionMappers.booleanValue()) {
                jersey.register((Object)new ExceptionMapperBinder(this.detailedJsonProcessingExceptionMapper));
            }
            handler.addServlet(new ServletHolder("jersey", jerseyContainer), jersey.getUrlPattern());
        }
        InstrumentedEE10Handler instrumented = new InstrumentedEE10Handler(metricRegistry, this.metricPrefix, this.responseMeteredLevel);
        instrumented.setServer(server);
        instrumented.setHandler((Handler)handler);
        return instrumented;
    }

    protected ThreadPool createThreadPool(MetricRegistry metricRegistry) {
        BlockingArrayQueue queue = new BlockingArrayQueue(this.minThreads, this.maxThreads);
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, this.maxThreads, this.minThreads, (int)this.idleThreadTimeout.toMilliseconds(), (BlockingQueue)queue);
        if (this.enableVirtualThreads) {
            threadPool.setVirtualThreadsExecutor((Executor)new VirtualThreadPool(this.maxThreads));
        }
        threadPool.setName("dw");
        return threadPool;
    }

    protected Server buildServer(LifecycleEnvironment lifecycle, ThreadPool threadPool) {
        Server server = new Server(threadPool);
        server.addEventListener((EventListener)this.buildSetUIDListener());
        lifecycle.attach((ContainerLifeCycle)server);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(false);
        server.setErrorHandler((Request.Handler)errorHandler);
        server.setStopAtShutdown(true);
        server.setStopTimeout(this.shutdownGracePeriod.toMilliseconds());
        server.setDumpAfterStart(this.dumpAfterStart);
        server.setDumpBeforeStop(this.dumpBeforeStop);
        return server;
    }

    protected SetUIDListener buildSetUIDListener() {
        SetUIDListener listener = new SetUIDListener();
        if (this.startsAsRoot != null) {
            listener.setStartServerAsPrivileged(this.startsAsRoot.booleanValue());
        }
        if (this.gid != null) {
            listener.setGid(this.gid.intValue());
        }
        if (this.uid != null) {
            listener.setUid(this.uid.intValue());
        }
        if (this.user != null) {
            listener.setUsername(this.user);
        }
        if (this.group != null) {
            listener.setGroupname(this.group);
        }
        if (this.nofileHardLimit != null || this.nofileSoftLimit != null) {
            RLimit rlimit = new RLimit();
            if (this.nofileHardLimit != null) {
                rlimit.setHard((long)this.nofileHardLimit.intValue());
            }
            if (this.nofileSoftLimit != null) {
                rlimit.setSoft((long)this.nofileSoftLimit.intValue());
            }
            listener.setRLimitNoFiles(rlimit);
        }
        if (this.umask != null) {
            listener.setUmaskOctal(this.umask);
        }
        return listener;
    }

    protected void addRequestLog(Server server, String name, MutableServletContextHandler servletContextHandler) {
        if (this.getRequestLogFactory().isEnabled()) {
            RequestLog log = this.getRequestLogFactory().build(name);
            if (log instanceof LogbackAccessRequestLog) {
                servletContextHandler.insertHandler((Handler.Singleton)new LogbackAccessRequestLogAwareHandler());
            }
            server.setRequestLog(log);
        }
    }

    protected Handler addGracefulHandler(Handler handler) {
        GracefulHandler gracefulHandler = new GracefulHandler();
        gracefulHandler.setHandler(handler);
        return gracefulHandler;
    }

    protected Handler buildGzipHandler(Handler handler) {
        return this.gzip.isEnabled() ? this.gzip.build(handler) : handler;
    }

    protected void printBanner(String name) {
        Object msg;
        block18: {
            msg = "Starting " + name;
            try (InputStream resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("banner.txt");){
                if (resourceStream == null) break block18;
                try (InputStreamReader inputStreamReader = new InputStreamReader(resourceStream);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String banner = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
                    msg = String.format("Starting %s%n%s", name, banner);
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        LOGGER.info((String)msg);
    }
}

