/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.tls;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.tls.ReloadableX509KeyManager;
import org.apache.storm.security.auth.tls.ReloadableX509TrustManager;
import org.apache.storm.thrift.transport.TSSLTransportFactory;
import org.apache.storm.thrift.transport.TServerSocket;
import org.apache.storm.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableTsslTransportFactory
extends TSSLTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableTsslTransportFactory.class);

    public static TServerSocket getServerSocket(int port, int clientTimeout, InetAddress ifAddress, ThriftConnectionType type, Map<String, Object> conf) throws Exception {
        SSLContext ctx = ReloadableTsslTransportFactory.createSslContext(type, conf);
        return ReloadableTsslTransportFactory.createServerSocket(ctx.getServerSocketFactory(), port, clientTimeout, type.isClientAuthRequired(conf), ifAddress, type);
    }

    private static SSLContext createSslContext(ThriftConnectionType type, Map<String, Object> conf) throws Exception {
        ReloadableX509TrustManager trustManager = new ReloadableX509TrustManager(type.getServerTrustStorePath(conf), type.getServerTrustStorePassword(conf));
        ReloadableX509KeyManager keyManager = new ReloadableX509KeyManager(type.getServerKeyStorePath(conf), type.getServerKeyStorePassword(conf));
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, new SecureRandom());
        return ctx;
    }

    private static TServerSocket createServerSocket(SSLServerSocketFactory factory, int port, int timeout, boolean clientAuth, InetAddress ifAddress, ThriftConnectionType type) throws TTransportException {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(port, 100, ifAddress);
            serverSocket.setEnabledProtocols(new String[]{"TLSv1.2"});
            serverSocket.setSoTimeout(timeout);
            serverSocket.setNeedClientAuth(clientAuth);
            serverSocket.setWantClientAuth(clientAuth);
            return new TServerSocket((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().serverSocket((ServerSocket)serverSocket).clientTimeout(timeout));
        }
        catch (Exception e) {
            throw new TTransportException("Could not bind to port " + port, (Throwable)e);
        }
    }
}

