/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import java.nio.ByteBuffer;
import org.apache.storm.metricstore.Metric;
import org.apache.storm.metricstore.rocksdb.RocksDbKey;
import org.apache.storm.metricstore.rocksdb.StringMetadata;

class RocksDbValue {
    private static final byte CURRENT_METADATA_VERSION = 0;
    private static final byte CURRENT_METRIC_VERSION = 0;
    private static int METRIC_VALUE_SIZE = 41;
    private static int MIN_METADATA_VALUE_SIZE = 9;
    private byte[] value;

    RocksDbValue(byte[] value) {
        this.value = value;
    }

    RocksDbValue(long lastTimestamp, String metadataString) {
        this.value = new byte[MIN_METADATA_VALUE_SIZE + metadataString.length()];
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        bb.put((byte)0);
        bb.putLong(lastTimestamp);
        bb.put(metadataString.getBytes());
    }

    RocksDbValue(Metric m) {
        this.value = new byte[METRIC_VALUE_SIZE];
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        bb.put((byte)0);
        bb.putDouble(m.getValue());
        bb.putLong(m.getCount());
        bb.putDouble(m.getMin());
        bb.putDouble(m.getMax());
        bb.putDouble(m.getSum());
    }

    String getMetdataString() {
        if (this.value.length < MIN_METADATA_VALUE_SIZE) {
            throw new RuntimeException("RocksDB value is too small to be a metadata string!");
        }
        return new String(this.value, 9, this.value.length - 9);
    }

    StringMetadata getStringMetadata(RocksDbKey key) {
        return new StringMetadata(key.getType(), key.getMetadataStringId(), this.getLastTimestamp());
    }

    long getLastTimestamp() {
        return ByteBuffer.wrap(this.value, 1, 8).getLong();
    }

    byte[] getRaw() {
        return this.value;
    }

    void populateMetric(Metric metric) {
        ByteBuffer bb = ByteBuffer.wrap(this.value, 0, METRIC_VALUE_SIZE);
        bb.get();
        metric.setValue(bb.getDouble());
        metric.setCount(bb.getLong());
        metric.setMin(bb.getDouble());
        metric.setMax(bb.getDouble());
        metric.setSum(bb.getDouble());
    }
}

