/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kylin.metadata.upgrade;

import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class GlobalAclVersion extends RootPersistentEntity {
    public static final String DATA_PERMISSION_SEPARATE = "data-permission-separate";

    public static final String VERSION_KEY_NAME = ResourceStore.UPGRADE_META_KEY_TAG;

    @JsonProperty("acl_version")
    private String aclVersion;

    @JsonProperty("name")
    private String name = VERSION_KEY_NAME;

    @Override
    public String resourceName() {
        return VERSION_KEY_NAME;
    }

    @Override
    public MetadataType resourceType() {
        return MetadataType.SYSTEM;
    }

}
