/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.deploy.impl.ShiroConfig;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.SessionConfigType;

public class ShiroDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String LISTENER_CLASSNAME = "org.apache.shiro.web.env.EnvironmentLoaderListener";
    private static final String SHIRO_FILTER_CLASSNAME = "org.apache.shiro.web.servlet.ShiroFilter";
    private static final String POST_FILTER_CLASSNAME = "org.apache.knox.gateway.filter.ShiroSubjectIdentityAdapter";
    private static final String COOKIE_FILTER_CLASSNAME = "org.apache.knox.gateway.filter.ResponseCookieFilter";
    private static final String REDIRECT_FILTER_CLASSNAME = "org.apache.knox.gateway.filter.RedirectToUrlFilter";
    private static final String SESSION_TIMEOUT = "sessionTimeout";
    private static final String REMEMBER_ME = "rememberme";
    private static final String SHRIO_CONFIG_FILE_NAME = "shiro.ini";
    private static final String SHIRO_URL_CONFIG = "urls";
    private static final int DEFAULT_SESSION_TIMEOUT = 30;

    public String getRole() {
        return "authentication";
    }

    public String getName() {
        return "ShiroProvider";
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        context.getWebAppDescriptor().createListener().listenerClass(LISTENER_CLASSNAME);
        int st = 30;
        SessionConfigType sessionConfig = context.getWebAppDescriptor().createSessionConfig();
        Map params = provider.getParams();
        String sts = (String)params.get(SESSION_TIMEOUT);
        if (sts != null && !sts.trim().isEmpty()) {
            st = Integer.parseInt(sts.trim());
        }
        if (st <= 0) {
            st = 30;
        }
        sessionConfig.sessionTimeout(Integer.valueOf(st));
        sessionConfig.getOrCreateCookieConfig().httpOnly(Boolean.valueOf(true));
        sessionConfig.getOrCreateCookieConfig().secure(Boolean.valueOf(true));
        String clusterName = context.getTopology().getName();
        ShiroConfig config = new ShiroConfig(provider, clusterName);
        String configStr = config.toString();
        context.getWebArchive().addAsWebInfResource((Asset)new StringAsset(configStr), SHRIO_CONFIG_FILE_NAME);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        String cookies;
        Map providerParams;
        String redirectToUrl;
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        if ((redirectToUrl = (String)(providerParams = provider.getParams()).get("redirectToUrl")) != null) {
            params.add(resource.createFilterParam().name("redirectToUrl").value(redirectToUrl));
            resource.addFilter().name("Redirect" + this.getName()).role(this.getRole()).impl(REDIRECT_FILTER_CLASSNAME).params(params);
            params.clear();
        }
        if ((cookies = (String)providerParams.get("restrictedCookies")) == null) {
            params.add(resource.createFilterParam().name("restrictedCookies").value(REMEMBER_ME));
        } else {
            params.add(resource.createFilterParam().name("restrictedCookies").value(cookies));
        }
        resource.addFilter().name("Pre" + this.getName()).role(this.getRole()).impl(COOKIE_FILTER_CLASSNAME).params(params);
        params.clear();
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(SHIRO_FILTER_CLASSNAME).params(params);
        Map<String, String> shiroURLs = providerParams.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(SHIRO_URL_CONFIG)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, String> m : shiroURLs.entrySet()) {
            params.add(resource.createFilterParam().name(m.getKey()).value(m.getValue()));
        }
        resource.addFilter().name("Post" + this.getName()).role(this.getRole()).impl(POST_FILTER_CLASSNAME).params(params);
    }
}

