/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.PKCS5AlgorithmIdentifier;
import com.unboundid.util.ssl.cert.PKCS8EncryptionProperties;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PKCS8EncryptionHandler {
    private PKCS8EncryptionHandler() {
    }

    @NotNull
    public static byte[] encryptPrivateKey(@NotNull PKCS8PrivateKey privateKey, @NotNull char[] encryptionPassword, @NotNull PKCS8EncryptionProperties encryptionProperties) throws CertException {
        return PKCS8EncryptionHandler.encryptPrivateKey(privateKey.getPKCS8PrivateKeyBytes(), encryptionPassword, encryptionProperties);
    }

    @NotNull
    public static byte[] encryptPrivateKey(@NotNull byte[] privateKeyBytes, @NotNull char[] encryptionPassword, @NotNull PKCS8EncryptionProperties encryptionProperties) throws CertException {
        byte[] encryptedPrivteKeyData;
        byte[] cipherInitializationVector;
        Cipher cipher;
        SecretKeySpec secretKey;
        PKCS5AlgorithmIdentifier keyFactoryPRFAlgorithm = encryptionProperties.getKeyFactoryPRFAlgorithm();
        int keyFactoryIterationCount = encryptionProperties.getKeyFactoryIterationCount();
        int keyFactorySaltLengthBytes = encryptionProperties.getKeyFactorySaltLengthBytes();
        PKCS5AlgorithmIdentifier cipherTransformationAlgorithm = encryptionProperties.getCipherTransformationAlgorithm();
        String keyFactoryAlgorithm = PKCS5AlgorithmIdentifier.getPBKDF2SecretKeyFactoryAlgorithmForPseudorandomFunction(keyFactoryPRFAlgorithm);
        String cipherAlgorithm = PKCS5AlgorithmIdentifier.getCipherAlgorithmName(cipherTransformationAlgorithm);
        String cipherTransformation = PKCS5AlgorithmIdentifier.getCipherTransformationName(cipherTransformationAlgorithm);
        int cipherKeyLengthBits = PKCS5AlgorithmIdentifier.getCipherKeySizeBits(cipherTransformationAlgorithm);
        byte[] keyFactorySalt = StaticUtils.randomBytes(keyFactorySaltLengthBytes, true);
        try {
            SecretKeyFactory keyFactory = CryptoHelper.getSecretKeyFactory(keyFactoryAlgorithm);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(encryptionPassword, keyFactorySalt, keyFactoryIterationCount, cipherKeyLengthBits);
            secretKey = new SecretKeySpec(keyFactory.generateSecret(pbeKeySpec).getEncoded(), cipherAlgorithm);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_CREATE_ENC_SECRET_KEY.get(keyFactoryAlgorithm, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            cipher = CryptoHelper.getCipher(cipherTransformation);
            cipher.init(1, secretKey);
            cipherInitializationVector = cipher.getIV();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_CREATE_ENC_CIPHER.get(cipherTransformation, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            encryptedPrivteKeyData = cipher.doFinal(privateKeyBytes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_ENCRYPT_PRIVATE_KEY.get(cipherTransformation, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Sequence kdfParametersSequence = new ASN1Sequence(new ASN1OctetString(keyFactorySalt), new ASN1Integer(keyFactoryIterationCount), new ASN1Sequence(new ASN1ObjectIdentifier(keyFactoryPRFAlgorithm.getOID()), new ASN1Null()));
            ASN1Sequence kdfIdentifierSequence = new ASN1Sequence(new ASN1ObjectIdentifier(PKCS5AlgorithmIdentifier.PBKDF2.getOID()), kdfParametersSequence);
            ASN1Sequence cipherSequence = new ASN1Sequence(new ASN1ObjectIdentifier(cipherTransformationAlgorithm.getOID()), new ASN1OctetString(cipherInitializationVector));
            ASN1Sequence pbes2ParametersSequence = new ASN1Sequence(kdfIdentifierSequence, cipherSequence);
            ASN1Sequence pbes2Sequence = new ASN1Sequence(new ASN1ObjectIdentifier(PKCS5AlgorithmIdentifier.PBES2.getOID()), pbes2ParametersSequence);
            ASN1Sequence encryptedPrivateKeySequence = new ASN1Sequence(pbes2Sequence, new ASN1OctetString(encryptedPrivteKeyData));
            return encryptedPrivateKeySequence.encode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_ENCODE_ENC_PRIVATE_KEY.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static PKCS8PrivateKey decryptPrivateKey(@NotNull byte[] encryptedPrivateKeyBytes, @NotNull char[] encryptionPassword) throws CertException {
        byte[] decryptedKeyData;
        Cipher cipher;
        SecretKeySpec secretKey;
        byte[] initializationVector;
        String cipherTransformation;
        String cipherAlgorithm;
        String keyFactoryAlgorithm;
        int keyFactoryIterationCount;
        byte[] keyFactorySalt;
        ASN1Sequence pbes2Sequence;
        ASN1ObjectIdentifier keyEncryptionSchemeOID;
        ASN1Sequence keyEncryptionSchemeSequence;
        ASN1Sequence encryptedKeySequence;
        try {
            encryptedKeySequence = ASN1Sequence.decodeAsSequence(encryptedPrivateKeyBytes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_PARSE_AS_ENC_KEY_SEQUENCE.get(), e);
        }
        ASN1Element[] encryptedKeyElements = encryptedKeySequence.elements();
        if (encryptedKeyElements.length != 2) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_SEQUENCE_UNEXPECTED_ENC_KEY_ELEMENT_COUNT.get(encryptedKeyElements.length));
        }
        try {
            keyEncryptionSchemeSequence = encryptedKeyElements[0].decodeAsSequence();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_KEY_SCHEME_ELEMENT_NOT_SEQUENCE.get(), e);
        }
        ASN1Element[] keyEncryptionSchemeElements = keyEncryptionSchemeSequence.elements();
        if (keyEncryptionSchemeElements.length != 2) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_SEQUENCE_UNEXPECTED_KEY_SCHEME_ELEMENT_COUNT.get(keyEncryptionSchemeElements.length));
        }
        try {
            keyEncryptionSchemeOID = keyEncryptionSchemeElements[0].decodeAsObjectIdentifier();
        }
        catch (Exception e) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_PARSE_KEY_SCHEME_OID.get(), e);
        }
        if (!keyEncryptionSchemeOID.getOID().equals(PKCS5AlgorithmIdentifier.PBES2.getOID())) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_ENC_SCHEME_NOT_PBES2.get(keyEncryptionSchemeOID.getOID().toString()));
        }
        try {
            pbes2Sequence = keyEncryptionSchemeElements[1].decodeAsSequence();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_PBES2_PARAMS_NOT_SEQUENCE.get(), e);
        }
        ASN1Element[] pbes2Elements = pbes2Sequence.elements();
        if (pbes2Elements.length != 2) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_PBES2_UNEXPECTED_PARAMS_SEQUENCE_ELEMENT_COUNT.get(pbes2Elements.length));
        }
        Integer encryptionKeyLength = null;
        try {
            ASN1Element[] kdfElements = pbes2Elements[0].decodeAsSequence().elements();
            ASN1ObjectIdentifier kdfOID = kdfElements[0].decodeAsObjectIdentifier();
            if (!kdfOID.getOID().equals(PKCS5AlgorithmIdentifier.PBKDF2.getOID())) {
                throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_UNSUPPORTED_KDF.get(kdfOID.getOID().toString()));
            }
            ASN1Element[] pbkdf2Elements = kdfElements[1].decodeAsSequence().elements();
            keyFactorySalt = pbkdf2Elements[0].decodeAsOctetString().getValue();
            keyFactoryIterationCount = pbkdf2Elements[1].decodeAsInteger().intValue();
            PKCS5AlgorithmIdentifier prf = PKCS5AlgorithmIdentifier.HMAC_SHA_1;
            for (int i = 2; i < pbkdf2Elements.length; ++i) {
                ASN1ObjectIdentifier prfOID;
                if (pbkdf2Elements[i].getType() == 2) {
                    encryptionKeyLength = pbkdf2Elements[i].decodeAsInteger().intValue();
                    continue;
                }
                if (pbkdf2Elements[i].getType() != 48 || (prf = PKCS5AlgorithmIdentifier.forOID((prfOID = pbkdf2Elements[i].decodeAsSequence().elements()[0].decodeAsObjectIdentifier()).getOID())) != null) continue;
                throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_UNSUPPORTED_PBKDF2_PRF.get(prfOID.getOID().toString()));
            }
            keyFactoryAlgorithm = PKCS5AlgorithmIdentifier.getPBKDF2SecretKeyFactoryAlgorithmForPseudorandomFunction(prf);
            if (keyFactoryAlgorithm == null) {
                throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_UNSUPPORTED_PBKDF2_PRF.get(prf.getOID().toString()));
            }
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_DECODE_KDF_SETTINGS.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] cipherElements = pbes2Elements[1].decodeAsSequence().elements();
            ASN1ObjectIdentifier cipherOID = cipherElements[0].decodeAsObjectIdentifier();
            PKCS5AlgorithmIdentifier cipherIdentifier = PKCS5AlgorithmIdentifier.forOID(cipherOID.getOID());
            if (cipherIdentifier == null) {
                throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_UNSUPPORTED_CIPHER.get(cipherOID.getOID().toString()));
            }
            cipherAlgorithm = PKCS5AlgorithmIdentifier.getCipherAlgorithmName(cipherIdentifier);
            cipherTransformation = PKCS5AlgorithmIdentifier.getCipherTransformationName(cipherIdentifier);
            if (encryptionKeyLength == null) {
                encryptionKeyLength = PKCS5AlgorithmIdentifier.getCipherKeySizeBits(cipherIdentifier);
            }
            if (cipherAlgorithm == null || cipherTransformation == null || encryptionKeyLength == null) {
                throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_UNSUPPORTED_CIPHER.get(cipherOID.getOID().toString()));
            }
            initializationVector = cipherElements[1].decodeAsOctetString().getValue();
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_DECODE_CIPHER_SETTINGS.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            SecretKeyFactory keyFactory = CryptoHelper.getSecretKeyFactory(keyFactoryAlgorithm);
            PBEKeySpec keySpec = new PBEKeySpec(encryptionPassword, keyFactorySalt, keyFactoryIterationCount, encryptionKeyLength);
            secretKey = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), cipherAlgorithm);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_CREATE_DEC_SECRET_KEY.get(keyFactoryAlgorithm, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            cipher = CryptoHelper.getCipher(cipherTransformation);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(initializationVector));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_CREATE_DEC_CIPHER.get(cipherTransformation, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            decryptedKeyData = cipher.doFinal(encryptedKeyElements[1].decodeAsOctetString().getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_DECRYPT_KEY.get(cipherTransformation, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            return new PKCS8PrivateKey(decryptedKeyData);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PKCS8_ENC_HANDLER_CANNOT_PARSE_DECRYPTED_KEY.get(cipherTransformation, StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

