/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.generator.PriorityGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) throws HpackException {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(accumulator, headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public int generateHeaders(ByteBufferPool.Accumulator accumulator, int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        if (endStream) {
            flags |= 1;
        }
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData);
        ByteBuffer hpackByteBuffer = hpack.getByteBuffer();
        BufferUtil.flipToFlush((ByteBuffer)hpackByteBuffer, (int)0);
        int hpackLength = hpackByteBuffer.remaining();
        int maxHeaderBlock = this.getMaxFrameSize();
        if (this.maxHeaderBlockFragment > 0) {
            maxHeaderBlock = Math.min(maxHeaderBlock, this.maxHeaderBlockFragment);
        }
        if (hpackLength > maxHeaderBlock) {
            int length = maxHeaderBlock;
            if (priority != null) {
                length += 5;
            }
            RetainableByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
            ByteBuffer headerByteBuffer = header.getByteBuffer();
            this.generatePriority(headerByteBuffer, priority);
            BufferUtil.flipToFlush((ByteBuffer)headerByteBuffer, (int)0);
            accumulator.append(header);
            accumulator.append(RetainableByteBuffer.wrap((ByteBuffer)hpackByteBuffer.slice(0, maxHeaderBlock)));
            int totalLength = 9 + length;
            int position = maxHeaderBlock;
            while (position + maxHeaderBlock < hpackLength) {
                header = this.generateHeader(FrameType.CONTINUATION, maxHeaderBlock, 0, streamId);
                BufferUtil.flipToFlush((ByteBuffer)header.getByteBuffer(), (int)0);
                accumulator.append(header);
                accumulator.append(RetainableByteBuffer.wrap((ByteBuffer)hpackByteBuffer.slice(position, maxHeaderBlock)));
                position += maxHeaderBlock;
                totalLength += 9 + maxHeaderBlock;
            }
            hpackByteBuffer.position(position);
            header = this.generateHeader(FrameType.CONTINUATION, hpack.remaining(), 4, streamId);
            BufferUtil.flipToFlush((ByteBuffer)header.getByteBuffer(), (int)0);
            accumulator.append(header);
            accumulator.append(hpack);
            return totalLength += 9 + hpack.remaining();
        }
        flags |= 4;
        int length = hpackLength;
        if (priority != null) {
            length += 5;
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
        ByteBuffer headerByteBuffer = header.getByteBuffer();
        this.generatePriority(headerByteBuffer, priority);
        BufferUtil.flipToFlush((ByteBuffer)headerByteBuffer, (int)0);
        accumulator.append(header);
        accumulator.append(hpack);
        return 9 + length;
    }

    private void generatePriority(ByteBuffer header, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(header, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

