/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.StreamIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamIteratorTest {
    StreamIteratorTest() {
    }

    @Test
    void testForEachRemaining() {
        AtomicBoolean closed = new AtomicBoolean();
        StreamIterator iter = StreamIterator.iterator((Stream)((Stream)Stream.of(1, 2, 3).onClose(() -> closed.set(true))));
        AtomicInteger sum = new AtomicInteger();
        iter.forEachRemaining(sum::addAndGet);
        Assertions.assertEquals((int)6, (int)sum.get());
        Assertions.assertTrue((boolean)closed.get());
    }

    @Test
    void testHasNext() {
        AtomicBoolean closed = new AtomicBoolean();
        StreamIterator iter = StreamIterator.iterator((Stream)((Stream)Stream.of(1, 2, 3).onClose(() -> closed.set(true))));
        int sum = 0;
        while (iter.hasNext()) {
            sum += ((Integer)iter.next()).intValue();
        }
        Assertions.assertEquals((int)6, (int)sum);
        Assertions.assertTrue((boolean)closed.get());
    }
}

