/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages to/from a JMS Queue or Topic using plain JMS 1.x
 * API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SjmsEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Simple JMS component.
     */
    public interface SjmsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSjmsEndpointConsumerBuilder advanced() {
            return (AdvancedSjmsEndpointConsumerBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder acknowledgementMode(org.apache.camel.component.sjms.jms.SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder acknowledgementMode(String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a: <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder connectionFactory(jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder disableReplyTo(boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Whether the JmsConsumer processes the Exchange asynchronously. If
         * enabled then the JmsConsumer may pickup the next message from the JMS
         * queue, while the previous message is being processed asynchronously
         * (by the Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the JmsConsumer will pickup
         * the next message from the JMS queue. Note if transacted has been
         * enabled, then asyncConsumer=true does not run asynchronously, as
         * transaction must be executed synchronously (Camel 3.0 may support
         * async transactions).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder asyncConsumer(boolean asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Whether the JmsConsumer processes the Exchange asynchronously. If
         * enabled then the JmsConsumer may pickup the next message from the JMS
         * queue, while the previous message is being processed asynchronously
         * (by the Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the JmsConsumer will pickup
         * the next message from the JMS queue. Note if transacted has been
         * enabled, then asyncConsumer=true does not run asynchronously, as
         * transaction must be executed synchronously (Camel 3.0 may support
         * async transactions).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder asyncConsumer(String asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder autoStartup(boolean autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder autoStartup(String autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * Sets the JMS client ID to use. Note that this value, if specified,
         * must be unique and can only be used by a single JMS connection
         * instance. It is typically only required for durable topic
         * subscriptions. If using Apache ActiveMQ you may prefer to use Virtual
         * Topics instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder concurrentConsumers(int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder concurrentConsumers(String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The durable subscriber name for specifying durable topic
         * subscriptions. The clientId option must be configured as well.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param durableSubscriptionName the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder durableSubscriptionName(String durableSubscriptionName) {
            doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }
        /**
         * Specifies whether to use persistent delivery by default for replies.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param replyToDeliveryPersistent the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }
        /**
         * Specifies whether to use persistent delivery by default for replies.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param replyToDeliveryPersistent the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder replyToDeliveryPersistent(String replyToDeliveryPersistent) {
            doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SjmsEndpointConsumerBuilder basic() {
            return (SjmsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Enables eager loading of JMS properties and payload as soon as a
         * message is loaded which generally is inefficient as the JMS
         * properties may not be required but sometimes can catch early any
         * issues with the underlying JMS provider and the use of JMS
         * properties. See also the option eagerPoisonBody.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerLoadingOfProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }
        /**
         * Enables eager loading of JMS properties and payload as soon as a
         * message is loaded which generally is inefficient as the JMS
         * properties may not be required but sometimes can catch early any
         * issues with the underlying JMS provider and the use of JMS
         * properties. See also the option eagerPoisonBody.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerLoadingOfProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder eagerLoadingOfProperties(String eagerLoadingOfProperties) {
            doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }
        /**
         * If eagerLoadingOfProperties is enabled and the JMS message payload
         * (JMS body or JMS properties) is poison (cannot be read/mapped), then
         * set this text as the message body instead so the message can be
         * processed (the cause of the poison are already stored as exception on
         * the Exchange). This can be turned off by setting
         * eagerPoisonBody=false. See also the option eagerLoadingOfProperties.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Poison JMS message due to ${exception.message}
         * Group: consumer (advanced)
         * 
         * @param eagerPoisonBody the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder eagerPoisonBody(String eagerPoisonBody) {
            doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the JMS Message selector syntax.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param messageSelector the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder messageSelector(String messageSelector) {
            doSetProperty("messageSelector", messageSelector);
            return this;
        }
        /**
         * Whether a JMS consumer is allowed to send a reply message to the same
         * destination that the consumer is using to consume from. This prevents
         * an endless loop by consuming and sending back the same message to
         * itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param replyToSameDestinationAllowed the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }
        /**
         * Whether a JMS consumer is allowed to send a reply message to the same
         * destination that the consumer is using to consume from. This prevents
         * an endless loop by consuming and sending back the same message to
         * itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param replyToSameDestinationAllowed the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder replyToSameDestinationAllowed(String replyToSameDestinationAllowed) {
            doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStartListener(boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStartListener(String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStopListener(boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStopListener(String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder destinationCreationStrategy(org.apache.camel.component.sjms.jms.DestinationCreationStrategy destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder destinationCreationStrategy(String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionListener(jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionListener(String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsKeyFormatStrategy(org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsMessageType(org.apache.camel.component.sjms.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder mapJmsMessage(String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder messageCreatedStrategy(org.apache.camel.component.sjms.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder recoveryInterval(long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder recoveryInterval(String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointConsumerBuilder transferException(String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Simple JMS component.
     */
    public interface SjmsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSjmsEndpointProducerBuilder advanced() {
            return (AdvancedSjmsEndpointProducerBuilder) this;
        }

        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder acknowledgementMode(org.apache.camel.component.sjms.jms.SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder acknowledgementMode(String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a: <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder connectionFactory(jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder disableReplyTo(boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies the delivery mode to be used. Possible values are those
         * defined by jakarta.jms.DeliveryMode. NON_PERSISTENT = 1 and
         * PERSISTENT = 2.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param deliveryMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder deliveryMode(Integer deliveryMode) {
            doSetProperty("deliveryMode", deliveryMode);
            return this;
        }
        /**
         * Specifies the delivery mode to be used. Possible values are those
         * defined by jakarta.jms.DeliveryMode. NON_PERSISTENT = 1 and
         * PERSISTENT = 2.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param deliveryMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder deliveryMode(String deliveryMode) {
            doSetProperty("deliveryMode", deliveryMode);
            return this;
        }
        /**
         * Specifies whether persistent delivery is used by default.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deliveryPersistent the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder deliveryPersistent(boolean deliveryPersistent) {
            doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }
        /**
         * Specifies whether persistent delivery is used by default.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deliveryPersistent the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder deliveryPersistent(String deliveryPersistent) {
            doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }
        /**
         * Values greater than 1 specify the message priority when sending
         * (where 1 is the lowest priority and 9 is the highest). The
         * explicitQosEnabled option must also be enabled in order for this
         * option to have any effect.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder priority(int priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Values greater than 1 specify the message priority when sending
         * (where 1 is the lowest priority and 9 is the highest). The
         * explicitQosEnabled option must also be enabled in order for this
         * option to have any effect.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder priority(String priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when doing
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when doing
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyToConcurrentConsumers(String replyToConcurrentConsumers) {
            doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination in the JMS message, which
         * overrides the setting of replyTo. It is useful if you want to forward
         * the message to a remote Queue and receive the reply message from the
         * ReplyTo destination.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param replyToOverride the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyToOverride(String replyToOverride) {
            doSetProperty("replyToOverride", replyToOverride);
            return this;
        }
        /**
         * Allows for explicitly specifying which kind of strategy to use for
         * replyTo queues when doing request/reply over JMS. Possible values
         * are: Temporary or Exclusive. By default Camel will use temporary
         * queues. However if replyTo has been configured, then Exclusive is
         * used.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.ReplyToType</code> type.
         * 
         * Group: producer
         * 
         * @param replyToType the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyToType(org.apache.camel.component.sjms.ReplyToType replyToType) {
            doSetProperty("replyToType", replyToType);
            return this;
        }
        /**
         * Allows for explicitly specifying which kind of strategy to use for
         * replyTo queues when doing request/reply over JMS. Possible values
         * are: Temporary or Exclusive. By default Camel will use temporary
         * queues. However if replyTo has been configured, then Exclusive is
         * used.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.ReplyToType</code> type.
         * 
         * Group: producer
         * 
         * @param replyToType the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder replyToType(String replyToType) {
            doSetProperty("replyToType", replyToType);
            return this;
        }
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds). The default is 20 seconds. You can include
         * the header CamelJmsRequestTimeout to override this endpoint
         * configured timeout value, and thus have per message individual
         * timeout values. See also the requestTimeoutCheckerInterval option.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds). The default is 20 seconds. You can include
         * the header CamelJmsRequestTimeout to override this endpoint
         * configured timeout value, and thus have per message individual
         * timeout values. See also the requestTimeoutCheckerInterval option.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * When sending messages, specifies the time-to-live of the message (in
         * milliseconds).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder timeToLive(long timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * When sending messages, specifies the time-to-live of the message (in
         * milliseconds).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointProducerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointProducerBuilder extends EndpointProducerBuilder {
        default SjmsEndpointProducerBuilder basic() {
            return (SjmsEndpointProducerBuilder) this;
        }

        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder allowNullBody(boolean allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder allowNullBody(String allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Use this option to force disabling time to live. For example when you
         * do request/reply over JMS, then Camel will by default use the
         * requestTimeout value as time to live on the message being sent. The
         * problem is that the sender and receiver systems have to have their
         * clocks synchronized, so they are in sync. This is not always so easy
         * to archive. So you can use disableTimeToLive=true to not set a time
         * to live value on the sent message. Then the message will not expire
         * on the receiver system. See below in section About time to live for
         * more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param disableTimeToLive the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder disableTimeToLive(boolean disableTimeToLive) {
            doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }
        /**
         * Use this option to force disabling time to live. For example when you
         * do request/reply over JMS, then Camel will by default use the
         * requestTimeout value as time to live on the message being sent. The
         * problem is that the sender and receiver systems have to have their
         * clocks synchronized, so they are in sync. This is not always so easy
         * to archive. So you can use disableTimeToLive=true to not set a time
         * to live value on the sent message. Then the message will not expire
         * on the receiver system. See below in section About time to live for
         * more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param disableTimeToLive the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder disableTimeToLive(String disableTimeToLive) {
            doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }
        /**
         * Set if the deliveryMode, priority or timeToLive qualities of service
         * should be used when sending messages. This option is based on
         * Spring's JmsTemplate. The deliveryMode, priority and timeToLive
         * options are applied to the current endpoint. This contrasts with the
         * preserveMessageQos option, which operates at message granularity,
         * reading QoS properties exclusively from the Camel In message headers.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param explicitQosEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder explicitQosEnabled(Boolean explicitQosEnabled) {
            doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }
        /**
         * Set if the deliveryMode, priority or timeToLive qualities of service
         * should be used when sending messages. This option is based on
         * Spring's JmsTemplate. The deliveryMode, priority and timeToLive
         * options are applied to the current endpoint. This contrasts with the
         * preserveMessageQos option, which operates at message granularity,
         * reading QoS properties exclusively from the Camel In message headers.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param explicitQosEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder explicitQosEnabled(String explicitQosEnabled) {
            doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Set to true, if you want to send message using the QoS settings
         * specified on the message, instead of the QoS settings on the JMS
         * endpoint. The following three headers are considered JMSPriority,
         * JMSDeliveryMode, and JMSExpiration. You can provide all or only some
         * of them. If not provided, Camel will fall back to use the values from
         * the endpoint instead. So, when using this option, the headers
         * override the values from the endpoint. The explicitQosEnabled option,
         * by contrast, will only use options set on the endpoint, and not
         * values from the message header.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param preserveMessageQos the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder preserveMessageQos(boolean preserveMessageQos) {
            doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }
        /**
         * Set to true, if you want to send message using the QoS settings
         * specified on the message, instead of the QoS settings on the JMS
         * endpoint. The following three headers are considered JMSPriority,
         * JMSDeliveryMode, and JMSExpiration. You can provide all or only some
         * of them. If not provided, Camel will fall back to use the values from
         * the endpoint instead. So, when using this option, the headers
         * override the values from the endpoint. The explicitQosEnabled option,
         * by contrast, will only use options set on the endpoint, and not
         * values from the message header.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param preserveMessageQos the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder preserveMessageQos(String preserveMessageQos) {
            doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStartListener(boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStartListener(String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStopListener(boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStopListener(String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder destinationCreationStrategy(org.apache.camel.component.sjms.jms.DestinationCreationStrategy destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder destinationCreationStrategy(String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder exceptionListener(jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder exceptionListener(String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder jmsKeyFormatStrategy(org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder jmsMessageType(org.apache.camel.component.sjms.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder mapJmsMessage(String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder messageCreatedStrategy(org.apache.camel.component.sjms.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder recoveryInterval(long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder recoveryInterval(String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointProducerBuilder transferException(String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Simple JMS component.
     */
    public interface SjmsEndpointBuilder
            extends
                SjmsEndpointConsumerBuilder,
                SjmsEndpointProducerBuilder {
        default AdvancedSjmsEndpointBuilder advanced() {
            return (AdvancedSjmsEndpointBuilder) this;
        }

        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder acknowledgementMode(org.apache.camel.component.sjms.jms.SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder acknowledgementMode(String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a: <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder connectionFactory(jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ConnectionFactory</code> type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder disableReplyTo(boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SjmsEndpointBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointBuilder
            extends
                AdvancedSjmsEndpointConsumerBuilder,
                AdvancedSjmsEndpointProducerBuilder {
        default SjmsEndpointBuilder basic() {
            return (SjmsEndpointBuilder) this;
        }

        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder asyncStartListener(boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder asyncStartListener(String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder asyncStopListener(boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder asyncStopListener(String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder destinationCreationStrategy(org.apache.camel.component.sjms.jms.DestinationCreationStrategy destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder destinationCreationStrategy(String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder exceptionListener(jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>jakarta.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder exceptionListener(String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder jmsKeyFormatStrategy(org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder jmsMessageType(org.apache.camel.component.sjms.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsMessageType</code> type.
         * 
         * Group: advanced
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder mapJmsMessage(String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder messageCreatedStrategy(org.apache.camel.component.sjms.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder recoveryInterval(long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder recoveryInterval(String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedSjmsEndpointBuilder transferException(String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    public interface SjmsBuilders {
        /**
         * Simple JMS (camel-sjms)
         * Send and receive messages to/from a JMS Queue or Topic using plain
         * JMS 1.x API.
         * 
         * Category: messaging
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-sjms
         * 
         * @return the dsl builder for the headers' name.
         */
        default SjmsHeaderNameBuilder sjms() {
            return SjmsHeaderNameBuilder.INSTANCE;
        }
        /**
         * Simple JMS (camel-sjms)
         * Send and receive messages to/from a JMS Queue or Topic using plain
         * JMS 1.x API.
         * 
         * Category: messaging
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-sjms
         * 
         * Syntax: <code>sjms:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 2 enums and the value can be one of: queue, topic
         * 
         * Path parameter: destinationName (required)
         * DestinationName is a JMS queue or topic name. By default, the
         * destinationName is interpreted as a queue name.
         * 
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default SjmsEndpointBuilder sjms(String path) {
            return SjmsEndpointBuilderFactory.endpointBuilder("sjms", path);
        }
        /**
         * Simple JMS (camel-sjms)
         * Send and receive messages to/from a JMS Queue or Topic using plain
         * JMS 1.x API.
         * 
         * Category: messaging
         * Since: 2.11
         * Maven coordinates: org.apache.camel:camel-sjms
         * 
         * Syntax: <code>sjms:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 2 enums and the value can be one of: queue, topic
         * 
         * Path parameter: destinationName (required)
         * DestinationName is a JMS queue or topic name. By default, the
         * destinationName is interpreted as a queue name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default SjmsEndpointBuilder sjms(String componentName, String path) {
            return SjmsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Simple JMS component.
     */
    public static class SjmsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SjmsHeaderNameBuilder INSTANCE = new SjmsHeaderNameBuilder();

        /**
         * DestinationName is a JMS queue or topic name. By default, the
         * destinationName is interpreted as a queue name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JMSDestinationName}.
         */
        public String jMSDestinationName() {
            return "CamelJMSDestinationName";
        }
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JmsRequestTimeout}.
         */
        public String jmsRequestTimeout() {
            return "CamelJmsRequestTimeout";
        }
        /**
         * The correlation ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JMSCorrelationID}.
         */
        public String jMSCorrelationID() {
            return "JMSCorrelationID";
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JMSReplyTo}.
         */
        public String jMSReplyTo() {
            return "JMSReplyTo";
        }
    }
    static SjmsEndpointBuilder endpointBuilder(String componentName, String path) {
        class SjmsEndpointBuilderImpl extends AbstractEndpointBuilder implements SjmsEndpointBuilder, AdvancedSjmsEndpointBuilder {
            public SjmsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SjmsEndpointBuilderImpl(path);
    }
}